/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Bar;
import game.Res;
import javax.microedition.lcdui.Graphics;

public class ItemList {
    private ItemList parent;
    private ItemList[] subItems;
    private short name;
    private byte selIndex;
    private boolean disabled;
    private int indexShow;
    private int limit = 3;
    private int loopShow = 6;
    private Bar bar;

    public ItemList(ItemList parent, int name) {
        if (Res.isW176()) {
            this.loopShow = 3;
        }
        this.parent = parent;
        this.name = (short)name;
        this.disabled = false;
    }

    public void setItems(int[] itemNames) {
        this.subItems = null;
        this.selIndex = 0;
        if (itemNames != null) {
            this.subItems = new ItemList[itemNames.length];
            for (int i = 0; i < this.subItems.length; ++i) {
                this.subItems[i] = new ItemList(this, itemNames[i]);
            }
        }
        this.bar = new Bar(-1, Res.getScaleHeight(32), 5, Res.getScaleHeight(160), 1, this.getSubItemsCount() - 1);
    }

    public void drawBar(Graphics g) {
        this.bar.draw(g);
    }

    public void resetSelection() {
        this.selIndex = 0;
    }

    public void disableAllSubItems() {
        for (int i = 0; i < this.subItems.length; ++i) {
            this.subItems[i].disable();
        }
    }

    public void disable() {
        this.disabled = true;
    }

    public void enable() {
        this.disabled = false;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public int getSubItemsCount() {
        return this.subItems.length;
    }

    public ItemList getItemByName(int name) {
        for (int i = 0; i < this.subItems.length; ++i) {
            if (this.subItems[i].getName() != name) continue;
            return this.subItems[i];
        }
        return null;
    }

    public int getName() {
        return this.name;
    }

    public ItemList getParent() {
        return this.parent;
    }

    public int getSelectedIndex() {
        return this.selIndex;
    }

    public ItemList getItem(int index) {
        return this.subItems[index];
    }

    public ItemList getSelectedItem() {
        return this.subItems[this.selIndex];
    }

    public boolean select(int index) {
        if (index < 0 || index > this.subItems.length - 1 || this.subItems[index].isDisabled()) {
            return false;
        }
        this.selIndex = (byte)index;
        return true;
    }

    public int getSelNextLoop(byte index1, int loop) {
        byte i_Sel = 0;
        byte copy = this.selIndex;
        this.selIndex = index1;
        for (int i = 0; i < loop; ++i) {
            this.selNext(true, false);
        }
        i_Sel = this.selIndex;
        this.selIndex = copy;
        return i_Sel;
    }

    public void selNext(boolean isLoop, boolean isCheckDis) {
        boolean isEnd = false;
        this.selIndex = (byte)(this.selIndex + 1);
        if (this.selIndex < this.getSubItemsCount() && this.indexShow + this.loopShow < this.getSubItemsCount() && this.selIndex > this.indexShow + (this.loopShow - 1) - this.limit) {
            ++this.indexShow;
        }
        if (this.selIndex >= this.getSubItemsCount()) {
            isEnd = true;
            this.selIndex = isLoop ? (byte)0 : (byte)(this.getSubItemsCount() - 1);
        }
        if (!isEnd) {
            this.bar.up();
        }
    }

    public int getSelPrevLoop(byte index1, int loop) {
        byte i_Sel = 0;
        byte copy = this.selIndex;
        this.selIndex = index1;
        for (int i = 0; i < loop; ++i) {
            this.selPrev(true, false);
        }
        i_Sel = this.selIndex;
        this.selIndex = copy;
        return i_Sel;
    }

    public void selPrev(boolean isLoop, boolean isCheckDis) {
        boolean isEnd = false;
        this.selIndex = (byte)(this.selIndex - 1);
        if (this.selIndex >= 0 && this.indexShow > 0 && this.selIndex < this.indexShow + this.limit) {
            --this.indexShow;
        }
        if (this.selIndex < 0) {
            isEnd = true;
            this.selIndex = isLoop ? (byte)(this.getSubItemsCount() - 1) : (byte)0;
        }
        if (!isEnd) {
            this.bar.down();
        }
    }

    public int get_indexShow() {
        return this.indexShow;
    }

    public int get_loopShow() {
        return this.loopShow;
    }

    public void set_loopShow(int a) {
        this.loopShow = a;
        this.limit = this.loopShow / 2;
    }
}

