/*
 * Decompiled with CFR 0.152.
 */
package game;

import com.lemonquest.lq3d.LQAppearance;
import com.lemonquest.lq3d.LQBufferedTexture;
import com.lemonquest.lq3d.LQFactory;
import com.lemonquest.lq3d.LQMesh;
import com.lemonquest.lq3d.LQPrimitive;
import com.lemonquest.lq3d.LQTexture;
import com.lemonquest.lq3d.LQTransform;
import com.lemonquest.lq3d.renderlist.LQMeshBuffer;
import com.lemonquest.lq3d.renderlist.LQRenderList;
import com.lemonquest.lq3d.renderlist.LQRenderNode;
import com.lemonquest.text.LQFont;
import com.lemonquest.text.LQLanguage;
import com.lemonquest.util.LQConsole;
import com.lemonquest.util.LQGfx;
import game.GameMain;
import game.LQSound;
import game.LevelMap;
import game.MainMIDlet;
import game.Profile;
import game.RaceMapClipper;
import game.TreeClipper;
import game.UI;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Res {
    private static Res instance;
    private GameMain game;
    public static int ScreenX;
    public static int ScreenY;
    public static int ScreenW;
    public static int ScreenH;
    public static String DIR_3D;
    public static String DIR;
    public LQAppearance[] groundApp;
    public LQRenderList groundRenderList;
    public RaceMapClipper raceMapClipper;
    public LQAppearance[] treeApp;
    public LQRenderList treeRenderList;
    public TreeClipper treeClipper;
    public LQAppearance humanReplaceApp;
    public LQAppearance humanAddApp;
    public LQAppearance bikeReplaceApp;
    public LQAppearance[] bikeReplaceAppSimple;
    public LQAppearance bikeAddApp;
    public LQAppearance comModulateApp;
    public LQAppearance comAddApp;
    public LQAppearance comAlphaApp;
    public static final byte humanMeshRide = 2;
    public static final byte humanMeshStand = 5;
    public static final byte humanMeshCrash = 7;
    public LQMesh[] humanMeshes;
    public LQMesh bikeMesh;
    public LQMesh bikeMeshSimple;
    public LQPrimitive bikeShadowPrim;
    public LQPrimitive bikeSparkPrim;
    public LQRenderNode[] bikeSparkRenderNode;
    public LQPrimitive bikeSandPrim;
    public LQRenderNode[] bikeSandRenderNode;
    public LQPrimitive bikeSmokePrim;
    public LQRenderNode[] bikeSmokeRenderNode;
    public LQPrimitive bikeBackLightPrim;
    public LQTransform groundTrans = LQFactory.LQTransform();
    public LQTexture levelNormalTex;
    public LQTexture levelEffectTex;
    public LQTexture comEffectTex;
    public Image smap;
    public Image gameBgImg_Dry;
    public Image gameBgImg_Rain;
    public LQGfx[] waterDropEffGfx;
    public LQGfx curcuitThumbGfx;
    public LQGfx curcuitThumbBikesGfx;
    public LQGfx countingBigGfx;
    public LQGfx countingSmallGfx;
    public LQGfx countingGoGfx;
    public LQGfx[] effectFullScreenGfx;
    public LQGfx accGameAlphaBar;
    public Image notifyIconImg;
    public Image topCenterUiImg;
    public Image topRightUiImg;
    public Image topLeftUiImg;
    public Image dashboardImg;
    public Image wrongWayImg;
    public LQGfx meterGfx;
    public LQFont fontNumWhiteBig;
    public LQFont fontNumWhiteMid;
    public LQBufferedTexture bufferedBikeTexture;
    public LQBufferedTexture bufferedHumanTexture;
    public byte[] bikeHueScale;
    public byte[] humanHueScale;
    public int[] bikePalBuf;
    public int[] humanPalBuf;
    public final int[] BikeColors = new int[]{1719948, 10881792, 2791946, 10682533, 0xCAC00A, 49103, 14056960, 0};
    public final int BikeColorNum = this.BikeColors.length;
    public int[][] bikePalettesFromFile;
    public int[][] humanPalettesFromFile;
    public LQGfx logoLqGfx;
    public LQGfx menuGameLogoGfx;
    public LQGfx menuCoverGfx;
    public LQGfx menuBgGfx;
    public LQGfx menuCurcuitThumb;
    public static LQGfx menuWhiteBar;
    public static LQGfx menuBlackBar;
    public LQGfx menuAlphaCircuitBG;
    public LQGfx menuAlphaSplitLine;
    public LQGfx menuArrowGfx;
    public LQGfx menuLockGfx;
    public LQGfx menuTireConfigBG;
    public LQGfx coin;
    public LQGfx CopyRight;
    public LQFont fontWhiteBig;
    public LQFont fontWhiteMid;
    public LQFont fontWhiteSmall;
    private String bigFontFile;
    private String midFontFile;
    public String smallFontFile;
    public String[] txt;
    public Profile userProfile;
    public static LQSound audioManager;
    public static int SND_MENU;
    public static int SND_OPTIONS;
    public static int SND_WIN;
    public static int SND_LOSE;
    public static int SND_SOUND_ON;
    public String[] SND_CONTENT = new String[]{"/res/menu.mid", "/res/options.mid", "/res/win.mid", "/res/lose.mid", "/res/soundOn.mid"};
    public int[][] TOTAL_SOUND = new int[][]{{SND_MENU, 0, 0}, {SND_OPTIONS, 0, 0}, {SND_WIN, 0, 0}, {SND_LOSE, 0, 0}, {SND_SOUND_ON, 0, 0}};
    public boolean[] NEED_RESUME = new boolean[]{true, true, false, false, false};
    LevelLoader levelLoader;
    StaticResLoader staticResLoader;
    MenuLoader menuLoader;
    public int loadingTick;
    public boolean isLoadOver;
    public int loadMenuNextState;
    public Random rand = new Random();

    public void release3D() {
        this.groundApp = null;
        this.groundRenderList = null;
        this.raceMapClipper = null;
        this.treeApp = null;
        this.treeRenderList = null;
        this.treeClipper = null;
        this.humanReplaceApp = null;
        this.humanAddApp = null;
        this.bikeReplaceApp = null;
        this.bikeReplaceAppSimple = null;
        this.bikeAddApp = null;
        this.comModulateApp = null;
        this.comAddApp = null;
        this.comAlphaApp = null;
        this.humanMeshes = null;
        this.bikeMesh = null;
        this.bikeMeshSimple = null;
        this.bikeShadowPrim = null;
        this.bikeSparkPrim = null;
        this.bikeSparkRenderNode = null;
        this.bikeSandPrim = null;
        this.bikeSandRenderNode = null;
        this.bikeSmokePrim = null;
        this.bikeSmokeRenderNode = null;
        this.bikeBackLightPrim = null;
        this.groundTrans = null;
        this.levelNormalTex = null;
        this.levelEffectTex = null;
        this.comEffectTex = null;
        this.bufferedBikeTexture = null;
        this.bufferedHumanTexture = null;
        this.bikePalettesFromFile = null;
        this.humanPalettesFromFile = null;
    }

    public static Res instance() {
        return instance;
    }

    public static void init() {
        instance = new Res();
    }

    private Res() {
        DIR_3D = "/res/res_3d/";
        DIR = "/res/";
        this.bigFontFile = DIR + "BM_10.ssf";
        this.midFontFile = DIR + "BM_7.ssf";
        this.smallFontFile = DIR + "fontMid.ssf";
    }

    public void loadFontBig() {
        if (this.fontWhiteBig != null) {
            return;
        }
        this.loadFontSamll();
        this.fontWhiteBig = this.fontWhiteSmall;
    }

    public void loadFontMid() {
        if (this.fontWhiteMid != null) {
            return;
        }
        this.loadFontSamll();
        this.fontWhiteMid = this.fontWhiteSmall;
    }

    public void loadFontSamll() {
        if (this.fontWhiteSmall != null) {
            return;
        }
        DataInputStream fontStream3 = new DataInputStream(this.getClass().getResourceAsStream(this.smallFontFile));
        this.fontWhiteSmall = new LQFont(fontStream3);
    }

    public void loadFontNumBig() {
        if (this.fontNumWhiteBig != null) {
            return;
        }
        this.loadFontSamll();
        this.fontNumWhiteBig = this.fontWhiteSmall;
    }

    public void loadFontNumSmall() {
        if (this.fontNumWhiteMid != null) {
            return;
        }
        this.loadFontSamll();
        this.fontNumWhiteMid = this.fontWhiteSmall;
    }

    public void loadMenuTitle() {
    }

    public void startLoadMenu(GameMain game) {
        if (UI.SOUND_OPEN && audioManager != null) {
            audioManager.StopCurrentSound();
        }
        this.game = game;
        this.loadingTick = 0;
        this.isLoadOver = false;
        this.menuLoader = new MenuLoader();
        this.menuLoader.start();
    }

    public void load_CopyRight() {
        if (this.CopyRight == null) {
            this.CopyRight = new LQGfx(DIR + "CopyRight.png");
        }
    }

    public void releaseLevel() {
        int i;
        if (this.bikeSparkRenderNode != null) {
            for (i = 0; i < this.bikeSparkRenderNode.length; ++i) {
                this.bikeSparkRenderNode[i] = null;
            }
            this.bikeSparkRenderNode = null;
        }
        if (this.bikeSandRenderNode != null) {
            for (i = 0; i < this.bikeSandRenderNode.length; ++i) {
                this.bikeSandRenderNode[i] = null;
            }
            this.bikeSandRenderNode = null;
        }
        this.gameBgImg_Dry = null;
        this.gameBgImg_Rain = null;
        if (this.waterDropEffGfx != null) {
            for (i = 0; i < this.waterDropEffGfx.length; ++i) {
                this.waterDropEffGfx[i] = null;
            }
            this.waterDropEffGfx = null;
        }
        this.curcuitThumbBikesGfx = null;
        this.curcuitThumbGfx = null;
        this.countingBigGfx = null;
        this.countingSmallGfx = null;
        this.countingGoGfx = null;
        this.countingSmallGfx = null;
        this.countingGoGfx = null;
        this.effectFullScreenGfx = null;
        this.game.effects.release();
        this.notifyIconImg = null;
        this.topCenterUiImg = null;
        this.topRightUiImg = null;
        this.topLeftUiImg = null;
        this.dashboardImg = null;
        this.wrongWayImg = null;
        this.meterGfx = null;
        System.gc();
    }

    public void startLoadLevel(GameMain game) {
        if (UI.SOUND_OPEN && audioManager != null) {
            audioManager.StopCurrentSound();
        }
        this.game = game;
        this.loadingTick = 0;
        this.isLoadOver = false;
        this.levelLoader = new LevelLoader();
        this.levelLoader.start();
    }

    public void startLoadStaticRes(GameMain game) {
        if (UI.SOUND_OPEN && audioManager != null) {
            audioManager.StopCurrentSound();
        }
        this.game = game;
        this.loadingTick = 0;
        this.isLoadOver = false;
        this.staticResLoader = new StaticResLoader();
        this.staticResLoader.start();
    }

    public static void resetClip(Graphics g) {
        g.setClip(ScreenX, ScreenY, ScreenW, ScreenH);
    }

    private void initAbout() {
        String Edition = ": " + MainMIDlet.instance.getAppProperty("MIDlet-Version");
        int i = this.txt[26].indexOf("VERSION");
        this.txt[26] = this.txt[26].substring(0, i + 7) + Edition + "\n" + this.txt[26].substring(i + 8, this.txt[26].length());
    }

    public void initLogoRes() {
        GameMain.initVibrate();
        this.logoLqGfx = new LQGfx(DIR + "logo.png");
        this.logoLqGfx.setAlpha(20);
        LQLanguage lang = new LQLanguage();
        this.txt = lang.loadTxtFile(DIR + "txt.lang");
        this.initAbout();
        this.loadFontBig();
        this.loadFontMid();
        this.loadFontSamll();
    }

    public void releaseLogoRes() {
        this.logoLqGfx = null;
        System.gc();
    }

    public void initMainMenuRes() {
        this.menuCoverGfx = new LQGfx(DIR + "cover.png");
        if (this.menuBgGfx == null) {
            this.menuBgGfx = new LQGfx(DIR + "menu_bg.png");
        }
        this.loadMenuTitle();
        this.loadFontBig();
        this.loadFontMid();
        this.loadFontSamll();
        this.loadFontNumBig();
        if (menuWhiteBar == null) {
            menuWhiteBar = new LQGfx(DIR + "menuSelectBar.png");
        }
        if (menuBlackBar == null) {
            menuBlackBar = new LQGfx(DIR + "menuSelectBar_w.png");
            menuBlackBar.setAlpha(127);
        }
        if (this.menuAlphaSplitLine == null) {
            this.menuAlphaSplitLine = this.createSplitLineGfx(8 * ScreenW / 10);
        }
        if (this.menuCurcuitThumb == null) {
            this.menuCurcuitThumb = new LQGfx(DIR + "circuit_thumb_small.png");
            this.menuCurcuitThumb.setAlpha(200);
        }
        if (this.menuAlphaCircuitBG == null) {
            this.menuAlphaCircuitBG = Res.createFixedMsgBox(this.menuCurcuitThumb.getWidth() / 15 + 10, this.menuCurcuitThumb.getHeight() + 10, 5, 0);
            this.menuAlphaCircuitBG.setAlpha(127);
        }
        if (this.menuArrowGfx == null) {
            this.menuArrowGfx = new LQGfx(DIR + "aaaa.png");
        }
        if (this.menuLockGfx == null) {
            this.menuLockGfx = new LQGfx(DIR + "lock.png");
        }
        this.initChooseBikeData();
    }

    public void load_menuCurcuitThumb() {
        if (this.menuCurcuitThumb == null) {
            this.menuCurcuitThumb = new LQGfx(DIR + "circuit_thumb_small.png");
            this.menuCurcuitThumb.setAlpha(200);
        }
    }

    public void load_menuAlphaCircuitBG() {
        if (this.menuAlphaCircuitBG == null) {
            this.menuAlphaCircuitBG = Res.createFixedMsgBox(this.menuCurcuitThumb.getWidth() / 15 + 10, this.menuCurcuitThumb.getHeight() + 10, 5, 0);
            this.menuAlphaCircuitBG.setAlpha(127);
        }
    }

    public void load_menuBgGfx() {
        if (this.menuBgGfx == null) {
            this.menuBgGfx = new LQGfx(DIR + "menu_bg.png");
        }
    }

    public void initMainMenuResForMiniGame() {
        if (this.menuBgGfx == null) {
            this.menuBgGfx = new LQGfx(DIR + "menu_bg.png");
        }
        this.loadMenuTitle();
        this.loadFontBig();
        this.loadFontMid();
        this.loadFontSamll();
        this.loadFontNumBig();
        if (menuWhiteBar == null) {
            menuWhiteBar = new LQGfx(DIR + "menuSelectBar.png");
        }
        if (menuBlackBar == null) {
            menuBlackBar = new LQGfx(DIR + "menuSelectBar_w.png");
            menuBlackBar.setAlpha(127);
        }
        if (this.menuAlphaSplitLine == null) {
            this.menuAlphaSplitLine = this.createSplitLineGfx(8 * ScreenW / 10);
        }
        if (this.menuCurcuitThumb == null) {
            this.menuCurcuitThumb = new LQGfx(DIR + "circuit_thumb_small.png");
            this.menuCurcuitThumb.setAlpha(200);
        }
        if (this.menuAlphaCircuitBG == null) {
            this.menuAlphaCircuitBG = Res.createFixedMsgBox(this.menuCurcuitThumb.getWidth() / 15 + 10, this.menuCurcuitThumb.getHeight() + 10, 5, 0);
            this.menuAlphaCircuitBG.setAlpha(127);
        }
        if (this.menuArrowGfx == null) {
            this.menuArrowGfx = new LQGfx(DIR + "aaaa.png");
        }
        if (this.menuLockGfx == null) {
            this.menuLockGfx = new LQGfx(DIR + "lock.png");
        }
    }

    public void releaseMainMenuRes() {
        this.fontWhiteBig = null;
        this.menuCoverGfx = null;
        this.menuGameLogoGfx = null;
        this.releaseChooseBikeData();
        System.gc();
    }

    public void initPauseMenuRes() {
        this.loadFontBig();
        this.loadFontSamll();
        if (menuWhiteBar == null) {
            menuWhiteBar = new LQGfx(DIR + "menuSelectBar.png");
        }
        if (menuBlackBar == null) {
            menuBlackBar = new LQGfx(DIR + "menuSelectBar_w.png");
        }
        if (this.menuAlphaSplitLine == null) {
            this.menuAlphaSplitLine = this.createSplitLineGfx(8 * ScreenW / 10);
        }
    }

    public void releasePauseMenuRes() {
        menuWhiteBar = null;
        menuBlackBar = null;
        this.menuAlphaSplitLine = null;
        this.fontWhiteBig = null;
        System.gc();
    }

    public void initLevelResultsRes() {
        this.initPauseMenuRes();
        menuWhiteBar.setAlpha(127);
        this.loadFontMid();
        this.loadFontSamll();
    }

    public void releaseLevelResultsRes() {
        this.releasePauseMenuRes();
        this.fontWhiteMid = null;
        this.fontWhiteSmall = null;
        System.gc();
    }

    private void initChooseBikeData() {
        DataInputStream dis = new DataInputStream(this.getClass().getResourceAsStream(DIR_3D + "com_bike.tex"));
        this.bufferedBikeTexture = LQFactory.LQBufferedTexture(dis);
        try {
            dis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        dis = new DataInputStream(this.getClass().getResourceAsStream(DIR_3D + "com_human.tex"));
        this.bufferedHumanTexture = LQFactory.LQBufferedTexture(dis);
        try {
            dis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.bikeHueScale = this.getTexHueScale(this.bufferedBikeTexture, 0, 180);
        this.humanHueScale = this.getTexHueScale(this.bufferedHumanTexture, 0, 180);
        this.bikePalBuf = new int[this.bufferedBikeTexture.getPalette().length];
        System.arraycopy(this.bufferedBikeTexture.getPalette(), 0, this.bikePalBuf, 0, this.bikePalBuf.length);
        this.humanPalBuf = new int[this.bufferedHumanTexture.getPalette().length];
        System.arraycopy(this.bufferedHumanTexture.getPalette(), 0, this.humanPalBuf, 0, this.humanPalBuf.length);
        this.bikePalettesFromFile = new int[this.BikeColorNum][];
        this.humanPalettesFromFile = new int[this.BikeColorNum][];
        for (int i = 0; i < this.BikeColorNum; ++i) {
            int pos;
            DataInputStream palStream = new DataInputStream(this.getClass().getResourceAsStream(DIR_3D + "com_bike_" + i + ".pal"));
            try {
                this.bikePalettesFromFile[i] = new int[palStream.readShort()];
                for (pos = 0; pos < this.bikePalettesFromFile[i].length; ++pos) {
                    this.bikePalettesFromFile[i][pos] = palStream.readInt();
                }
                palStream.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            palStream = new DataInputStream(this.getClass().getResourceAsStream(DIR_3D + "com_human_" + i + ".pal"));
            try {
                this.humanPalettesFromFile[i] = new int[palStream.readShort()];
                for (pos = 0; pos < this.humanPalettesFromFile[i].length; ++pos) {
                    this.humanPalettesFromFile[i][pos] = palStream.readInt();
                }
                palStream.close();
                continue;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void releaseChooseBikeData() {
        this.bufferedBikeTexture = null;
        this.bufferedHumanTexture = null;
        this.bikeHueScale = null;
        this.humanHueScale = null;
        this.bikePalBuf = null;
        this.humanPalBuf = null;
        this.bikePalettesFromFile = null;
        this.humanPalettesFromFile = null;
        System.gc();
    }

    private byte[] getTexHueScale(LQBufferedTexture texture, int hueMin, int hueMax) {
        float[] rgb_f = new float[3];
        int[] pal = texture.getPalette();
        byte[] data = new byte[pal.length];
        for (int i = 0; i < pal.length; ++i) {
            rgb_f[0] = pal[i] >> 16 & 0xFF;
            rgb_f[1] = pal[i] >> 8 & 0xFF;
            rgb_f[2] = pal[i] & 0xFF;
            float[] hsv_f = LQGfx.RGBtoHSV(rgb_f);
            data[i] = hsv_f[0] >= (float)hueMin && hsv_f[0] <= (float)hueMax ? (byte)1 : 0;
        }
        return data;
    }

    public void initLoadingRes() {
        if (menuWhiteBar == null) {
            menuWhiteBar = new LQGfx(DIR + "menuSelectBar.png");
            menuWhiteBar.setAlpha(127);
        }
        if (this.menuAlphaSplitLine == null) {
            this.menuAlphaSplitLine = this.createSplitLineGfx(8 * ScreenW / 10);
        }
        if (this.menuBgGfx == null) {
            this.menuBgGfx = new LQGfx(DIR + "menu_bg.png");
        }
        this.loadMenuTitle();
        this.loadFontMid();
    }

    public void releaseLoadingRes() {
        menuWhiteBar = null;
        menuBlackBar = null;
        this.menuAlphaSplitLine = null;
        this.menuAlphaCircuitBG = null;
        this.menuBgGfx = null;
        this.menuCurcuitThumb = null;
        this.menuGameLogoGfx = null;
        this.fontWhiteSmall = null;
        this.menuArrowGfx = null;
        this.menuLockGfx = null;
        System.gc();
    }

    public static void showFreeMem(String msg) {
        System.gc();
        LQConsole.output(msg + "  ---->  " + Runtime.getRuntime().freeMemory() / 1000L + "/" + Runtime.getRuntime().totalMemory() / 1000L);
    }

    public int drawX2Thumb(int num, int scale, short[] boundingBox) {
        return num - boundingBox[0] >> scale;
    }

    public int drawY2Thumb(int num, int scale, short[] boundingBox) {
        int h = boundingBox[1] - boundingBox[3] >> scale;
        return 90 - (num - boundingBox[1]) >> scale;
    }

    public LQGfx createSplitLineGfx(int w) {
        Image img = Res.createBlankImage(w, 2);
        Graphics g = img.getGraphics();
        g.setColor(0);
        g.drawLine(0, 0, w, 0);
        g.setColor(0xFFFFFF);
        g.drawLine(0, 1, w, 1);
        LQGfx gfx = new LQGfx(img, 0, 0, img.getWidth(), img.getHeight());
        gfx.setAlpha(127);
        return gfx;
    }

    public LQGfx createCurcuitThumbnail(LevelMap map, int scale) {
        short[] levelBoundingBox = map.getBoundingBox();
        int w = levelBoundingBox[2] - levelBoundingBox[0] >> scale;
        int h = levelBoundingBox[1] - levelBoundingBox[3] >> scale;
        Image img = Res.createBlankImage(w, h);
        Graphics g = img.getGraphics();
        this.drawCurcuitThumbnail(g, map, scale);
        return new LQGfx(img, 0, 0, w, h);
    }

    public void drawCurcuitThumbnail(Graphics g, LevelMap map, int scale) {
        LevelMap.Ground[] grounds = map.getGrounds();
        short[] BoundingBox = map.getBoundingBox();
        int nextID = 0;
        for (int i = 0; i < grounds.length; ++i) {
            nextID = i + 1;
            if (nextID >= grounds.length) {
                nextID -= grounds.length;
            }
            int off = 1;
            off = 2;
            g.setColor(0);
            g.drawLine(this.drawX2Thumb(grounds[i].x, scale, BoundingBox) + off, this.drawY2Thumb(grounds[i].y, scale, BoundingBox) + off, this.drawX2Thumb(grounds[nextID].x, scale, BoundingBox) + off, this.drawY2Thumb(grounds[nextID].y, scale, BoundingBox) + off);
            g.setColor(0xFFFFFF);
            g.drawLine(this.drawX2Thumb(grounds[i].x, scale, BoundingBox), this.drawY2Thumb(grounds[i].y, scale, BoundingBox), this.drawX2Thumb(grounds[nextID].x, scale, BoundingBox), this.drawY2Thumb(grounds[nextID].y, scale, BoundingBox));
            if (i != map.getFinishLineGroundID()) continue;
            g.setColor(0xFFFF00);
            int x = this.drawX2Thumb(grounds[i].x, scale, BoundingBox);
            int y = this.drawY2Thumb(grounds[i].y, scale, BoundingBox);
            g.fillRect(x - 2, y - 2, 5, 5);
        }
    }

    public LQGfx createCurcuitThumbnail(String imgFile, int total, int index) {
        LQGfx tmp = new LQGfx(imgFile);
        int thumbWidth = tmp.getWidth() / total;
        Image img = Res.createBlankImage(thumbWidth, tmp.getHeight());
        tmp.draw(img.getGraphics(), 0, 0, index * thumbWidth, 0, thumbWidth, tmp.getHeight(), 0);
        return new LQGfx(img, 0, 0, img.getWidth(), img.getHeight());
    }

    public static LQGfx createFixedMsgBox(int w, int h, int roundRadius, int color) {
        Image img = Res.createBlankImage(w, h);
        Graphics g = img.getGraphics();
        g.setColor(color);
        if (roundRadius > 0) {
            g.fillRoundRect(0, 0, w, h, roundRadius, roundRadius);
        } else {
            g.fillRect(0, 0, w, h);
        }
        return new LQGfx(img, 0, 0, w, h);
    }

    public static Image createBlankImage(int w, int h) {
        Image img = Image.createImage((int)w, (int)h);
        Graphics g = img.getGraphics();
        int[] rgb = new int[w * h];
        for (int i = 0; i < rgb.length; ++i) {
            rgb[i] = 0xFF00FF;
            rgb[i] = 0;
        }
        g.drawRGB(rgb, 0, w, 0, 0, w, h, false);
        return img;
    }

    public static void changePalette(LQBufferedTexture texture, String paletteFile) {
        DataInputStream palStream = new DataInputStream(Res.instance().getClass().getResourceAsStream(paletteFile));
        int[] newPalette = null;
        try {
            newPalette = new int[palStream.readShort()];
            for (int pos = 0; pos < newPalette.length; ++pos) {
                newPalette[pos] = palStream.readInt();
            }
            palStream.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        texture.updatePalette(newPalette);
    }

    public static int getScaleWidth(int w1) {
        return w1 * 240 / 240;
    }

    public static int getScaleHeight(int h1) {
        return h1 * 320 / 320;
    }

    public int getScaleSmallMap() {
        int scale = 6;
        if (Res.isW128() || Res.isW176()) {
            scale = 7;
        }
        if (Res.isSBmemory()) {
            scale = 7;
        }
        return scale;
    }

    public static boolean isW128() {
        return false;
    }

    public static boolean isW176() {
        return false;
    }

    public static boolean isW240() {
        return true;
    }

    public static boolean isH160() {
        return false;
    }

    public static boolean isSB240() {
        return false;
    }

    public static boolean isSB240_29X() {
        return false;
    }

    public static boolean is352x416() {
        return false;
    }

    public static boolean is320x240() {
        return false;
    }

    public static boolean isSBmemory() {
        return false;
    }

    public static boolean isHI() {
        return true;
    }

    public static boolean isK700() {
        return false;
    }

    public static boolean isCanChangeColor() {
        return false;
    }

    static {
        SND_MENU = 0;
        SND_OPTIONS = 1;
        SND_WIN = 2;
        SND_LOSE = 3;
        SND_SOUND_ON = 4;
    }

    private class StaticResLoader
    extends Thread {
        private StaticResLoader() {
        }

        public void run() {
            LQConsole.output("init...");
            Res.this.levelNormalTex = LQFactory.LQTexture(DIR_3D + "map_0.tex");
            Res.this.levelEffectTex = LQFactory.LQTexture(DIR_3D + "map_0_effect.tex");
            Res.this.comEffectTex = LQFactory.LQTexture(DIR_3D + "com_effect.tex");
            Res.showFreeMem("s texture");
            Res.this.comModulateApp = LQFactory.LQAppearance(1, Res.this.comEffectTex, 0, 3, 0);
            Res.this.comAddApp = LQFactory.LQAppearance(1, Res.this.comEffectTex, 0, 2, 0);
            Res.this.comAlphaApp = LQFactory.LQAppearance(1, Res.this.comEffectTex, 0, 1, 0);
            Res.this.bikeReplaceApp = LQFactory.LQAppearance(1, DIR_3D + "com_bike.tex", 0, 0, 0);
            Res.this.bikeAddApp = LQFactory.LQAppearance(1, DIR_3D + "com_bike.tex", 0, 2, 0);
            Res.this.humanReplaceApp = LQFactory.LQAppearance(1, DIR_3D + "com_human.tex", 0, 0, 0);
            Res.this.humanAddApp = LQFactory.LQAppearance(1, DIR_3D + "com_human.tex", 0, 2, 0);
            Res.showFreeMem("s appearances");
            int[] maxVertNum = new int[]{1400};
            maxVertNum[0] = 1400;
            Res.this.groundApp = new LQAppearance[1];
            Res.this.groundApp[0] = LQFactory.LQAppearance(1, DIR_3D + "map_0.tex", 0, 0, 0);
            Res.this.groundRenderList = new LQRenderList(Res.this.groundApp, maxVertNum, null);
            Res.showFreeMem("s grounds");
            maxVertNum = new int[]{700, 360, 90, 60};
            if (!Res.isSBmemory()) {
                Res.this.treeApp = new LQAppearance[4];
                Res.this.treeApp[0] = LQFactory.LQAppearance(1, Res.this.levelNormalTex, 0, 0, 0);
                Res.this.treeApp[1] = LQFactory.LQAppearance(1, Res.this.levelEffectTex, 0, 1, 0);
                Res.this.treeApp[2] = LQFactory.LQAppearance(1, Res.this.comEffectTex, 0, 3, 0);
                Res.this.treeApp[3] = LQFactory.LQAppearance(1, Res.this.levelEffectTex, 0, 2, 0);
                Res.this.treeRenderList = new LQRenderList(Res.this.treeApp, maxVertNum, null);
            }
            if (Res.isSBmemory()) {
                Res.this.treeApp = null;
                Res.this.treeRenderList = null;
            }
            Res.showFreeMem("s trees");
            Res.this.raceMapClipper = new RaceMapClipper(Res.this.game);
            Res.this.groundRenderList.setClipper(Res.this.raceMapClipper);
            Res.this.treeClipper = new TreeClipper(Res.this.game);
            if (!Res.isSBmemory()) {
                Res.this.treeRenderList.setClipper(Res.this.treeClipper);
            }
            Res.this.humanMeshes = new LQMesh[8];
            Res.this.humanMeshes[0] = LQFactory.LQMesh(DIR_3D + "human_l_90.mesh", "human_l_90");
            Res.this.humanMeshes[1] = LQFactory.LQMesh(DIR_3D + "human_l_45.mesh", "human_l_45");
            Res.this.humanMeshes[2] = LQFactory.LQMesh(DIR_3D + "human_0.mesh", "human_0");
            Res.this.humanMeshes[3] = LQFactory.LQMesh(DIR_3D + "human_r_45.mesh", "human_r_45");
            Res.this.humanMeshes[4] = LQFactory.LQMesh(DIR_3D + "human_r_90.mesh", "human_r_90");
            Res.this.humanMeshes[5] = LQFactory.LQMesh(DIR_3D + "human_2.mesh", "human_stand");
            Res.this.humanMeshes[6] = LQFactory.LQMesh(DIR_3D + "human_2.mesh", "human_crash1");
            Res.this.humanMeshes[7] = LQFactory.LQMesh(DIR_3D + "human_2.mesh", "human_crash2");
            for (int i = 0; i < Res.this.humanMeshes.length; ++i) {
                Res.this.humanMeshes[i].setAppearance(Res.this.humanReplaceApp);
            }
            Res.showFreeMem("s human meshes");
            Res.this.bikeMeshSimple = LQFactory.LQMesh(DIR_3D + "bike_npc.mesh", "bike");
            Res.this.bikeMesh = LQFactory.LQMesh(DIR_3D + "bike.mesh", "bike");
            Res.this.bikeMesh.setAppearance(Res.this.bikeReplaceApp);
            Res.showFreeMem("s bike mesh");
            String meshFilePath = DIR_3D + "smoke_shadow.lq3d";
            DataInputStream meshStream = new DataInputStream(this.getClass().getResourceAsStream(meshFilePath));
            Res.this.bikeSparkRenderNode = new LQRenderNode[1];
            meshFilePath = DIR_3D + "eff_spark_0.lq3d";
            meshStream = new DataInputStream(this.getClass().getResourceAsStream(meshFilePath));
            LQMeshBuffer sparkMesh = new LQMeshBuffer(meshStream, null);
            try {
                meshStream.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            Res.this.bikeSparkRenderNode[0] = new LQRenderNode(sparkMesh, 2);
            Res.this.bikeSparkRenderNode[0].createDataBuffer(0, 0, 0);
            Res.this.bikeSparkPrim = LQFactory.LQPrimitive(Res.this.bikeSparkRenderNode[0], Res.this.comAddApp);
            Res.this.bikeSandRenderNode = new LQRenderNode[1];
            meshFilePath = DIR_3D + "eff_sand_0.lq3d";
            meshStream = new DataInputStream(this.getClass().getResourceAsStream(meshFilePath));
            LQMeshBuffer sandMesh = new LQMeshBuffer(meshStream, null);
            try {
                meshStream.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            Res.this.bikeSandRenderNode[0] = new LQRenderNode(sandMesh, 2);
            Res.this.bikeSandRenderNode[0].createDataBuffer(0, 0, 0);
            Res.this.bikeSandPrim = LQFactory.LQPrimitive(Res.this.bikeSandRenderNode[0], Res.this.comAlphaApp);
            meshFilePath = DIR_3D + "eff_smoke_0.lq3d";
            meshStream = new DataInputStream(this.getClass().getResourceAsStream(meshFilePath));
            LQMeshBuffer smokeMesh = new LQMeshBuffer(meshStream, null);
            try {
                meshStream.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            LQRenderNode tmpNode = new LQRenderNode(smokeMesh, 2);
            Res.this.bikeSmokePrim = LQFactory.LQPrimitive(tmpNode, Res.this.comAddApp);
            Res.showFreeMem("s effects");
            LQConsole.output("loading static done!");
            Res.this.initMainMenuRes();
            audioManager = new LQSound(Res.this.SND_CONTENT, Res.this.TOTAL_SOUND, Res.this.NEED_RESUME, false);
            Res.this.userProfile = new Profile();
            Res.this.userProfile.load();
            ((Res)Res.this).game.ui.createMenuTree();
            Res.this.userProfile.save();
            System.gc();
            Res.this.isLoadOver = true;
            Res.this.staticResLoader = null;
        }
    }

    class LevelLoader
    extends Thread {
        LevelLoader() {
        }

        public void run() {
            LQMeshBuffer smokeMesh;
            DataInputStream meshStream;
            String meshFilePath;
            int i;
            GameMain.setLoading(21);
            Res.this.game.initLevel(Res.this.game.getLevelIndex());
            GameMain.setLoading(11);
            try {
                Res.this.smap = null;
                Res.this.smap = Image.createImage((String)(DIR + "smap/smap" + Res.this.game.getLevelIndex() + ".png"));
            }
            catch (Exception e) {
                // empty catch block
            }
            GameMain.setLoading(12);
            Res.this.curcuitThumbBikesGfx = new LQGfx(DIR + "circuit_thumb_bikes.png");
            if (!Res.isSBmemory()) {
                Res.this.countingBigGfx = new LQGfx(DIR + "321_b.png");
                Res.this.countingSmallGfx = new LQGfx(DIR + "321_s.png");
                Res.this.countingGoGfx = new LQGfx(DIR + "GO.png");
            }
            GameMain.setLoading(13);
            Res.this.effectFullScreenGfx = new LQGfx[5];
            for (int i2 = 0; i2 < Res.this.effectFullScreenGfx.length; ++i2) {
                Res.this.effectFullScreenGfx[i2] = Res.createFixedMsgBox(5, ScreenH, 0, 0);
                Res.this.effectFullScreenGfx[i2].setAlpha((5 - i2) * 51);
            }
            GameMain.setLoading(14);
            try {
                Res.this.notifyIconImg = Image.createImage((String)(DIR + "notify_icon.png"));
                GameMain.setLoading(15);
                if (!Res.isW128() && !Res.isSBmemory()) {
                    Res.this.topCenterUiImg = Image.createImage((String)(DIR + "top_center.png"));
                    Res.this.topRightUiImg = Image.createImage((String)(DIR + "top_right.png"));
                    Res.this.topLeftUiImg = Image.createImage((String)(DIR + "top_left.png"));
                }
                GameMain.setLoading(16);
                Res.this.dashboardImg = Image.createImage((String)(DIR + "dashboard.png"));
                Res.this.wrongWayImg = Image.createImage((String)(DIR + "X.png"));
                GameMain.setLoading(17);
                if (((Res)Res.this).game.getLevelCustom().typeOfRace == 8 || ((Res)Res.this).game.getLevelCustom().typeOfRace == 7) {
                    Res.this.meterGfx = new LQGfx(DIR + "chi.png");
                    Res.this.meterGfx.setAlpha(180);
                }
                GameMain.setLoading(18);
            }
            catch (IOException ex1) {
                // empty catch block
            }
            Res.this.loadFontNumBig();
            GameMain.setLoading(19);
            Res.this.loadFontNumSmall();
            Res.showFreeMem("loadLevel");
            GameMain.setLoading(1);
            Res.this.bikeReplaceAppSimple = new LQAppearance[6];
            DataInputStream texBufStream = new DataInputStream(this.getClass().getResourceAsStream(DIR_3D + "com_npc.tex"));
            LQBufferedTexture texBuf = LQFactory.LQBufferedTexture(texBufStream);
            try {
                texBufStream.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            GameMain.setLoading(2);
            for (i = 0; i < Res.this.bikeReplaceAppSimple.length; ++i) {
                Res.changePalette(texBuf, DIR_3D + "com_npc_" + i + ".pal");
                LQTexture texture = LQFactory.LQTexture(DIR_3D + "com_npc." + i + ".tex", texBuf);
                Res.this.bikeReplaceAppSimple[i] = LQFactory.LQAppearance(1, texture, 0, 0, 0);
            }
            GameMain.setLoading(3);
            Res.this.bikeSparkRenderNode = new LQRenderNode[3];
            for (i = 0; i < Res.this.bikeSparkRenderNode.length; ++i) {
                meshFilePath = DIR_3D + "eff_spark_" + i + ".lq3d";
                meshStream = new DataInputStream(this.getClass().getResourceAsStream(meshFilePath));
                LQMeshBuffer sparkMesh = new LQMeshBuffer(meshStream, null);
                try {
                    meshStream.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                Res.this.bikeSparkRenderNode[i] = new LQRenderNode(sparkMesh, 2);
                Res.this.bikeSparkRenderNode[i].createDataBuffer(0, 0, 0);
            }
            GameMain.setLoading(4);
            Res.this.bikeSandRenderNode = new LQRenderNode[2];
            for (i = 0; i < Res.this.bikeSandRenderNode.length; ++i) {
                meshFilePath = DIR_3D + "eff_sand_" + i + ".lq3d";
                meshStream = new DataInputStream(this.getClass().getResourceAsStream(meshFilePath));
                smokeMesh = new LQMeshBuffer(meshStream, null);
                try {
                    meshStream.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                Res.this.bikeSandRenderNode[i] = new LQRenderNode(smokeMesh, 2);
                Res.this.bikeSandRenderNode[i].createDataBuffer(0, 0, 0);
            }
            GameMain.setLoading(5);
            Res.this.bikeSmokeRenderNode = new LQRenderNode[1];
            for (i = 0; i < Res.this.bikeSmokeRenderNode.length; ++i) {
                meshFilePath = null;
                if (((Res)Res.this).game.getLevelCustom().weather == 0) {
                    meshFilePath = DIR_3D + "eff_smoke_" + i + ".lq3d";
                } else if (((Res)Res.this).game.getLevelCustom().weather == 1) {
                    meshFilePath = DIR_3D + "eff_smoke_rain.lq3d";
                }
                meshStream = new DataInputStream(this.getClass().getResourceAsStream(meshFilePath));
                smokeMesh = new LQMeshBuffer(meshStream, null);
                try {
                    meshStream.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                Res.this.bikeSmokeRenderNode[i] = new LQRenderNode(smokeMesh, 2);
                Res.this.bikeSmokeRenderNode[i].createDataBuffer(0, 0, 0);
            }
            GameMain.setLoading(6);
            try {
                if (!Res.isSBmemory() || Res.isK700()) {
                    if (Res.isHI()) {
                        // empty if block
                    }
                    if (((Res)Res.this).game.getLevelCustom().weather == 0) {
                        Res.this.gameBgImg_Dry = Image.createImage((String)(DIR_3D + "bg.png"));
                    } else {
                        Res.this.gameBgImg_Rain = Image.createImage((String)(DIR_3D + "bg_rain.png"));
                    }
                }
                GameMain.setLoading(7);
                if (!Res.isSBmemory()) {
                    Res.this.waterDropEffGfx = new LQGfx[2];
                    Res.this.waterDropEffGfx[0] = new LQGfx(DIR + "drop_big.png");
                    Res.this.waterDropEffGfx[1] = new LQGfx(DIR + "drop_small.png");
                }
                GameMain.setLoading(8);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            Res.showFreeMem("level effs");
            System.gc();
            Res.this.isLoadOver = true;
            Res.this.levelLoader = null;
            GameMain.setLoading(9);
        }
    }

    class MenuLoader
    extends Thread {
        MenuLoader() {
        }

        public void run() {
            Res.this.initMainMenuRes();
            System.gc();
            if (Res.this.loadMenuNextState == 132) {
                audioManager.PlaySound(SND_OPTIONS, -1);
            } else {
                audioManager.PlaySound(SND_MENU, -1);
            }
            Res.this.game.setGameState(Res.this.loadMenuNextState);
            Res.this.isLoadOver = true;
            Res.this.menuLoader = null;
        }
    }
}

