/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.lq3d;

import com.lemonquest.lq3d.LQAppearance;
import com.lemonquest.lq3d.LQCamera;
import com.lemonquest.lq3d.LQFactory;
import com.lemonquest.lq3d.LQGraphics3D;
import com.lemonquest.lq3d.LQPrimitive;
import com.lemonquest.lq3d.LQTransform;
import com.lemonquest.util.LQConsole;

public class LQBillboardGroup {
    protected byte m_alignType = 0;
    public static final byte Align_CenterPoint = 0;
    public static final byte Align_BottomMidPoint = 1;
    private LQPrimitive bbPrim;
    private LQTransform bbTrans = LQFactory.LQTransform();
    int m_maxVertNum;
    short[] verts;
    short[] texels;
    float[] camUp = new float[3];
    float[] camRight = new float[3];
    short[] tmpV = new short[12];
    short[] resetV = new short[12];

    public LQBillboardGroup(byte alignType, String textureFile, int pixelBlendMode, int maxVertNum) {
        this.m_alignType = alignType;
        LQAppearance primApp = LQFactory.LQAppearance(0, textureFile, 0, pixelBlendMode, 0);
        this.init(primApp, maxVertNum);
    }

    public LQBillboardGroup(byte alignType, LQAppearance app, int maxVertNum) {
        this.m_alignType = alignType;
        this.init(app, maxVertNum);
    }

    private void init(LQAppearance app, int maxVertNum) {
        this.m_maxVertNum = maxVertNum;
        this.bbPrim = LQFactory.LQPrimitive(1, app, maxVertNum);
        this.verts = new short[maxVertNum * 3];
        this.texels = new short[maxVertNum * 2];
        for (int i = 0; i < this.resetV.length; ++i) {
            this.resetV[i] = 0;
        }
    }

    public int addBillboard(short[] vertices, short[] texels) {
        int i;
        int index = this.bbPrim.addSubPrim(vertices, null, null, texels);
        if (index < 0) {
            LQConsole.println("vertex buffer full");
            return index;
        }
        for (i = index; i < vertices.length; ++i) {
            this.verts[i] = vertices[i - index];
        }
        if (texels != null) {
            for (i = index; i < texels.length; ++i) {
                this.texels[i] = texels[i - index];
            }
        }
        return index;
    }

    public void setAppearance(LQAppearance app) {
        this.bbPrim.setAppearance(app);
    }

    public LQPrimitive getPrimitive() {
        return this.bbPrim;
    }

    public void update(LQCamera camera, float[] newPosition, short[] texels) {
    }

    public void update(LQCamera camera, float[] scaleX, float[] scaleY, float[] bbPos, float[] centerPos, short[] texels, byte[] colors) {
        if (centerPos != null) {
            this.bbTrans.identity();
            this.bbTrans.translateWorld(centerPos[0], centerPos[1], centerPos[2]);
        }
        camera.getNormalUp(this.camUp);
        camera.getNormalRight(this.camRight);
        int faceNum = scaleX.length;
        for (int i = 0; i < faceNum; ++i) {
            float x = bbPos[i * 3];
            float y = bbPos[i * 3 + 1];
            float z = bbPos[i * 3 + 2];
            float dz = 0.0f;
            float dy = 0.0f;
            float dx = 0.0f;
            float cz = 0.0f;
            float cy = 0.0f;
            float cx = 0.0f;
            float bz = 0.0f;
            float by = 0.0f;
            float bx = 0.0f;
            float az = 0.0f;
            float ay = 0.0f;
            float ax = 0.0f;
            if (this.m_alignType == 0) {
                ax = x - (this.camRight[0] * scaleX[i] + this.camUp[0] * scaleY[i]) * 2.0f;
                ay = y - (this.camRight[1] * scaleX[i] + this.camUp[1] * scaleY[i]) * 2.0f;
                az = z - (this.camRight[2] * scaleX[i] + this.camUp[2] * scaleY[i]) * 2.0f;
                bx = x + (this.camRight[0] * scaleX[i] - this.camUp[0] * scaleY[i]) * 2.0f;
                by = y + (this.camRight[1] * scaleX[i] - this.camUp[1] * scaleY[i]) * 2.0f;
                bz = z + (this.camRight[2] * scaleX[i] - this.camUp[2] * scaleY[i]) * 2.0f;
                cx = x - (this.camRight[0] * scaleX[i] - this.camUp[0] * scaleY[i]) * 2.0f;
                cy = y - (this.camRight[1] * scaleX[i] - this.camUp[1] * scaleY[i]) * 2.0f;
                cz = z - (this.camRight[2] * scaleX[i] - this.camUp[2] * scaleY[i]) * 2.0f;
                dx = x + (this.camRight[0] * scaleX[i] + this.camUp[0] * scaleY[i]) * 2.0f;
                dy = y + (this.camRight[1] * scaleX[i] + this.camUp[1] * scaleY[i]) * 2.0f;
                dz = z + (this.camRight[2] * scaleX[i] + this.camUp[2] * scaleY[i]) * 2.0f;
            } else if (this.m_alignType == 1) {
                ax = x - this.camRight[0] * scaleX[i];
                ay = y - this.camRight[1] * scaleX[i];
                az = z - this.camRight[2] * scaleX[i];
                bx = x + this.camRight[0] * scaleX[i];
                by = y + this.camRight[1] * scaleX[i];
                bz = z + this.camRight[2] * scaleX[i];
                cx = x - this.camRight[0] * scaleX[i] + this.camUp[0] * scaleY[i] * 2.0f;
                cy = y - this.camRight[1] * scaleX[i] + this.camUp[1] * scaleY[i] * 2.0f;
                cz = z - this.camRight[2] * scaleX[i] + this.camUp[2] * scaleY[i] * 2.0f;
                dx = x + this.camRight[0] * scaleX[i] + this.camUp[0] * scaleY[i] * 2.0f;
                dy = y + this.camRight[1] * scaleX[i] + this.camUp[1] * scaleY[i] * 2.0f;
                dz = z + this.camRight[2] * scaleX[i] + this.camUp[2] * scaleY[i] * 2.0f;
            }
            this.verts[i * 12] = LQFactory.ModelingNumber(ax);
            this.verts[i * 12 + 1] = LQFactory.ModelingNumber(ay);
            this.verts[i * 12 + 2] = LQFactory.ModelingNumber(az);
            this.verts[i * 12 + 3] = LQFactory.ModelingNumber(bx);
            this.verts[i * 12 + 4] = LQFactory.ModelingNumber(by);
            this.verts[i * 12 + 5] = LQFactory.ModelingNumber(bz);
            this.verts[i * 12 + 6] = LQFactory.ModelingNumber(cx);
            this.verts[i * 12 + 7] = LQFactory.ModelingNumber(cy);
            this.verts[i * 12 + 8] = LQFactory.ModelingNumber(cz);
            this.verts[i * 12 + 9] = LQFactory.ModelingNumber(dx);
            this.verts[i * 12 + 10] = LQFactory.ModelingNumber(dy);
            this.verts[i * 12 + 11] = LQFactory.ModelingNumber(dz);
        }
        this.bbPrim.fastUpdateVert(this.verts);
        if (texels != null) {
            this.bbPrim.fastUpdateTexels(texels);
        }
        if (colors != null) {
            this.bbPrim.fastUpdateColors(colors);
        }
    }

    public void update(int vertexIndex, LQCamera camera, float scaleX, float scaleY, float[] bbPos, short[] texels, byte[] colors) {
        camera.getNormalUp(this.camUp);
        camera.getNormalRight(this.camRight);
        float x = bbPos[0];
        float y = bbPos[1];
        float z = bbPos[2];
        float dz = 0.0f;
        float dy = 0.0f;
        float dx = 0.0f;
        float cz = 0.0f;
        float cy = 0.0f;
        float cx = 0.0f;
        float bz = 0.0f;
        float by = 0.0f;
        float bx = 0.0f;
        float az = 0.0f;
        float ay = 0.0f;
        float ax = 0.0f;
        if (this.m_alignType == 0) {
            ax = x - (this.camRight[0] * scaleX + this.camUp[0] * scaleY);
            ay = y - (this.camRight[1] * scaleX + this.camUp[1] * scaleY);
            az = z - (this.camRight[2] * scaleX + this.camUp[2] * scaleY);
            bx = x + (this.camRight[0] * scaleX - this.camUp[0] * scaleY);
            by = y + (this.camRight[1] * scaleX - this.camUp[1] * scaleY);
            bz = z + (this.camRight[2] * scaleX - this.camUp[2] * scaleY);
            cx = x - (this.camRight[0] * scaleX - this.camUp[0] * scaleY);
            cy = y - (this.camRight[1] * scaleX - this.camUp[1] * scaleY);
            cz = z - (this.camRight[2] * scaleX - this.camUp[2] * scaleY);
            dx = x + (this.camRight[0] * scaleX + this.camUp[0] * scaleY);
            dy = y + (this.camRight[1] * scaleX + this.camUp[1] * scaleY);
            dz = z + (this.camRight[2] * scaleX + this.camUp[2] * scaleY);
        } else if (this.m_alignType == 1) {
            ax = x - this.camRight[0] * scaleX;
            ay = y - this.camRight[1] * scaleX;
            az = z - this.camRight[2] * scaleX;
            bx = x + this.camRight[0] * scaleX;
            by = y + this.camRight[1] * scaleX;
            bz = z + this.camRight[2] * scaleX;
            cx = x - this.camRight[0] * scaleX + this.camUp[0] * scaleY * 2.0f;
            cy = y - this.camRight[1] * scaleX + this.camUp[1] * scaleY * 2.0f;
            cz = z - this.camRight[2] * scaleX + this.camUp[2] * scaleY * 2.0f;
            dx = x + this.camRight[0] * scaleX + this.camUp[0] * scaleY * 2.0f;
            dy = y + this.camRight[1] * scaleX + this.camUp[1] * scaleY * 2.0f;
            dz = z + this.camRight[2] * scaleX + this.camUp[2] * scaleY * 2.0f;
        }
        this.tmpV[0] = LQFactory.ModelingNumber(ax);
        this.tmpV[1] = LQFactory.ModelingNumber(ay);
        this.tmpV[2] = LQFactory.ModelingNumber(az);
        this.tmpV[3] = LQFactory.ModelingNumber(bx);
        this.tmpV[4] = LQFactory.ModelingNumber(by);
        this.tmpV[5] = LQFactory.ModelingNumber(bz);
        this.tmpV[6] = LQFactory.ModelingNumber(cx);
        this.tmpV[7] = LQFactory.ModelingNumber(cy);
        this.tmpV[8] = LQFactory.ModelingNumber(cz);
        this.tmpV[9] = LQFactory.ModelingNumber(dx);
        this.tmpV[10] = LQFactory.ModelingNumber(dy);
        this.tmpV[11] = LQFactory.ModelingNumber(dz);
        this.bbPrim.fastUpdateVert(vertexIndex, this.tmpV);
        if (texels != null) {
            this.bbPrim.fastUpdateTexels(vertexIndex, texels);
        }
        if (colors != null) {
            this.bbPrim.fastUpdateColors(vertexIndex, colors);
        }
    }

    public void disableBillboard(int vertexIndex) {
        this.bbPrim.fastUpdateVert(vertexIndex, this.resetV);
    }

    public void setARGBColor(int color) {
        this.bbPrim.setARGBColor(color);
    }

    public void draw(LQGraphics3D g3d) {
        g3d.render(this.bbPrim, this.bbTrans);
    }
}

