/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.lq3d.renderlist;

import com.lemonquest.lq3d.LQTransform;
import com.lemonquest.lq3d.LQVector;
import com.lemonquest.math.LQMath;
import java.io.DataInputStream;

public class LQMeshBuffer {
    private short[] vertices;
    public short[] normals;
    private short[] texels;
    private byte[] colors;
    private short[][] indices;
    public short[] indicesBuf;

    public LQMeshBuffer(DataInputStream dis, LQTransform rotateMatrix) {
        try {
            this.fromStream(dis, rotateMatrix);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.unfoldIndexBuffer();
    }

    public void release() {
        this.vertices = null;
        this.normals = null;
        this.texels = null;
        this.colors = null;
        this.indices = null;
        this.indicesBuf = null;
    }

    public void unfoldIndexBuffer() {
        int vertexNum = 0;
        for (int i = 0; i < this.indices.length; ++i) {
            vertexNum += (this.indices[i].length - 2) * 3;
        }
        System.out.println("vertNum:" + vertexNum);
        this.indicesBuf = new short[vertexNum];
        int count = 0;
        boolean flip = false;
        for (int stripIndex = 0; stripIndex < this.indices.length; ++stripIndex) {
            flip = false;
            for (int i = 0; i < this.indices[stripIndex].length - 2; ++i) {
                if (flip) {
                    this.indicesBuf[count++] = this.indices[stripIndex][i + 1];
                    this.indicesBuf[count++] = this.indices[stripIndex][i + 0];
                    this.indicesBuf[count++] = this.indices[stripIndex][i + 2];
                } else {
                    this.indicesBuf[count++] = this.indices[stripIndex][i + 0];
                    this.indicesBuf[count++] = this.indices[stripIndex][i + 1];
                    this.indicesBuf[count++] = this.indices[stripIndex][i + 2];
                }
                flip = !flip;
            }
        }
        this.indices = null;
    }

    public void fromStream(DataInputStream dis, LQTransform rotateMatrix) throws Exception {
        int texNum;
        int colNum;
        int normNum;
        byte reservedByte = dis.readByte();
        int vertNum = dis.readInt();
        if (vertNum > 0) {
            int componentsNum = dis.readInt();
            this.vertices = new short[vertNum * componentsNum];
            for (int vertIndex = 0; vertIndex < vertNum; ++vertIndex) {
                LQVector point = new LQVector();
                point.setX(dis.readFloat());
                point.setY(dis.readFloat());
                point.setZ(dis.readFloat());
                if (rotateMatrix != null) {
                    point.mul(rotateMatrix);
                }
                this.vertices[vertIndex * componentsNum + 0] = (short)LQMath.round(point.getX());
                this.vertices[vertIndex * componentsNum + 1] = (short)LQMath.round(point.getY());
                this.vertices[vertIndex * componentsNum + 2] = (short)LQMath.round(point.getZ());
            }
        }
        if ((normNum = dis.readInt()) > 0) {
            int componentsNum = dis.readInt();
            this.normals = new short[normNum * componentsNum];
            for (int normIndex = 0; normIndex < normNum; ++normIndex) {
                this.normals[normIndex * componentsNum + 0] = dis.readShort();
                this.normals[normIndex * componentsNum + 1] = dis.readShort();
                this.normals[normIndex * componentsNum + 2] = dis.readShort();
            }
        }
        if ((colNum = dis.readInt()) > 0) {
            int componentsNum = dis.readInt();
            this.colors = new byte[colNum * 4];
            for (int colIndex = 0; colIndex < colNum; ++colIndex) {
                for (int componentIndex = 0; componentIndex < componentsNum; ++componentIndex) {
                    this.colors[colIndex * 4 + componentIndex] = dis.readByte();
                }
                if (componentsNum >= 4) continue;
                this.colors[colIndex * 4 + 3] = -1;
            }
        }
        if ((texNum = dis.readInt()) > 0) {
            int componentsNum = dis.readInt();
            this.texels = new short[texNum * componentsNum];
            for (int texelIndex = 0; texelIndex < texNum; ++texelIndex) {
                this.texels[texelIndex * componentsNum + 0] = dis.readShort();
                this.texels[texelIndex * componentsNum + 1] = dis.readShort();
            }
        }
        int stripNum = dis.readInt();
        this.indices = new short[stripNum][];
        for (int stripIndex = 0; stripIndex < stripNum; ++stripIndex) {
            int stripLen = dis.readShort();
            this.indices[stripIndex] = new short[stripLen];
            for (int stripLenIndex = 0; stripLenIndex < stripLen; ++stripLenIndex) {
                this.indices[stripIndex][stripLenIndex] = dis.readShort();
            }
        }
    }

    public short[] getVertex(int transX, int transY, int transZ) {
        int vertNum = this.indicesBuf.length;
        short[] vert = new short[vertNum * 3];
        int start = 0;
        for (int i = 0; i < vertNum; ++i) {
            start = this.indicesBuf[i] * 3;
            vert[i * 3 + 0] = (short)(this.vertices[start + 0] + transX);
            vert[i * 3 + 1] = (short)(this.vertices[start + 1] + transY);
            vert[i * 3 + 2] = (short)(this.vertices[start + 2] + transZ);
        }
        return vert;
    }

    public short[] getTexels() {
        if (this.texels == null) {
            return null;
        }
        int vertNum = this.indicesBuf.length;
        short[] texel = new short[vertNum * 2];
        int start = 0;
        for (int i = 0; i < vertNum; ++i) {
            start = this.indicesBuf[i] * 2;
            texel[i * 2 + 0] = this.texels[start + 0];
            texel[i * 2 + 1] = this.texels[start + 1];
        }
        return texel;
    }

    public byte[] getColor() {
        if (this.colors == null) {
            return null;
        }
        int vertNum = this.indicesBuf.length;
        byte[] col = new byte[vertNum * 4];
        int start = 0;
        for (int i = 0; i < vertNum; ++i) {
            start = this.indicesBuf[i] * 4;
            col[i * 4 + 0] = this.colors[start + 0];
            col[i * 4 + 1] = this.colors[start + 1];
            col[i * 4 + 2] = this.colors[start + 2];
            col[i * 4 + 3] = this.colors[start + 3];
        }
        return col;
    }
}

