/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.lq3d_m3g;

import com.lemonquest.lq3d.LQCamera;
import com.lemonquest.lq3d.LQConfig;
import com.lemonquest.lq3d.LQTransform;
import com.lemonquest.lq3d_m3g.LQTransform_m3g;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Transform;

public class LQCamera_m3g
extends LQCamera {
    protected CamData m_camData;
    protected int m_width;
    protected int m_height;
    protected float[] bufMatrix = new float[16];
    float[] bufRight = new float[3];
    float[] bufUp = new float[3];
    float[] bufLook = new float[3];
    Transform m_objTransform = new Transform();

    public LQCamera_m3g() {
        this.m_camData = new CamData();
        this.m_width = LQConfig.ScreenWidth;
        this.m_height = LQConfig.ScreenHeight;
        float[] pos = new float[]{0.0f, 0.0f, 0.0f};
        float[] look = new float[]{0.0f, 0.0f, -1.0f};
        float[] up = new float[]{0.0f, 1.0f, 0.0f};
        this.lookAt(pos, look, up);
    }

    public void lookAt(LQTransform trans, float[] pos, float[] look, float[] up) {
        up = LQCamera_m3g.rotateCamYaxis(up);
        float inv_len = (float)(1.0 / Math.sqrt((look[0] - 0.0f) * (look[0] - 0.0f) + (look[1] - 0.0f) * (look[1] - 0.0f) + (look[2] - 0.0f) * (look[2] - 0.0f)));
        float nomalLookX = (look[0] - 0.0f) * inv_len;
        float nomalLookY = (look[1] - 0.0f) * inv_len;
        float nomalLookZ = (look[2] - 0.0f) * inv_len;
        inv_len = (float)(1.0 / Math.sqrt((up[0] - 0.0f) * (up[0] - 0.0f) + (up[1] - 0.0f) * (up[1] - 0.0f) + (up[2] - 0.0f) * (up[2] - 0.0f)));
        float nomalUpX = (up[0] - 0.0f) * inv_len;
        float nomalUpY = (up[1] - 0.0f) * inv_len;
        float nomalUpZ = (up[2] - 0.0f) * inv_len;
        float normalSideX = nomalLookY * nomalUpZ - nomalLookZ * nomalUpY;
        float normalSideY = nomalLookZ * nomalUpX - nomalLookX * nomalUpZ;
        float normalSideZ = nomalLookX * nomalUpY - nomalLookY * nomalUpX;
        inv_len = (float)(1.0 / Math.sqrt(normalSideX * normalSideX + normalSideY * normalSideY + normalSideZ * normalSideZ));
        this.bufRight[0] = normalSideX *= inv_len;
        this.bufRight[1] = normalSideY *= inv_len;
        this.bufRight[2] = normalSideZ *= inv_len;
        this.bufUp[0] = nomalUpX;
        this.bufUp[1] = nomalUpY;
        this.bufUp[2] = nomalUpZ;
        nomalUpX = normalSideY * nomalLookZ - normalSideZ * nomalLookY;
        nomalUpY = normalSideZ * nomalLookX - normalSideX * nomalLookZ;
        nomalUpZ = normalSideX * nomalLookY - normalSideY * nomalLookX;
        this.bufMatrix[0] = normalSideX;
        this.bufMatrix[1] = nomalUpX;
        this.bufMatrix[2] = -nomalLookX;
        this.bufMatrix[3] = pos[0];
        this.bufMatrix[4] = normalSideY;
        this.bufMatrix[5] = nomalUpY;
        this.bufMatrix[6] = -nomalLookY;
        this.bufMatrix[7] = pos[1];
        this.bufMatrix[8] = normalSideZ;
        this.bufMatrix[9] = nomalUpZ;
        this.bufMatrix[10] = -nomalLookZ;
        this.bufMatrix[11] = pos[2];
        this.bufMatrix[12] = 0.0f;
        this.bufMatrix[13] = 0.0f;
        this.bufMatrix[14] = 0.0f;
        this.bufMatrix[15] = 1.0f;
        ((Transform)trans.data()).set(this.bufMatrix);
    }

    public void lookAt(float[] pos, float[] look, float[] up) {
        this.lookAt(this.m_camData.m_transform, pos, look, up);
    }

    public void targetAt(LQTransform trans, float[] pos, float[] target, float[] up) {
        float[] look = new float[3];
        for (int i = 0; i < 3; ++i) {
            look[i] = target[i] - pos[i];
        }
        this.lookAt(trans, pos, look, up);
    }

    public void targetAt(float[] pos, float[] target, float[] up) {
        this.targetAt(this.m_camData.m_transform, pos, target, up);
    }

    public float[] getBufRight() {
        return this.bufRight;
    }

    public float[] getBufUp() {
        return this.bufUp;
    }

    public LQTransform getTransform() {
        return this.m_camData.m_transform;
    }

    public void setPerspective(float zNear, float zFar, float deg, int width, int height) {
        this.m_width = width;
        this.m_height = height;
        this.m_camData.m_camera.setPerspective(deg, (float)width / (float)height, zNear, zFar);
    }

    public Object data() {
        return this.m_camData;
    }

    public void getNormalUp(float[] up) {
        up[0] = this.bufMatrix[1];
        up[1] = this.bufMatrix[5];
        up[2] = this.bufMatrix[9];
        float len = (float)Math.sqrt(up[0] * up[0] + up[1] * up[1] + up[2] * up[2]);
        up[0] = up[0] / len;
        up[1] = up[1] / len;
        up[2] = up[2] / len;
    }

    public void getNormalRight(float[] right) {
        right[0] = this.bufMatrix[0];
        right[1] = this.bufMatrix[4];
        right[2] = this.bufMatrix[8];
        float len = (float)Math.sqrt(right[0] * right[0] + right[1] * right[1] + right[2] * right[2]);
        right[0] = right[0] / len;
        right[1] = right[1] / len;
        right[2] = right[2] / len;
    }

    public void getNormalLook(float[] look) {
        look[0] = -this.bufMatrix[2];
        look[1] = -this.bufMatrix[6];
        look[2] = -this.bufMatrix[10];
    }

    public void Pos3D2Pos2D(float[] pos3D, float[] pos2D) {
        float[] pos = new float[]{pos3D[0], pos3D[1], pos3D[2], 1.0f};
        this.m_objTransform.transform(pos);
        Transform invTrans = new Transform((Transform)this.m_camData.m_transform.data());
        invTrans.invert();
        invTrans.transform(pos);
        float z = -pos[2];
        float x = 0.0f;
        float y = 0.0f;
        Transform transProjection = new Transform();
        this.m_camData.m_camera.getProjection(transProjection);
        transProjection.transform(pos);
        x = pos[0] * (float)LQConfig.ScreenWidth / (2.0f * z);
        y = pos[1] * (float)LQConfig.ScreenHeight / (2.0f * z);
        pos2D[0] = (int)((float)(LQConfig.ScreenWidth / 2) + x);
        pos2D[1] = (int)((float)(LQConfig.ScreenHeight / 2) - y);
    }

    public static class CamData {
        protected Camera m_camera = new Camera();
        protected LQTransform m_transform = new LQTransform_m3g();
    }
}

