/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.lq3d_mcv3;

import com.lemonquest.lq3d.LQCamera;
import com.lemonquest.lq3d.LQConfig;
import com.lemonquest.lq3d.LQFactory;
import com.lemonquest.lq3d.LQTransform;
import com.lemonquest.lq3d_mcv3.LQTransform_mcv3;
import com.mascotcapsule.micro3d.v3.AffineTrans;
import com.mascotcapsule.micro3d.v3.FigureLayout;
import com.mascotcapsule.micro3d.v3.Vector3D;

public class LQCamera_mcv3
extends LQCamera {
    FigureLayout m_camera;
    LQTransform m_camTrans;
    Vector3D bufPosVec = new Vector3D();
    Vector3D bufUpVec = new Vector3D();
    Vector3D bufLookVec = new Vector3D();
    float[] bufRight = new float[3];
    float[] bufUp = new float[3];
    float[] bufLook = new float[3];
    LQTransform m_objTransform = LQFactory.LQTransform();

    public LQCamera_mcv3() {
        this.m_camTrans = new LQTransform_mcv3();
        this.m_camera = new FigureLayout((AffineTrans)this.m_camTrans.data(), 0, 0, LQConfig.ScreenX + LQConfig.ScreenWidth / 2, LQConfig.ScreenY + LQConfig.ScreenHeight / 2);
        float[] pos = new float[]{0.0f, 0.0f, 0.0f};
        float[] look = new float[]{0.0f, 0.0f, -1.0f};
        float[] up = new float[]{0.0f, 1.0f, 0.0f};
        this.lookAt(pos, look, up);
    }

    public Object data() {
        return this.m_camera;
    }

    public LQTransform getTransform() {
        return this.m_camTrans;
    }

    public void lookAt(float[] pos, float[] look, float[] up) {
        this.lookAt(this.m_camTrans, pos, look, up);
    }

    public void lookAt(LQTransform trans, float[] pos, float[] look, float[] up) {
        up = LQCamera_mcv3.rotateCamYaxis(up);
        float inv_len = (float)(1.0 / Math.sqrt(look[0] * look[0] + look[1] * look[1] + look[2] * look[2]));
        float normalLookX = look[0] * inv_len;
        float normalLookY = look[1] * inv_len;
        float normalLookZ = look[2] * inv_len;
        inv_len = (float)(1.0 / Math.sqrt((up[0] - 0.0f) * (up[0] - 0.0f) + (up[1] - 0.0f) * (up[1] - 0.0f) + (up[2] - 0.0f) * (up[2] - 0.0f)));
        float normalUpX = (up[0] - 0.0f) * inv_len;
        float normalUpY = (up[1] - 0.0f) * inv_len;
        float normalUpZ = (up[2] - 0.0f) * inv_len;
        float sideX = normalLookY * normalUpZ - normalLookZ * normalUpY;
        float sideY = normalLookZ * normalUpX - normalLookX * normalUpZ;
        float sideZ = normalLookX * normalUpY - normalLookY * normalUpX;
        inv_len = 1.0f / (float)Math.sqrt(sideX * sideX + sideY * sideY + sideZ * sideZ);
        this.bufRight[0] = sideX *= inv_len;
        this.bufRight[1] = sideY *= inv_len;
        this.bufRight[2] = sideZ *= inv_len;
        normalUpX = sideY * normalLookZ - sideZ * normalLookY;
        normalUpY = sideZ * normalLookX - sideX * normalLookZ;
        normalUpZ = sideX * normalLookY - sideY * normalLookX;
        this.bufUp[0] = normalUpX;
        this.bufUp[1] = normalUpY;
        this.bufUp[2] = normalUpZ;
        this.bufLook[0] = normalLookX;
        this.bufLook[1] = normalLookY;
        this.bufLook[2] = normalLookZ;
        this.bufPosVec.set((int)(pos[0] * 10.0f), (int)(pos[1] * 10.0f), (int)(pos[2] * 10.0f));
        this.bufLookVec.set((int)(normalLookX * 4096.0f), (int)(normalLookY * 4096.0f), (int)(normalLookZ * 4096.0f));
        this.bufUpVec.set((int)(normalUpX * 4096.0f), (int)(normalUpY * 4096.0f), (int)(normalUpZ * 4096.0f));
        ((AffineTrans)trans.data()).lookAt(this.bufPosVec, this.bufLookVec, this.bufUpVec);
    }

    public void targetAt(float[] pos, float[] look, float[] up) {
        this.targetAt(this.m_camTrans, pos, look, up);
    }

    public void targetAt(LQTransform trans, float[] pos, float[] target, float[] up) {
        float[] look = new float[]{target[0] - pos[0], target[1] - pos[1], target[2] - pos[2]};
        this.lookAt(trans, pos, look, up);
    }

    public float[] getBufRight() {
        return this.bufRight;
    }

    public float[] getBufUp() {
        return this.bufUp;
    }

    public void setPerspective(float zNear, float zFar, float deg, int width, int height) {
        int zn = (int)zNear;
        zn = Math.max(1, zn);
        int zf = (int)(zFar *= 10.0f);
        zf = Math.max(zn + 1, Math.min(zf, 32760));
        int d = (int)(deg * 11.377778f);
        this.m_camera.setCenter(LQConfig.ScreenX + LQConfig.ScreenWidth / 2, LQConfig.ScreenY + LQConfig.ScreenHeight / 2);
        this.m_camera.setPerspective(zn, zf, width, height);
        this.m_camera.setPerspective(zn, zf, d);
    }

    public void getNormalUp(float[] up) {
        up[0] = this.getBufUp()[0];
        up[1] = this.getBufUp()[1];
        up[2] = this.getBufUp()[2];
    }

    public void getNormalRight(float[] right) {
        right[0] = this.getBufRight()[0];
        right[1] = this.getBufRight()[1];
        right[2] = this.getBufRight()[2];
    }

    public void getNormalLook(float[] look) {
        look[0] = this.bufLook[0];
        look[1] = this.bufLook[1];
        look[2] = this.bufLook[2];
    }

    public void Pos3D2Pos2D(float[] pos3D, float[] pos2D) {
        float[] pos = new float[]{pos3D[0], pos3D[1], pos3D[2], 1.0f};
        this.m_objTransform.transform(pos);
        LQTransform invTrans = LQFactory.LQTransform(this.m_camTrans);
        invTrans.invert();
        invTrans.transform(pos);
        float z = -pos[2];
        float x = 0.0f;
        float y = 0.0f;
        LQTransform_mcv3 transProjection = new LQTransform_mcv3(this.m_camera.getAffineTrans());
        transProjection.transform(pos);
        x = pos[0] * (float)LQConfig.ScreenWidth / (2.0f * z);
        y = pos[1] * (float)LQConfig.ScreenHeight / (2.0f * z);
        pos2D[0] = (int)((float)(LQConfig.ScreenWidth / 2) + x);
        pos2D[1] = (int)((float)(LQConfig.ScreenHeight / 2) - y);
    }
}

