/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Bike;
import game.Design;
import game.GameMain;
import game.RMSMgr;
import game.RiderInfo;
import game.UI;
import java.util.Random;

public class Profile {
    GhostData[] ghostHS = null;
    public GhostData gUpLoad = new GhostData();
    public GhostData gDownLoad = new GhostData();
    public int[] achievementEarned = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private int unlockedCircuitNum = 1;
    private final int CHAMP_NEW;
    private final int CHAMP_YET;
    private int champState = 0;
    private int champCurrLevel = 0;
    private int champRaceDay = 0;
    private int champWeather = 0;
    private int[] champTrainings = new int[3];
    private int[] champTotalRanks = new int[RiderInfo.infos.length];
    private final int index_racesWon;
    private final int index_racesOvertake;
    private final int index_racesFinishChampionshipMode;
    private final int index_lemonMoney;
    public static final int BikeSpeed = 0;
    public static final int BikeAcc = 1;
    public static final int BikeHandling = 2;
    public static final int BikeBrake = 3;
    public static final int BikePoints = 4;
    private int[] bikeProperties = new int[]{3, 2, 1, 2, 10};
    private int[] bestTimes = new int[Design.ChampionshipCircuitLaps.length];
    private boolean[] hasGhostData = new boolean[Design.ChampionshipCircuitLaps.length];

    public Profile() {
        this.CHAMP_NEW = 0;
        this.CHAMP_YET = 1;
        this.index_racesWon = 18;
        this.index_racesOvertake = 19;
        this.index_racesFinishChampionshipMode = 20;
        this.index_lemonMoney = 21;
    }

    public int getNums_achievementEarned() {
        int result = 0;
        for (int i = 0; i < GameMain.POINT_Achievement.length; ++i) {
            if (this.achievementEarned[i] == 0) continue;
            ++result;
        }
        return result;
    }

    public boolean getNewAchievement(int indexAch) {
        if (this.achievementEarned[indexAch] == 0) {
            this.achievementEarned[indexAch] = 1;
            return true;
        }
        return false;
    }

    public void add_OverTake(int numsOverTake) {
        this.achievementEarned[19] = this.achievementEarned[19] + numsOverTake;
        int overTake = this.achievementEarned[19];
        if (overTake > 10) {
            this.getAchievement(0);
        }
        if (overTake > 20) {
            this.getAchievement(1);
        }
        if (overTake > 50) {
            this.getAchievement(2);
        }
        if (overTake > 100) {
            this.getAchievement(3);
        }
        if (overTake > 200) {
            this.getAchievement(4);
        }
        if (overTake > 500) {
            this.getAchievement(5);
        }
    }

    public void add_racesFinishChampionshipMode() {
        this.achievementEarned[20] = this.achievementEarned[20] + 1;
        int racesFinishChampionshipMode = this.achievementEarned[20];
        if (racesFinishChampionshipMode == 15) {
            this.getAchievement(17);
        }
    }

    public void add_racesWon() {
        this.achievementEarned[18] = this.achievementEarned[18] + 1;
        int racesWon = this.achievementEarned[18];
        if (racesWon == 1) {
            this.getAchievement(11);
        }
        if (racesWon == 5) {
            this.getAchievement(12);
        }
        if (racesWon == 10) {
            this.getAchievement(13);
        }
        if (racesWon == 20) {
            this.getAchievement(14);
        }
        if (racesWon == 50) {
            this.getAchievement(15);
        }
        if (racesWon == 100) {
            this.getAchievement(16);
        }
    }

    public void addBikePoints(int points) {
        this.bikeProperties[4] = this.bikeProperties[4] + points;
        int point = this.bikeProperties[4];
        if (point >= 20) {
            this.getAchievement(6);
        }
        if (point >= 50) {
            this.getAchievement(7);
        }
        if (point >= 100) {
            this.getAchievement(8);
        }
        if (point >= 200) {
            this.getAchievement(9);
        }
        if (point >= 500) {
            this.getAchievement(10);
        }
        this.saveBikeProperty();
        this.saveAchievementEarned();
    }

    public void getAchievement(int indexA) {
        if (this.achievementEarned[indexA] == 0) {
            this.achievementEarned[indexA] = 1;
            this.achievementEarned[21] = this.achievementEarned[21] + GameMain.POINT_Achievement[indexA];
        }
        this.saveAchievementEarned();
    }

    public int get_lemonMoney() {
        return this.achievementEarned[21];
    }

    public int getNeededPoints(int propertyIndex, int currentProperty) {
        if (currentProperty >= Design.BikeEnhancePoints[propertyIndex - 0].length) {
            currentProperty = Design.BikeEnhancePoints[propertyIndex - 0].length - 1;
        }
        return Design.BikeEnhancePoints[propertyIndex - 0][currentProperty];
    }

    public void saveAchievementEarned() {
        RMSMgr rms = RMSMgr.getInstance();
        rms.saveRmsIntArray("3dvr46_achievementEarned", this.achievementEarned);
    }

    public int getBikeProper(int propertyIndex) {
        return this.bikeProperties[propertyIndex];
    }

    public void setBikeProperty(int propertyIndex, int points) {
        this.bikeProperties[propertyIndex] = points;
    }

    public boolean isNewRecord(int levelIndex, int time1) {
        return time1 < this.getBestTime(levelIndex);
    }

    public int getBestTime(int circuitIndex) {
        return this.bestTimes[circuitIndex];
    }

    public void setNewRecord(int circuitIndex, int time) {
        this.bestTimes[circuitIndex] = time;
    }

    public boolean hasChampionshipRecord() {
        return this.champState == 1;
    }

    public int[] getChampTotalRanks() {
        return this.champTotalRanks;
    }

    public void setChampTotalRanks(int[] totalRanks) {
        for (int i = 0; i < totalRanks.length; ++i) {
            this.champTotalRanks[i] = totalRanks[i];
        }
    }

    public int getChampRaceDay() {
        return this.champRaceDay;
    }

    public int getChampLevel() {
        return this.champCurrLevel;
    }

    public int getChampInfoLevel() {
        int champInfoLevel = this.champCurrLevel - 1;
        if (champInfoLevel < 0) {
            champInfoLevel = 14;
        }
        return champInfoLevel + 1;
    }

    public int getChampWeather() {
        return this.champWeather;
    }

    public int[] getChampTrainings() {
        return this.champTrainings;
    }

    public boolean champNextRaceDay() {
        boolean finishedSeason = false;
        ++this.champRaceDay;
        ++this.champCurrLevel;
        if (this.champCurrLevel > Design.ChampionshipCircuitLaps.length - 1) {
            this.champCurrLevel = 0;
            this.champRaceDay = 0;
            finishedSeason = true;
        }
        this.createRaceDayOnce();
        this.champState = 1;
        return finishedSeason;
    }

    public void champYet() {
        this.champState = 1;
        this.save();
    }

    public void save() {
        this.saveBikeProperty();
        this.saveChamp();
    }

    public void load() {
        int[] bestTimesRecords;
        int[] bikeProps;
        RMSMgr rms = RMSMgr.getInstance();
        this.achievementEarned = null;
        this.achievementEarned = rms.getRmsIntArray("3dvr46_achievementEarned");
        if (this.achievementEarned == null) {
            this.achievementEarned = new int[22];
            for (int i = 0; i < this.achievementEarned.length; ++i) {
                this.achievementEarned[i] = 0;
            }
        }
        if ((bikeProps = rms.getRmsIntArray("3dvr46_bikeproperties")) != null) {
            this.bikeProperties = bikeProps;
        }
        if ((bestTimesRecords = rms.getRmsIntArray("3dvr46_bestTimes")) == null) {
            for (int i = 0; i < this.bestTimes.length; ++i) {
                this.bestTimes[i] = Integer.MAX_VALUE;
            }
        } else {
            this.bestTimes = bestTimesRecords;
        }
        this.loadChamp();
        this.loadGhostDataStats();
    }

    public void saveBikeProperty() {
        RMSMgr rms = RMSMgr.getInstance();
        rms.saveRmsIntArray("3dvr46_bikeproperties", this.bikeProperties);
    }

    public void resetChampRecord() {
        this.champState = 0;
        this.champCurrLevel = 0;
        this.champRaceDay = 0;
        this.bikeProperties[0] = 3;
        this.bikeProperties[1] = 2;
        this.bikeProperties[2] = 1;
        this.bikeProperties[3] = 2;
        this.bikeProperties[4] = 10;
        this.champTotalRanks = null;
        this.champTotalRanks = new int[RiderInfo.infos.length];
        this.save();
        this.load();
    }

    public void saveChamp() {
        RMSMgr rms = RMSMgr.getInstance();
        int[] data = new int[]{this.champCurrLevel, this.champRaceDay, this.champWeather, this.champTrainings[0], this.champTrainings[1], this.champTrainings[2], this.champState};
        rms.saveRmsIntArray("3dvr46_championship", data);
        rms.saveRmsIntArray("3dvr46_champ_standings", this.champTotalRanks);
    }

    public void loadChamp() {
        RMSMgr rms = RMSMgr.getInstance();
        int[] record = rms.getRmsIntArray("3dvr46_championship");
        this.champState = 0;
        if (record != null) {
            this.champCurrLevel = record[0];
            this.champRaceDay = record[1];
            this.champWeather = record[2];
            this.champTrainings[0] = record[3];
            this.champTrainings[1] = record[4];
            this.champTrainings[2] = record[5];
            this.champState = record[6];
        } else {
            this.createRaceDayOnce();
        }
        int[] standings = rms.getRmsIntArray("3dvr46_champ_standings");
        if (standings != null) {
            this.champTotalRanks = null;
            this.champTotalRanks = standings;
        }
    }

    private void createRaceDayOnce() {
        Random rand = new Random();
        this.champWeather = Math.abs(rand.nextInt()) % 4 < 1 ? 1 : 0;
        int[] allTraining = new int[]{60, 61, 62, 63, 64};
        this.champTrainings = UI.select3From5(allTraining);
    }

    public void unlockNewCircuit() {
        if (this.unlockedCircuitNum < this.bestTimes.length) {
            ++this.unlockedCircuitNum;
        }
    }

    public int getUnlockedCircuitNum() {
        return this.unlockedCircuitNum;
    }

    public void saveGhostData(Bike bike, int levelIndex, int time1) {
        GhostData data = new GhostData();
        data.fromBike(bike, levelIndex);
        this.setNewRecord(levelIndex, time1);
        data.toRMS();
        this.hasGhostData[levelIndex] = true;
    }

    public boolean loadGhostData(Bike bike, int levelIndex) {
        GhostData data = new GhostData();
        if (!data.fromRMS(levelIndex)) {
            return false;
        }
        data.toBike(bike);
        return true;
    }

    public void saveGhostDataToNet(Bike bike, int levelIndex) {
        GhostData data = new GhostData();
        data.fromBike(bike, levelIndex);
    }

    public void loadGhostDataFromNet(Bike bike, int levelIndex) {
        int i;
        int[] prop = this.gDownLoad.properties;
        int[] frame = this.gDownLoad.frames;
        byte[] control = this.gDownLoad.controls;
        System.out.println("loadGhostDataFromNet-------------------------------------------");
        for (i = 0; i < prop.length; ++i) {
            System.out.print(prop[i] + ",");
        }
        System.out.println();
        for (i = 0; i < frame.length; ++i) {
            System.out.print(frame[i] + ",");
        }
        System.out.println();
        for (i = 0; i < control.length; ++i) {
            System.out.print(control[i] + ",");
        }
        System.out.println();
        System.out.println("loadGhostDataFromNet end----------------------------------------");
        GhostData data = new GhostData();
        data.fromRawData(levelIndex, prop, frame, control);
        data.toBike(bike);
    }

    public void loadGhostHS() {
        this.ghostHS = new GhostData[15];
        for (int i = 0; i < this.ghostHS.length; ++i) {
            this.ghostHS[i] = new GhostData();
            this.ghostHS[i].fromRMS(i);
        }
    }

    public void loadGhostDataStats() {
        RMSMgr rms = RMSMgr.getInstance();
        for (int i = 0; i < Design.ChampionshipCircuitLaps.length; ++i) {
            int[] properties = rms.getRmsIntArray("3dvr46_ghost_" + i + "_prop");
            this.hasGhostData[i] = properties != null;
        }
    }

    public boolean hasGhostData(int levelIndex) {
        return this.hasGhostData[levelIndex];
    }

    public class GhostData {
        public boolean isOK = false;
        public int level_index;
        public int[] properties;
        public int[] frames;
        public byte[] controls;

        public void fromBike(Bike bike, int levelIndex) {
            this.level_index = levelIndex;
            this.properties = new int[6];
            this.properties[0] = Profile.this.bikeProperties[0];
            this.properties[1] = Profile.this.bikeProperties[1];
            this.properties[2] = Profile.this.bikeProperties[2];
            this.properties[3] = Profile.this.bikeProperties[3];
            this.properties[4] = bike.getBikeCustom().tireHardness;
            this.properties[5] = bike.getBikeCustom().tireType;
            int nodeCount = 0;
            Bike.ReplayNode node = bike.getReplayList();
            while (node != null) {
                ++nodeCount;
                node = node.nextNode;
            }
            this.controls = new byte[nodeCount];
            this.frames = new int[nodeCount];
            node = bike.getReplayList();
            int index = 0;
            while (node != null) {
                this.controls[index] = node.control;
                this.frames[index] = node.frame;
                ++index;
                node = node.nextNode;
            }
        }

        public void toBike(Bike bike) {
            if (this.properties == null) {
                return;
            }
            bike.setPerformance(this.properties[1], this.properties[0], this.properties[2], this.properties[3]);
            Bike.BikeCustom bikeCustom = new Bike.BikeCustom();
            bikeCustom.tireHardness = (byte)this.properties[4];
            bikeCustom.tireType = (byte)this.properties[5];
            bike.setBikeCustom(bikeCustom);
            Bike.ReplayNode replayList = null;
            Bike.ReplayNode node = null;
            for (int i = 0; i < this.frames.length; ++i) {
                Bike.ReplayNode newNode = new Bike.ReplayNode();
                newNode.frame = this.frames[i];
                newNode.control = this.controls[i];
                if (node != null) {
                    node.nextNode = newNode;
                    node = newNode;
                    continue;
                }
                replayList = node = newNode;
            }
            bike.setReplayList(replayList);
        }

        public boolean fromRMS(int levelIndex) {
            this.level_index = levelIndex;
            RMSMgr rms = RMSMgr.getInstance();
            this.properties = rms.getRmsIntArray("3dvr46_ghost_" + levelIndex + "_prop");
            this.frames = rms.getRmsIntArray("3dvr46_ghost_" + levelIndex + "_frames");
            this.controls = rms.getRmsByte("3dvr46_ghost_" + levelIndex + "_controls");
            this.isOK = true;
            if (this.properties == null) {
                this.isOK = false;
            }
            return this.properties != null;
        }

        public void toRMS() {
            RMSMgr rms = RMSMgr.getInstance();
            rms.saveRmsIntArray("3dvr46_ghost_" + this.level_index + "_prop", this.properties);
            rms.saveRmsIntArray("3dvr46_ghost_" + this.level_index + "_frames", this.frames);
            rms.saveRmsByte("3dvr46_ghost_" + this.level_index + "_controls", this.controls);
            rms.saveRmsIntArray("3dvr46_bestTimes", Profile.this.bestTimes);
        }

        public void fromRawData(int levelIndex, int[] prop, int[] frame, byte[] control) {
            this.level_index = levelIndex;
            this.properties = prop;
            this.frames = frame;
            this.controls = control;
        }
    }
}

