/*
 * Decompiled with CFR 0.152.
 */
package MyGame;

import MyGame.Buildings;
import MyGame.EnemyJeep;
import MyGame.Items;
import MyGame.Jeepney;
import MyGame.RoadLayer;
import MyGame.Stations;
import MyGame.Vehicles;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;

public class TrackLayerManager
extends LayerManager {
    static int CANVAS_X;
    static int CANVAS_Y;
    static int DISP_WIDTH;
    static int DISP_HEIGHT;
    static int ROAD_LENGHT;
    private Jeepney myJeepney;
    private Vehicles[] myBottomVehicles;
    private Vehicles[] myTopVehicles;
    private Items[] myBadItems;
    private Items[] myGoodItems;
    private EnemyJeep[] myEnemyJeep;
    private RoadLayer myRoad;
    private Buildings myBuildings;
    private Stations stations;
    public boolean upDirection;
    public boolean rightDirection;
    public boolean enemyLoading = false;
    public int newSpeed;
    public int passengers;
    public int maxPassengers;
    public int damagePoints;
    public int unloadedPassengers;
    public int loadedPassengers;
    public int mileage;
    public int gas;
    public int gasFill;
    public int jeepHealth;
    public int driverHealth;
    public int driverHealthCounter;
    public int repairFill;
    public int healthFill;
    public int healthAdded;
    public int liters;
    public int totalFare;
    public int flagCounter;
    public int token = 1;
    public int trafficViolation;
    public int trafficFlagCounter;
    public int maxSpeed;
    public int Level;
    public int enemySpeed;
    public int jeepYPosition = 0;
    public int jeepXPosition = 0;
    public int loadingDistance = 0;
    public int itemCounter = 0;
    public int turboCounter = 0;
    public int musicCounter = 0;
    public int scramblerCounter = 0;
    public final int kmPerLiter;
    public boolean zeroEarnings;
    public boolean gasFlag;
    public boolean loadingFlag;
    public boolean repairFlag;
    public boolean driveThruFlag;
    public boolean lowFuelFlag;
    public boolean JeepLowHealthFlag;
    public boolean DriverLowHealthFlag;
    public boolean trafficSpeedFlag;
    public int myCurrentTopY;
    public int viewX;
    public int enemyPosition;
    private Image fireTruckImage;
    private Image carPoliceImage;
    private Image redCarImage;
    private Image blueCarImage;
    private Image motor;
    private Image tricycle;
    private Image enemy2;
    private Image enemyJeep;
    private Image oilSpill;
    private Image garbage;
    private Image construction;
    private Image turbo;
    private Image repair;
    private Image music;
    private Image burger;
    private Image scrambler;
    private Image money;
    private Image brokenJeep;
    private int dispGap;
    public int soundCounter = 0;
    public int soundNumber = 0;

    Vehicles[] getVehicles() {
        int i;
        Vehicles[] retArray = new Vehicles[this.myTopVehicles.length + this.myBottomVehicles.length];
        for (i = 0; i < this.myTopVehicles.length; ++i) {
            retArray[i] = this.myTopVehicles[i];
        }
        for (i = 0; i < this.myBottomVehicles.length; ++i) {
            retArray[i + this.myTopVehicles.length] = this.myBottomVehicles[i];
        }
        return retArray;
    }

    Items[] getItems() {
        int i;
        Items[] retArray = new Items[this.myGoodItems.length + this.myBadItems.length];
        for (i = 0; i < this.myGoodItems.length; ++i) {
            retArray[i] = this.myGoodItems[i];
        }
        for (i = 0; i < this.myBadItems.length; ++i) {
            retArray[i + this.myGoodItems.length] = this.myBadItems[i];
        }
        return retArray;
    }

    EnemyJeep[] getEnemyJeep() {
        EnemyJeep[] retArray = new EnemyJeep[this.myEnemyJeep.length];
        for (int i = 0; i < this.myEnemyJeep.length; ++i) {
            retArray[i] = this.myEnemyJeep[i];
        }
        return retArray;
    }

    public void toggleSoundCounter(int sound) {
        this.soundCounter = this.soundCounter == 0 ? 1 : 0;
        this.soundNumber = sound;
    }

    public TrackLayerManager(int x, int y, int width, int height, int speed, int level, int seat, int body, int fare, int jHealth, int myGas, int dHealth) throws Exception {
        int i;
        this.kmPerLiter = 200;
        CANVAS_X = x;
        CANVAS_Y = y;
        DISP_WIDTH = width;
        DISP_HEIGHT = height;
        this.dispGap = DISP_WIDTH >= 320 ? 60 : 0;
        ROAD_LENGHT = RoadLayer.ROWS * 70;
        this.upDirection = true;
        this.Level = level;
        this.gas = myGas;
        this.jeepHealth = jHealth;
        this.driverHealth = dHealth;
        this.newSpeed = 0;
        this.token = 1;
        this.damagePoints = 8 - body;
        this.totalFare = fare;
        this.maxSpeed = speed;
        this.passengers = 0;
        this.unloadedPassengers = 0;
        this.loadedPassengers = 0;
        this.maxPassengers = 10 + seat;
        this.zeroEarnings = true;
        this.gasFlag = false;
        this.loadingFlag = false;
        this.lowFuelFlag = false;
        this.enemySpeed = speed - 3;
        this.repairFlag = false;
        this.driveThruFlag = false;
        this.JeepLowHealthFlag = false;
        this.DriverLowHealthFlag = false;
        this.trafficSpeedFlag = false;
        this.itemCounter = 0;
        this.turboCounter = 0;
        this.musicCounter = 0;
        this.scramblerCounter = 0;
        this.gasFill = 0;
        this.liters = 0;
        this.driverHealthCounter = 0;
        this.repairFill = 0;
        this.healthAdded = 0;
        this.healthFill = 0;
        this.mileage = 20000;
        this.flagCounter = 0;
        this.trafficViolation = 0;
        this.trafficFlagCounter = 0;
        this.loadingDistance = 0;
        this.myCurrentTopY = ROAD_LENGHT - DISP_HEIGHT;
        this.viewX = 29;
        this.setViewWindow(this.viewX, 0, DISP_WIDTH, DISP_HEIGHT);
        this.fireTruckImage = Image.createImage((String)"/images/fireTruck.png");
        this.carPoliceImage = Image.createImage((String)"/images/carPolice.png");
        this.blueCarImage = Image.createImage((String)"/images/blueCar.png");
        this.redCarImage = Image.createImage((String)"/images/redCar.png");
        this.motor = Image.createImage((String)"/images/motor.png");
        this.tricycle = Image.createImage((String)"/images/tricycle.png");
        this.enemy2 = Image.createImage((String)"/images/enemy2.png");
        this.oilSpill = Image.createImage((String)"/images/oilspill.png");
        this.garbage = Image.createImage((String)"/images/garbage.png");
        this.construction = Image.createImage((String)"/images/construction.png");
        this.repair = Image.createImage((String)"/images/repair.png");
        this.turbo = Image.createImage((String)"/images/turbo.png");
        this.burger = Image.createImage((String)"/images/burger.png");
        this.music = Image.createImage((String)"/images/music.png");
        this.money = Image.createImage((String)"/images/money.png");
        this.scrambler = Image.createImage((String)"/images/scrambler.png");
        this.enemyJeep = Image.createImage((String)"/images/enemy1.png");
        this.brokenJeep = Image.createImage((String)"/images/broken_jeep.png");
        if (this.myJeepney == null) {
            this.myJeepney = new Jeepney(136 + this.dispGap, this.myCurrentTopY + DISP_HEIGHT - 70, DISP_WIDTH);
            this.append((Layer)this.myJeepney);
        }
        if (this.myBottomVehicles == null) {
            this.myBottomVehicles = new Vehicles[7];
            for (i = 0; i < this.myBottomVehicles.length; ++i) {
                if (i == 0) {
                    this.myBottomVehicles[i] = new Vehicles(true, this.carPoliceImage, 17, 40, DISP_WIDTH);
                } else if (i == 1) {
                    this.myBottomVehicles[i] = new Vehicles(true, this.fireTruckImage, 17, 43, DISP_WIDTH);
                } else if (i == 2) {
                    this.myBottomVehicles[i] = new Vehicles(true, this.redCarImage, 17, 30, DISP_WIDTH);
                } else if (i == 3) {
                    this.myBottomVehicles[i] = new Vehicles(true, this.blueCarImage, 17, 30, DISP_WIDTH);
                } else if (i == 4) {
                    this.myBottomVehicles[i] = new Vehicles(true, this.motor, 10, 20, DISP_WIDTH);
                } else if (i == 5) {
                    this.myBottomVehicles[i] = new Vehicles(true, this.tricycle, 15, 20, DISP_WIDTH);
                } else if (i == 6) {
                    this.myBottomVehicles[i] = new Vehicles(true, this.enemy2, 17, 30, DISP_WIDTH);
                }
                this.append((Layer)this.myBottomVehicles[i]);
            }
        }
        if (this.myTopVehicles == null) {
            this.myTopVehicles = new Vehicles[7];
            for (i = 0; i < this.myTopVehicles.length; ++i) {
                if (i == 0) {
                    this.myTopVehicles[i] = new Vehicles(false, this.blueCarImage, 17, 30, DISP_WIDTH);
                } else if (i == 1) {
                    this.myTopVehicles[i] = new Vehicles(false, this.redCarImage, 17, 30, DISP_WIDTH);
                } else if (i == 2) {
                    this.myTopVehicles[i] = new Vehicles(false, this.fireTruckImage, 17, 43, DISP_WIDTH);
                } else if (i == 3) {
                    this.myTopVehicles[i] = new Vehicles(false, this.carPoliceImage, 17, 40, DISP_WIDTH);
                } else if (i == 4) {
                    this.myTopVehicles[i] = new Vehicles(false, this.motor, 10, 20, DISP_WIDTH);
                } else if (i == 5) {
                    this.myTopVehicles[i] = new Vehicles(false, this.tricycle, 15, 20, DISP_WIDTH);
                } else if (i == 6) {
                    this.myTopVehicles[i] = new Vehicles(false, this.enemy2, 17, 30, DISP_WIDTH);
                }
                this.append((Layer)this.myTopVehicles[i]);
            }
        }
        if (this.myGoodItems == null) {
            this.myGoodItems = new Items[6];
            for (i = 0; i < this.myGoodItems.length; ++i) {
                if (i == 0) {
                    this.myGoodItems[i] = new Items(true, this.turbo, 15, 21, DISP_WIDTH);
                } else if (i == 1) {
                    this.myGoodItems[i] = new Items(true, this.repair, 15, 21, DISP_WIDTH);
                } else if (i == 2) {
                    this.myGoodItems[i] = new Items(true, this.burger, 15, 18, DISP_WIDTH);
                } else if (i == 3) {
                    this.myGoodItems[i] = new Items(true, this.music, 15, 18, DISP_WIDTH);
                } else if (i == 4) {
                    this.myGoodItems[i] = new Items(true, this.scrambler, 18, 13, DISP_WIDTH);
                } else if (i == 5) {
                    this.myGoodItems[i] = new Items(true, this.money, 15, 21, DISP_WIDTH);
                }
                this.append((Layer)this.myGoodItems[i]);
            }
        }
        if (this.myBadItems == null) {
            this.myBadItems = new Items[4];
            for (i = 0; i < this.myBadItems.length; ++i) {
                if (i == 0) {
                    this.myBadItems[i] = new Items(false, this.construction, 18, 30, DISP_WIDTH);
                } else if (i == 1) {
                    this.myBadItems[i] = new Items(false, this.oilSpill, 15, 15, DISP_WIDTH);
                } else if (i == 2) {
                    this.myBadItems[i] = new Items(false, this.garbage, 15, 15, DISP_WIDTH);
                } else if (i == 3) {
                    this.myBadItems[i] = new Items(false, this.brokenJeep, 17, 27, DISP_WIDTH);
                }
                this.append((Layer)this.myBadItems[i]);
            }
        }
        if (this.myEnemyJeep == null) {
            this.myEnemyJeep = new EnemyJeep[1];
            for (i = 0; i < this.myEnemyJeep.length; ++i) {
                this.myEnemyJeep[i] = new EnemyJeep(true, this.enemyJeep, 18, 29, DISP_WIDTH);
                this.append((Layer)this.myEnemyJeep[i]);
            }
        }
        if (this.stations == null) {
            this.stations = new Stations(DISP_WIDTH);
            this.append((Layer)this.stations);
        }
        if (this.myBuildings == null) {
            this.myBuildings = new Buildings(DISP_WIDTH);
            this.append((Layer)this.myBuildings);
            this.myBuildings.setCell(3, 6, 0);
            this.myBuildings.setCell(3, 15, 0);
        }
        if (this.myRoad == null) {
            this.myRoad = new RoadLayer(DISP_WIDTH);
            this.append((Layer)this.myRoad);
        }
        this.myRoad.setCell(1, 5, 1);
        this.myRoad.setCell(1, 25, 1);
    }

    void goingUp(boolean up, int speed, int Token) {
        if (this.myJeepney.LdngColCounter < 1 && this.myJeepney.GasColCounter < 1 && this.myJeepney.DrvColCounter < 1 && this.myJeepney.RprColCounter < 1 && !this.trafficSpeedFlag) {
            this.upDirection = up;
            this.token = Token;
            this.newSpeed += speed;
        }
    }

    void goingRight(boolean right, int Token) {
        if (this.myJeepney.LdngColCounter < 1 && this.myJeepney.GasColCounter < 1 && this.myJeepney.VehcColCounter < 1 && this.myJeepney.EnemyColCounter < 1 && this.myJeepney.BldgColCounter < 1 && this.myJeepney.RprColCounter < 1 && !this.trafficSpeedFlag) {
            this.rightDirection = right;
            this.token = Token;
            if (this.myJeepney.getRefPixelX() < 20 + this.dispGap || this.myJeepney.getRefPixelX() > 240 + this.dispGap - 10) {
                if (this.rightDirection) {
                    this.myJeepney.move(-(this.newSpeed * 3), 0);
                } else if (!this.rightDirection) {
                    this.myJeepney.move(this.newSpeed * 3, 0);
                }
            } else if (this.rightDirection) {
                this.myJeepney.move(this.newSpeed / 2 + 1, 0);
            } else {
                this.myJeepney.move(-this.newSpeed / 2 - 1, 0);
            }
        }
    }

    void reset(int level, int speed, int seat, int body, int fare, int jHealth, int myGas, int dHealth) {
        int i;
        if (this.myRoad != null) {
            this.myRoad.reset();
        }
        if (this.myBuildings != null) {
            this.myBuildings.reset();
        }
        if (this.stations != null) {
            this.stations.reset();
        }
        if (this.myJeepney != null) {
            this.myJeepney.reset();
        }
        if (this.myBottomVehicles != null) {
            for (i = 0; i < this.myBottomVehicles.length; ++i) {
                this.myBottomVehicles[i].reset();
            }
        }
        if (this.myTopVehicles != null) {
            for (i = 0; i < this.myTopVehicles.length; ++i) {
                this.myTopVehicles[i].reset();
            }
        }
        if (this.myBadItems != null) {
            for (i = 0; i < this.myBadItems.length; ++i) {
                this.myBadItems[i].reset();
            }
        }
        if (this.myGoodItems != null) {
            for (i = 0; i < this.myGoodItems.length; ++i) {
                this.myGoodItems[i].reset();
            }
        }
        if (this.myEnemyJeep != null) {
            for (i = 0; i < this.myEnemyJeep.length; ++i) {
                this.myEnemyJeep[i].reset();
            }
        }
        this.myCurrentTopY = ROAD_LENGHT - DISP_HEIGHT;
        this.viewX = 29;
        this.upDirection = true;
        this.newSpeed = 0;
        this.token = 1;
        this.Level = level;
        this.maxSpeed = speed;
        this.maxPassengers = 10 + seat;
        this.damagePoints = 8 - body;
        this.totalFare = fare;
        this.jeepHealth = jHealth;
        this.gas = myGas;
        this.driverHealth = dHealth;
        this.enemySpeed = speed - 3;
        this.passengers = 0;
        this.unloadedPassengers = 0;
        this.loadedPassengers = 0;
        this.gasFlag = false;
        this.loadingFlag = false;
        this.repairFlag = false;
        this.driveThruFlag = false;
        this.lowFuelFlag = false;
        this.JeepLowHealthFlag = false;
        this.DriverLowHealthFlag = false;
        this.trafficSpeedFlag = false;
        this.myRoad.setCell(1, 5, 1);
        this.myRoad.setCell(1, 25, 1);
        this.gasFill = 0;
        this.liters = 0;
        this.driverHealthCounter = 0;
        this.repairFill = 0;
        this.healthAdded = 0;
        this.enemyLoading = false;
        this.healthFill = 0;
        this.mileage = 200 * this.gas;
        this.flagCounter = 0;
        this.trafficViolation = 0;
        this.trafficFlagCounter = 0;
        this.loadingDistance = 0;
        this.itemCounter = 0;
        this.turboCounter = 0;
        this.musicCounter = 0;
        this.scramblerCounter = 0;
        this.stations.setVisible(true);
        this.myBuildings.setVisible(true);
        this.myBuildings.setCell(3, 6, 0);
        this.myBuildings.setCell(3, 15, 0);
        this.stations.setCell(3, 12, 0);
        this.stations.setCell(3, 2, 0);
        this.stations.setCell(3, 9, 0);
    }

    public void paint(Graphics g) {
        this.setViewWindow(this.viewX, this.myCurrentTopY, DISP_WIDTH, DISP_HEIGHT);
        this.paint(g, CANVAS_X, CANVAS_Y);
    }

    private void wrap() {
        block11: {
            block10: {
                int i;
                if (this.myCurrentTopY >= 0) break block10;
                int wrapDistance = 0;
                wrapDistance = DISP_HEIGHT > 234 ? ROAD_LENGHT - DISP_HEIGHT - 180 : ROAD_LENGHT - DISP_HEIGHT - 220;
                if (!this.upDirection) break block11;
                this.myCurrentTopY += wrapDistance;
                this.myJeepney.move(0, wrapDistance);
                for (i = 0; i < this.myBottomVehicles.length; ++i) {
                    this.myBottomVehicles[i].move(0, wrapDistance);
                }
                for (i = 0; i < this.myTopVehicles.length; ++i) {
                    this.myTopVehicles[i].move(0, wrapDistance);
                }
                for (i = 0; i < this.myBadItems.length; ++i) {
                    this.myBadItems[i].move(0, wrapDistance);
                }
                for (i = 0; i < this.myGoodItems.length; ++i) {
                    this.myGoodItems[i].move(0, wrapDistance);
                }
                break block11;
            }
            if (this.myCurrentTopY > ROAD_LENGHT - DISP_HEIGHT) {
                int wrapDistance = 0;
                wrapDistance = DISP_HEIGHT > 234 ? ROAD_LENGHT - DISP_HEIGHT - 180 : ROAD_LENGHT - DISP_HEIGHT - 220;
                if (!this.upDirection) {
                    int i;
                    this.myCurrentTopY -= wrapDistance;
                    this.myJeepney.move(0, -wrapDistance);
                    for (i = 0; i < this.myBottomVehicles.length; ++i) {
                        this.myBottomVehicles[i].move(0, -wrapDistance);
                    }
                    for (i = 0; i < this.myTopVehicles.length; ++i) {
                        this.myTopVehicles[i].move(0, -wrapDistance);
                    }
                    for (i = 0; i < this.myBadItems.length; ++i) {
                        this.myBadItems[i].move(0, -wrapDistance);
                    }
                    for (i = 0; i < this.myGoodItems.length; ++i) {
                        this.myGoodItems[i].move(0, -wrapDistance);
                    }
                }
            }
        }
    }

    void advance(int gameTicks) {
        int x;
        int i;
        if (DISP_WIDTH == 240) {
            this.viewX = this.myJeepney.getRefPixelX() >= 116 ? 29 : (this.myJeepney.getRefPixelX() <= 97 ? 9 : this.myJeepney.getRefPixelX() - 89);
        }
        this.jeepXPosition = this.myJeepney.getRefPixelX();
        this.jeepYPosition = this.myJeepney.getRefPixelY();
        this.loadingDistance += this.newSpeed;
        this.mileage -= this.newSpeed;
        this.gas = this.mileage / 200;
        ++this.driverHealthCounter;
        if (this.driverHealthCounter > 1000) {
            this.driverHealthCounter = 1;
        }
        if (this.driverHealthCounter % 100 == 0) {
            --this.driverHealth;
        }
        this.loadingFlag = this.myJeepney.LdngColCounter > 0;
        if (this.flagCounter > 0) {
            --this.flagCounter;
        } else {
            this.lowFuelFlag = false;
            this.JeepLowHealthFlag = false;
            this.DriverLowHealthFlag = false;
        }
        if (this.itemCounter > 0) {
            this.itemCounter -= this.newSpeed;
        }
        if (this.turboCounter > 0) {
            if (this.turboCounter == 1) {
                this.maxSpeed -= 2;
                this.myJeepney.turboFrameFlag = false;
                if (this.newSpeed > this.maxSpeed) {
                    this.newSpeed = this.maxSpeed;
                }
            }
            --this.turboCounter;
        }
        if (this.musicCounter > 0) {
            if (this.musicCounter == 1) {
                this.maxPassengers -= 4;
                if (this.passengers > this.maxPassengers) {
                    this.passengers = this.maxPassengers;
                }
            }
            --this.musicCounter;
        }
        if (this.scramblerCounter > 0) {
            --this.scramblerCounter;
        }
        if (this.trafficFlagCounter > 0) {
            --this.trafficFlagCounter;
        } else {
            this.trafficSpeedFlag = false;
        }
        if (this.newSpeed > 6 && this.scramblerCounter < 1 && (this.jeepYPosition < 1930 && this.jeepYPosition > 1808 || this.jeepYPosition < 530 && this.jeepYPosition > 408)) {
            this.trafficSpeedFlag = true;
            if (this.jeepYPosition < 1824 && this.jeepYPosition > 1808 || this.jeepYPosition < 424 && this.jeepYPosition > 408) {
                this.trafficFlagCounter = 70;
                this.newSpeed = 0;
                this.myJeepney.setTrafficFlag(this.trafficSpeedFlag);
                this.myJeepney.move(60 - this.myJeepney.getRefPixelX() + 37 + this.dispGap, 0);
            }
        } else {
            if (this.trafficFlagCounter == 0) {
                this.trafficSpeedFlag = false;
            }
            if (this.trafficFlagCounter == 1) {
                this.myJeepney.setTrafficFlag(false);
                this.newSpeed = 1;
                this.upDirection = true;
            }
            if (this.trafficFlagCounter == 60 && this.trafficSpeedFlag) {
                this.myRoad.setCell(1, 5, this.myRoad.myAnimatedPoliceIndex);
                this.myRoad.setCell(1, 25, this.myRoad.myAnimatedPoliceIndex);
            }
            if (this.trafficFlagCounter == 69 && this.trafficSpeedFlag) {
                this.toggleSoundCounter(2);
            }
            if (this.trafficFlagCounter == 1 && this.trafficSpeedFlag) {
                ++this.trafficViolation;
                this.myRoad.setCell(1, 5, 1);
                this.myRoad.setCell(1, 25, 1);
                this.totalFare -= this.trafficViolation * 40;
            }
        }
        if (this.gas == 25 || this.gas == 20 || this.gas == 10 || this.gas == 5) {
            if (this.flagCounter == 0) {
                this.lowFuelFlag = true;
                this.flagCounter = 50;
            }
        } else if (this.flagCounter == 0) {
            this.lowFuelFlag = false;
        }
        if (this.jeepHealth < 21) {
            this.JeepLowHealthFlag = true;
            if (this.flagCounter == 0) {
                this.JeepLowHealthFlag = true;
                this.flagCounter = 8;
            }
        } else if (this.flagCounter == 0) {
            this.JeepLowHealthFlag = false;
        }
        if (this.driverHealth == 25 || this.driverHealth == 15 || this.driverHealth == 10 || this.driverHealth == 5) {
            this.DriverLowHealthFlag = true;
            if (this.flagCounter == 0) {
                this.DriverLowHealthFlag = true;
                this.flagCounter = 50;
            }
        } else {
            this.DriverLowHealthFlag = false;
            if (this.flagCounter == 0) {
                this.DriverLowHealthFlag = false;
            }
        }
        this.myCurrentTopY = !this.upDirection ? (this.myCurrentTopY += this.newSpeed) : (this.myCurrentTopY -= this.newSpeed);
        this.myRoad.advance(gameTicks);
        this.stations.advance(gameTicks);
        this.myBuildings.advance(gameTicks);
        this.myJeepney.advance(gameTicks, this.upDirection, this.rightDirection, this.newSpeed);
        for (i = 0; i < this.myBottomVehicles.length; ++i) {
            this.myBottomVehicles[i].advance(this.myJeepney, gameTicks, this.myCurrentTopY + DISP_HEIGHT, this.myCurrentTopY, this.trafficSpeedFlag, this.trafficFlagCounter);
            this.jeepHealth -= this.myJeepney.checkVehicleCollision(this.myBottomVehicles[i], this.rightDirection, this.token, false, this.upDirection, this.newSpeed, this.damagePoints);
            this.driverHealth -= this.myJeepney.driverDamage;
            if (this.myJeepney.VehcCollided) {
                this.toggleSoundCounter(9);
                if (this.myJeepney.getRefPixelY() < this.myBottomVehicles[i].getRefPixelY()) {
                    this.newSpeed = 4;
                    this.upDirection = true;
                } else {
                    this.newSpeed = 1;
                    this.upDirection = false;
                }
            }
            for (x = 0; x < this.myBottomVehicles.length; ++x) {
                if (i == x) continue;
                this.myBottomVehicles[i].checkCollision(this.myBottomVehicles[x], true, true);
            }
            this.myBottomVehicles[i].checkItemCollision(this.myBadItems[0], true);
            this.myBottomVehicles[i].checkItemCollision(this.myBadItems[3], true);
            this.myEnemyJeep[0].checkVehicleCollision(this.myBottomVehicles[i], this.enemyLoading);
            this.myBottomVehicles[i].Distance(this.newSpeed, this.upDirection);
        }
        for (i = 0; i < this.myTopVehicles.length; ++i) {
            this.myTopVehicles[i].advance(this.myJeepney, gameTicks, this.myCurrentTopY + DISP_HEIGHT, this.myCurrentTopY, this.trafficSpeedFlag, this.trafficFlagCounter);
            this.jeepHealth -= this.myJeepney.checkVehicleCollision(this.myTopVehicles[i], this.rightDirection, this.token, true, this.upDirection, this.newSpeed, this.damagePoints);
            this.driverHealth -= this.myJeepney.driverDamage;
            if (this.myJeepney.VehcCollided) {
                this.toggleSoundCounter(9);
                if (this.myJeepney.getRefPixelX() - this.myTopVehicles[i].getRefPixelX() < 17 && this.myJeepney.getRefPixelX() - this.myTopVehicles[i].getRefPixelX() > -17) {
                    if (this.myJeepney.getRefPixelY() < this.myTopVehicles[i].getRefPixelY() - 30) {
                        this.newSpeed = 1;
                        this.upDirection = true;
                        this.token = 1;
                    } else {
                        this.newSpeed = 3;
                        this.upDirection = false;
                        this.token = 2;
                    }
                } else {
                    this.newSpeed = 2;
                }
            }
            for (x = 0; x < this.myTopVehicles.length; ++x) {
                if (i == x) continue;
                this.myTopVehicles[i].checkCollision(this.myTopVehicles[x], true, false);
            }
            this.myTopVehicles[i].checkItemCollision(this.myBadItems[0], false);
            this.myTopVehicles[i].checkItemCollision(this.myBadItems[3], false);
            this.myEnemyJeep[0].checkVehicleCollision(this.myTopVehicles[i], this.enemyLoading);
        }
        if (this.myJeepney.returnToken == 5 && this.myJeepney.LdngColCounter < 1 && this.myJeepney.GasColCounter < 1) {
            this.token = 1;
        } else if (this.myJeepney.returnToken == 2 && this.myJeepney.LdngColCounter > 1 && this.myJeepney.GasColCounter > 1) {
            this.token = 2;
        }
        for (i = 0; i < this.myBadItems.length; ++i) {
            this.myBadItems[i].advance(this.myJeepney, gameTicks, this.myCurrentTopY + DISP_HEIGHT, this.myCurrentTopY, this.trafficSpeedFlag, false);
            this.jeepHealth -= this.myJeepney.checkItemCollision(this.myBadItems[i], this.rightDirection, this.token, this.upDirection, this.newSpeed, false, i, this.itemCounter, this.damagePoints);
            this.driverHealth -= this.myJeepney.driverDamage;
            if (this.myJeepney.ItemCollided) {
                this.newSpeed = 3;
                if (i == 0 || i == 3) {
                    this.toggleSoundCounter(9);
                    if (!this.upDirection) {
                        this.upDirection = true;
                    } else if (this.upDirection) {
                        this.upDirection = false;
                    }
                    if (this.rightDirection) {
                        this.myJeepney.move(-5, 0);
                    } else {
                        this.myJeepney.move(5, 0);
                    }
                } else {
                    this.itemCounter = 80;
                    this.toggleSoundCounter(9);
                }
            }
            if (this.itemCounter == 80) {
                this.driverHealth -= this.myJeepney.driverDamage;
            }
            if (i != 0 && i != 3) continue;
            this.myEnemyJeep[0].checkItemCollision(this.myBadItems[i]);
        }
        for (i = 0; i < this.myGoodItems.length; ++i) {
            this.myGoodItems[i].advance(this.myJeepney, gameTicks, this.myCurrentTopY + DISP_HEIGHT, this.myCurrentTopY, this.trafficSpeedFlag, true);
            this.jeepHealth += this.myJeepney.checkItemCollision(this.myGoodItems[i], this.rightDirection, this.token, this.upDirection, this.newSpeed, true, i, this.itemCounter, this.damagePoints);
            if (this.jeepHealth > 100) {
                this.jeepHealth = 100;
            }
            this.driverHealth += this.myJeepney.driverBurger;
            if (this.myJeepney.ItemColCounter == 99 && i == 5) {
                this.totalFare += Jeepney.moneyBag;
            }
            if (this.driverHealth > 100) {
                this.driverHealth = 100;
            }
            if (this.myJeepney.turboFlag) {
                this.turboCounter = 600;
                if (this.turboCounter == 600) {
                    this.maxSpeed += 2;
                }
            }
            if (this.myJeepney.musicFlag) {
                this.maxPassengers += 4;
                this.musicCounter = 600;
            }
            if (this.myJeepney.scramblerFlag) {
                this.scramblerCounter = 600;
            }
            if (this.turboCounter > 0) {
                this.myGoodItems[0].setVisible(false);
            }
            if (this.musicCounter > 0) {
                this.myGoodItems[3].setVisible(false);
            }
            if (this.scramblerCounter > 0) {
                this.myGoodItems[4].setVisible(false);
            }
            this.myGoodItems[i].Distance(this.newSpeed, this.upDirection);
        }
        for (i = 0; i < this.myEnemyJeep.length; ++i) {
            if (this.Level > 1) {
                this.myEnemyJeep[i].advance(this.myJeepney, gameTicks, this.enemySpeed, this.myCurrentTopY, this.trafficSpeedFlag, this.trafficFlagCounter, this.enemyLoading, DISP_HEIGHT);
                this.jeepHealth -= this.myJeepney.checkEnemyCollision(this.myEnemyJeep[i], this.rightDirection, this.token, false, this.upDirection, this.newSpeed, this.damagePoints);
                this.driverHealth -= this.myJeepney.driverDamage;
                this.enemyPosition = this.myEnemyJeep[i].getRefPixelY() - this.myJeepney.getRefPixelY();
            }
            this.driverHealth -= this.myJeepney.driverDamage;
            if (!this.myJeepney.EnemyCollided) continue;
            if (this.myJeepney.EnemyColCounter == 20 && this.myJeepney.LdngCollided) {
                this.myEnemyJeep[i].move(-20, 0);
            }
            this.toggleSoundCounter(9);
            if (this.myJeepney.getRefPixelY() < this.myEnemyJeep[i].getRefPixelY()) {
                this.newSpeed = 5;
                this.upDirection = true;
                continue;
            }
            this.newSpeed = 2;
            this.upDirection = false;
        }
        if (this.Level > 1) {
            if (this.enemyPosition < 0 && this.enemyPosition > -400 && (this.myEnemyJeep[0].getRefPixelY() > 860 && this.myEnemyJeep[0].getRefPixelY() < 930 || this.myEnemyJeep[0].getRefPixelY() > 2119 && this.myEnemyJeep[0].getRefPixelY() < 2189) && !this.myJeepney.LdngCollided && this.newSpeed > 0 && this.Level > 1 && this.myJeepney.getRefPixelY() - this.myEnemyJeep[0].getRefPixelY() > 32) {
                this.enemyLoading = true;
                this.myEnemyJeep[0].move(181 + this.dispGap - this.myEnemyJeep[0].getRefPixelX(), 0);
            } else if (this.enemyPosition > 260 || this.Level == 1) {
                this.enemyLoading = false;
            }
        }
        this.passengers = this.myJeepney.currentPassengers;
        this.unloadedPassengers = this.myJeepney.passengersUnloaded;
        this.loadedPassengers = this.myJeepney.newPassengers;
        this.totalFare = this.totalFare + this.myJeepney.fareEarned - this.gasFill - this.repairFill * 4 - this.healthFill;
        if (this.myJeepney.LdngColCounter == 1 || this.enemyLoading) {
            this.stations.setVisible(false);
            this.myBuildings.setCell(3, 6, this.myBuildings.myAnimatedLoadingIndex);
            this.myBuildings.setCell(3, 15, this.myBuildings.myAnimatedLoadingIndex);
            this.loadingDistance = 0;
            if (this.myJeepney.LdngColCounter == 1) {
                this.newSpeed = 1;
                this.upDirection = true;
            }
        } else if (this.loadingDistance > 400) {
            this.stations.setVisible(true);
            this.myBuildings.setCell(3, 6, 0);
            this.myBuildings.setCell(3, 15, 0);
            this.stations.setCell(3, 12, 0);
            this.stations.setCell(3, 2, 0);
            this.stations.setCell(3, 9, 0);
            if (this.Level == 1) {
                this.enemyLoading = false;
            }
        }
        if (this.myJeepney.LdngColCounter == 74) {
            this.toggleSoundCounter(3);
        }
        this.jeepHealth -= this.myJeepney.checkBuildingCollision(this.myBuildings, 178 + this.dispGap - this.myJeepney.getRefPixelX(), 97 + this.dispGap - this.myJeepney.getRefPixelX(), this.rightDirection, this.damagePoints);
        this.driverHealth -= this.myJeepney.driverDamage;
        if (this.myJeepney.BldgColCounter == 19) {
            this.driverHealth -= 3;
            this.toggleSoundCounter(9);
        }
        if (this.myJeepney.BldgCollided) {
            this.newSpeed = 2;
            this.upDirection = this.token != 1;
        }
        if (this.myJeepney.checkStationCollision(this.stations, 178 + this.dispGap - this.myJeepney.getRefPixelX(), this.passengers, this.maxPassengers)) {
            this.newSpeed = 0;
            this.myJeepney.move(182 + this.dispGap - this.myJeepney.getRefPixelX(), 0);
        }
        if (this.myJeepney.GasColCounter > 1) {
            this.gasFlag = true;
            this.gasFill = 0;
            if (this.myJeepney.GasColCounter == 99) {
                this.toggleSoundCounter(5);
            }
            this.myBuildings.setCell(3, 12, 0);
            this.stations.setVisible(true);
            this.stations.setCell(3, 12, this.stations.myAnimatedGasStationIndex);
            this.zeroEarnings = this.totalFare <= 0;
            if (!this.zeroEarnings && this.gas < 100) {
                this.mileage += 200;
                this.gasFill = 1;
                this.liters += this.gasFill;
                if (this.mileage > 20000) {
                    this.mileage = 20000;
                }
            } else {
                this.gasFill = 0;
            }
        } else if (this.myJeepney.GasColCounter == 1) {
            this.gasFlag = false;
            this.gasFill = 0;
            this.liters = 0;
            this.stations.setCell(3, 12, 0);
            this.myBuildings.setCell(3, 12, this.myBuildings.myAnimatedGasStationIndex);
            this.newSpeed = 1;
            this.upDirection = true;
        }
        if (this.myJeepney.RprColCounter > 1) {
            this.repairFlag = true;
            this.repairFill = 0;
            this.myBuildings.setCell(3, 2, 0);
            this.stations.setVisible(true);
            this.stations.setCell(3, 2, this.stations.myAnimatedRepairStationIndex);
            if (this.myJeepney.RprColCounter == 99) {
                this.toggleSoundCounter(4);
            }
            this.zeroEarnings = this.totalFare <= 0;
            if (this.totalFare > 3 && this.jeepHealth < 100) {
                ++this.jeepHealth;
                this.repairFill = 1;
                this.healthAdded += this.repairFill;
            } else {
                this.repairFill = 0;
            }
        } else if (this.myJeepney.RprColCounter == 1) {
            this.repairFlag = false;
            this.repairFill = 0;
            this.healthAdded = 0;
            this.stations.setCell(3, 2, 0);
            this.myBuildings.setCell(3, 2, this.myBuildings.myAnimatedRepairStationIndex);
            this.newSpeed = 1;
            this.upDirection = true;
        }
        if (this.myJeepney.DrvColCounter > 1) {
            this.driveThruFlag = true;
            this.healthFill = 0;
            this.myBuildings.setCell(3, 9, 0);
            this.stations.setCell(3, 9, this.stations.myAnimatedDriveThruIndex);
            this.stations.setVisible(true);
            if (this.myJeepney.DrvColCounter == 99) {
                this.toggleSoundCounter(6);
            }
            this.zeroEarnings = this.totalFare <= 0;
            if (!this.zeroEarnings && this.driverHealth < 100) {
                ++this.driverHealth;
                this.healthFill = 1;
                this.healthAdded += this.healthFill;
            } else {
                this.healthFill = 0;
            }
        } else if (this.myJeepney.DrvColCounter == 1) {
            this.driveThruFlag = false;
            this.healthFill = 0;
            this.healthAdded = 0;
            this.stations.setCell(3, 9, 0);
            this.myBuildings.setCell(3, 9, this.myBuildings.myAnimatedDriveThruIndex);
            this.newSpeed = 1;
            this.upDirection = true;
        }
        this.wrap();
    }
}

