/*
 * Decompiled with CFR 0.152.
 */
package MyGame;

import MyGame.Items;
import MyGame.Jeepney;
import MyGame.Vehicles;
import java.util.Random;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class EnemyJeep
extends Sprite {
    static int WIDTH = 18;
    static int HEIGHT = 29;
    private byte enemySpeed = (byte)4;
    private Random myRandom = new Random();
    private boolean passedThrough;
    private boolean goingUp;
    private int myCurrentTopBound;
    private int dispGap;

    public EnemyJeep(boolean top, Image image, int width, int height, int dWidth) throws Exception {
        super(image, width, height);
        WIDTH = width;
        HEIGHT = height;
        this.goingUp = top;
        this.dispGap = dWidth >= 320 ? 60 : 0;
        if (!this.goingUp) {
            this.setTransform(1);
        }
        this.passedThrough = false;
        this.setVisible(false);
    }

    synchronized boolean go() {
        boolean retVal = false;
        if (!this.isVisible()) {
            retVal = true;
            this.passedThrough = false;
            this.setVisible(true);
            if (this.goingUp) {
                int randomXLeft = this.getRandomInt(2);
                if (randomXLeft == 0) {
                    this.setRefPixelPosition(this.dispGap + 161, this.myCurrentTopBound - 4 * HEIGHT);
                    this.enemySpeed = (byte)4;
                } else if (randomXLeft == 1) {
                    this.setRefPixelPosition(this.dispGap + 181, this.myCurrentTopBound - 4 * HEIGHT);
                    this.enemySpeed = (byte)4;
                }
                this.move(0, 1);
            }
        }
        return retVal;
    }

    void reset() {
        this.setVisible(false);
        this.passedThrough = false;
    }

    void checkVehicleCollision(Vehicles vehicle, boolean enemyLoading) {
        if (this.collidesWith(vehicle, true)) {
            if (!enemyLoading) {
                if (this.getRefPixelX() < 190 + this.dispGap && this.getRefPixelX() > 104 + this.dispGap) {
                    this.move(-20, 2);
                } else {
                    this.move(40, 2);
                }
            } else {
                vehicle.move(-20, 0);
            }
        }
    }

    void checkItemCollision(Items item) {
        if (this.collidesWith(item, true)) {
            if (this.getRefPixelX() < 190 + this.dispGap && this.getRefPixelX() > 104 + this.dispGap) {
                this.move(-20, 2);
            } else {
                this.move(40, 2);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    void advance(Jeepney jeepney, int tickCount, int speed, int currentTopBound, boolean trafficFlag, int trafficCounter, boolean enemyLoading, int dHeight) {
        block13: {
            this.enemySpeed = (byte)speed;
            this.myCurrentTopBound = currentTopBound;
            if (this.getRefPixelY() < 165) {
                if (dHeight > 234) {
                    this.move(0, 2800 - dHeight - 180);
                } else if (this.getRefPixelY() < 130) {
                    this.move(0, 2800 - dHeight - 220);
                }
            }
            if (!this.isVisible()) break block13;
            if (tickCount % 5 == 0) {
                this.nextFrame();
            }
            if (enemyLoading) break block13;
            if (jeepney.BldgColCounter <= 1 && jeepney.LdngColCounter <= 1 && jeepney.GasColCounter <= 1 && jeepney.RprColCounter <= 1 && jeepney.DrvColCounter <= 1 || this.getRefPixelX() <= 170 + this.dispGap || this.getRefPixelY() + 30 <= jeepney.getRefPixelY()) ** GOTO lbl-1000
            if (this.getRefPixelY() < jeepney.getRefPixelY() + 32 + 2) {
                this.move(-20, -this.enemySpeed);
            } else if (jeepney.EnemyColCounter > 1 && jeepney.getRefPixelY() < this.getRefPixelY() && jeepney.getRefPixelX() - this.getRefPixelX() < 17 && jeepney.getRefPixelX() - this.getRefPixelX() > -17) {
                if (this.getRefPixelX() < 190 + this.dispGap && this.getRefPixelX() > 104 + this.dispGap) {
                    this.move(-20, 2);
                } else {
                    this.move(40, 2);
                }
                this.enemySpeed = (byte)7;
            } else {
                if (jeepney.EnemyColCounter > 1) {
                    this.enemySpeed = (byte)7;
                }
                this.move(0, -this.enemySpeed);
            }
            if (!this.passedThrough && this.getRefPixelY() < jeepney.getRefPixelY()) {
                this.passedThrough = true;
            }
        }
    }

    private int getRandomInt(int upper) {
        int retVal = this.myRandom.nextInt() % upper;
        if (retVal < 0) {
            retVal += upper;
        }
        return retVal;
    }
}

