/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class AALScaledTileset {
    public static final int FP_RES = 15;
    public static final int DEFAULT_NB_SCALED_TILES = 20;
    private short[] m_tileCoordsShort;
    private int[] m_rgbDataSrc;
    private int[] m_rgbDataDest;
    private int m_scanLengthSrc;
    private Image[][] m_scaledTiles;

    public AALScaledTileset() {
        this.m_scaledTiles = new Image[20][];
    }

    public AALScaledTileset(int p_nbScaledTiles) {
        this.m_scaledTiles = new Image[p_nbScaledTiles][];
    }

    public int getNbScalingLevels(int p_scaledTileIndex) {
        return this.m_scaledTiles[p_scaledTileIndex].length;
    }

    public int getTileHeight(int p_scaledTileIndex, int p_scalingLevel) {
        return this.m_scaledTiles[p_scaledTileIndex][p_scalingLevel].getHeight();
    }

    public int getTileWidth(int p_scaledTileIndex, int p_scalingLevel) {
        return this.m_scaledTiles[p_scaledTileIndex][p_scalingLevel].getWidth();
    }

    public void beginScalingTiles(int p_tilesetResourceId) throws IOException {
        DataInputStream tilesetInputStream = AALDevice.openFileAsStream(p_tilesetResourceId);
        int tilesetImageResourceIdInteger = AALDevice.readFilerefChunkIntegerValue(tilesetInputStream);
        int nbTiles = tilesetInputStream.readUnsignedByte();
        int tileIndexBiggestArea = 0;
        this.m_tileCoordsShort = new short[nbTiles * 4];
        for (int i = 0; i < nbTiles; ++i) {
            this.m_tileCoordsShort[i * 4 + 0] = tilesetInputStream.readShort();
            this.m_tileCoordsShort[i * 4 + 1] = tilesetInputStream.readShort();
            this.m_tileCoordsShort[i * 4 + 2] = tilesetInputStream.readShort();
            this.m_tileCoordsShort[i * 4 + 3] = tilesetInputStream.readShort();
            if (this.m_tileCoordsShort[i * 4 + 2] * this.m_tileCoordsShort[i * 4 + 3] <= this.m_tileCoordsShort[tileIndexBiggestArea * 4 + 2] * this.m_tileCoordsShort[tileIndexBiggestArea * 4 + 3]) continue;
            tileIndexBiggestArea = i;
        }
        tilesetInputStream.close();
        tilesetInputStream = null;
        Image tilesetImage = AALDevice.createImage(tilesetImageResourceIdInteger);
        this.m_rgbDataSrc = new int[tilesetImage.getWidth() * tilesetImage.getHeight()];
        this.m_scanLengthSrc = tilesetImage.getWidth();
        this.m_rgbDataSrc = AALScaledTileset.myGetRGB(tilesetImage);
        tilesetImage = null;
        this.m_rgbDataDest = new int[this.m_tileCoordsShort[tileIndexBiggestArea * 4 + 2] * this.m_tileCoordsShort[tileIndexBiggestArea * 4 + 3]];
    }

    public static int[] myGetRGB(Image image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int length = width * height;
        int[] maskwhite = new int[length];
        int[] maskblack = new int[length];
        Image buffer = Image.createImage((int)width, (int)height);
        Graphics g = buffer.getGraphics();
        g.setColor(0);
        g.fillRect(0, 0, width, height);
        g.drawImage(image, 0, 0, 20);
        buffer.getRGB(maskwhite, 0, width, 0, 0, width, height);
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, width, height);
        g.drawImage(image, 0, 0, 20);
        buffer.getRGB(maskblack, 0, width, 0, 0, width, height);
        buffer = null;
        int[] imageRGB = new int[width * height];
        image.getRGB(imageRGB, 0, width, 0, 0, width, height);
        for (int i = 0; i < length; ++i) {
            if ((maskwhite[i] & 0xFFFFFF) != 0 || (maskblack[i] & 0xFFFFFF) != 0xFFFFFF) continue;
            imageRGB[i] = 0;
        }
        return imageRGB;
    }

    public void endScalingTiles() {
        this.m_tileCoordsShort = null;
        this.m_rgbDataSrc = null;
        this.m_rgbDataDest = null;
    }

    public void shrinkTile(int p_scaledTileIndex, int p_tilesetTileIndex, int p_nbScalingLevels, int p_fpScalingStep, boolean p_processAlpha) {
        short xSrc = this.m_tileCoordsShort[p_tilesetTileIndex * 4 + 0];
        short ySrc = this.m_tileCoordsShort[p_tilesetTileIndex * 4 + 1];
        short widthSrc = this.m_tileCoordsShort[p_tilesetTileIndex * 4 + 2];
        short heightSrc = this.m_tileCoordsShort[p_tilesetTileIndex * 4 + 3];
        this.m_scaledTiles[p_scaledTileIndex] = new Image[p_nbScalingLevels];
        for (int i = 0; i < p_nbScalingLevels; ++i) {
            int fpScale = 0x40000000 / (32768 + i * p_fpScalingStep);
            int widthDest = this.m_tileCoordsShort[p_tilesetTileIndex * 4 + 2] * fpScale >> 15;
            int heightDest = this.m_tileCoordsShort[p_tilesetTileIndex * 4 + 3] * fpScale >> 15;
            if (widthDest == 0) {
                widthDest = 1;
            }
            if (heightDest == 0) {
                heightDest = 1;
            }
            if (i > 0 && this.m_scaledTiles[p_scaledTileIndex][i - 1].getWidth() == widthDest && this.m_scaledTiles[p_scaledTileIndex][i - 1].getHeight() == heightDest) {
                this.m_scaledTiles[p_scaledTileIndex][i] = this.m_scaledTiles[p_scaledTileIndex][i - 1];
                continue;
            }
            AALScaledTileset.scaleTile_Nearest(this.m_rgbDataSrc, this.m_scanLengthSrc, xSrc, ySrc, widthSrc, heightSrc, this.m_rgbDataDest, widthDest, heightDest);
            this.m_scaledTiles[p_scaledTileIndex][i] = Image.createRGBImage((int[])this.m_rgbDataDest, (int)widthDest, (int)heightDest, (boolean)p_processAlpha);
        }
    }

    public void drawTileDesiredHeight(int p_scaledTileIndex, int p_desiredHeight, int p_x, int p_y, int p_anchor) {
        int imageIndex;
        if (p_desiredHeight < 1) {
            return;
        }
        Image[] images = this.m_scaledTiles[p_scaledTileIndex];
        for (imageIndex = images.length - 1; imageIndex > 0 && images[imageIndex].getHeight() < p_desiredHeight; --imageIndex) {
        }
        AALDevice.s_activeGraphics.drawImage(images[imageIndex], p_x, p_y, p_anchor);
    }

    private static void scaleTile_Nearest(int[] p_rgbDataSrc, int p_scanLengthSrc, int p_xSrc, int p_ySrc, int p_widthSrc, int p_heightSrc, int[] p_rgbDataDest, int p_widthDest, int p_heightDest) {
        int fpYSrcStart;
        int fpXSrcStep = (p_widthSrc << 15) / p_widthDest;
        int fpYSrcStep = (p_heightSrc << 15) / p_heightDest;
        int fpXSrcStart = (fpXSrcStep >> 1) + (p_xSrc << 15);
        int fpYSrc = fpYSrcStart = (fpYSrcStep >> 1) + (p_ySrc << 15);
        int rowDestOffset = 0;
        for (int yDest = 0; yDest < p_heightDest; ++yDest) {
            int rowOffset = (fpYSrc >> 15) * p_scanLengthSrc;
            int fpXSrc = fpXSrcStart;
            for (int xDest = 0; xDest < p_widthDest; ++xDest) {
                p_rgbDataDest[rowDestOffset + xDest] = p_rgbDataSrc[rowOffset + (fpXSrc >> 15)];
                fpXSrc += fpXSrcStep;
            }
            fpYSrc += fpYSrcStep;
            rowDestOffset += p_widthDest;
        }
    }
}

