/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;

public final class GTKAnim {
    public static final int BEHAVIOR_LOOP_ONCE = 0;
    public static final int BEHAVIOR_LOOP_RESTART = 1;
    public static final int BEHAVIOR_LOOP_PING = 2;
    private static final int BEHAVIOR_LOOP_MASK = 3;
    private static final int BEHAVIOR_POSSIBLE_TRANSFORMATIONS_MASK = 65280;
    private static final int BEHAVIOR_POSSIBLE_TRANSFORMATIONS_BITSHIFT = 8;
    public static final int STATE_STOPPED = 0;
    public static final int STATE_FORWARD = 1;
    public static final int STATE_BACKWARD = 2;
    private static final int INSTANCE_TIME_BIT_SHIFT = 16;
    private static final int INSTANCE_FRAME_BIT_SHIFT = 2;
    private static final int INSTANCE_STATE_BIT_SHIFT = 0;
    private static final int INSTANCE_TIME_BIT_MASK = -65536;
    private static final int INSTANCE_FRAME_BIT_MASK = 65532;
    private static final int INSTANCE_STATE_BIT_MASK = 3;
    private static final int TEMP_BUFFER_OFFSET_HOT_SPOT = 0;
    private static final int TEMP_BUFFER_OFFSET_FRAME_BOUNDING_BOX = 2;
    private static final int SIZEOF_TEMP_BUFFER = 6;
    private static final int[] s_tempBuffer = new int[6];
    private short[] m_modelLayerDataArrayShort;
    private byte[] m_modelFrameToLayerIndices;
    private short[] m_modelFrameTimeLimit;
    private int m_modelBehaviour;
    private int m_modelTotalDuration;

    public GTKAnim(int p_nbFrames, int p_nbLayers, int p_loopMode, int p_possibleTransformations) {
        this.m_modelLayerDataArrayShort = new short[p_nbLayers * 3];
        if (p_nbFrames != p_nbLayers) {
            this.m_modelFrameToLayerIndices = new byte[p_nbFrames];
        }
        this.m_modelFrameTimeLimit = new short[p_nbFrames];
        this.m_modelBehaviour = p_loopMode | p_possibleTransformations << 8;
    }

    public void addFrameLayer(int p_frameIndex, int p_globalLayerIndex, int p_layerTileIndex, int p_frameDuration, int p_hotspotX, int p_hotspotY) {
        int layerOffset = p_globalLayerIndex * 3;
        this.m_modelLayerDataArrayShort[layerOffset++] = (short)p_layerTileIndex;
        this.m_modelLayerDataArrayShort[layerOffset++] = (short)p_hotspotX;
        this.m_modelLayerDataArrayShort[layerOffset] = (short)p_hotspotY;
        if (this.m_modelFrameToLayerIndices != null) {
            this.m_modelFrameToLayerIndices[p_frameIndex] = (byte)p_globalLayerIndex;
        }
        if (this.m_modelFrameTimeLimit[p_frameIndex] == 0) {
            this.m_modelFrameTimeLimit[p_frameIndex] = (short)(p_frameIndex == 0 ? p_frameDuration : this.m_modelFrameTimeLimit[p_frameIndex - 1] + p_frameDuration);
            this.m_modelTotalDuration += p_frameDuration;
        }
    }

    public void setLoopMode(int p_loopMode) {
        this.m_modelBehaviour = this.m_modelBehaviour & 0xFFFFFFFC | p_loopMode;
    }

    public int getLoopMode() {
        return this.m_modelBehaviour & 3;
    }

    private boolean isComposite() {
        return this.m_modelFrameToLayerIndices != null;
    }

    public int getPossibleTransformations() {
        return (this.m_modelBehaviour & 0xFF00) >>> 8;
    }

    public int getNbFrames() {
        return this.m_modelFrameTimeLimit.length;
    }

    public int getTotalDuration() {
        return this.m_modelTotalDuration;
    }

    public int getNbTotalLayers() {
        int result = this.m_modelLayerDataArrayShort.length / 3;
        return result;
    }

    public int getNbLayersAtFrame(int p_frameIndex) {
        int firstLayerIndex = this.getFirstLayerIndexAtFrame(p_frameIndex);
        int lastLayerIndex = this.getLastLayerIndexAtFrame(p_frameIndex);
        return lastLayerIndex - firstLayerIndex + 1;
    }

    private int getFirstLayerIndexAtFrame(int p_frameIndex) {
        int result = p_frameIndex;
        if (this.isComposite() && p_frameIndex != 0) {
            result = (this.m_modelFrameToLayerIndices[p_frameIndex - 1] & 0xFF) + 1;
        }
        return result;
    }

    private int getLastLayerIndexAtFrame(int p_frameIndex) {
        int result = p_frameIndex;
        if (this.isComposite()) {
            result = this.m_modelFrameToLayerIndices[p_frameIndex] & 0xFF;
        }
        return result;
    }

    private int getLayerTileIndex(int p_layerOffset) {
        short result = this.m_modelLayerDataArrayShort[p_layerOffset];
        return result;
    }

    private int getLayerHotspotX(int p_layerOffset) {
        short result = this.m_modelLayerDataArrayShort[p_layerOffset + 1];
        return result;
    }

    private int getLayerHotspotY(int p_layerOffset) {
        short result = this.m_modelLayerDataArrayShort[p_layerOffset + 2];
        return result;
    }

    public void computeGlobalBoundingBox(AALTileset p_modelTileset, int p_tileTransformation, int[] p_outputArray, int p_outputOffset) {
        int nbFrames = this.m_modelFrameTimeLimit.length;
        int[] frameRectangle = s_tempBuffer;
        this.computeFrameBoundingBox(0, p_modelTileset, p_tileTransformation, frameRectangle, 2);
        int boundingLeft = frameRectangle[2];
        int boundingTop = frameRectangle[3];
        int boundingRight = frameRectangle[4];
        int boundingBottom = frameRectangle[5];
        for (int i = 0; i < nbFrames; ++i) {
            this.computeFrameBoundingBox(i, p_modelTileset, p_tileTransformation, frameRectangle, 2);
            boundingLeft = Math.min(boundingLeft, frameRectangle[2]);
            boundingTop = Math.min(boundingTop, frameRectangle[3]);
            boundingRight = Math.max(boundingRight, frameRectangle[4]);
            boundingBottom = Math.max(boundingBottom, frameRectangle[5]);
        }
        p_outputArray[p_outputOffset++] = boundingLeft;
        p_outputArray[p_outputOffset++] = boundingTop;
        p_outputArray[p_outputOffset++] = boundingRight;
        p_outputArray[p_outputOffset++] = boundingBottom;
    }

    public void computeFrameBoundingBox(int p_frameIndex, AALTileset p_modelTileset, int p_tileTransformation, int[] p_outputArray, int p_outputOffset) {
        int currentLayerIndex;
        int lastLayerIndex = this.getLastLayerIndexAtFrame(p_frameIndex) * 3;
        int[] hotspotArray = s_tempBuffer;
        this.computeTransformedHotspot(currentLayerIndex, p_modelTileset, p_tileTransformation, hotspotArray, 0);
        int boundingLeft = -hotspotArray[0];
        int boundingTop = -hotspotArray[1];
        int boundingRight = boundingLeft;
        int boundingBottom = boundingTop;
        for (currentLayerIndex = this.getFirstLayerIndexAtFrame(p_frameIndex) * 3; currentLayerIndex <= lastLayerIndex; currentLayerIndex += 3) {
            int tileIndex = this.getLayerTileIndex(currentLayerIndex);
            this.computeTransformedHotspot(currentLayerIndex, p_modelTileset, p_tileTransformation, hotspotArray, 0);
            int layerLeft = -hotspotArray[0];
            int layerTop = -hotspotArray[1];
            int layerRight = layerLeft + p_modelTileset.getTileWidth(tileIndex, p_tileTransformation);
            int layerBottom = layerTop + p_modelTileset.getTileHeight(tileIndex, p_tileTransformation);
            boundingLeft = Math.min(boundingLeft, layerLeft);
            boundingTop = Math.min(boundingTop, layerTop);
            boundingRight = Math.max(boundingRight, layerRight);
            boundingBottom = Math.max(boundingBottom, layerBottom);
        }
        p_outputArray[p_outputOffset++] = boundingLeft;
        p_outputArray[p_outputOffset++] = boundingTop;
        p_outputArray[p_outputOffset++] = boundingRight;
        p_outputArray[p_outputOffset++] = boundingBottom;
    }

    public void computeTransformedHotspot(int p_layerOffset, AALTileset p_modelTileset, int p_tileTransformation, int[] p_outputArray, int p_outputOffset) {
        int hotspotX = this.getLayerHotspotX(p_layerOffset);
        int hotspotY = this.getLayerHotspotY(p_layerOffset);
        int transformedHotspotX = hotspotX;
        int transformedHotspotY = hotspotY;
        switch (p_tileTransformation) {
            case 0: {
                break;
            }
            case 1: {
                transformedHotspotX = hotspotY;
                transformedHotspotY = p_modelTileset.getTileWidth(this.getLayerTileIndex(p_layerOffset)) - hotspotX;
                break;
            }
            case 2: {
                transformedHotspotX = p_modelTileset.getTileWidth(this.getLayerTileIndex(p_layerOffset)) - hotspotX;
                transformedHotspotY = p_modelTileset.getTileHeight(this.getLayerTileIndex(p_layerOffset)) - hotspotY;
                break;
            }
            case 3: {
                transformedHotspotX = p_modelTileset.getTileHeight(this.getLayerTileIndex(p_layerOffset)) - hotspotY;
                transformedHotspotY = hotspotX;
                break;
            }
            case 4: {
                transformedHotspotX = p_modelTileset.getTileWidth(this.getLayerTileIndex(p_layerOffset)) - hotspotX;
                transformedHotspotY = hotspotY;
                break;
            }
            case 5: {
                transformedHotspotX = hotspotY;
                transformedHotspotY = hotspotX;
                break;
            }
            case 6: {
                transformedHotspotX = hotspotX;
                transformedHotspotY = p_modelTileset.getTileHeight(this.getLayerTileIndex(p_layerOffset)) - hotspotY;
                break;
            }
            case 7: {
                transformedHotspotX = p_modelTileset.getTileHeight(this.getLayerTileIndex(p_layerOffset)) - hotspotY;
                transformedHotspotY = p_modelTileset.getTileWidth(this.getLayerTileIndex(p_layerOffset)) - hotspotX;
            }
        }
        p_outputArray[p_outputOffset + 0] = transformedHotspotX;
        p_outputArray[p_outputOffset + 1] = transformedHotspotY;
    }

    private static void checkInstanceFieldLengths(int p_time, int p_frameIndex) {
    }

    private int createInstance(int p_currentTime, int p_currentFrame, int p_currentState) {
        return p_currentTime << 16 | p_currentFrame << 2 | p_currentState;
    }

    public int startInstanceAtFrame(int p_frameIndex) {
        short currentTime = p_frameIndex == 0 ? (short)0 : this.m_modelFrameTimeLimit[p_frameIndex - 1];
        return this.createInstance(currentTime, p_frameIndex, 1);
    }

    public int startInstanceFromEnd() {
        return this.createInstance(this.m_modelTotalDuration, this.m_modelFrameTimeLimit.length - 1, 2);
    }

    public static int getInstanceCurrentTime(int p_instance) {
        return (p_instance & 0xFFFF0000) >>> 16;
    }

    public static int getInstanceCurrentFrame(int p_instance) {
        return (p_instance & 0xFFFC) >>> 2;
    }

    public static int getInstanceCurrentState(int p_instance) {
        return p_instance & 3;
    }

    public int updateInstance(int p_instance, int p_elapsedTime) {
        int instanceCurrentState = GTKAnim.getInstanceCurrentState(p_instance);
        int instanceCurrentFrame = GTKAnim.getInstanceCurrentFrame(p_instance);
        int instanceCurrentTime = GTKAnim.getInstanceCurrentTime(p_instance);
        switch (instanceCurrentState) {
            case 1: {
                instanceCurrentTime += p_elapsedTime;
                break;
            }
            case 2: {
                instanceCurrentTime -= p_elapsedTime;
            }
        }
        switch (this.m_modelBehaviour & 3) {
            case 0: {
                if (instanceCurrentTime < this.m_modelTotalDuration && instanceCurrentTime > 0) break;
                instanceCurrentState = 0;
                break;
            }
            case 1: {
                if (instanceCurrentTime < this.m_modelTotalDuration) break;
                instanceCurrentTime -= this.m_modelTotalDuration;
                instanceCurrentFrame = 0;
                break;
            }
            case 2: {
                if (instanceCurrentTime < 0) {
                    instanceCurrentState = 1;
                    break;
                }
                if (instanceCurrentTime < this.m_modelTotalDuration) break;
                instanceCurrentState = 2;
            }
        }
        switch (instanceCurrentState) {
            case 1: {
                int lastFrame = this.m_modelFrameTimeLimit.length - 1;
                while (instanceCurrentFrame < lastFrame && instanceCurrentTime >= this.m_modelFrameTimeLimit[instanceCurrentFrame]) {
                    ++instanceCurrentFrame;
                }
                break;
            }
            case 2: {
                while (instanceCurrentFrame > 0 && instanceCurrentTime < this.m_modelFrameTimeLimit[instanceCurrentFrame - 1]) {
                    --instanceCurrentFrame;
                }
                break;
            }
        }
        GTKAnim.checkInstanceFieldLengths(instanceCurrentTime, instanceCurrentFrame);
        return this.createInstance(instanceCurrentTime, instanceCurrentFrame, instanceCurrentState);
    }

    public void drawInstance(int p_instance, AALTileset p_modelTileset, int p_x, int p_y, int p_transformation) {
        this.checkPossibleTransformation(p_transformation);
        int currentFrameIndex = GTKAnim.getInstanceCurrentFrame(p_instance);
        int currentLayerIndex = this.getFirstLayerIndexAtFrame(currentFrameIndex);
        int lastLayerIndex = this.getLastLayerIndexAtFrame(currentFrameIndex);
        currentLayerIndex += currentLayerIndex << 1;
        lastLayerIndex += lastLayerIndex << 1;
        int[] hotspotArray = s_tempBuffer;
        while (currentLayerIndex <= lastLayerIndex) {
            this.computeTransformedHotspot(currentLayerIndex, p_modelTileset, p_transformation, hotspotArray, 0);
            p_modelTileset.drawTile(this.getLayerTileIndex(currentLayerIndex), p_transformation, p_x - hotspotArray[0], p_y - hotspotArray[1]);
            currentLayerIndex += 3;
        }
    }

    private void checkPossibleTransformation(int p_transformation) {
    }

    public static GTKAnim loadAnimation(int p_fileId, int p_loopMode) throws IOException {
        AALMidlet.checkLargeElapsedTime();
        DataInputStream stream = AALDevice.openFileAsStream(p_fileId);
        int possibleTransformations = stream.readUnsignedByte();
        int nbFrames = stream.readUnsignedByte();
        int nbTotalLayers = stream.readUnsignedByte();
        GTKAnim animation = new GTKAnim(nbFrames, nbTotalLayers, p_loopMode, possibleTransformations);
        int layerGlobalIndex = 0;
        for (int i = 0; i < nbFrames; ++i) {
            short duration = stream.readShort();
            int nbLayers = stream.readUnsignedByte();
            for (int j = 0; j < nbLayers; ++j) {
                int tilesetIndex = stream.readUnsignedByte();
                short hotspotX = stream.readShort();
                short hotspotY = stream.readShort();
                animation.addFrameLayer(i, layerGlobalIndex, tilesetIndex, duration, hotspotX, hotspotY);
                ++layerGlobalIndex;
            }
        }
        stream.close();
        AALMidlet.checkLargeElapsedTime();
        return animation;
    }
}

