/*
 * Decompiled with CFR 0.152.
 */
package mcloud.sik.hiscores;

import java.io.DataInputStream;
import java.io.IOException;
import mcloud.sik.common.IHardwareUser;
import mcloud.sik.common.Module;
import mcloud.sik.common.NetProtocol;
import mcloud.sik.common.Params;
import mcloud.sik.common.Resources;
import mcloud.sik.common.SIK;
import mcloud.sik.hiscores.HighscoreResult;
import mcloud.sik.hiscores.HttpConnThread;
import mcloud.sik.hiscores.IHSUser;

public class HiScoresModule
extends Module
implements Runnable,
IHardwareUser,
Params,
Resources {
    private String serverLink;
    private String appName = null;
    private boolean connectionInProgress = false;
    private boolean enabled;
    private int uid = -1;
    private int gid = -1;
    private String pin;
    private String nick;
    private String category = null;
    private HighscoreResult gotPending;
    private String param;
    private static final byte STATE_IDLE = 0;
    private static final byte STATE_SEND_SCORES = 1;
    private static final byte STATE_ASK_GUID = 2;
    private static final byte STATE_WAIT_UID = 3;
    private static final byte STATE_ASK_GUID_IN_REG = 4;
    private static final byte STATE_WAIT_SMS = 5;
    private static final byte STATE_REQUEST_NEAREST = 6;
    private static final byte STATE_REQUEST_PORTION = 7;
    private static final byte STATE_ASK_GUID_IN_REQNEAR = 8;
    private static final byte STATE_ASK_GUID_IN_FB = 9;
    public int uploadStatus = 5;
    public long lastTime;
    public long elapsedTime = 0L;
    static final int TIME_OUT_MS = 45000;
    public HttpConnThread httpThread;
    public static boolean connectionOpened;
    private int viewId;
    private int count;
    private String reqParam;

    public HiScoresModule() {
        String appNameJadKey;
        String serverLinkJadKey = (String)SIK.getResource(5, true);
        if (serverLinkJadKey != null) {
            this.serverLink = SIK.instance.sikUser.getJadAttribute(serverLinkJadKey);
        }
        if (this.serverLink != null && this.serverLink.trim().length() == 0) {
            this.serverLink = null;
        }
        if (this.serverLink != null) {
            String host;
            if (this.serverLink.indexOf("http://") == -1) {
                this.serverLink = "http://" + this.serverLink;
            }
            if ((host = this.serverLink.substring(7, this.serverLink.length())).indexOf("/") == -1) {
                this.serverLink = this.serverLink + "/";
            } else if (host.indexOf("/") != host.length() - 1 && host.charAt(host.length() - 1) == '/') {
                this.serverLink = this.serverLink.substring(0, this.serverLink.length() - 1);
            }
        }
        if ((appNameJadKey = (String)SIK.getResource(8, true)) != null) {
            this.appName = SIK.instance.sikUser.getJadAttribute(appNameJadKey);
        }
        if ("".equals(this.appName)) {
            this.appName = null;
        }
        this.enabled = this.appName != null && this.serverLink != null;
        this.state = 0;
    }

    public boolean initActive(Object[] params) {
        return true;
    }

    public void initState(byte state) {
    }

    public void requestNearest(String cat, int viewId, int count) {
        if (this.getGid() < 0) {
            this.category = cat;
            this.viewId = viewId;
            this.count = count;
            this.askForGid((byte)8);
            return;
        }
        this.connectionInProgress = true;
        NetProtocol.NetPacket packet = new NetProtocol.NetPacket(3, new Object[]{this.appName, cat, new Integer(viewId), this.param, new Integer(this.gid), new Integer(count)});
        this.state = (byte)6;
        SIK.instance.getHardware().sendAsyncNetworkPacket(this.serverLink, this, packet);
    }

    public void requestPortion(String cat, int viewId, int from, int count, String param) {
        this.connectionInProgress = true;
        NetProtocol.NetPacket packet = new NetProtocol.NetPacket(2, new Object[]{this.appName, cat, new Integer(viewId), param, new Integer(from), new Integer(count)});
        this.state = (byte)7;
        SIK.instance.getHardware().sendAsyncNetworkPacket(this.serverLink, this, packet);
    }

    public void requestFaceBook(String cat, int viewId, String param) {
        if (this.getGid() < 0) {
            this.category = cat;
            this.viewId = viewId;
            this.reqParam = param;
            this.askForGid((byte)9);
            return;
        }
        this.connectionInProgress = true;
        NetProtocol.NetPacket packet = new NetProtocol.NetPacket(5, new Object[]{this.appName, cat, new Integer(viewId), param, new Integer(this.gid)});
        this.state = (byte)6;
        SIK.instance.getHardware().sendAsyncNetworkPacket(this.serverLink, this, packet);
    }

    public static int readInt(DataInputStream dis) throws IOException {
        byte[] buffer = new byte[1];
        byte[] data = new byte[4];
        for (int i = 0; i < 4; ++i) {
            dis.read(buffer, 0, 1);
            data[i] = buffer[0];
        }
        int result = (data[0] & 0xFF) << 24;
        result += (data[1] & 0xFF) << 16;
        result += (data[2] & 0xFF) << 8;
        return result += data[3] & 0xFF;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void destroy() {
    }

    public int getOperationResult() {
        return this.uploadStatus;
    }

    public void run() {
    }

    public String getString(int index) {
        String message = null;
        switch (index) {
            case 1: {
                message = this.httpThread.result;
                break;
            }
            case 3: {
                message = (String)SIK.getResource(3, false);
                if (message != null) break;
                message = (String)SIK.getResource(3, true);
                break;
            }
            case 2: {
                message = (String)SIK.getResource(4, false);
                if (message != null) break;
                message = (String)SIK.getResource(4, true);
                break;
            }
            case 4: {
                message = (String)SIK.getResource(2, false);
                if (message != null) break;
                message = (String)SIK.getResource(2, true);
            }
        }
        return message;
    }

    private String generateHash(int score, int gid, String name) {
        return gid + "" + score + name;
    }

    private synchronized void waitForConnectionToFinish() {
        int i = 100;
        while (this.connectionInProgress && i > 0) {
            try {
                this.wait(200L);
                --i;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void sendHS(int score, String category) {
        this.waitForConnectionToFinish();
        if (!this.isEnabled()) {
            this.notifyError();
            return;
        }
        if (this.getGid() == -1) {
            this.askForGid((byte)2);
            this.savePendingData(score, category);
        } else if (this.uid == -1) {
            this.savePendingData(score, category);
            SIK.instance.sikUser.notifyNetworkOperation(1, 2, null);
        } else {
            this.trueSendHS(score, category);
        }
    }

    private void trueSendHS(int score, String category) {
        this.category = category;
        NetProtocol.NetPacket pack = this.makeSendHSPacket(score, category);
        this.connectionInProgress = true;
        this.state = 1;
        SIK.instance.getHardware().sendAsyncNetworkPacket(this.serverLink, this, pack);
    }

    private void askForGid(byte state) {
        NetProtocol.NetPacket pack = this.makeAskGuidPacket();
        this.connectionInProgress = true;
        this.state = state;
        SIK.instance.getHardware().sendAsyncNetworkPacket(this.serverLink, this, pack);
    }

    public void sendPendingData(String nick) {
        this.waitForConnectionToFinish();
        if (!this.isEnabled()) {
            this.notifyError();
            return;
        }
        if (!this.popPendingData()) {
            this.notifyOk(null);
            return;
        }
        if (this.getGid() == -1) {
            this.askForGid((byte)2);
        } else {
            if (!nick.equals("")) {
                this.nick = nick;
            }
            this.sendPendingIfExists();
        }
    }

    private void sendPendingIfExists() {
        if (!this.popPendingData()) {
            this.notifyOk(null);
            return;
        }
        this.trueSendHS(this.gotPending.getScore(), this.gotPending.getName());
        this.gotPending = null;
    }

    private void notifyOk(String message) {
        SIK.instance.sikUser.notifyNetworkOperation(1, 0, message);
    }

    private void notifyError() {
        SIK.instance.sikUser.notifyNetworkOperation(1, 3, null);
    }

    private boolean popPendingData() {
        if (this.gotPending != null) {
            return true;
        }
        String data = SIK.instance.readDataFromRMS("pending");
        if (data == null) {
            return false;
        }
        int score = Integer.parseInt(data.substring(0, data.indexOf(":")));
        data = data.substring(data.indexOf(":") + 1);
        String cat = data.substring(0, data.indexOf(":"));
        data = data.substring(data.indexOf(":") + 1);
        SIK.instance.writeDataToRMS("pending", data);
        this.gotPending = new HighscoreResult(0, cat, score);
        return true;
    }

    public void register(String nick) {
        int gid = this.getGid();
        this.nick = nick;
        this.uid = 1;
        if (gid < 0) {
            this.askForGid((byte)4);
            return;
        }
        SIK.instance.sikUser.notifyNetworkOperation(1, 0, null);
    }

    private void sendRegisteringSMS() {
        String phonenum = SIK.instance.sikUser.getJadAttribute("SIK-Auth-SMSPhone");
        this.state = (byte)5;
        SIK.instance.getHardware().sendSMS(phonenum, "" + this.getGid() + ":" + this.pin, this);
    }

    private void ping() {
        this.connectionInProgress = true;
        SIK.instance.getHardware().sendAsyncNetworkPacket(this.serverLink, this, this.makePingPacket());
    }

    private NetProtocol.NetPacket makePingPacket() {
        NetProtocol.NetPacket pack = new NetProtocol.NetPacket();
        pack.type = (byte)4;
        pack.data = new Object[]{this.appName, new Integer(this.getGid())};
        return pack;
    }

    private NetProtocol.NetPacket makeAskGuidPacket() {
        return new NetProtocol.NetPacket(0, new Object[]{this.appName, SIK.instance.sikUser.getLanguage()});
    }

    private void savePendingData(int score, String category) {
        String old = SIK.instance.readDataFromRMS("pending");
        String newD = "" + score + ":" + category + ":";
        if (old == null) {
            old = "";
        }
        SIK.instance.writeDataToRMS("pending", old + newD);
    }

    public int getGid() {
        if (this.gid == -1) {
            this.getAuthFromRMS();
        }
        return this.gid;
    }

    private void getAuthFromRMS() {
        try {
            String auth = SIK.instance.readDataFromRMS("auth");
            if (auth == null || auth.indexOf(":") < 0) {
                return;
            }
            try {
                String str = auth.substring(0, auth.indexOf(":"));
                if (!str.equals("")) {
                    this.uid = Integer.parseInt(str);
                }
                if (!(str = (auth = auth.substring(auth.indexOf(":") + 1)).substring(0, auth.indexOf(":"))).equals("")) {
                    this.gid = Integer.parseInt(str);
                }
                if (!(str = (auth = auth.substring(auth.indexOf(":") + 1)).substring(0, auth.indexOf(":"))).equals("")) {
                    this.pin = str;
                }
                if (!(str = auth.substring(auth.indexOf(":") + 1)).equals("")) {
                    this.nick = str;
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        catch (Throwable e) {
            System.out.println("Caught!");
            e.printStackTrace();
        }
    }

    private void writeAuthToRMS() {
        String auth = "" + this.uid + ":" + this.gid + ":" + this.pin + ":" + this.nick;
        SIK.instance.writeDataToRMS("auth", auth);
    }

    private NetProtocol.NetPacket makeSendHSPacket(int score, String category) {
        int gid = this.getGid();
        if (gid == -1) {
            return null;
        }
        NetProtocol.NetPacket pack = new NetProtocol.NetPacket(1, new Object[]{this.appName, category, new Integer(gid), this.nick, new Integer(score), this.generateHash(score, gid, this.nick), this.getParam(), new Integer(10)});
        return pack;
    }

    public void receiveNetworkPacket(int result, NetProtocol.NetPacket packet) {
        if (!this.connectionInProgress) {
            return;
        }
        this.connectionInProgress = false;
        if (result == 1) {
            SIK.instance.sikUser.notifyNetworkOperation(1, 1, null);
            this.state = 0;
            return;
        }
        if (result != 200) {
            SIK.instance.sikUser.notifyNetworkOperation(1, 3, "" + result);
            this.state = 0;
            return;
        }
        this.parsePacket(packet);
    }

    public void notifySMSOperation(int result) {
        if (result != 0) {
            SIK.instance.sikUser.notifyNetworkOperation(1, 3, "Cannot send SMS");
            return;
        }
        this.state = (byte)3;
        this.ping();
    }

    private void parsePacket(NetProtocol.NetPacket packet) {
        switch (packet.type) {
            case 1: {
                Object[] data = (Object[])packet.data[0];
                int position = (Integer)data[0];
                int num = (Integer)data[1];
                HighscoreResult[] results = new HighscoreResult[num];
                num = num * 3 + 2;
                int i = 2;
                int j = 0;
                while (i < num) {
                    results[j] = new HighscoreResult((Integer)data[i], (String)data[i + 1], (Integer)data[i + 2]);
                    i += 3;
                    ++j;
                }
                ((IHSUser)SIK.instance.sikUser).returnResultTable(this.category, 2, results, position);
                this.category = null;
                this.state = 0;
                this.sendPendingIfExists();
                break;
            }
            case 0: {
                this.gid = (Integer)packet.data[0];
                this.pin = (String)packet.data[1];
                this.writeAuthToRMS();
                if (this.state == 4) {
                    this.register(this.nick);
                    break;
                }
                if (this.state == 8) {
                    this.requestNearest(this.category, this.viewId, this.count);
                    break;
                }
                if (this.state == 9) {
                    this.requestFaceBook(this.category, this.viewId, this.reqParam);
                    break;
                }
                this.state = 0;
                SIK.instance.sikUser.notifyNetworkOperation(1, 2, null);
                break;
            }
            case -1: {
                if (this.state == 3) {
                    this.ping();
                    break;
                }
                this.state = 0;
                this.notifyError();
                break;
            }
            case 2: {
                if (this.state == 3) {
                    this.uid = (Integer)packet.data[0];
                    this.writeAuthToRMS();
                    this.state = 0;
                    this.notifyOk(null);
                    break;
                }
                this.state = 0;
                this.notifyError();
            }
        }
    }

    public String getParam() {
        if (this.param == null) {
            this.param = SIK.instance.sikUser.getJadAttribute("High-Scores-Param");
        }
        if (this.param == null) {
            this.param = "";
        }
        return this.param;
    }
}

