/*
 * Decompiled with CFR 0.152.
 */
public class OnRoadElement
extends SimpleObject {
    public boolean active;
    public boolean isgum = false;
    public boolean respawnable;
    public boolean boost = false;
    public boolean atack = false;
    public boolean trap = false;
    public boolean fatality = false;
    public boolean invincibility = false;
    public boolean autopilot = false;
    public boolean random = false;
    public boolean positionChanged = false;
    public int respawntime;
    public int[] nearestPoint = new int[2];
    public int updateframe;
    public Vector3D attackDist;
    public boolean vectSet;
    public Vector3D attackPos;
    public int owner;
    public boolean shown;
    public int animRepeat;
    public boolean isInSecondFlushRange = false;

    public void init(int image, Vector3D pos, Vector3D dir, boolean act, boolean res, int typ, int anim) {
        if (anim == 8) {
            super.init(image, pos, dir, 30.0f, 330.0f, true, true);
        } else if (anim == 4) {
            super.init(image, pos, dir, 18.0f, 120.0f, true, true);
        } else if (anim == 3 && (typ == 7 || typ == 0)) {
            super.init(image, pos, dir, 20.0f, 80.0f, true, true);
        } else if (typ == 7) {
            super.init(image, pos, dir, 80.0f, 80.0f, true, true);
        } else {
            super.init(image, pos, dir, 40.0f, 40.0f, true, true);
        }
        this.active = act;
        this.respawnable = res;
        this.animationFrame = anim;
        if (typ == 0) {
            this.isgum = true;
        } else if (typ == 1) {
            this.boost = true;
        } else if (typ == 2) {
            this.trap = true;
        } else if (typ == 3) {
            this.atack = true;
        } else if (typ == 4) {
            this.fatality = true;
        } else if (typ == 5) {
            this.invincibility = true;
        } else if (typ == 6) {
            this.autopilot = true;
        } else if (typ == 7) {
            this.random = true;
        }
    }

    public void setNearestPoint(int[] point) {
        this.nearestPoint = point;
    }

    public boolean getActive() {
        return this.active;
    }

    public void itemDeActivate() {
        this.active = false;
    }

    public void itemActivate() {
        this.active = true;
        this.positionChanged = true;
    }

    public void triggerWall() {
        this.active = false;
    }

    public void triggerKart() {
        this.respawntime = 3;
    }

    public void setRespawnTime(int restime) {
        this.respawntime = restime;
    }

    public void setShown() {
        this.shown = true;
    }

    public void setPosition(Vector3D posi, Vector3D dire) {
        this.vDirection = dire;
        if (this.atack) {
            dire.scalarMul(20 * Track.mScale);
            this.vPosition = Vector3D.add(posi, dire);
        } else if (this.trap || this.isgum) {
            this.vDirection = dire;
            this.vDirection.scalarMul(-20 * Track.mScale);
            this.vPosition = Vector3D.add(posi, dire);
        }
    }

    public void updatePosition() {
        if (this.respawntime > 86) {
            if (this.attackDist != null && this.vectSet) {
                this.vDirection.scalarMul(0.9f);
                this.attackDist.normalize();
                this.attackDist.scalarMul(25.0f * (float)Track.mScale);
                this.vDirection.add(this.attackDist);
            } else {
                this.vDirection.scalarMul(1.1f);
            }
        } else if (this.respawntime < 86 && this.respawntime > 80) {
            if (this.attackDist != null && this.vectSet) {
                this.vDirection.scalarMul(0.8f);
                this.attackDist.normalize();
                this.attackDist.scalarMul(15.0f * (float)Track.mScale);
                this.vDirection.add(this.attackDist);
            } else {
                this.vDirection.scalarMul(0.95f);
            }
        } else if (this.respawntime < 60) {
            this.vDirection.scalarMul(0.99f);
        }
        this.vPosition = Vector3D.add(this.vPosition, this.vDirection);
    }

    public void updateDirection(Vector3D dir) {
        this.vDirection = dir;
    }

    public void Respawn() {
        this.itemActivate();
        this.animFrame = 0;
    }
}

