/*
 * Decompiled with CFR 0.152.
 */
import com.mascotcapsule.micro3d.v3.AffineTrans;
import com.mascotcapsule.micro3d.v3.Effect3D;
import com.mascotcapsule.micro3d.v3.FigureLayout;
import com.mascotcapsule.micro3d.v3.Graphics3D;
import com.mascotcapsule.micro3d.v3.Vector3D;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class RaceManager {
    private static Graphics3D g3d = new Graphics3D();
    public static Effect3D effect = new Effect3D();
    public static FigureLayout layout = new FigureLayout();
    public static AffineTrans viewTransform;
    public static AffineTrans cameraTransform;
    public Track m_Track;
    public Kart[] m_Karts;
    public PhysicalEntity[] m_physicalEntities;
    public Gate[] missionDoors;
    public OffroadElement[] m_StaticElements;
    public OnRoadElement[] m_StaticItems;
    public OnRoadElement[] m_DynamicItems;
    public OnRoadElement[] m_RespawnableItems;
    public OnRoadElement[] m_SpawnableItems;
    public TrackHelper[] trackHelpers;
    public TrackHelper[][] trackHelpersType;
    public AI[] m_AI;
    private int[][] m_NearestPoint;
    private SimpleObject gate;
    private SimpleObject[] gatePillars = new SimpleObject[2];
    private int spawnableBalls = 15;
    private int spawnableItems = 10;
    private int spawnedBalls;
    public Image img_MiniMap;
    public float scale;
    public int mmapTx;
    public int mmapTy;
    private int respawn;
    private final int FPS;
    private long time;
    Random generator = new Random();
    public boolean[] renderKart;
    private static Vector3D camPos;
    private static Vector3D camDir;
    private static Vector3D camDist;
    public boolean camAnim;
    private static int camAnimStep;
    private float frameCount;
    public int facing;
    public boolean rotateLeft;
    public int frameX;
    public static int frameBase;
    private int mItemCollisionRadius;
    static final int lapRange = 3;
    private OffroadElement[] m_pillars;
    public static boolean vibrateCamera;
    public static float cameraFrameCounter;
    public static boolean gForceCamera;
    public static Vector3D gForceCameraVector;
    public static float gForceCameraFrameCounter;
    private boolean cameraIsOnShortcut;
    public boolean as;
    public boolean bs;
    public boolean cs;
    public boolean ds = false;
    public float[] aiMissionParameters = new float[5];
    private static final int[] strItemTextureIndex;
    public int[][] race;
    private Image img_bgLayer1;
    private Image img_bgLayer2;
    private Image img_bgLayer3;
    int[] nearestPoint;
    private float[] cameraMatrix = new float[16];
    private Vector3D sla_zaxis = new Vector3D();
    private Vector3D sla_xaxis = new Vector3D();
    private Vector3D sla_yaxis = new Vector3D();
    private float bgScrollAngle;
    public static Vector3D sv_p;
    public static Vector3D sv_t;
    public static Vector3D sv_u;
    Vector3D sv_cam = new Vector3D();
    float sv_boostDist = 0.0f;
    float sv_boostDistStep = 2.0f * (float)Track.mScale;
    Vector3D startPos = new Vector3D();
    Vector3D stepPos = new Vector3D();
    Vector3D startTar = new Vector3D();
    Vector3D stepTar = new Vector3D();
    Vector3D bgDir = new Vector3D();
    final float camAnimStep1;
    final float camAnimWidthBase;
    float camAnimStep2;
    float camAnimStep3;
    float camAnimStep4;
    final float camAnimDistAdd;
    final float camAnimStep5;
    final float camAnimStartHeight;
    final float camAnimDistance = 2.5f * MainCanvas.CAMERA_POSITION_DISTANCE;
    int qp1;
    int qp2;
    Vector3D tc_trA = new Vector3D();
    Vector3D tc_trB = new Vector3D();
    Vector3D tc_trC = new Vector3D();
    Vector3D tc_trp = new Vector3D();
    Vector3D v0 = new Vector3D();
    Vector3D v1 = new Vector3D();
    Vector3D v2 = new Vector3D();
    Vector3D ckgl_kartPos = new Vector3D();
    Vector3D[] ckgl_v = new Vector3D[30];
    Vector3D ckgl_P1 = new Vector3D();
    Vector3D ckgl_P2 = new Vector3D();
    Vector3D ckgl_P3 = new Vector3D();
    private int[] crtn_pnr = new int[20];
    Vector3D wayDir = new Vector3D();
    Vector3D kartDir = new Vector3D();
    Vector3D cnpDist = new Vector3D();
    int mBackgroundY = 0;
    float flushKartRange = MainCanvas.VISIBILITY_RANGE / 3.0f;
    float flushItemsRange = MainCanvas.VISIBILITY_RANGE / 3.0f;
    boolean[] inFirstFlushKartRange = new boolean[10];
    Vector3D flushDist = new Vector3D();

    public RaceManager() {
        this.FPS = 30;
        this.camAnimStep1 = 20.0f;
        this.camAnimWidthBase = 50.0f;
        this.camAnimDistAdd = 20.0f;
        this.camAnimStep5 = 20.0f;
        this.camAnimStartHeight = 200.0f;
        Kart.clearData();
        SimpleObject.clear();
        SpriteLoader.free();
    }

    public void init(int[][] myRace) {
        this.race = myRace;
        this.init_00();
        Menu.incProgress();
        this.init_01();
        Menu.incProgress();
        this.init_02();
        Menu.incProgress();
        this.init_03();
        Menu.incProgress();
        this.init_04();
        Menu.incProgress();
        this.init_05();
    }

    public void init_00() {
        this.m_Track = new Track();
        try {
            if (GameLogic.gameMode == 1) {
                this.m_Track.init(Stats.missionTracks[GameLogic.gameWorld * 3 + GameLogic.gameTrack]);
            } else {
                this.m_Track.init(Stats.TRACK_FILE_NAMES[GameLogic.gameWorld][GameLogic.gameTrack]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void init_01() {
        Gate.clearGates();
        this.initBackground();
        this.initMiniMap();
    }

    public void init_02() {
        this.initPhysicalObjects(this.race);
        this.initAI(this.race[0]);
    }

    public void init_03() {
        try {
            this.mItemCollisionRadius = (250 + GameLogic.gameDifficulty * 150) * Track.mScale * Track.mScale;
            this.initOffroads();
            if (GameLogic.gameMode != 2) {
                this.initItems();
            }
        }
        catch (Exception e) {
            System.out.println("Init Offroads or Items Exception");
            e.printStackTrace();
        }
    }

    public void init_04() {
        try {
            this.initHelpers();
            this.initDoors();
        }
        catch (Exception e) {
            System.out.println("Init Helpers or Doors Exception");
            e.printStackTrace();
        }
        this.m_NearestPoint = new int[this.m_physicalEntities.length][2];
    }

    public void init_05() {
        viewTransform = new AffineTrans();
        cameraTransform = new AffineTrans();
        layout.setPerspective(150, (int)MainCanvas.VISIBILITY_LONG_RANGE, (int)(4096.0f * MainCanvas.CAMERA_FOV / 360.0f));
        layout.setAffineTrans(viewTransform);
        layout.setCenter(120, 160);
        effect.setTransparency(true);
        camPos = new Vector3D();
        camDir = new Vector3D();
        camDist = new Vector3D();
        this.camAnim = false;
        camAnimStep = 0;
        Kart.beginIntro();
        PhysicalEntity.cutoffLevel = 1.0f * Stats.frame[GameLogic.gameDifficulty];
        this.time = System.currentTimeMillis();
    }

    private void initBackground() {
        try {
            int wnr = GameLogic.gameWorld + 1;
            int tnr = GameLogic.gameTrack + 1;
            this.img_bgLayer1 = Image.createImage((String)("/Sprites/Track/bg_layer_" + wnr + "_1.png"));
            this.img_bgLayer2 = Image.createImage((String)("/Sprites/Track/bg_layer_" + wnr + "_2_" + tnr + ".png"));
            this.img_bgLayer3 = Image.createImage((String)("/Sprites/Track/bg_layer_" + wnr + "_3.png"));
        }
        catch (Exception e) {
            System.out.println("Error loading background image.");
        }
    }

    private void initMiniMap() {
        int y2;
        int x2;
        int y1;
        int x1;
        int i;
        int i2;
        float maxy;
        float maxx;
        float minx = maxx = this.m_Track.iPoints[0].getx();
        float miny = maxy = this.m_Track.iPoints[0].getz();
        for (i2 = 0; i2 < this.m_Track.leftSideVertices.length - 1; i2 += 3) {
            if (minx > (float)this.m_Track.leftSideVertices[i2]) {
                minx = this.m_Track.leftSideVertices[i2];
            }
            if (maxx < (float)this.m_Track.leftSideVertices[i2]) {
                maxx = this.m_Track.leftSideVertices[i2];
            }
            if (miny > (float)this.m_Track.leftSideVertices[i2 + 2]) {
                miny = this.m_Track.leftSideVertices[i2 + 2];
            }
            if (!(maxy < (float)this.m_Track.leftSideVertices[i2 + 2])) continue;
            maxy = this.m_Track.leftSideVertices[i2 + 2];
        }
        for (i2 = 0; i2 < this.m_Track.rightSideVertices.length - 1; i2 += 3) {
            if (minx > (float)this.m_Track.rightSideVertices[i2]) {
                minx = this.m_Track.rightSideVertices[i2];
            }
            if (maxx < (float)this.m_Track.rightSideVertices[i2]) {
                maxx = this.m_Track.rightSideVertices[i2];
            }
            if (miny > (float)this.m_Track.rightSideVertices[i2 + 2]) {
                miny = this.m_Track.rightSideVertices[i2 + 2];
            }
            if (!(maxy < (float)this.m_Track.rightSideVertices[i2 + 2])) continue;
            maxy = this.m_Track.rightSideVertices[i2 + 2];
        }
        for (int s = 0; s < this.m_Track.mShortcutsArray.size(); ++s) {
            int i3;
            TrackShortcut sc = (TrackShortcut)this.m_Track.mShortcutsArray.elementAt(s);
            for (i3 = 0; i3 < sc.leftSideVertices.length - 1; i3 += 3) {
                if (minx > (float)sc.leftSideVertices[i3]) {
                    minx = sc.leftSideVertices[i3];
                }
                if (maxx < (float)sc.leftSideVertices[i3]) {
                    maxx = sc.leftSideVertices[i3];
                }
                if (miny > (float)sc.leftSideVertices[i3 + 2]) {
                    miny = sc.leftSideVertices[i3 + 2];
                }
                if (!(maxy < (float)sc.leftSideVertices[i3 + 2])) continue;
                maxy = sc.leftSideVertices[i3 + 2];
            }
            for (i3 = 0; i3 < sc.rightSideVertices.length - 1; i3 += 3) {
                if (minx > (float)sc.rightSideVertices[i3]) {
                    minx = sc.rightSideVertices[i3];
                }
                if (maxx < (float)sc.rightSideVertices[i3]) {
                    maxx = sc.rightSideVertices[i3];
                }
                if (miny > (float)sc.rightSideVertices[i3 + 2]) {
                    miny = sc.rightSideVertices[i3 + 2];
                }
                if (!(maxy < (float)sc.rightSideVertices[i3 + 2])) continue;
                maxy = sc.rightSideVertices[i3 + 2];
            }
        }
        int H = (int)(maxy - miny);
        int W = (int)(maxx - minx);
        if (H * GameLogic.HUD_MINIMAP_W > W * GameLogic.HUD_MINIMAP_H) {
            GameLogic.HUD_MINIMAP_W = W * GameLogic.HUD_MINIMAP_H / H;
        } else {
            GameLogic.HUD_MINIMAP_H = H * GameLogic.HUD_MINIMAP_W / W;
        }
        this.scale = GameLogic.HUD_MINIMAP_W > GameLogic.HUD_MINIMAP_H ? (float)(GameLogic.HUD_MINIMAP_H - 2) / (float)H : (float)(GameLogic.HUD_MINIMAP_W - 2) / (float)W;
        this.img_MiniMap = Image.createImage((int)GameLogic.HUD_MINIMAP_W, (int)GameLogic.HUD_MINIMAP_H);
        Graphics map_Graphics = this.img_MiniMap.getGraphics();
        this.mmapTx = -((int)(minx * this.scale));
        this.mmapTy = -((int)(miny * this.scale));
        map_Graphics.setColor(255, 255, 0);
        map_Graphics.fillRect(0, 0, GameLogic.HUD_MINIMAP_W, GameLogic.HUD_MINIMAP_H);
        int x3 = (int)((float)this.m_Track.leftSideVertices[this.m_Track.leftSideVertices.length - 6] * this.scale);
        int y3 = (int)((float)this.m_Track.leftSideVertices[this.m_Track.leftSideVertices.length - 4] * this.scale);
        int x4 = (int)((float)this.m_Track.rightSideVertices[this.m_Track.rightSideVertices.length - 3] * this.scale);
        int y4 = (int)((float)this.m_Track.rightSideVertices[this.m_Track.rightSideVertices.length - 1] * this.scale);
        for (i = 0; i < this.m_Track.roadVertices.length / 6; ++i) {
            x1 = x3;
            y1 = y3;
            x2 = x4;
            y2 = y4;
            x3 = (int)((float)this.m_Track.leftSideVertices[6 * i + 0] * this.scale);
            y3 = (int)((float)this.m_Track.leftSideVertices[6 * i + 2] * this.scale);
            x4 = (int)((float)this.m_Track.rightSideVertices[6 * i + 3] * this.scale);
            y4 = (int)((float)this.m_Track.rightSideVertices[6 * i + 5] * this.scale);
            map_Graphics.setColor(127, 127, 127);
            map_Graphics.fillTriangle(x1 + this.mmapTx, y1 + this.mmapTy, x2 + this.mmapTx, y2 + this.mmapTy, x3 + this.mmapTx, y3 + this.mmapTy);
            map_Graphics.fillTriangle(x2 + this.mmapTx, y2 + this.mmapTy, x3 + this.mmapTx, y3 + this.mmapTy, x4 + this.mmapTx, y4 + this.mmapTy);
            map_Graphics.setColor(0, 0, 0);
            map_Graphics.drawLine(x1 + this.mmapTx, y1 + this.mmapTy, x3 + this.mmapTx, y3 + this.mmapTy);
            map_Graphics.drawLine(x2 + this.mmapTx, y2 + this.mmapTy, x4 + this.mmapTx, y4 + this.mmapTy);
        }
        x3 = (int)((float)this.m_Track.roadVertices[this.m_Track.roadVertices.length - 6] * this.scale);
        y3 = (int)((float)this.m_Track.roadVertices[this.m_Track.roadVertices.length - 4] * this.scale);
        x4 = (int)((float)this.m_Track.roadVertices[this.m_Track.roadVertices.length - 3] * this.scale);
        y4 = (int)((float)this.m_Track.roadVertices[this.m_Track.roadVertices.length - 1] * this.scale);
        for (i = 0; i < this.m_Track.roadVertices.length / 6; ++i) {
            x1 = x3;
            y1 = y3;
            x2 = x4;
            y2 = y4;
            x3 = (int)((float)this.m_Track.roadVertices[6 * i + 0] * this.scale);
            y3 = (int)((float)this.m_Track.roadVertices[6 * i + 2] * this.scale);
            x4 = (int)((float)this.m_Track.roadVertices[6 * i + 3] * this.scale);
            y4 = (int)((float)this.m_Track.roadVertices[6 * i + 5] * this.scale);
            map_Graphics.setColor(255, 255, 255);
            map_Graphics.fillTriangle(x1 + this.mmapTx, y1 + this.mmapTy, x2 + this.mmapTx, y2 + this.mmapTy, x3 + this.mmapTx, y3 + this.mmapTy);
            map_Graphics.fillTriangle(x2 + this.mmapTx, y2 + this.mmapTy, x3 + this.mmapTx, y3 + this.mmapTy, x4 + this.mmapTx, y4 + this.mmapTy);
        }
        map_Graphics.setColor(255, 0, 0);
        x1 = (int)((float)this.m_Track.leftSideVertices[0] * this.scale);
        y1 = (int)((float)this.m_Track.leftSideVertices[2] * this.scale);
        x2 = (int)((float)this.m_Track.rightSideVertices[3] * this.scale);
        y2 = (int)((float)this.m_Track.rightSideVertices[5] * this.scale);
        map_Graphics.drawLine(x1 + this.mmapTx, y1 + this.mmapTy, x2 + this.mmapTx, y2 + this.mmapTy);
        int[] rgb = new int[GameLogic.HUD_MINIMAP_W * GameLogic.HUD_MINIMAP_H];
        this.img_MiniMap.getRGB(rgb, 0, GameLogic.HUD_MINIMAP_W, 0, 0, GameLogic.HUD_MINIMAP_W, GameLogic.HUD_MINIMAP_H);
        for (int i4 = 0; i4 < rgb.length; ++i4) {
            if (rgb[i4] == -256) {
                rgb[i4] = 0;
                continue;
            }
            int n = i4;
            rgb[n] = rgb[n] & Integer.MAX_VALUE;
        }
        this.img_MiniMap = Image.createRGBImage((int[])rgb, (int)GameLogic.HUD_MINIMAP_W, (int)GameLogic.HUD_MINIMAP_H, (boolean)true);
    }

    private void initPhysicalObjects(int[][] race) {
        int i;
        this.initKarts(race);
        this.m_physicalEntities = new PhysicalEntity[this.m_Karts.length];
        for (i = 0; i < this.m_Karts.length; ++i) {
            this.m_physicalEntities[i] = this.m_Karts[i];
        }
        for (i = 0; i < this.m_physicalEntities.length; ++i) {
            this.m_physicalEntities[i].prevNearestPoint[0] = 0;
            this.m_physicalEntities[i].prevNearestPoint[1] = 0;
        }
    }

    private void initKarts(int[][] race) {
        int i;
        Kart.resetIndexes();
        Random r = new Random(System.currentTimeMillis());
        Kart.sun.set(1.0f + r.nextFloat() * 2.5f, 0.0f, 1.0f + r.nextFloat() * 2.5f);
        Kart.sun.scalarMul(6.0f);
        int[] ka = race[1];
        int[] ca = race[0];
        Vector3D loctemp = new Vector3D();
        Vector3D offset = new Vector3D();
        loctemp.set(this.m_Track.iPoints[0]);
        loctemp.add(new Vector3D(0.0f, -4.0f, 0.0f));
        Vector3D tmp = new Vector3D(this.m_Track.iPoints[1]);
        tmp.sub(this.m_Track.iPoints[0]);
        tmp.normalize();
        Vector3D vT = Vector3D.sub(this.m_Track.iPoints[0], this.m_Track.iPoints[1]);
        vT.normalize();
        Vector3D vCs = Vector3D.crossProduct(vT, new Vector3D(0.0f, 1.0f, 0.0f));
        vCs.scalarMul(this.m_Track.iPointsWidth[0] * 0.75f);
        offset.set(vCs);
        loctemp.add(vCs);
        vCs.scalarMul(2.0f / (float)(ka.length + 1));
        this.gate = new SimpleObject();
        this.gatePillars[0] = new SimpleObject();
        this.gatePillars[1] = new SimpleObject();
        Vector3D left = new Vector3D(this.m_Track.iPoints[0]);
        Vector3D right = new Vector3D(this.m_Track.iPoints[0]);
        Vector3D top = new Vector3D(this.m_Track.iPoints[0]);
        this.gatePillars[0].init(2, 100.0f, this.m_Track.iPointsWidth[0] / (float)Track.mScale, true, true);
        this.gatePillars[1].init(2, 100.0f, this.m_Track.iPointsWidth[0] / (float)Track.mScale, true, true);
        Vector3D move = Vector3D.crossProduct(Vector3D.sub(this.m_Track.iPoints[0], this.m_Track.iPoints[1]), new Vector3D(0.0f, 1.0f, 0.0f));
        move.normalize();
        move.scalarMul(this.m_Track.iPointsWidth[0] + this.m_Track.roadSideWidth / 2.0f);
        left.add(move);
        right.sub(move);
        this.gatePillars[0].setPosition(left);
        this.gatePillars[1].setPosition(right);
        this.gatePillars[0].update();
        this.gatePillars[1].update();
        this.gate.init(65, false, true);
        this.gate.setSize((this.m_Track.iPointsWidth[0] + this.m_Track.roadSideWidth / 2.0f + 100.0f) * 2.0f, (this.m_Track.iPointsWidth[0] + this.m_Track.roadSideWidth / 2.0f) * 2.0f / 7.0f);
        top.sety(top.gety() + this.m_Track.iPointsWidth[0] - this.gate.getHeight() / 2.0f);
        this.gate.setPosition(top);
        float angle = (float)mMath.toDegrees(mMath.acos(tmp.getz()));
        if (tmp.getx() < 0.0f) {
            angle = -angle;
        }
        this.gate.setRotation(new Vector3D(0.0f, angle, 0.0f));
        this.gate.update();
        this.m_Karts = new Kart[ka.length];
        this.renderKart = new boolean[ka.length];
        for (i = 0; i < this.m_Karts.length; ++i) {
            int j = i;
            if (j == 0) {
                j = (this.m_Karts.length - 1) / 2;
            } else if (j == (this.m_Karts.length - 1) / 2) {
                j = 0;
            }
            loctemp.sub(vCs);
            offset.sub(vCs);
            this.m_Karts[j] = new Kart();
            this.m_Karts[j].init(loctemp, tmp, offset, ka[j], ca[j], Stats.kartStats[ca[j]][ka[j]][0], Stats.kartStats[ca[j]][ka[j]][1], Stats.kartStats[ca[j]][ka[j]][2], GameLogic.gameDifficulty, j == 0, Stats.KART_ROLL[ca[j]][ka[j]] / (float)Track.mScale, Stats.KART_DRIFT_ROLL[ca[j]][ka[j]] / (float)Track.mScale);
            this.m_Karts[j].setTrackFriction(2.0f);
        }
        for (i = 0; i < this.ckgl_v.length; ++i) {
            this.ckgl_v[i] = new Vector3D();
        }
    }

    public void initAI(int[] ch) {
        this.m_AI = new AI[ch.length];
        this.m_AI[0] = new AI();
        this.m_AI[0].init(this.m_Karts[0], this, 0.9f, 0.0f, 0.0f, 0.1f, 0.0f);
        this.m_AI[0].setSleep();
        if (GameLogic.gameMode == 1) {
            for (int i = 1; i < this.m_AI.length; ++i) {
                this.m_AI[i] = new AI();
                this.m_AI[i].init(this.m_Karts[i], this, this.aiMissionParameters[0], this.aiMissionParameters[1], this.aiMissionParameters[2], this.aiMissionParameters[3], this.aiMissionParameters[4]);
            }
        } else {
            for (int i = 1; i < this.m_AI.length; ++i) {
                this.m_AI[i] = new AI();
                this.m_AI[i].init(this.m_Karts[i], this, Stats.charStats[GameLogic.gameDifficulty][ch[i]][0], Stats.charStats[GameLogic.gameDifficulty][ch[i]][1], Stats.charStats[GameLogic.gameDifficulty][ch[i]][2], Stats.charStats[GameLogic.gameDifficulty][ch[i]][3], Stats.charStats[GameLogic.gameDifficulty][ch[i]][4]);
            }
        }
    }

    private void initOffroads() {
        int sum = 0;
        int step = 1;
        for (int i = 2; i < this.m_Track.mItemArray.length; ++i) {
            sum += this.m_Track.mItemArray[i].size() / step;
        }
        this.m_StaticElements = new OffroadElement[sum];
        int staticElementsIndex = 0;
        for (int j = 2; j < this.m_Track.mItemArray.length; ++j) {
            float scale = this.m_Track.mItemScale[j];
            for (int i = 0; i < this.m_Track.mItemArray[j].size(); i += step) {
                this.m_StaticElements[staticElementsIndex] = new OffroadElement();
                Vector3D tmp = (Vector3D)this.m_Track.mItemArray[j].elementAt(i);
                tmp.sety(this.checkGroundLevel(null, tmp, this.checkNearestPoint(tmp)) - 3.0f);
                boolean isTree = false;
                if (j == 4 || j == 11 || j == 12 || j == 17) {
                    isTree = true;
                }
                this.m_StaticElements[staticElementsIndex].init(strItemTextureIndex[j], tmp, null, scale, isTree);
                this.m_StaticElements[staticElementsIndex].setNearestPoint(this.checkNearestPoint(tmp));
                if (++staticElementsIndex < sum) continue;
                return;
            }
        }
    }

    private void initItems() {
        Vector3D tmp;
        int i;
        if (GameLogic.gameItems) {
            this.m_SpawnableItems = new OnRoadElement[this.spawnableItems];
            for (i = 0; i < this.m_SpawnableItems.length; ++i) {
                this.m_SpawnableItems[i] = new OnRoadElement();
            }
            for (i = 0; i < this.spawnableItems; ++i) {
                this.m_SpawnableItems[i].init(10, new Vector3D(20 * Track.mScale, 0.0f, 20 * Track.mScale), new Vector3D(0.0f, 0.0f, 0.0f), false, false, 2, 4);
            }
            this.m_RespawnableItems = new OnRoadElement[this.m_Track.mItemArray[1].size()];
            for (i = 0; i < this.m_RespawnableItems.length; ++i) {
                this.m_RespawnableItems[i] = new OnRoadElement();
                tmp = (Vector3D)this.m_Track.mItemArray[1].elementAt(i);
                if (GameLogic.gameMode == 5) {
                    tmp.sety(this.checkGroundLevel(null, tmp, this.checkNearestPoint(tmp)));
                }
                tmp.sety(tmp.gety() + 50.0f);
                this.m_RespawnableItems[i].init(strItemTextureIndex[1], tmp, null, true, true, 7, 3);
                this.nearestPoint = this.checkNearestPoint(this.m_RespawnableItems[i].getPosition());
                this.m_RespawnableItems[i].setNearestPoint(this.nearestPoint);
                this.m_RespawnableItems[i].update();
            }
            this.m_DynamicItems = new OnRoadElement[this.spawnableItems];
            for (i = 0; i < this.m_DynamicItems.length; ++i) {
                this.m_DynamicItems[i] = new OnRoadElement();
            }
            for (i = 0; i < this.spawnableItems; ++i) {
                this.m_DynamicItems[i].init(11, new Vector3D(0.0f, 0.0f, 0.0f), new Vector3D(0.0f, 0.0f, 0.0f), false, false, 3, 8);
            }
        }
        this.spawnedBalls = this.m_Track.mItemArray[0].size();
        this.m_StaticItems = new OnRoadElement[this.spawnedBalls + this.spawnableBalls];
        for (i = 0; i < this.m_StaticItems.length; ++i) {
            this.m_StaticItems[i] = new OnRoadElement();
            this.m_StaticItems[i].reverseAnim = true;
            if (i < this.spawnedBalls) {
                tmp = (Vector3D)this.m_Track.mItemArray[0].elementAt(i);
                if (GameLogic.gameMode == 5) {
                    tmp.sety(this.checkGroundLevel(null, tmp, this.checkNearestPoint(tmp)));
                } else if (GameLogic.gameMode != 1 || GameLogic.gameWorld != 1 || GameLogic.gameTrack != 1) {
                    tmp.sety(this.checkGroundLevel(null, tmp, this.checkNearestPoint(tmp)));
                }
                this.m_StaticItems[i].init(strItemTextureIndex[0], tmp, null, true, false, 0, 3);
                this.nearestPoint = this.checkNearestPoint(this.m_StaticItems[i].getPosition());
                this.m_StaticItems[i].setNearestPoint(this.nearestPoint);
                this.m_StaticItems[i].update();
                continue;
            }
            this.m_StaticItems[i].init(strItemTextureIndex[0], new Vector3D(0.0f, 0.0f, 0.0f), null, false, false, 0, 3);
        }
    }

    public void initHelpers() {
        Vector3D slope = new Vector3D();
        if (this.m_Track.mHelperArray == null) {
            Vector3D move = new Vector3D();
            this.trackHelpers = new TrackHelper[this.m_Track.iPoints.length / 6];
            this.trackHelpersType = new TrackHelper[3][];
            int len = this.trackHelpers.length / 3;
            int add1 = 0;
            int add2 = 0;
            if (this.trackHelpers.length % 3 == 2) {
                add1 = 1;
                add2 = 1;
            } else if (this.trackHelpers.length % 3 == 1) {
                add1 = 1;
                add2 = 0;
            }
            this.trackHelpersType[0] = new TrackHelper[len + add1];
            this.trackHelpersType[1] = new TrackHelper[len + add2];
            this.trackHelpersType[2] = new TrackHelper[len];
            int[] index = new int[3];
            Random r = new Random(System.currentTimeMillis());
            for (int i = 0; i < this.trackHelpers.length; ++i) {
                move.set(r.nextFloat() * 25.0f, r.nextFloat() * 25.0f, r.nextFloat() * 25.0f);
                this.trackHelpers[i] = new TrackHelper();
                this.trackHelpers[i].init(Vector3D.add(this.m_Track.iPoints[i * 6 + 3], move), i % 3, 0);
                this.trackHelpers[i].nearestPoint = this.checkNearestPoint(this.trackHelpers[i].getPosition());
                Vector3D tmp = new Vector3D(this.m_Track.iPoints[this.trackHelpers[i].nearestPoint[0]]);
                tmp.sub(this.m_Track.iPoints[(this.trackHelpers[i].nearestPoint[0] + 1) % this.m_Track.iPoints.length]);
                tmp.normalize();
                float angle = (float)mMath.toDegrees(mMath.acos(tmp.getz()));
                if (tmp.getx() < 0.0f) {
                    angle = -angle;
                }
                this.trackHelpers[i].setTrackRotation(angle - 90.0f);
                float height = this.checkGroundLevel(slope, this.trackHelpers[i].getPosition(), this.trackHelpers[i].nearestPoint);
                this.trackHelpers[i].setGround(height, slope);
                this.trackHelpersType[i % 3][index[i % 3]] = this.trackHelpers[i];
                int n = i % 3;
                index[n] = index[n] + 1;
            }
        } else {
            float height;
            float angle;
            Vector3D tmp;
            int i;
            Vector3D move = new Vector3D();
            int sum = this.m_Track.mHelperArray[0].size() + this.m_Track.mHelperArray[1].size() + this.m_Track.mHelperArray[2].size();
            this.trackHelpers = new TrackHelper[sum];
            this.trackHelpersType = new TrackHelper[3][];
            int len = this.trackHelpers.length / 3;
            int index = 0;
            this.trackHelpersType[1] = new TrackHelper[this.m_Track.mHelperArray[0].size()];
            for (i = 0; i < this.m_Track.mHelperArray[0].size(); ++i) {
                this.trackHelpers[index] = new TrackHelper();
                this.trackHelpers[index].init((Vector3D)this.m_Track.mHelperArray[0].elementAt(i), 1, 0);
                this.trackHelpers[index].nearestPoint = this.checkNearestPoint(this.trackHelpers[index].getPosition());
                if (this.trackHelpers[index].nearestPoint[1] == 0) {
                    tmp = new Vector3D(this.m_Track.iPoints[this.trackHelpers[index].nearestPoint[0]]);
                    tmp.sub(this.m_Track.iPoints[(this.trackHelpers[index].nearestPoint[0] + 1) % this.m_Track.iPoints.length]);
                    tmp.normalize();
                } else {
                    TrackShortcut sc = (TrackShortcut)this.m_Track.mShortcutsArray.elementAt(this.trackHelpers[index].nearestPoint[1] - 1);
                    tmp = new Vector3D(sc.iPoints[this.trackHelpers[index].nearestPoint[0]]);
                    tmp.sub(sc.iPoints[(this.trackHelpers[index].nearestPoint[0] + 1) % sc.iPoints.length]);
                    tmp.normalize();
                }
                angle = (float)mMath.toDegrees(mMath.acos(tmp.getz()));
                if (tmp.getx() < 0.0f) {
                    angle = -angle;
                }
                this.trackHelpers[index].setTrackRotation(angle - 90.0f);
                height = this.checkGroundLevel(slope, this.trackHelpers[index].getPosition(), this.trackHelpers[index].nearestPoint);
                this.trackHelpers[index].setGround(height, slope);
                this.trackHelpersType[1][i] = this.trackHelpers[index];
                ++index;
            }
            this.trackHelpersType[0] = new TrackHelper[this.m_Track.mHelperArray[2].size()];
            for (i = 0; i < this.m_Track.mHelperArray[2].size(); ++i) {
                this.trackHelpers[index] = new TrackHelper();
                this.trackHelpers[index].init((Vector3D)this.m_Track.mHelperArray[2].elementAt(i), 0, 0);
                this.trackHelpers[index].nearestPoint = this.checkNearestPoint(this.trackHelpers[index].getPosition());
                tmp = new Vector3D(this.m_Track.iPoints[this.trackHelpers[index].nearestPoint[0]]);
                tmp.sub(this.m_Track.iPoints[(this.trackHelpers[index].nearestPoint[0] + 1) % this.m_Track.iPoints.length]);
                tmp.normalize();
                angle = (float)mMath.toDegrees(mMath.acos(tmp.getz()));
                if (tmp.getx() < 0.0f) {
                    angle = -angle;
                }
                this.trackHelpers[index].setTrackRotation(angle - 90.0f);
                height = this.checkGroundLevel(slope, this.trackHelpers[index].getPosition(), this.trackHelpers[index].nearestPoint);
                this.trackHelpers[index].setGround(height, slope);
                this.trackHelpersType[0][i] = this.trackHelpers[index];
                ++index;
            }
            this.trackHelpersType[2] = new TrackHelper[this.m_Track.mHelperArray[1].size()];
            for (i = 0; i < this.m_Track.mHelperArray[1].size(); ++i) {
                this.trackHelpers[index] = new TrackHelper();
                this.trackHelpers[index].init((Vector3D)this.m_Track.mHelperArray[1].elementAt(i), 2, 0);
                this.trackHelpers[index].nearestPoint = this.checkNearestPoint(this.trackHelpers[index].getPosition());
                if (this.trackHelpers[index].nearestPoint[1] == 0) {
                    tmp = new Vector3D(this.m_Track.iPoints[this.trackHelpers[index].nearestPoint[0]]);
                    tmp.sub(this.m_Track.iPoints[(this.trackHelpers[index].nearestPoint[0] + 1) % this.m_Track.iPoints.length]);
                    tmp.normalize();
                } else {
                    TrackShortcut sc = (TrackShortcut)this.m_Track.mShortcutsArray.elementAt(this.trackHelpers[index].nearestPoint[1] - 1);
                    tmp = new Vector3D(sc.iPoints[this.trackHelpers[index].nearestPoint[0]]);
                    tmp.sub(sc.iPoints[(this.trackHelpers[index].nearestPoint[0] + 1) % sc.iPoints.length]);
                    tmp.normalize();
                }
                angle = (float)mMath.toDegrees(mMath.acos(tmp.getz()));
                if (tmp.getx() < 0.0f) {
                    angle = -angle;
                }
                this.trackHelpers[index].setTrackRotation(angle - 90.0f);
                height = this.checkGroundLevel(slope, this.trackHelpers[index].getPosition(), this.trackHelpers[index].nearestPoint);
                this.trackHelpers[index].setGround(height, slope);
                this.trackHelpersType[2][i] = this.trackHelpers[index];
                ++index;
            }
        }
    }

    public int getDoorNumber() {
        return this.missionDoors.length;
    }

    private void initDoors() {
        this.missionDoors = new Gate[this.m_Track.mGatePos.length];
        for (int i = 0; i < this.missionDoors.length; ++i) {
            this.missionDoors[i] = new Gate();
            this.missionDoors[i].init(this.m_Track.mGatePos[i], i);
            this.missionDoors[i].nearestPoint = this.checkNearestPoint(this.missionDoors[i].getPosition());
            Vector3D tmp = new Vector3D(this.m_Track.iPoints[this.missionDoors[i].nearestPoint[0]]);
            tmp.sub(this.m_Track.iPoints[(this.missionDoors[i].nearestPoint[0] + 1) % this.m_Track.iPoints.length]);
            tmp.normalize();
            float angle = (float)mMath.toDegrees(mMath.acos(tmp.getz()));
            if (tmp.getx() < 0.0f) {
                angle = -angle;
            }
            this.missionDoors[i].setTrackRotation(angle - 180.0f);
            Vector3D slope = new Vector3D();
            float height = this.checkGroundLevel(slope, this.missionDoors[i].getPosition(), this.missionDoors[i].nearestPoint);
            this.missionDoors[i].setGround(height + 280.0f, slope);
        }
    }

    private float pointFromLine(Vector3D point, float a, float b) {
        return (float)((double)Math.abs(a * point.getx() - point.getz() + b) * mMath.invSqrt(1.0f + a * a));
    }

    private Vector3D wallCollsion(Vector3D objectPos, Vector3D leftWallPos, Vector3D rightWallPos, float distance) {
        float b1;
        float a1 = (leftWallPos.getz() - rightWallPos.getz()) / (leftWallPos.getx() - rightWallPos.getx());
        if (this.pointFromLine(objectPos, a1, b1 = rightWallPos.getz() - a1 * rightWallPos.getx()) <= distance) {
            float a2 = -1.0f / a1;
            float b2 = leftWallPos.getz() - a2 * leftWallPos.getx();
            float a3 = a2;
            float b3 = rightWallPos.getz() - a3 * rightWallPos.getx();
            Vector3D dif = Vector3D.sub(leftWallPos, rightWallPos);
            float dist = dif.length() * 1.05f;
            float len = this.pointFromLine(objectPos, a2, b2) + this.pointFromLine(objectPos, a3, b3);
            if (len > dist) {
                return null;
            }
            dif.normalize();
            return dif;
        }
        return null;
    }

    private Vector3D radialCollsion(Vector3D loc, float range, Kart kart) {
        Vector3D dist = Vector3D.sub(kart.getPosition(), loc);
        Vector3D oldPos = Vector3D.sub(kart.getPosition(), kart.getOldPosition());
        oldPos.scalarDiv(2.0f);
        oldPos = Vector3D.sub(kart.getPosition(), oldPos);
        Vector3D oldDist = Vector3D.sub(loc, oldPos);
        float test = range * range;
        if (dist.quaterLength() < test) {
            return Vector3D.normalize(dist);
        }
        if (oldDist.quaterLength() < test) {
            return Vector3D.normalize(oldDist);
        }
        return null;
    }

    private void checkDoorCollsions(Gate door, Kart kart) {
        if (Math.abs(door.nearestPoint[0] - kart.nearestPoint[0]) <= 1) {
            Vector3D check = this.wallCollsion(kart.getPosition(), door.getLeftPillarLocation(), door.getRightPillarLocation(), door.getGateDepth());
            if (check != null) {
                if (kart.getAltitude() >= door.getGateHeight()) {
                    if (kart.getAltitude() < door.getGateTop()) {
                        kart.triggerCollision(check);
                    }
                } else {
                    int cd = kart.getCurrentDoor();
                    if (cd + 1 == door.getGateId()) {
                        kart.setCurrentDoor(cd + 1);
                    } else if (kart.isPlayer && cd != door.getGateId()) {
                        MissionManager.setFail();
                    }
                }
            }
            if ((check = this.radialCollsion(door.getLeftPillarLocation(), door.getPillarWidth(), kart)) != null) {
                kart.triggerCollision(check);
                return;
            }
            check = this.radialCollsion(door.getRightPillarLocation(), door.getPillarWidth(), kart);
            if (check != null) {
                kart.triggerCollision(check);
                return;
            }
        }
    }

    public void dropItem(Vector3D position, Vector3D direction, int type, boolean isPlayer, int owner) {
        block5: {
            block7: {
                block6: {
                    if (type != 0) break block6;
                    for (int x = 0; x < this.spawnableBalls + this.spawnedBalls; ++x) {
                        if (this.m_StaticItems[x].active) continue;
                        Random r = new Random(System.currentTimeMillis());
                        Vector3D pos = new Vector3D(position.getx() + r.nextFloat() * 20.0f, 0.0f, position.getz() + r.nextFloat() * 20.0f);
                        pos.sety(this.checkGroundLevel(null, pos, this.checkNearestPoint(pos)));
                        this.m_StaticItems[x].setPosition(pos, direction);
                        this.m_StaticItems[x].itemActivate();
                        if (!isPlayer) break block5;
                        SoundManager.playSfx(14);
                        break block5;
                    }
                    break block5;
                }
                if (type != 3) break block7;
                for (int x = 0; x < this.spawnableItems; ++x) {
                    if (!this.m_SpawnableItems[x].active) {
                        position.sety(this.checkGroundLevel(null, position, this.checkNearestPoint(position)) + 30.0f);
                        this.m_SpawnableItems[x].setPosition(position, direction);
                        this.m_SpawnableItems[x].itemActivate();
                        if (!isPlayer) break block5;
                        SoundManager.playSfx(3);
                        break block5;
                    }
                    if (x != this.spawnableItems - 1) continue;
                    int random = this.generator.nextInt(this.spawnableItems);
                    this.m_SpawnableItems[random].setPosition(position, direction);
                    if (!isPlayer) break block5;
                    SoundManager.playSfx(3);
                    break block5;
                }
                break block5;
            }
            if (type != 2) break block5;
            for (int x = 0; x < this.spawnableItems; ++x) {
                if (!this.m_DynamicItems[x].active) {
                    this.m_DynamicItems[x].setPosition(position, direction);
                    this.m_DynamicItems[x].itemActivate();
                    this.m_DynamicItems[x].respawntime = 90;
                    this.m_DynamicItems[x].owner = owner;
                    if (!isPlayer) break;
                    SoundManager.playSfx(13);
                    break;
                }
                if (x != this.spawnableItems) continue;
                this.m_DynamicItems[x].setPosition(position, direction);
                this.m_DynamicItems[x].itemActivate();
                this.m_DynamicItems[x].respawntime = 90;
                if (!isPlayer) continue;
                SoundManager.playSfx(13);
            }
        }
    }

    private void setLookAt(Vector3D pos, Vector3D target, Vector3D up) {
        this.bgDir.set(target);
        this.bgDir.sub(pos);
        this.bgDir.sety(0.0f);
        this.bgDir.normalize();
        this.bgScrollAngle = (float)mMath.toDegrees(mMath.acos((this.bgDir.getx() * 0.0f + this.bgDir.getz() * -1.0f) / this.bgDir.length()));
        if (this.bgDir.getx() > 0.0f) {
            this.bgScrollAngle = 360.0f - this.bgScrollAngle;
        }
        camPos.set(pos);
        camDir.set(target);
        camDir.sub(camPos);
        this.sla_zaxis.set(pos);
        this.sla_zaxis.sub(target);
        this.sla_zaxis.normalize();
        this.sla_xaxis.set(up);
        this.sla_xaxis.crossProduct(this.sla_zaxis);
        this.sla_xaxis.normalize();
        this.sla_yaxis.set(this.sla_zaxis);
        this.sla_yaxis.crossProduct(this.sla_xaxis);
        this.cameraMatrix[0] = this.sla_xaxis.getx();
        this.cameraMatrix[1] = this.sla_yaxis.getx();
        this.cameraMatrix[2] = this.sla_zaxis.getx();
        this.cameraMatrix[3] = pos.getx();
        this.cameraMatrix[4] = this.sla_xaxis.gety();
        this.cameraMatrix[5] = this.sla_yaxis.gety();
        this.cameraMatrix[6] = this.sla_zaxis.gety();
        this.cameraMatrix[7] = pos.gety();
        this.cameraMatrix[8] = this.sla_xaxis.getz();
        this.cameraMatrix[9] = this.sla_yaxis.getz();
        this.cameraMatrix[10] = this.sla_zaxis.getz();
        this.cameraMatrix[11] = pos.getz();
        this.cameraMatrix[12] = 0.0f;
        this.cameraMatrix[13] = 0.0f;
        this.cameraMatrix[14] = 0.0f;
        this.cameraMatrix[15] = 1.0f;
        int px = (int)pos.getx();
        int py = (int)pos.gety();
        int pz = (int)pos.getz();
        Vector3D look = Vector3D.sub(target, pos);
        int lx = (int)look.getx();
        int ly = (int)look.gety();
        int lz = (int)look.getz();
        cameraTransform.setIdentity();
        cameraTransform.lookAt(new Vector3D(px, py, pz), new Vector3D(lx, ly, lz), new Vector3D(0, 4096, 0));
        int[] tmp = new int[12];
        for (int i = 0; i < 12; ++i) {
            tmp[i] = i != 3 && i != 7 && i != 11 ? (int)(this.cameraMatrix[i] * 4096.0f) : (int)this.cameraMatrix[i];
        }
        viewTransform.set(cameraTransform);
    }

    private void setView(Kart vehicle) {
        this.sv_cam.set(vehicle.getCameraVector());
        if (this.m_Karts[0].isBoosted || this.m_Karts[0].isInvincible) {
            this.sv_boostDist += this.sv_boostDistStep * 1.1f;
            if (this.sv_boostDist > vehicle.vVelocity.length() * 0.8f) {
                this.sv_boostDist = vehicle.vVelocity.length() * 0.8f;
            }
        } else if (this.m_Karts[0].isTrapSet) {
            if (this.m_Karts[0].isTrapDeployed) {
                this.sv_boostDist = vehicle.vVelocity.length() * 0.1f;
            } else if (!this.m_Karts[0].isTrapDeployed) {
                this.sv_boostDist += this.sv_boostDistStep;
                if (this.sv_boostDist > vehicle.vVelocity.length() * 0.5f) {
                    this.sv_boostDist = vehicle.vVelocity.length() * 0.5f;
                }
            }
        } else if (this.m_Karts[0].isKatamari) {
            this.sv_boostDist -= this.sv_boostDistStep;
            if (this.sv_boostDist < vehicle.vVelocity.length() * -0.5f) {
                this.sv_boostDist = vehicle.vVelocity.length() * -0.5f;
            }
        } else if (this.sv_boostDist >= 0.0f) {
            this.sv_boostDist -= this.sv_boostDistStep * 4.0f;
            if (this.sv_boostDist < vehicle.vVelocity.length() * 0.4f) {
                this.sv_boostDist = vehicle.vVelocity.length() * 0.4f;
            }
        } else {
            this.sv_boostDist += this.sv_boostDistStep * 4.0f;
        }
        this.sv_cam.scalarMul(MainCanvas.CAMERA_POSITION_DISTANCE + this.sv_boostDist);
        sv_p.set(vehicle.getPosition());
        sv_p.sub(this.sv_cam);
        this.checkCameraCollisions();
        sv_t.set(vehicle.getPosition());
        sv_t.sety(sv_t.gety() + MainCanvas.CAMERA_TARGET_Y);
        sv_u = new Vector3D(0.0f, 1.0f, 0.0f);
        if (vibrateCamera) {
            sv_t.add(RaceManager.vibrateCameraPosition(cameraFrameCounter));
        }
        if (gForceCamera) {
            sv_p.add(this.gForceCameraPosition(gForceCameraVector));
        }
        if ((this.m_Karts[0].showGrass || this.m_Karts[0].showMud || this.m_Karts[0].isOnRocks || this.m_Karts[0].isBoosted) && this.m_Karts[0].isPlayer) {
            Random r = new Random();
            Vector3D vibrate = new Vector3D();
            vibrate.set(r.nextFloat() * this.m_Karts[0].actualSpeed.length() * 0.05f, r.nextFloat() * this.m_Karts[0].actualSpeed.length() * 0.05f, r.nextFloat() * this.m_Karts[0].actualSpeed.length() * 0.05f);
            sv_t.add(vibrate);
        }
        try {
            this.setLookAt(sv_p, sv_t, sv_u);
        }
        catch (Exception e) {
            System.out.println(e + " in setLookAt.");
            System.out.println("p: " + sv_p);
            System.out.println("t: " + sv_t);
            System.out.println("u: " + sv_u);
            System.out.println("cameraVector: " + vehicle.getCameraVector());
            System.out.println("kartPosition: " + vehicle.getPosition());
        }
    }

    private void setAnim(float frame) {
        int[] nearestPoint = new int[]{0, 0};
        switch (camAnimStep) {
            case 0: {
                ++camAnimStep;
                this.frameCount = 0.0f;
                this.camAnimStep2 = 50.0f * (float)(this.m_Karts.length - 1) / (float)(this.m_Karts.length + 1);
                this.camAnimStep3 = 50.0f * (float)((this.m_Karts.length - 1) / 2) / (float)(this.m_Karts.length + 1);
                this.camAnimStep4 = 50.0f * (float)((this.m_Karts.length - 1) / 2) / (float)(this.m_Karts.length + 1) + 20.0f;
                sv_p.set(this.m_Karts[this.m_Karts.length - 1].getPosition());
                sv_p.sety(this.checkGroundLevel(null, sv_p, nearestPoint));
                sv_p.sety(sv_p.gety() + 200.0f);
                sv_t.set(this.m_Karts[this.m_Karts.length - 1].getPosition());
                sv_t.sety(this.checkGroundLevel(null, sv_t, nearestPoint));
                break;
            }
            case 1: {
                if (this.frameCount < 20.0f) {
                    if (this.frameCount < 10.0f) {
                        this.sv_cam.set(this.m_Karts[this.m_Karts.length - 1].getCameraVector());
                        this.sv_cam.setx(-this.sv_cam.getx());
                        this.sv_cam.setz(-this.sv_cam.getz());
                        this.sv_cam.scalarMul(this.camAnimDistance);
                        this.startPos.set(this.m_Karts[this.m_Karts.length - 1].getPosition());
                        this.startPos.sety(this.checkGroundLevel(null, this.startPos, nearestPoint));
                        this.startPos.sety(this.startPos.gety() + 200.0f);
                        this.stepPos.set(this.m_Karts[this.m_Karts.length - 1].getPosition());
                        this.stepPos.sety(this.checkGroundLevel(null, this.stepPos, nearestPoint));
                        this.stepPos.sub(this.sv_cam);
                        this.stepPos.sub(this.startPos);
                        this.stepPos.scalarMul(0.05f);
                        sv_t.set(this.m_Karts[this.m_Karts.length - 1].getPosition());
                        sv_t.sety(this.checkGroundLevel(null, sv_t, nearestPoint));
                    }
                    sv_p.set(this.stepPos);
                    sv_p.scalarMul(this.frameCount);
                    sv_p.add(this.startPos);
                    break;
                }
                ++camAnimStep;
                this.frameCount = 0.0f;
                this.startPos.set(sv_p);
                this.sv_cam.set(this.m_Karts[(this.m_Karts.length - 1) / 2].getCameraVector());
                this.sv_cam.setx(-this.sv_cam.getx());
                this.sv_cam.setz(-this.sv_cam.getz());
                this.sv_cam.scalarMul(this.camAnimDistance);
                this.stepPos.set(this.m_Karts[(this.m_Karts.length - 1) / 2].getPosition());
                this.stepPos.sety(this.checkGroundLevel(null, this.stepPos, nearestPoint));
                this.stepPos.sub(this.sv_cam);
                this.stepPos.sub(this.startPos);
                this.stepPos.scalarMul(1.0f / this.camAnimStep2);
                this.startTar.set(sv_t);
                this.stepTar.set(this.m_Karts[(this.m_Karts.length - 1) / 2].getPosition());
                this.stepTar.sety(this.checkGroundLevel(null, this.stepTar, nearestPoint));
                this.stepTar.sub(this.startTar);
                this.stepTar.scalarMul(1.0f / this.camAnimStep2);
                break;
            }
            case 2: {
                if (this.frameCount < this.camAnimStep2) {
                    sv_p.set(this.stepPos);
                    sv_p.scalarMul(this.frameCount);
                    sv_p.add(this.startPos);
                    sv_t.set(this.stepTar);
                    sv_t.scalarMul(this.frameCount);
                    sv_t.add(this.startTar);
                    break;
                }
                ++camAnimStep;
                this.frameCount = 0.0f;
                this.startTar.set(sv_t);
                this.stepTar.set(this.m_Karts[0].getPosition());
                this.stepTar.sety(this.checkGroundLevel(null, this.stepTar, nearestPoint));
                this.stepTar.sub(this.startTar);
                this.stepTar.scalarMul(1.0f / this.camAnimStep3);
                break;
            }
            case 3: {
                if (this.frameCount < this.camAnimStep3) {
                    sv_t.set(this.stepTar);
                    sv_t.scalarMul(this.frameCount);
                    sv_t.add(this.startTar);
                    break;
                }
                ++camAnimStep;
                this.frameCount = 0.0f;
                this.startPos.set(sv_p);
                this.sv_cam.set(this.m_Karts[0].getCameraVector());
                this.sv_cam.scalarMul(this.camAnimDistance);
                this.stepPos.set(this.m_Karts[0].getPosition());
                this.stepPos.sety(this.checkGroundLevel(null, this.stepPos, nearestPoint));
                this.stepPos.sub(this.sv_cam);
                this.stepPos.sub(this.startPos);
                this.stepPos.scalarMul(1.0f / this.camAnimStep4);
                break;
            }
            case 4: {
                if (this.frameCount < this.camAnimStep4) {
                    sv_p.set(this.stepPos);
                    sv_p.scalarMul(this.frameCount);
                    sv_p.add(this.startPos);
                    break;
                }
                ++camAnimStep;
                this.frameCount = 0.0f;
                this.startPos.set(sv_p);
                this.sv_cam.set(this.m_Karts[0].getCameraVector());
                this.sv_cam.scalarMul(MainCanvas.CAMERA_POSITION_DISTANCE);
                this.stepPos.set(this.m_Karts[0].getPosition());
                this.stepPos.sety(this.checkGroundLevel(null, this.stepPos, nearestPoint));
                this.stepPos.sub(this.sv_cam);
                this.stepPos.sub(this.startPos);
                this.stepPos.scalarMul(0.05f);
                this.startTar.set(this.m_Karts[0].getPosition());
                this.startTar.sety(this.checkGroundLevel(null, this.startTar, nearestPoint));
                this.stepTar.set(0.0f, MainCanvas.CAMERA_TARGET_Y / 20.0f, 0.0f);
                break;
            }
            case 5: {
                if (this.frameCount < 20.0f) {
                    sv_p.set(this.stepPos);
                    sv_p.scalarMul(this.frameCount);
                    sv_p.add(this.startPos);
                    sv_t.set(this.stepTar);
                    sv_t.scalarMul(this.frameCount);
                    sv_t.add(this.startTar);
                    break;
                }
                this.camAnim = false;
            }
        }
        this.frameCount += frame;
        this.setLookAt(sv_p, sv_t, sv_u);
    }

    private void checkTrackCollisions(PhysicalEntity entity, int[] nearestPoint) {
        int nearShortcutNr = -1;
        int nearShortcutSide = -1;
        int nearShortcutPoint = -1;
        boolean coll = false;
        float colT = 0.0f;
        if (!entity.isOnShortcut) {
            if (!entity.isSleeping()) {
                Vector3D vD;
                float dot;
                Vector3D vKP;
                int i;
                Kart k = entity.getType() == 0 ? (Kart)entity : null;
                Vector3D[] kbb = entity.getBoundingBox();
                Vector3D kartPos = new Vector3D(entity.getPosition());
                Vector3D dist = new Vector3D();
                int p1 = nearestPoint[0] - 1;
                if (p1 < 0) {
                    p1 += this.m_Track.iPoints.length - 1;
                } else if (p1 > this.m_Track.iPoints.length - 1) {
                    p1 -= this.m_Track.iPoints.length - 1;
                }
                int pp1 = p1 - 1;
                if (pp1 < 0) {
                    pp1 += this.m_Track.iPoints.length - 1;
                } else if (pp1 > this.m_Track.iPoints.length - 1) {
                    pp1 -= this.m_Track.iPoints.length - 1;
                }
                dist.set(kartPos);
                dist.sub(this.m_Track.iPoints[p1]);
                float len1 = dist.length();
                int p2 = nearestPoint[0] + 1;
                if (p2 > this.m_Track.iPoints.length - 1) {
                    p2 -= this.m_Track.iPoints.length - 1;
                } else if (p2 < 0) {
                    p2 += this.m_Track.iPoints.length - 1;
                }
                dist.set(kartPos);
                dist.sub(this.m_Track.iPoints[p2]);
                float len2 = dist.length();
                if (len1 > len2) {
                    p1 = nearestPoint[0];
                } else {
                    p2 = nearestPoint[0];
                }
                Vector3D vP1L = null;
                Vector3D vP1R = null;
                Vector3D vNL = null;
                Vector3D vNR = null;
                int[] tmpNr = new int[2];
                if (this.checkRoadsideTriangeNr(kartPos, nearestPoint, tmpNr)) {
                    p1 = tmpNr[0];
                    p2 = tmpNr[1];
                }
                vP1L = new Vector3D(this.m_Track.leftSideVertices[p1 * 2 * 3 + 0], this.m_Track.leftSideVertices[p1 * 2 * 3 + 1], this.m_Track.leftSideVertices[p1 * 2 * 3 + 2]);
                Vector3D vP2L = new Vector3D(this.m_Track.leftSideVertices[p2 * 2 * 3 + 0], this.m_Track.leftSideVertices[p2 * 2 * 3 + 1], this.m_Track.leftSideVertices[p2 * 2 * 3 + 2]);
                vNL = Vector3D.normalize(Vector3D.crossProduct(Vector3D.sub(vP2L, vP1L), new Vector3D(0.0f, 1.0f, 0.0f)));
                for (i = 0; i < 4; ++i) {
                    vKP = new Vector3D(kbb[4 + i]);
                    dot = Vector3D.dotProduct(vNL, Vector3D.sub(vKP, vP1L));
                    vD = Vector3D.sub(this.m_Track.iPoints[p1], vKP);
                    if (!(dot < colT) || this.checkIfOnRoadside(vKP, nearestPoint) != -1) continue;
                    entity.triggerTrackCollision(vNL, dot);
                    kbb = entity.getBoundingBox();
                    k.endBoost();
                }
                vP1R = new Vector3D(this.m_Track.rightSideVertices[p1 * 2 * 3 + 0 + 3], this.m_Track.rightSideVertices[p1 * 2 * 3 + 1 + 3], this.m_Track.rightSideVertices[p1 * 2 * 3 + 2 + 3]);
                Vector3D vP2R = new Vector3D(this.m_Track.rightSideVertices[p2 * 2 * 3 + 0 + 3], this.m_Track.rightSideVertices[p2 * 2 * 3 + 1 + 3], this.m_Track.rightSideVertices[p2 * 2 * 3 + 2 + 3]);
                vNR = Vector3D.normalize(Vector3D.crossProduct(Vector3D.sub(vP1R, vP2R), new Vector3D(0.0f, 1.0f, 0.0f)));
                for (i = 0; i < 4; ++i) {
                    vKP = new Vector3D(kbb[0 + i]);
                    dot = Vector3D.dotProduct(vNR, Vector3D.sub(vKP, vP1R));
                    vD = Vector3D.sub(this.m_Track.iPoints[p1], vKP);
                    if (!(dot < colT) || this.checkIfOnRoadside(vKP, nearestPoint) != -1) continue;
                    entity.triggerTrackCollision(vNR, dot);
                    kbb = entity.getBoundingBox();
                    k.endBoost();
                }
                if (k != null) {
                    boolean closeScL = false;
                    boolean closeScR = false;
                    for (int i2 = 0; i2 < this.m_Track.mShortcutsArray.size(); ++i2) {
                        TrackShortcut sc = (TrackShortcut)this.m_Track.mShortcutsArray.elementAt(i2);
                        if (nearestPoint[0] >= sc.startPoints[0] && nearestPoint[0] <= sc.startPoints[3] && sc.startSide == 1 || nearestPoint[0] >= sc.endPoints[0] && nearestPoint[0] <= sc.endPoints[3] && sc.endSide == 1) {
                            closeScR = true;
                        }
                        if ((nearestPoint[0] < sc.startPoints[0] || nearestPoint[0] > sc.startPoints[3] || sc.startSide != 0) && (nearestPoint[0] < sc.endPoints[0] || nearestPoint[0] > sc.endPoints[3] || sc.endSide != 0)) continue;
                        closeScL = true;
                    }
                    if (this.checkIfOnRoadside(kartPos, nearestPoint) > -1 && !closeScL && !closeScR) {
                        k.setTrackSection(1);
                    } else {
                        k.setTrackSection(0);
                    }
                }
            }
        } else {
            TrackShortcut sc = (TrackShortcut)this.m_Track.mShortcutsArray.elementAt(nearestPoint[1] - 1);
            if (!entity.isSleeping()) {
                Vector3D vD;
                float dot;
                Vector3D vKP;
                int i;
                int p1;
                Kart k = entity.getType() == 0 ? (Kart)entity : null;
                Vector3D[] kbb = entity.getBoundingBox();
                Vector3D kartPos = new Vector3D(entity.getPosition());
                Vector3D dist = new Vector3D();
                if (nearestPoint[0] == 0) {
                    nearestPoint[0] = 1;
                }
                if (nearestPoint[0] >= sc.iPoints.length - 1) {
                    nearestPoint[0] = sc.iPoints.length - 2;
                }
                if ((p1 = nearestPoint[0] - 1) < 0) {
                    p1 = 0;
                } else if (p1 > sc.iPoints.length - 1) {
                    p1 = sc.iPoints.length - 1;
                }
                dist.set(kartPos);
                dist.sub(sc.iPoints[p1]);
                float len1 = dist.length();
                int p2 = nearestPoint[0] + 1;
                if (p2 > sc.iPoints.length - 1) {
                    p2 = sc.iPoints.length - 1;
                } else if (p2 < 0) {
                    p2 += sc.iPoints.length - 1;
                }
                dist.set(kartPos);
                dist.sub(sc.iPoints[p2]);
                float len2 = dist.length();
                if (len1 > len2) {
                    p1 = nearestPoint[0];
                } else {
                    p2 = nearestPoint[0];
                }
                Vector3D vP1L = null;
                Vector3D vP1R = null;
                Vector3D vNL = null;
                Vector3D vNR = null;
                vP1L = new Vector3D(sc.leftSideVertices[p1 * 2 * 3 + 0], sc.leftSideVertices[p1 * 2 * 3 + 1], sc.leftSideVertices[p1 * 2 * 3 + 2]);
                Vector3D vP2L = new Vector3D(sc.leftSideVertices[p2 * 2 * 3 + 0], sc.leftSideVertices[p2 * 2 * 3 + 1], sc.leftSideVertices[p2 * 2 * 3 + 2]);
                vNL = Vector3D.normalize(Vector3D.crossProduct(Vector3D.sub(vP2L, vP1L), new Vector3D(0.0f, 1.0f, 0.0f)));
                for (i = 0; i < 4; ++i) {
                    vKP = new Vector3D(kbb[4 + i]);
                    dot = Vector3D.dotProduct(vNL, Vector3D.sub(vKP, vP1L));
                    vD = Vector3D.sub(sc.iPoints[p1], vKP);
                    if (!(dot < colT)) continue;
                    entity.triggerTrackCollision(vNL, dot);
                    kbb = entity.getBoundingBox();
                    k.endBoost();
                }
                vP1R = new Vector3D(sc.rightSideVertices[p1 * 2 * 3 + 0 + 3], sc.rightSideVertices[p1 * 2 * 3 + 1 + 3], sc.rightSideVertices[p1 * 2 * 3 + 2 + 3]);
                Vector3D vP2R = new Vector3D(sc.rightSideVertices[p2 * 2 * 3 + 0 + 3], sc.rightSideVertices[p2 * 2 * 3 + 1 + 3], sc.rightSideVertices[p2 * 2 * 3 + 2 + 3]);
                vNR = Vector3D.normalize(Vector3D.crossProduct(Vector3D.sub(vP1R, vP2R), new Vector3D(0.0f, 1.0f, 0.0f)));
                for (i = 0; i < 4; ++i) {
                    vKP = new Vector3D(kbb[4 + i]);
                    dot = Vector3D.dotProduct(vNR, Vector3D.sub(vKP, vP1R));
                    vD = Vector3D.sub(sc.iPoints[p1], vKP);
                    if (!(dot < colT)) continue;
                    entity.triggerTrackCollision(vNR, dot);
                    kbb = entity.getBoundingBox();
                    k.endBoost();
                }
                if (k != null) {
                    if (this.checkIfOnRoadside(kartPos, nearestPoint) > -1) {
                        k.setTrackSection(1);
                    } else {
                        k.setTrackSection(0);
                    }
                }
            }
        }
    }

    private boolean checkLightTrackCollisions(PhysicalEntity entity, int[] nearestPoint) {
        boolean coll = false;
        if (!entity.isSleeping()) {
            Vector3D pos;
            Vector3D vD;
            float dot;
            Vector3D vKP;
            int i;
            short[] rightSideVertices;
            short[] leftSideVertices;
            Vector3D[] iPoints;
            if (entity.isOnShortcut) {
                TrackShortcut sc = (TrackShortcut)this.m_Track.mShortcutsArray.elementAt(nearestPoint[1] - 1);
                iPoints = sc.iPoints;
                leftSideVertices = sc.leftSideVertices;
                rightSideVertices = sc.rightSideVertices;
            } else {
                iPoints = this.m_Track.iPoints;
                leftSideVertices = this.m_Track.leftSideVertices;
                rightSideVertices = this.m_Track.rightSideVertices;
            }
            Vector3D[] kbb = entity.getBoundingBox();
            Vector3D entityPos = new Vector3D(entity.getPosition());
            Vector3D dist = new Vector3D();
            int p1 = nearestPoint[0] - 1;
            if (p1 < 0) {
                p1 += iPoints.length - 1;
            } else if (p1 > iPoints.length - 1) {
                p1 -= iPoints.length - 1;
            }
            dist.set(entityPos);
            dist.sub(iPoints[p1]);
            float len1 = dist.length();
            int p2 = nearestPoint[0] + 1;
            if (p2 > iPoints.length - 1) {
                p2 -= iPoints.length - 1;
            } else if (p2 < 0) {
                p2 += iPoints.length - 1;
            }
            dist.set(entityPos);
            dist.sub(iPoints[p2]);
            float len2 = dist.length();
            if (len1 > len2) {
                p1 = nearestPoint[0];
            } else {
                p2 = nearestPoint[0];
            }
            Vector3D vP1L = null;
            Vector3D vP1R = null;
            Vector3D vNL = null;
            Vector3D vNR = null;
            try {
                vP1L = new Vector3D(leftSideVertices[p1 * 2 * 3 + 0], leftSideVertices[p1 * 2 * 3 + 1], leftSideVertices[p1 * 2 * 3 + 2]);
                Vector3D vP2L = new Vector3D(leftSideVertices[p2 * 2 * 3 + 0], leftSideVertices[p2 * 2 * 3 + 1], leftSideVertices[p2 * 2 * 3 + 2]);
                vNL = Vector3D.normalize(Vector3D.crossProduct(Vector3D.sub(vP2L, vP1L), new Vector3D(0.0f, 1.0f, 0.0f)));
                for (i = 0; i < 4; ++i) {
                    vKP = new Vector3D(kbb[4 + i]);
                    dot = Vector3D.dotProduct(vNL, Vector3D.sub(vKP, vP1L));
                    vD = Vector3D.sub(iPoints[p1], vKP);
                    if (!(dot < 0.0f) || !entity.isOnShortcut && !(vD.length() > this.m_Track.iPointsWidth[p1] + this.m_Track.roadSideWidth)) continue;
                    pos = Vector3D.sub(entity.getPosition(), Vector3D.scalarMul(-1.0f, vNL));
                    entity.setPosition(pos);
                    coll = true;
                }
            }
            catch (Exception e) {
                System.out.println("Exception in light track collision handling in " + entity.getInfo());
            }
            try {
                vP1R = new Vector3D(rightSideVertices[p1 * 2 * 3 + 0 + 3], rightSideVertices[p1 * 2 * 3 + 1 + 3], rightSideVertices[p1 * 2 * 3 + 2 + 3]);
                Vector3D vP2R = new Vector3D(rightSideVertices[p2 * 2 * 3 + 0 + 3], rightSideVertices[p2 * 2 * 3 + 1 + 3], rightSideVertices[p2 * 2 * 3 + 2 + 3]);
                vNR = Vector3D.normalize(Vector3D.crossProduct(Vector3D.sub(vP1R, vP2R), new Vector3D(0.0f, 1.0f, 0.0f)));
                for (i = 0; i < 4; ++i) {
                    vKP = new Vector3D(kbb[4 + i]);
                    dot = Vector3D.dotProduct(vNR, Vector3D.sub(vKP, vP1R));
                    vD = Vector3D.sub(iPoints[p1], vKP);
                    if (!(dot < 0.0f) || !entity.isOnShortcut && !(vD.length() > this.m_Track.iPointsWidth[p1] + this.m_Track.roadSideWidth)) continue;
                    pos = Vector3D.sub(entity.getPosition(), Vector3D.scalarMul(-1.0f, vNR));
                    entity.setPosition(pos);
                    coll = true;
                }
            }
            catch (Exception e) {
                System.out.println("Exception in light track collision handling in " + entity.getInfo());
            }
        }
        return coll;
    }

    private int checkMainRoadCollision(PhysicalEntity entity, int nearestPoint, float collTolerance) {
        Vector3D vD;
        float dot;
        Vector3D vKP;
        int i;
        Vector3D[] kbb = entity.getBoundingBox();
        Vector3D kartPos = new Vector3D(entity.getPosition());
        Vector3D dist = new Vector3D();
        int p1 = nearestPoint - 1;
        if (p1 < 0) {
            p1 += this.m_Track.iPoints.length - 1;
        } else if (p1 > this.m_Track.iPoints.length - 1) {
            p1 -= this.m_Track.iPoints.length - 1;
        }
        dist.set(kartPos);
        dist.sub(this.m_Track.iPoints[p1]);
        float len1 = dist.length();
        int p2 = nearestPoint + 1;
        if (p2 > this.m_Track.iPoints.length - 1) {
            p2 -= this.m_Track.iPoints.length - 1;
        } else if (p2 < 0) {
            p2 += this.m_Track.iPoints.length - 1;
        }
        dist.set(kartPos);
        dist.sub(this.m_Track.iPoints[p2]);
        float len2 = dist.length();
        if (len1 > len2) {
            p1 = nearestPoint;
        } else {
            p2 = nearestPoint;
        }
        Vector3D vP1L = null;
        Vector3D vP1R = null;
        Vector3D vNL = null;
        Vector3D vNR = null;
        try {
            vP1L = new Vector3D(this.m_Track.leftSideVertices[p1 * 2 * 3 + 0], this.m_Track.leftSideVertices[p1 * 2 * 3 + 1], this.m_Track.leftSideVertices[p1 * 2 * 3 + 2]);
            Vector3D vP2L = new Vector3D(this.m_Track.leftSideVertices[p2 * 2 * 3 + 0], this.m_Track.leftSideVertices[p2 * 2 * 3 + 1], this.m_Track.leftSideVertices[p2 * 2 * 3 + 2]);
            vNL = Vector3D.normalize(Vector3D.crossProduct(Vector3D.sub(vP2L, vP1L), new Vector3D(0.0f, 1.0f, 0.0f)));
            for (i = 0; i < 4; ++i) {
                vKP = new Vector3D(kbb[4 + i]);
                dot = Vector3D.dotProduct(vNL, Vector3D.sub(vKP, vP1L));
                vD = Vector3D.sub(this.m_Track.iPoints[p1], vKP);
                if (!(dot < collTolerance)) continue;
                return 0;
            }
        }
        catch (Exception e) {
            System.out.println("Exception in checkMainRoadCollision(left) handling in " + entity.getInfo());
        }
        try {
            vP1R = new Vector3D(this.m_Track.rightSideVertices[p1 * 2 * 3 + 0 + 3], this.m_Track.rightSideVertices[p1 * 2 * 3 + 1 + 3], this.m_Track.rightSideVertices[p1 * 2 * 3 + 2 + 3]);
            Vector3D vP2R = new Vector3D(this.m_Track.rightSideVertices[p2 * 2 * 3 + 0 + 3], this.m_Track.rightSideVertices[p2 * 2 * 3 + 1 + 3], this.m_Track.rightSideVertices[p2 * 2 * 3 + 2 + 3]);
            vNR = Vector3D.normalize(Vector3D.crossProduct(Vector3D.sub(vP1R, vP2R), new Vector3D(0.0f, 1.0f, 0.0f)));
            for (i = 0; i < 4; ++i) {
                vKP = new Vector3D(kbb[4 + i]);
                dot = Vector3D.dotProduct(vNR, Vector3D.sub(vKP, vP1R));
                vD = Vector3D.sub(this.m_Track.iPoints[p1], vKP);
                if (!(dot < collTolerance)) continue;
                return 1;
            }
        }
        catch (Exception e) {
            System.out.println("Exception in checkMainRoadCollision(right) handling in " + entity.getInfo());
        }
        return -1;
    }

    private int checkShortcutCollision(PhysicalEntity entity, int nearestPoint, int scNr) {
        float collTolerance = 7.0f;
        TrackShortcut sc = (TrackShortcut)this.m_Track.mShortcutsArray.elementAt(scNr);
        if (!entity.isSleeping()) {
            Vector3D vD;
            float dot;
            Vector3D vKP;
            int i;
            int p1;
            Kart k = entity.getType() == 0 ? (Kart)entity : null;
            Vector3D[] kbb = entity.getBoundingBox();
            Vector3D kartPos = new Vector3D(entity.getPosition());
            Vector3D dist = new Vector3D();
            if (nearestPoint == 0) {
                nearestPoint = 1;
            }
            if (nearestPoint >= sc.iPoints.length - 1) {
                nearestPoint = sc.iPoints.length - 2;
            }
            if ((p1 = nearestPoint - 1) < 0) {
                p1 = 0;
            } else if (p1 > sc.iPoints.length - 1) {
                p1 = sc.iPoints.length - 1;
            }
            dist.set(kartPos);
            dist.sub(sc.iPoints[p1]);
            float len1 = dist.length();
            int p2 = nearestPoint + 1;
            if (p2 > sc.iPoints.length - 1) {
                p2 = sc.iPoints.length - 1;
            } else if (p2 < 0) {
                p2 += sc.iPoints.length - 1;
            }
            dist.set(kartPos);
            dist.sub(sc.iPoints[p2]);
            float len2 = dist.length();
            if (len1 > len2) {
                p1 = nearestPoint;
            } else {
                p2 = nearestPoint;
            }
            Vector3D vP1L = null;
            Vector3D vP1R = null;
            Vector3D vNL = null;
            Vector3D vNR = null;
            vP1L = new Vector3D(sc.leftSideVertices[p1 * 2 * 3 + 0], sc.leftSideVertices[p1 * 2 * 3 + 1], sc.leftSideVertices[p1 * 2 * 3 + 2]);
            Vector3D vP2L = new Vector3D(sc.leftSideVertices[p2 * 2 * 3 + 0], sc.leftSideVertices[p2 * 2 * 3 + 1], sc.leftSideVertices[p2 * 2 * 3 + 2]);
            vNL = Vector3D.normalize(Vector3D.crossProduct(Vector3D.sub(vP2L, vP1L), new Vector3D(0.0f, 1.0f, 0.0f)));
            for (i = 0; i < 4; ++i) {
                vKP = new Vector3D(kbb[4 + i]);
                dot = Vector3D.dotProduct(vNL, Vector3D.sub(vKP, vP1L));
                vD = Vector3D.sub(sc.iPoints[p1], vKP);
                if (!(dot < collTolerance)) continue;
                return 0;
            }
            vP1R = new Vector3D(sc.rightSideVertices[p1 * 2 * 3 + 0 + 3], sc.rightSideVertices[p1 * 2 * 3 + 1 + 3], sc.rightSideVertices[p1 * 2 * 3 + 2 + 3]);
            Vector3D vP2R = new Vector3D(sc.rightSideVertices[p2 * 2 * 3 + 0 + 3], sc.rightSideVertices[p2 * 2 * 3 + 1 + 3], sc.rightSideVertices[p2 * 2 * 3 + 2 + 3]);
            vNR = Vector3D.normalize(Vector3D.crossProduct(Vector3D.sub(vP1R, vP2R), new Vector3D(0.0f, 1.0f, 0.0f)));
            for (i = 0; i < 4; ++i) {
                vKP = new Vector3D(kbb[4 + i]);
                dot = Vector3D.dotProduct(vNR, Vector3D.sub(vKP, vP1R));
                vD = Vector3D.sub(sc.iPoints[p1], vKP);
                if (!(dot < collTolerance)) continue;
                return 1;
            }
        }
        return -1;
    }

    private void checkRaceState(Kart kart, int[] nearestPoint) {
        if (nearestPoint[1] == 0) {
            if (nearestPoint[0] < 3 && kart.nearestPoint[0] > this.m_Track.iPoints.length - 1 - 3) {
                ++kart.lap;
            }
            if (nearestPoint[0] > this.m_Track.iPoints.length - 1 - 3 && kart.nearestPoint[0] < 3) {
                --kart.lap;
            }
            kart.actPos = kart.lap * this.m_Track.iPoints.length + nearestPoint[0];
        } else {
            TrackShortcut sc = (TrackShortcut)this.m_Track.mShortcutsArray.elementAt(nearestPoint[1] - 1);
            kart.actPos = kart.lap * this.m_Track.iPoints.length + sc.startPoints[0] + nearestPoint[0] * (sc.endPoints[0] - sc.startPoints[0]) / sc.iPoints.length;
        }
        if (kart.actPos > kart.bestPos) {
            kart.bestPos = kart.actPos;
        }
        kart.nearestPoint = nearestPoint;
    }

    private boolean triangleCheck(Vector3D A, Vector3D B, Vector3D C, Vector3D p) {
        this.tc_trA.set(A.getx(), 0.0f, A.getz());
        this.tc_trB.set(B.getx(), 0.0f, B.getz());
        this.tc_trC.set(C.getx(), 0.0f, C.getz());
        this.tc_trp.set(p.getx(), 0.0f, p.getz());
        this.v0.set(this.tc_trC);
        this.v0.sub(this.tc_trA);
        this.v1.set(this.tc_trB);
        this.v1.sub(this.tc_trA);
        this.v2.set(this.tc_trp);
        this.v2.sub(this.tc_trA);
        float dot00 = Vector3D.dotProduct(this.v0, this.v0);
        float dot01 = Vector3D.dotProduct(this.v0, this.v1);
        float dot02 = Vector3D.dotProduct(this.v0, this.v2);
        float dot11 = Vector3D.dotProduct(this.v1, this.v1);
        float dot12 = Vector3D.dotProduct(this.v1, this.v2);
        float invDenom = 1.0f / (dot00 * dot11 - dot01 * dot01);
        float u = (dot11 * dot02 - dot01 * dot12) * invDenom;
        float v = (dot00 * dot12 - dot01 * dot02) * invDenom;
        return u > 0.0f && v > 0.0f && u + v < 1.0f;
    }

    private float checkGroundLevel(Vector3D slope, Vector3D position, int[] nearestPoint) {
        int nextnext;
        int next;
        int prevprev;
        int prev;
        this.ckgl_kartPos.set(position);
        if (nearestPoint[1] == 0) {
            prev = nearestPoint[0] == 0 ? this.m_Track.iPoints.length - 1 : nearestPoint[0] - 1;
            prevprev = prev == 0 ? this.m_Track.iPoints.length - 1 : prev - 1;
            next = nearestPoint[0] == this.m_Track.iPoints.length - 1 ? 0 : nearestPoint[0] + 1;
            nextnext = next == this.m_Track.iPoints.length - 1 ? 0 : next + 1;
            try {
                this.ckgl_v[0].set(this.m_Track.roadVertices[prevprev * 2 * 3 + 0], this.m_Track.roadVertices[prevprev * 2 * 3 + 1], this.m_Track.roadVertices[prevprev * 2 * 3 + 2]);
                this.ckgl_v[1].set(this.m_Track.roadVertices[prevprev * 2 * 3 + 0 + 3], this.m_Track.roadVertices[prevprev * 2 * 3 + 1 + 3], this.m_Track.roadVertices[prevprev * 2 * 3 + 2 + 3]);
                this.ckgl_v[2].set(this.m_Track.roadVertices[prev * 2 * 3 + 0], this.m_Track.roadVertices[prev * 2 * 3 + 1], this.m_Track.roadVertices[prev * 2 * 3 + 2]);
                this.ckgl_v[3].set(this.m_Track.roadVertices[prev * 2 * 3 + 0 + 3], this.m_Track.roadVertices[prev * 2 * 3 + 1 + 3], this.m_Track.roadVertices[prev * 2 * 3 + 2 + 3]);
                this.ckgl_v[4].set(this.m_Track.roadVertices[nearestPoint[0] * 2 * 3 + 0], this.m_Track.roadVertices[nearestPoint[0] * 2 * 3 + 1], this.m_Track.roadVertices[nearestPoint[0] * 2 * 3 + 2]);
                this.ckgl_v[5].set(this.m_Track.roadVertices[nearestPoint[0] * 2 * 3 + 0 + 3], this.m_Track.roadVertices[nearestPoint[0] * 2 * 3 + 1 + 3], this.m_Track.roadVertices[nearestPoint[0] * 2 * 3 + 2 + 3]);
                this.ckgl_v[6].set(this.m_Track.roadVertices[next * 2 * 3 + 0], this.m_Track.roadVertices[next * 2 * 3 + 1], this.m_Track.roadVertices[next * 2 * 3 + 2]);
                this.ckgl_v[7].set(this.m_Track.roadVertices[next * 2 * 3 + 0 + 3], this.m_Track.roadVertices[next * 2 * 3 + 1 + 3], this.m_Track.roadVertices[next * 2 * 3 + 2 + 3]);
                this.ckgl_v[8].set(this.m_Track.roadVertices[nextnext * 2 * 3 + 0], this.m_Track.roadVertices[nextnext * 2 * 3 + 1], this.m_Track.roadVertices[nextnext * 2 * 3 + 2]);
                this.ckgl_v[9].set(this.m_Track.roadVertices[nextnext * 2 * 3 + 0 + 3], this.m_Track.roadVertices[nextnext * 2 * 3 + 1 + 3], this.m_Track.roadVertices[nextnext * 2 * 3 + 2 + 3]);
                this.ckgl_v[10].set(this.m_Track.leftSideVertices[prevprev * 2 * 3 + 0], this.m_Track.leftSideVertices[prevprev * 2 * 3 + 1], this.m_Track.leftSideVertices[prevprev * 2 * 3 + 2]);
                this.ckgl_v[11].set(this.m_Track.leftSideVertices[prevprev * 2 * 3 + 0 + 3], this.m_Track.leftSideVertices[prevprev * 2 * 3 + 1 + 3], this.m_Track.leftSideVertices[prevprev * 2 * 3 + 2 + 3]);
                this.ckgl_v[12].set(this.m_Track.leftSideVertices[prev * 2 * 3 + 0], this.m_Track.leftSideVertices[prev * 2 * 3 + 1], this.m_Track.leftSideVertices[prev * 2 * 3 + 2]);
                this.ckgl_v[13].set(this.m_Track.leftSideVertices[prev * 2 * 3 + 0 + 3], this.m_Track.leftSideVertices[prev * 2 * 3 + 1 + 3], this.m_Track.leftSideVertices[prev * 2 * 3 + 2 + 3]);
                this.ckgl_v[14].set(this.m_Track.leftSideVertices[nearestPoint[0] * 2 * 3 + 0], this.m_Track.leftSideVertices[nearestPoint[0] * 2 * 3 + 1], this.m_Track.leftSideVertices[nearestPoint[0] * 2 * 3 + 2]);
                this.ckgl_v[15].set(this.m_Track.leftSideVertices[nearestPoint[0] * 2 * 3 + 0 + 3], this.m_Track.leftSideVertices[nearestPoint[0] * 2 * 3 + 1 + 3], this.m_Track.leftSideVertices[nearestPoint[0] * 2 * 3 + 2 + 3]);
                this.ckgl_v[16].set(this.m_Track.leftSideVertices[next * 2 * 3 + 0], this.m_Track.leftSideVertices[next * 2 * 3 + 1], this.m_Track.leftSideVertices[next * 2 * 3 + 2]);
                this.ckgl_v[17].set(this.m_Track.leftSideVertices[next * 2 * 3 + 0 + 3], this.m_Track.leftSideVertices[next * 2 * 3 + 1 + 3], this.m_Track.leftSideVertices[next * 2 * 3 + 2 + 3]);
                this.ckgl_v[18].set(this.m_Track.leftSideVertices[nextnext * 2 * 3 + 0], this.m_Track.leftSideVertices[nextnext * 2 * 3 + 1], this.m_Track.leftSideVertices[nextnext * 2 * 3 + 2]);
                this.ckgl_v[19].set(this.m_Track.leftSideVertices[nextnext * 2 * 3 + 0 + 3], this.m_Track.leftSideVertices[nextnext * 2 * 3 + 1 + 3], this.m_Track.leftSideVertices[nextnext * 2 * 3 + 2 + 3]);
                this.ckgl_v[20].set(this.m_Track.rightSideVertices[prevprev * 2 * 3 + 0], this.m_Track.rightSideVertices[prevprev * 2 * 3 + 1], this.m_Track.rightSideVertices[prevprev * 2 * 3 + 2]);
                this.ckgl_v[21].set(this.m_Track.rightSideVertices[prevprev * 2 * 3 + 0 + 3], this.m_Track.rightSideVertices[prevprev * 2 * 3 + 1 + 3], this.m_Track.rightSideVertices[prevprev * 2 * 3 + 2 + 3]);
                this.ckgl_v[22].set(this.m_Track.rightSideVertices[prev * 2 * 3 + 0], this.m_Track.rightSideVertices[prev * 2 * 3 + 1], this.m_Track.rightSideVertices[prev * 2 * 3 + 2]);
                this.ckgl_v[23].set(this.m_Track.rightSideVertices[prev * 2 * 3 + 0 + 3], this.m_Track.rightSideVertices[prev * 2 * 3 + 1 + 3], this.m_Track.rightSideVertices[prev * 2 * 3 + 2 + 3]);
                this.ckgl_v[24].set(this.m_Track.rightSideVertices[nearestPoint[0] * 2 * 3 + 0], this.m_Track.rightSideVertices[nearestPoint[0] * 2 * 3 + 1], this.m_Track.rightSideVertices[nearestPoint[0] * 2 * 3 + 2]);
                this.ckgl_v[25].set(this.m_Track.rightSideVertices[nearestPoint[0] * 2 * 3 + 0 + 3], this.m_Track.rightSideVertices[nearestPoint[0] * 2 * 3 + 1 + 3], this.m_Track.rightSideVertices[nearestPoint[0] * 2 * 3 + 2 + 3]);
                this.ckgl_v[26].set(this.m_Track.rightSideVertices[next * 2 * 3 + 0], this.m_Track.rightSideVertices[next * 2 * 3 + 1], this.m_Track.rightSideVertices[next * 2 * 3 + 2]);
                this.ckgl_v[27].set(this.m_Track.rightSideVertices[next * 2 * 3 + 0 + 3], this.m_Track.rightSideVertices[next * 2 * 3 + 1 + 3], this.m_Track.rightSideVertices[next * 2 * 3 + 2 + 3]);
                this.ckgl_v[28].set(this.m_Track.rightSideVertices[nextnext * 2 * 3 + 0], this.m_Track.rightSideVertices[nextnext * 2 * 3 + 1], this.m_Track.rightSideVertices[nextnext * 2 * 3 + 2]);
                this.ckgl_v[29].set(this.m_Track.rightSideVertices[nextnext * 2 * 3 + 0 + 3], this.m_Track.rightSideVertices[nextnext * 2 * 3 + 1 + 3], this.m_Track.rightSideVertices[nextnext * 2 * 3 + 2 + 3]);
            }
            catch (Exception e) {
                System.out.println("Exception in ground checking at " + position);
                return 0.0f;
            }
        }
        TrackShortcut sc = (TrackShortcut)this.m_Track.mShortcutsArray.elementAt(nearestPoint[1] - 1);
        prev = nearestPoint[0] == 0 ? 0 : nearestPoint[0] - 1;
        prevprev = prev == 0 ? 0 : prev - 1;
        next = nearestPoint[0] >= sc.iPoints.length - 1 ? sc.iPoints.length - 1 : nearestPoint[0] + 1;
        nextnext = next == sc.iPoints.length - 1 ? sc.iPoints.length - 1 : next + 1;
        try {
            this.ckgl_v[0].set(sc.roadVertices[prevprev * 2 * 3 + 0], sc.roadVertices[prevprev * 2 * 3 + 1], sc.roadVertices[prevprev * 2 * 3 + 2]);
            this.ckgl_v[1].set(sc.roadVertices[prevprev * 2 * 3 + 0 + 3], sc.roadVertices[prevprev * 2 * 3 + 1 + 3], sc.roadVertices[prevprev * 2 * 3 + 2 + 3]);
            this.ckgl_v[2].set(sc.roadVertices[prev * 2 * 3 + 0], sc.roadVertices[prev * 2 * 3 + 1], sc.roadVertices[prev * 2 * 3 + 2]);
            this.ckgl_v[3].set(sc.roadVertices[prev * 2 * 3 + 0 + 3], sc.roadVertices[prev * 2 * 3 + 1 + 3], sc.roadVertices[prev * 2 * 3 + 2 + 3]);
            this.ckgl_v[4].set(sc.roadVertices[nearestPoint[0] * 2 * 3 + 0], sc.roadVertices[nearestPoint[0] * 2 * 3 + 1], sc.roadVertices[nearestPoint[0] * 2 * 3 + 2]);
            this.ckgl_v[5].set(sc.roadVertices[nearestPoint[0] * 2 * 3 + 0 + 3], sc.roadVertices[nearestPoint[0] * 2 * 3 + 1 + 3], sc.roadVertices[nearestPoint[0] * 2 * 3 + 2 + 3]);
            this.ckgl_v[6].set(sc.roadVertices[next * 2 * 3 + 0], sc.roadVertices[next * 2 * 3 + 1], sc.roadVertices[next * 2 * 3 + 2]);
            this.ckgl_v[7].set(sc.roadVertices[next * 2 * 3 + 0 + 3], sc.roadVertices[next * 2 * 3 + 1 + 3], sc.roadVertices[next * 2 * 3 + 2 + 3]);
            this.ckgl_v[8].set(sc.roadVertices[nextnext * 2 * 3 + 0], sc.roadVertices[nextnext * 2 * 3 + 1], sc.roadVertices[nextnext * 2 * 3 + 2]);
            this.ckgl_v[9].set(sc.roadVertices[nextnext * 2 * 3 + 0 + 3], sc.roadVertices[nextnext * 2 * 3 + 1 + 3], sc.roadVertices[nextnext * 2 * 3 + 2 + 3]);
            this.ckgl_v[10].set(sc.leftSideVertices[prevprev * 2 * 3 + 0], sc.leftSideVertices[prevprev * 2 * 3 + 1], sc.leftSideVertices[prevprev * 2 * 3 + 2]);
            this.ckgl_v[11].set(sc.leftSideVertices[prevprev * 2 * 3 + 0 + 3], sc.leftSideVertices[prevprev * 2 * 3 + 1 + 3], sc.leftSideVertices[prevprev * 2 * 3 + 2 + 3]);
            this.ckgl_v[12].set(sc.leftSideVertices[prev * 2 * 3 + 0], sc.leftSideVertices[prev * 2 * 3 + 1], sc.leftSideVertices[prev * 2 * 3 + 2]);
            this.ckgl_v[13].set(sc.leftSideVertices[prev * 2 * 3 + 0 + 3], sc.leftSideVertices[prev * 2 * 3 + 1 + 3], sc.leftSideVertices[prev * 2 * 3 + 2 + 3]);
            this.ckgl_v[14].set(sc.leftSideVertices[nearestPoint[0] * 2 * 3 + 0], sc.leftSideVertices[nearestPoint[0] * 2 * 3 + 1], sc.leftSideVertices[nearestPoint[0] * 2 * 3 + 2]);
            this.ckgl_v[15].set(sc.leftSideVertices[nearestPoint[0] * 2 * 3 + 0 + 3], sc.leftSideVertices[nearestPoint[0] * 2 * 3 + 1 + 3], sc.leftSideVertices[nearestPoint[0] * 2 * 3 + 2 + 3]);
            this.ckgl_v[16].set(sc.leftSideVertices[next * 2 * 3 + 0], sc.leftSideVertices[next * 2 * 3 + 1], sc.leftSideVertices[next * 2 * 3 + 2]);
            this.ckgl_v[17].set(sc.leftSideVertices[next * 2 * 3 + 0 + 3], sc.leftSideVertices[next * 2 * 3 + 1 + 3], sc.leftSideVertices[next * 2 * 3 + 2 + 3]);
            this.ckgl_v[18].set(sc.leftSideVertices[nextnext * 2 * 3 + 0], sc.leftSideVertices[nextnext * 2 * 3 + 1], sc.leftSideVertices[nextnext * 2 * 3 + 2]);
            this.ckgl_v[19].set(sc.leftSideVertices[nextnext * 2 * 3 + 0 + 3], sc.leftSideVertices[nextnext * 2 * 3 + 1 + 3], sc.leftSideVertices[nextnext * 2 * 3 + 2 + 3]);
            this.ckgl_v[20].set(sc.rightSideVertices[prevprev * 2 * 3 + 0], sc.rightSideVertices[prevprev * 2 * 3 + 1], sc.rightSideVertices[prevprev * 2 * 3 + 2]);
            this.ckgl_v[21].set(sc.rightSideVertices[prevprev * 2 * 3 + 0 + 3], sc.rightSideVertices[prevprev * 2 * 3 + 1 + 3], sc.rightSideVertices[prevprev * 2 * 3 + 2 + 3]);
            this.ckgl_v[22].set(sc.rightSideVertices[prev * 2 * 3 + 0], sc.rightSideVertices[prev * 2 * 3 + 1], sc.rightSideVertices[prev * 2 * 3 + 2]);
            this.ckgl_v[23].set(sc.rightSideVertices[prev * 2 * 3 + 0 + 3], sc.rightSideVertices[prev * 2 * 3 + 1 + 3], sc.rightSideVertices[prev * 2 * 3 + 2 + 3]);
            this.ckgl_v[24].set(sc.rightSideVertices[nearestPoint[0] * 2 * 3 + 0], sc.rightSideVertices[nearestPoint[0] * 2 * 3 + 1], sc.rightSideVertices[nearestPoint[0] * 2 * 3 + 2]);
            this.ckgl_v[25].set(sc.rightSideVertices[nearestPoint[0] * 2 * 3 + 0 + 3], sc.rightSideVertices[nearestPoint[0] * 2 * 3 + 1 + 3], sc.rightSideVertices[nearestPoint[0] * 2 * 3 + 2 + 3]);
            this.ckgl_v[26].set(sc.rightSideVertices[next * 2 * 3 + 0], sc.rightSideVertices[next * 2 * 3 + 1], sc.rightSideVertices[next * 2 * 3 + 2]);
            this.ckgl_v[27].set(sc.rightSideVertices[next * 2 * 3 + 0 + 3], sc.rightSideVertices[next * 2 * 3 + 1 + 3], sc.rightSideVertices[next * 2 * 3 + 2 + 3]);
            this.ckgl_v[28].set(sc.rightSideVertices[nextnext * 2 * 3 + 0], sc.rightSideVertices[nextnext * 2 * 3 + 1], sc.rightSideVertices[nextnext * 2 * 3 + 2]);
            this.ckgl_v[29].set(sc.rightSideVertices[nextnext * 2 * 3 + 0 + 3], sc.rightSideVertices[nextnext * 2 * 3 + 1 + 3], sc.rightSideVertices[nextnext * 2 * 3 + 2 + 3]);
        }
        catch (Exception e) {
            System.out.println("Exception in shortcut ground checking at " + position);
            return 0.0f;
        }
        int d1 = 0;
        int d2 = 0;
        int d3 = 0;
        boolean found = false;
        for (int i = 0; i < this.ckgl_v.length - 2; ++i) {
            d1 = i;
            d2 = i + 1;
            d3 = i + 2;
            if (this.triangleCheck(this.ckgl_v[d1], this.ckgl_v[d2], this.ckgl_v[d3], this.ckgl_kartPos)) {
                found = true;
                break;
            }
            if (i == 7) {
                i = 10;
            }
            if (i != 17) continue;
            i = 20;
        }
        if (!found && nearestPoint[1] == 1) {
            int[] tmp = new int[2];
            tmp = this.checkNearestPoint(this.ckgl_kartPos);
            prev = tmp[0] == 0 ? this.m_Track.iPoints.length - 1 : tmp[0] - 1;
            prevprev = prev == 0 ? this.m_Track.iPoints.length - 1 : prev - 1;
            next = tmp[0] == this.m_Track.iPoints.length - 1 ? 0 : tmp[0] + 1;
            nextnext = next == this.m_Track.iPoints.length - 1 ? 0 : next + 1;
            this.ckgl_v[0].set(this.m_Track.roadVertices[prevprev * 2 * 3 + 0], this.m_Track.roadVertices[prevprev * 2 * 3 + 1], this.m_Track.roadVertices[prevprev * 2 * 3 + 2]);
            this.ckgl_v[1].set(this.m_Track.roadVertices[prevprev * 2 * 3 + 0 + 3], this.m_Track.roadVertices[prevprev * 2 * 3 + 1 + 3], this.m_Track.roadVertices[prevprev * 2 * 3 + 2 + 3]);
            this.ckgl_v[2].set(this.m_Track.roadVertices[prev * 2 * 3 + 0], this.m_Track.roadVertices[prev * 2 * 3 + 1], this.m_Track.roadVertices[prev * 2 * 3 + 2]);
            this.ckgl_v[3].set(this.m_Track.roadVertices[prev * 2 * 3 + 0 + 3], this.m_Track.roadVertices[prev * 2 * 3 + 1 + 3], this.m_Track.roadVertices[prev * 2 * 3 + 2 + 3]);
            this.ckgl_v[4].set(this.m_Track.roadVertices[tmp[0] * 2 * 3 + 0], this.m_Track.roadVertices[tmp[0] * 2 * 3 + 1], this.m_Track.roadVertices[tmp[0] * 2 * 3 + 2]);
            this.ckgl_v[5].set(this.m_Track.roadVertices[tmp[0] * 2 * 3 + 0 + 3], this.m_Track.roadVertices[tmp[0] * 2 * 3 + 1 + 3], this.m_Track.roadVertices[tmp[0] * 2 * 3 + 2 + 3]);
            this.ckgl_v[6].set(this.m_Track.roadVertices[next * 2 * 3 + 0], this.m_Track.roadVertices[next * 2 * 3 + 1], this.m_Track.roadVertices[next * 2 * 3 + 2]);
            this.ckgl_v[7].set(this.m_Track.roadVertices[next * 2 * 3 + 0 + 3], this.m_Track.roadVertices[next * 2 * 3 + 1 + 3], this.m_Track.roadVertices[next * 2 * 3 + 2 + 3]);
            this.ckgl_v[8].set(this.m_Track.roadVertices[nextnext * 2 * 3 + 0], this.m_Track.roadVertices[nextnext * 2 * 3 + 1], this.m_Track.roadVertices[nextnext * 2 * 3 + 2]);
            this.ckgl_v[9].set(this.m_Track.roadVertices[nextnext * 2 * 3 + 0 + 3], this.m_Track.roadVertices[nextnext * 2 * 3 + 1 + 3], this.m_Track.roadVertices[nextnext * 2 * 3 + 2 + 3]);
            this.ckgl_v[10].set(this.m_Track.leftSideVertices[prevprev * 2 * 3 + 0], this.m_Track.leftSideVertices[prevprev * 2 * 3 + 1], this.m_Track.leftSideVertices[prevprev * 2 * 3 + 2]);
            this.ckgl_v[11].set(this.m_Track.leftSideVertices[prevprev * 2 * 3 + 0 + 3], this.m_Track.leftSideVertices[prevprev * 2 * 3 + 1 + 3], this.m_Track.leftSideVertices[prevprev * 2 * 3 + 2 + 3]);
            this.ckgl_v[12].set(this.m_Track.leftSideVertices[prev * 2 * 3 + 0], this.m_Track.leftSideVertices[prev * 2 * 3 + 1], this.m_Track.leftSideVertices[prev * 2 * 3 + 2]);
            this.ckgl_v[13].set(this.m_Track.leftSideVertices[prev * 2 * 3 + 0 + 3], this.m_Track.leftSideVertices[prev * 2 * 3 + 1 + 3], this.m_Track.leftSideVertices[prev * 2 * 3 + 2 + 3]);
            this.ckgl_v[14].set(this.m_Track.leftSideVertices[tmp[0] * 2 * 3 + 0], this.m_Track.leftSideVertices[tmp[0] * 2 * 3 + 1], this.m_Track.leftSideVertices[tmp[0] * 2 * 3 + 2]);
            this.ckgl_v[15].set(this.m_Track.leftSideVertices[tmp[0] * 2 * 3 + 0 + 3], this.m_Track.leftSideVertices[tmp[0] * 2 * 3 + 1 + 3], this.m_Track.leftSideVertices[tmp[0] * 2 * 3 + 2 + 3]);
            this.ckgl_v[16].set(this.m_Track.leftSideVertices[next * 2 * 3 + 0], this.m_Track.leftSideVertices[next * 2 * 3 + 1], this.m_Track.leftSideVertices[next * 2 * 3 + 2]);
            this.ckgl_v[17].set(this.m_Track.leftSideVertices[next * 2 * 3 + 0 + 3], this.m_Track.leftSideVertices[next * 2 * 3 + 1 + 3], this.m_Track.leftSideVertices[next * 2 * 3 + 2 + 3]);
            this.ckgl_v[18].set(this.m_Track.leftSideVertices[nextnext * 2 * 3 + 0], this.m_Track.leftSideVertices[nextnext * 2 * 3 + 1], this.m_Track.leftSideVertices[nextnext * 2 * 3 + 2]);
            this.ckgl_v[19].set(this.m_Track.leftSideVertices[nextnext * 2 * 3 + 0 + 3], this.m_Track.leftSideVertices[nextnext * 2 * 3 + 1 + 3], this.m_Track.leftSideVertices[nextnext * 2 * 3 + 2 + 3]);
            this.ckgl_v[20].set(this.m_Track.rightSideVertices[prevprev * 2 * 3 + 0], this.m_Track.rightSideVertices[prevprev * 2 * 3 + 1], this.m_Track.rightSideVertices[prevprev * 2 * 3 + 2]);
            this.ckgl_v[21].set(this.m_Track.rightSideVertices[prevprev * 2 * 3 + 0 + 3], this.m_Track.rightSideVertices[prevprev * 2 * 3 + 1 + 3], this.m_Track.rightSideVertices[prevprev * 2 * 3 + 2 + 3]);
            this.ckgl_v[22].set(this.m_Track.rightSideVertices[prev * 2 * 3 + 0], this.m_Track.rightSideVertices[prev * 2 * 3 + 1], this.m_Track.rightSideVertices[prev * 2 * 3 + 2]);
            this.ckgl_v[23].set(this.m_Track.rightSideVertices[prev * 2 * 3 + 0 + 3], this.m_Track.rightSideVertices[prev * 2 * 3 + 1 + 3], this.m_Track.rightSideVertices[prev * 2 * 3 + 2 + 3]);
            this.ckgl_v[24].set(this.m_Track.rightSideVertices[tmp[0] * 2 * 3 + 0], this.m_Track.rightSideVertices[tmp[0] * 2 * 3 + 1], this.m_Track.rightSideVertices[tmp[0] * 2 * 3 + 2]);
            this.ckgl_v[25].set(this.m_Track.rightSideVertices[tmp[0] * 2 * 3 + 0 + 3], this.m_Track.rightSideVertices[tmp[0] * 2 * 3 + 1 + 3], this.m_Track.rightSideVertices[tmp[0] * 2 * 3 + 2 + 3]);
            this.ckgl_v[26].set(this.m_Track.rightSideVertices[next * 2 * 3 + 0], this.m_Track.rightSideVertices[next * 2 * 3 + 1], this.m_Track.rightSideVertices[next * 2 * 3 + 2]);
            this.ckgl_v[27].set(this.m_Track.rightSideVertices[next * 2 * 3 + 0 + 3], this.m_Track.rightSideVertices[next * 2 * 3 + 1 + 3], this.m_Track.rightSideVertices[next * 2 * 3 + 2 + 3]);
            this.ckgl_v[28].set(this.m_Track.rightSideVertices[nextnext * 2 * 3 + 0], this.m_Track.rightSideVertices[nextnext * 2 * 3 + 1], this.m_Track.rightSideVertices[nextnext * 2 * 3 + 2]);
            this.ckgl_v[29].set(this.m_Track.rightSideVertices[nextnext * 2 * 3 + 0 + 3], this.m_Track.rightSideVertices[nextnext * 2 * 3 + 1 + 3], this.m_Track.rightSideVertices[nextnext * 2 * 3 + 2 + 3]);
            for (int i = 0; i < this.ckgl_v.length - 2; ++i) {
                d1 = i;
                d2 = i + 1;
                d3 = i + 2;
                if (this.triangleCheck(this.ckgl_v[d1], this.ckgl_v[d2], this.ckgl_v[d3], this.ckgl_kartPos)) {
                    found = true;
                    break;
                }
                if (i == 7) {
                    i = 10;
                }
                if (i != 17) continue;
                i = 20;
            }
        }
        if (!found) {
            float dista1 = 1.0E7f;
            float dista2 = 1.0E7f;
            float dista3 = 1.0E7f;
            int a1 = 0;
            int a2 = 0;
            int a3 = 0;
            for (int i = this.ckgl_v.length / 3; i < 2 * (this.ckgl_v.length / 3); ++i) {
                float dista = Vector3D.sub(position, this.ckgl_v[i]).length();
                if (dista < dista1) {
                    a3 = a2;
                    a2 = a1;
                    a1 = i;
                    dista3 = dista2;
                    dista2 = dista1;
                    dista1 = dista;
                    continue;
                }
                if (dista < dista2) {
                    a3 = a2;
                    a2 = i;
                    dista3 = dista2;
                    dista2 = dista;
                    continue;
                }
                if (!(dista < dista3)) continue;
                a3 = i;
                dista3 = dista;
            }
            float distb1 = 1.0E7f;
            float distb2 = 1.0E7f;
            float distb3 = 1.0E7f;
            int b1 = 0;
            int b2 = 0;
            int b3 = 0;
            for (int i = 2 * (this.ckgl_v.length / 3); i < this.ckgl_v.length; ++i) {
                float dista = Vector3D.sub(position, this.ckgl_v[i]).length();
                if (dista < distb1) {
                    b3 = b2;
                    b2 = b1;
                    b1 = i;
                    distb3 = distb2;
                    distb2 = distb1;
                    distb1 = dista;
                    continue;
                }
                if (dista < distb2) {
                    b3 = b2;
                    b2 = i;
                    distb3 = distb2;
                    distb2 = dista;
                    continue;
                }
                if (!(dista < distb3)) continue;
                b3 = i;
                distb3 = dista;
            }
            if (dista1 > distb1) {
                d1 = b1;
                d2 = b2;
                d3 = b3;
            } else {
                d1 = a1;
                d2 = a2;
                d3 = a3;
            }
        }
        float X = this.ckgl_kartPos.getx();
        float Z = this.ckgl_kartPos.getz();
        float Y1 = this.ckgl_v[d1].gety();
        float Y2 = this.ckgl_v[d2].gety();
        float Y3 = this.ckgl_v[d3].gety();
        float X1 = this.ckgl_v[d1].getx();
        float X2 = this.ckgl_v[d2].getx();
        float X3 = this.ckgl_v[d3].getx();
        float Z1 = this.ckgl_v[d1].getz();
        float Z2 = this.ckgl_v[d2].getz();
        float Z3 = this.ckgl_v[d3].getz();
        float h = 0.0f;
        Vector3D planeNorm = null;
        if (slope != null) {
            planeNorm = new Vector3D();
        }
        if (Y1 == Y2 && Y2 == Y3) {
            h = Y1;
            if (slope != null) {
                planeNorm.sety(1.0f);
            }
        } else {
            boolean risen = false;
            float d = 10.0f;
            float D = X1 * Y2 * Z3 + X2 * Y3 * Z1 + X3 * Y1 * Z2 - X2 * Y1 * Z3 - X1 * Y3 * Z2 - X3 * Y2 * Z1;
            if (D == 0.0f) {
                D = X1 * (Y2 += 1.0f) * Z3 + X2 * (Y3 += 1.0f) * Z1 + X3 * (Y1 += 1.0f) * Z2 - X2 * Y1 * Z3 - X1 * Y3 * Z2 - X3 * Y2 * Z1;
                risen = true;
            }
            float a = -d / D * (Y2 * Z3 + Y3 * Z1 + Y1 * Z2 - Y1 * Z3 - Y3 * Z2 - Y2 * Z1);
            float b = -d / D * (X1 * Z3 + X2 * Z1 + X3 * Z2 - X2 * Z3 - X1 * Z2 - X3 * Z1);
            float c = -d / D * (X1 * Y2 + X2 * Y3 + X3 * Y1 - X2 * Y1 - X1 * Y3 - X3 * Y2);
            h = -(a * X + c * Z + d) / b;
            if (risen) {
                h -= 1.0f;
            }
            if (slope != null) {
                this.ckgl_P1.set(X1, Y1, Z1);
                this.ckgl_P2.set(X2, Y2, Z2);
                this.ckgl_P3.set(X3, Y3, Z3);
                planeNorm = Vector3D.crossProduct(Vector3D.sub(this.ckgl_P2, this.ckgl_P1), Vector3D.sub(this.ckgl_P3, this.ckgl_P1));
                planeNorm.normalize();
                if (planeNorm.gety() < 0.0f) {
                    planeNorm.reverse();
                }
            }
        }
        if (Float.isNaN(h) || Float.isInfinite(h)) {
            h = 0.0f;
            System.out.println("ERROR in check ground at " + position);
        }
        if (found) {
            if (slope != null) {
                slope.set(planeNorm);
            }
            return h;
        }
        return position.gety();
    }

    private int checkIfOnRoadside(Vector3D position, int[] nearestPoint) {
        int nextnext;
        int next;
        int prevprev;
        int prev;
        this.ckgl_kartPos.set(position);
        if (nearestPoint[1] == 0) {
            prev = nearestPoint[0] == 0 ? this.m_Track.iPoints.length - 1 : nearestPoint[0] - 1;
            prevprev = prev == 0 ? this.m_Track.iPoints.length - 1 : prev - 1;
            next = nearestPoint[0] == this.m_Track.iPoints.length - 1 ? 0 : nearestPoint[0] + 1;
            nextnext = next == this.m_Track.iPoints.length - 1 ? 0 : next + 1;
            this.ckgl_v[0].set(this.m_Track.leftSideVertices[prevprev * 2 * 3 + 0], this.m_Track.leftSideVertices[prevprev * 2 * 3 + 1], this.m_Track.leftSideVertices[prevprev * 2 * 3 + 2]);
            this.ckgl_v[1].set(this.m_Track.leftSideVertices[prevprev * 2 * 3 + 0 + 3], this.m_Track.leftSideVertices[prevprev * 2 * 3 + 1 + 3], this.m_Track.leftSideVertices[prevprev * 2 * 3 + 2 + 3]);
            this.ckgl_v[2].set(this.m_Track.leftSideVertices[prev * 2 * 3 + 0], this.m_Track.leftSideVertices[prev * 2 * 3 + 1], this.m_Track.leftSideVertices[prev * 2 * 3 + 2]);
            this.ckgl_v[3].set(this.m_Track.leftSideVertices[prev * 2 * 3 + 0 + 3], this.m_Track.leftSideVertices[prev * 2 * 3 + 1 + 3], this.m_Track.leftSideVertices[prev * 2 * 3 + 2 + 3]);
            this.ckgl_v[4].set(this.m_Track.leftSideVertices[nearestPoint[0] * 2 * 3 + 0], this.m_Track.leftSideVertices[nearestPoint[0] * 2 * 3 + 1], this.m_Track.leftSideVertices[nearestPoint[0] * 2 * 3 + 2]);
            this.ckgl_v[5].set(this.m_Track.leftSideVertices[nearestPoint[0] * 2 * 3 + 0 + 3], this.m_Track.leftSideVertices[nearestPoint[0] * 2 * 3 + 1 + 3], this.m_Track.leftSideVertices[nearestPoint[0] * 2 * 3 + 2 + 3]);
            this.ckgl_v[6].set(this.m_Track.leftSideVertices[next * 2 * 3 + 0], this.m_Track.leftSideVertices[next * 2 * 3 + 1], this.m_Track.leftSideVertices[next * 2 * 3 + 2]);
            this.ckgl_v[7].set(this.m_Track.leftSideVertices[next * 2 * 3 + 0 + 3], this.m_Track.leftSideVertices[next * 2 * 3 + 1 + 3], this.m_Track.leftSideVertices[next * 2 * 3 + 2 + 3]);
            this.ckgl_v[8].set(this.m_Track.leftSideVertices[nextnext * 2 * 3 + 0], this.m_Track.leftSideVertices[nextnext * 2 * 3 + 1], this.m_Track.leftSideVertices[nextnext * 2 * 3 + 2]);
            this.ckgl_v[9].set(this.m_Track.leftSideVertices[nextnext * 2 * 3 + 0 + 3], this.m_Track.leftSideVertices[nextnext * 2 * 3 + 1 + 3], this.m_Track.leftSideVertices[nextnext * 2 * 3 + 2 + 3]);
            this.ckgl_v[10].set(this.m_Track.rightSideVertices[prevprev * 2 * 3 + 0], this.m_Track.rightSideVertices[prevprev * 2 * 3 + 1], this.m_Track.rightSideVertices[prevprev * 2 * 3 + 2]);
            this.ckgl_v[11].set(this.m_Track.rightSideVertices[prevprev * 2 * 3 + 0 + 3], this.m_Track.rightSideVertices[prevprev * 2 * 3 + 1 + 3], this.m_Track.rightSideVertices[prevprev * 2 * 3 + 2 + 3]);
            this.ckgl_v[12].set(this.m_Track.rightSideVertices[prev * 2 * 3 + 0], this.m_Track.rightSideVertices[prev * 2 * 3 + 1], this.m_Track.rightSideVertices[prev * 2 * 3 + 2]);
            this.ckgl_v[13].set(this.m_Track.rightSideVertices[prev * 2 * 3 + 0 + 3], this.m_Track.rightSideVertices[prev * 2 * 3 + 1 + 3], this.m_Track.rightSideVertices[prev * 2 * 3 + 2 + 3]);
            this.ckgl_v[14].set(this.m_Track.rightSideVertices[nearestPoint[0] * 2 * 3 + 0], this.m_Track.rightSideVertices[nearestPoint[0] * 2 * 3 + 1], this.m_Track.rightSideVertices[nearestPoint[0] * 2 * 3 + 2]);
            this.ckgl_v[15].set(this.m_Track.rightSideVertices[nearestPoint[0] * 2 * 3 + 0 + 3], this.m_Track.rightSideVertices[nearestPoint[0] * 2 * 3 + 1 + 3], this.m_Track.rightSideVertices[nearestPoint[0] * 2 * 3 + 2 + 3]);
            this.ckgl_v[16].set(this.m_Track.rightSideVertices[next * 2 * 3 + 0], this.m_Track.rightSideVertices[next * 2 * 3 + 1], this.m_Track.rightSideVertices[next * 2 * 3 + 2]);
            this.ckgl_v[17].set(this.m_Track.rightSideVertices[next * 2 * 3 + 0 + 3], this.m_Track.rightSideVertices[next * 2 * 3 + 1 + 3], this.m_Track.rightSideVertices[next * 2 * 3 + 2 + 3]);
            this.ckgl_v[18].set(this.m_Track.rightSideVertices[nextnext * 2 * 3 + 0], this.m_Track.rightSideVertices[nextnext * 2 * 3 + 1], this.m_Track.rightSideVertices[nextnext * 2 * 3 + 2]);
            this.ckgl_v[19].set(this.m_Track.rightSideVertices[nextnext * 2 * 3 + 0 + 3], this.m_Track.rightSideVertices[nextnext * 2 * 3 + 1 + 3], this.m_Track.rightSideVertices[nextnext * 2 * 3 + 2 + 3]);
        } else {
            TrackShortcut sc = (TrackShortcut)this.m_Track.mShortcutsArray.elementAt(nearestPoint[1] - 1);
            prev = nearestPoint[0] == 0 ? 0 : nearestPoint[0] - 1;
            prevprev = prev == 0 ? 0 : prev - 1;
            next = nearestPoint[0] >= sc.iPoints.length - 1 ? sc.iPoints.length - 1 : nearestPoint[0] + 1;
            nextnext = next == sc.iPoints.length - 1 ? sc.iPoints.length - 1 : next + 1;
            this.ckgl_v[0].set(sc.leftSideVertices[prevprev * 2 * 3 + 0], sc.leftSideVertices[prevprev * 2 * 3 + 1], sc.leftSideVertices[prevprev * 2 * 3 + 2]);
            this.ckgl_v[1].set(sc.leftSideVertices[prevprev * 2 * 3 + 0 + 3], sc.leftSideVertices[prevprev * 2 * 3 + 1 + 3], sc.leftSideVertices[prevprev * 2 * 3 + 2 + 3]);
            this.ckgl_v[2].set(sc.leftSideVertices[prev * 2 * 3 + 0], sc.leftSideVertices[prev * 2 * 3 + 1], sc.leftSideVertices[prev * 2 * 3 + 2]);
            this.ckgl_v[3].set(sc.leftSideVertices[prev * 2 * 3 + 0 + 3], sc.leftSideVertices[prev * 2 * 3 + 1 + 3], sc.leftSideVertices[prev * 2 * 3 + 2 + 3]);
            this.ckgl_v[4].set(sc.leftSideVertices[nearestPoint[0] * 2 * 3 + 0], sc.leftSideVertices[nearestPoint[0] * 2 * 3 + 1], sc.leftSideVertices[nearestPoint[0] * 2 * 3 + 2]);
            this.ckgl_v[5].set(sc.leftSideVertices[nearestPoint[0] * 2 * 3 + 0 + 3], sc.leftSideVertices[nearestPoint[0] * 2 * 3 + 1 + 3], sc.leftSideVertices[nearestPoint[0] * 2 * 3 + 2 + 3]);
            this.ckgl_v[6].set(sc.leftSideVertices[next * 2 * 3 + 0], sc.leftSideVertices[next * 2 * 3 + 1], sc.leftSideVertices[next * 2 * 3 + 2]);
            this.ckgl_v[7].set(sc.leftSideVertices[next * 2 * 3 + 0 + 3], sc.leftSideVertices[next * 2 * 3 + 1 + 3], sc.leftSideVertices[next * 2 * 3 + 2 + 3]);
            this.ckgl_v[8].set(sc.leftSideVertices[nextnext * 2 * 3 + 0], sc.leftSideVertices[nextnext * 2 * 3 + 1], sc.leftSideVertices[nextnext * 2 * 3 + 2]);
            this.ckgl_v[9].set(sc.leftSideVertices[nextnext * 2 * 3 + 0 + 3], sc.leftSideVertices[nextnext * 2 * 3 + 1 + 3], sc.leftSideVertices[nextnext * 2 * 3 + 2 + 3]);
            this.ckgl_v[10].set(sc.rightSideVertices[prevprev * 2 * 3 + 0], sc.rightSideVertices[prevprev * 2 * 3 + 1], sc.rightSideVertices[prevprev * 2 * 3 + 2]);
            this.ckgl_v[11].set(sc.rightSideVertices[prevprev * 2 * 3 + 0 + 3], sc.rightSideVertices[prevprev * 2 * 3 + 1 + 3], sc.rightSideVertices[prevprev * 2 * 3 + 2 + 3]);
            this.ckgl_v[12].set(sc.rightSideVertices[prev * 2 * 3 + 0], sc.rightSideVertices[prev * 2 * 3 + 1], sc.rightSideVertices[prev * 2 * 3 + 2]);
            this.ckgl_v[13].set(sc.rightSideVertices[prev * 2 * 3 + 0 + 3], sc.rightSideVertices[prev * 2 * 3 + 1 + 3], sc.rightSideVertices[prev * 2 * 3 + 2 + 3]);
            this.ckgl_v[14].set(sc.rightSideVertices[nearestPoint[0] * 2 * 3 + 0], sc.rightSideVertices[nearestPoint[0] * 2 * 3 + 1], sc.rightSideVertices[nearestPoint[0] * 2 * 3 + 2]);
            this.ckgl_v[15].set(sc.rightSideVertices[nearestPoint[0] * 2 * 3 + 0 + 3], sc.rightSideVertices[nearestPoint[0] * 2 * 3 + 1 + 3], sc.rightSideVertices[nearestPoint[0] * 2 * 3 + 2 + 3]);
            this.ckgl_v[16].set(sc.rightSideVertices[next * 2 * 3 + 0], sc.rightSideVertices[next * 2 * 3 + 1], sc.rightSideVertices[next * 2 * 3 + 2]);
            this.ckgl_v[17].set(sc.rightSideVertices[next * 2 * 3 + 0 + 3], sc.rightSideVertices[next * 2 * 3 + 1 + 3], sc.rightSideVertices[next * 2 * 3 + 2 + 3]);
            this.ckgl_v[18].set(sc.rightSideVertices[nextnext * 2 * 3 + 0], sc.rightSideVertices[nextnext * 2 * 3 + 1], sc.rightSideVertices[nextnext * 2 * 3 + 2]);
            this.ckgl_v[19].set(sc.rightSideVertices[nextnext * 2 * 3 + 0 + 3], sc.rightSideVertices[nextnext * 2 * 3 + 1 + 3], sc.rightSideVertices[nextnext * 2 * 3 + 2 + 3]);
        }
        int d1 = 0;
        int d2 = 0;
        int d3 = 0;
        for (int i = 0; i < this.ckgl_v.length - 2 - 10; ++i) {
            d1 = i;
            d2 = i + 1;
            d3 = i + 2;
            if (this.triangleCheck(this.ckgl_v[d1], this.ckgl_v[d2], this.ckgl_v[d3], this.ckgl_kartPos)) {
                if (i < 10) {
                    return 0;
                }
                return 1;
            }
            if (i != 7) continue;
            i = 10;
        }
        return -1;
    }

    private boolean checkRoadsideTriangeNr(Vector3D position, int[] nearestPoint, int[] surrPoints) {
        int nextnext;
        int next;
        int prevprev;
        int prev;
        this.ckgl_kartPos.set(position);
        int ppprev = 0;
        if (nearestPoint[1] == 0) {
            prev = nearestPoint[0] == 0 ? this.m_Track.iPoints.length - 1 : nearestPoint[0] - 1;
            prevprev = prev == 0 ? this.m_Track.iPoints.length - 1 : prev - 1;
            ppprev = prevprev == 0 ? this.m_Track.iPoints.length - 1 : prevprev - 1;
            next = nearestPoint[0] == this.m_Track.iPoints.length - 1 ? 0 : nearestPoint[0] + 1;
            nextnext = next == this.m_Track.iPoints.length - 1 ? 0 : next + 1;
            int nnnext = nextnext == this.m_Track.iPoints.length - 1 ? 0 : nextnext + 1;
            this.ckgl_v[0].set(this.m_Track.leftSideVertices[ppprev * 2 * 3 + 0], this.m_Track.leftSideVertices[ppprev * 2 * 3 + 1], this.m_Track.leftSideVertices[ppprev * 2 * 3 + 2]);
            this.ckgl_v[1].set(this.m_Track.leftSideVertices[ppprev * 2 * 3 + 0 + 3], this.m_Track.leftSideVertices[ppprev * 2 * 3 + 1 + 3], this.m_Track.leftSideVertices[ppprev * 2 * 3 + 2 + 3]);
            this.ckgl_v[2].set(this.m_Track.leftSideVertices[prevprev * 2 * 3 + 0], this.m_Track.leftSideVertices[prevprev * 2 * 3 + 1], this.m_Track.leftSideVertices[prevprev * 2 * 3 + 2]);
            this.ckgl_v[3].set(this.m_Track.leftSideVertices[prevprev * 2 * 3 + 0 + 3], this.m_Track.leftSideVertices[prevprev * 2 * 3 + 1 + 3], this.m_Track.leftSideVertices[prevprev * 2 * 3 + 2 + 3]);
            this.ckgl_v[4].set(this.m_Track.leftSideVertices[prev * 2 * 3 + 0], this.m_Track.leftSideVertices[prev * 2 * 3 + 1], this.m_Track.leftSideVertices[prev * 2 * 3 + 2]);
            this.ckgl_v[5].set(this.m_Track.leftSideVertices[prev * 2 * 3 + 0 + 3], this.m_Track.leftSideVertices[prev * 2 * 3 + 1 + 3], this.m_Track.leftSideVertices[prev * 2 * 3 + 2 + 3]);
            this.ckgl_v[6].set(this.m_Track.leftSideVertices[nearestPoint[0] * 2 * 3 + 0], this.m_Track.leftSideVertices[nearestPoint[0] * 2 * 3 + 1], this.m_Track.leftSideVertices[nearestPoint[0] * 2 * 3 + 2]);
            this.ckgl_v[7].set(this.m_Track.leftSideVertices[nearestPoint[0] * 2 * 3 + 0 + 3], this.m_Track.leftSideVertices[nearestPoint[0] * 2 * 3 + 1 + 3], this.m_Track.leftSideVertices[nearestPoint[0] * 2 * 3 + 2 + 3]);
            this.ckgl_v[8].set(this.m_Track.leftSideVertices[next * 2 * 3 + 0], this.m_Track.leftSideVertices[next * 2 * 3 + 1], this.m_Track.leftSideVertices[next * 2 * 3 + 2]);
            this.ckgl_v[9].set(this.m_Track.leftSideVertices[next * 2 * 3 + 0 + 3], this.m_Track.leftSideVertices[next * 2 * 3 + 1 + 3], this.m_Track.leftSideVertices[next * 2 * 3 + 2 + 3]);
            this.ckgl_v[10].set(this.m_Track.leftSideVertices[nextnext * 2 * 3 + 0], this.m_Track.leftSideVertices[nextnext * 2 * 3 + 1], this.m_Track.leftSideVertices[nextnext * 2 * 3 + 2]);
            this.ckgl_v[11].set(this.m_Track.leftSideVertices[nextnext * 2 * 3 + 0 + 3], this.m_Track.leftSideVertices[nextnext * 2 * 3 + 1 + 3], this.m_Track.leftSideVertices[nextnext * 2 * 3 + 2 + 3]);
            this.ckgl_v[12].set(this.m_Track.leftSideVertices[nnnext * 2 * 3 + 0], this.m_Track.leftSideVertices[nnnext * 2 * 3 + 1], this.m_Track.leftSideVertices[nnnext * 2 * 3 + 2]);
            this.ckgl_v[13].set(this.m_Track.leftSideVertices[nnnext * 2 * 3 + 0 + 3], this.m_Track.leftSideVertices[nnnext * 2 * 3 + 1 + 3], this.m_Track.leftSideVertices[nnnext * 2 * 3 + 2 + 3]);
            this.ckgl_v[14].set(this.m_Track.rightSideVertices[ppprev * 2 * 3 + 0], this.m_Track.rightSideVertices[ppprev * 2 * 3 + 1], this.m_Track.rightSideVertices[ppprev * 2 * 3 + 2]);
            this.ckgl_v[15].set(this.m_Track.rightSideVertices[ppprev * 2 * 3 + 0 + 3], this.m_Track.rightSideVertices[ppprev * 2 * 3 + 1 + 3], this.m_Track.rightSideVertices[ppprev * 2 * 3 + 2 + 3]);
            this.ckgl_v[16].set(this.m_Track.rightSideVertices[prevprev * 2 * 3 + 0], this.m_Track.rightSideVertices[prevprev * 2 * 3 + 1], this.m_Track.rightSideVertices[prevprev * 2 * 3 + 2]);
            this.ckgl_v[17].set(this.m_Track.rightSideVertices[prevprev * 2 * 3 + 0 + 3], this.m_Track.rightSideVertices[prevprev * 2 * 3 + 1 + 3], this.m_Track.rightSideVertices[prevprev * 2 * 3 + 2 + 3]);
            this.ckgl_v[18].set(this.m_Track.rightSideVertices[prev * 2 * 3 + 0], this.m_Track.rightSideVertices[prev * 2 * 3 + 1], this.m_Track.rightSideVertices[prev * 2 * 3 + 2]);
            this.ckgl_v[19].set(this.m_Track.rightSideVertices[prev * 2 * 3 + 0 + 3], this.m_Track.rightSideVertices[prev * 2 * 3 + 1 + 3], this.m_Track.rightSideVertices[prev * 2 * 3 + 2 + 3]);
            this.ckgl_v[20].set(this.m_Track.rightSideVertices[nearestPoint[0] * 2 * 3 + 0], this.m_Track.rightSideVertices[nearestPoint[0] * 2 * 3 + 1], this.m_Track.rightSideVertices[nearestPoint[0] * 2 * 3 + 2]);
            this.ckgl_v[21].set(this.m_Track.rightSideVertices[nearestPoint[0] * 2 * 3 + 0 + 3], this.m_Track.rightSideVertices[nearestPoint[0] * 2 * 3 + 1 + 3], this.m_Track.rightSideVertices[nearestPoint[0] * 2 * 3 + 2 + 3]);
            this.ckgl_v[22].set(this.m_Track.rightSideVertices[next * 2 * 3 + 0], this.m_Track.rightSideVertices[next * 2 * 3 + 1], this.m_Track.rightSideVertices[next * 2 * 3 + 2]);
            this.ckgl_v[23].set(this.m_Track.rightSideVertices[next * 2 * 3 + 0 + 3], this.m_Track.rightSideVertices[next * 2 * 3 + 1 + 3], this.m_Track.rightSideVertices[next * 2 * 3 + 2 + 3]);
            this.ckgl_v[24].set(this.m_Track.rightSideVertices[nextnext * 2 * 3 + 0], this.m_Track.rightSideVertices[nextnext * 2 * 3 + 1], this.m_Track.rightSideVertices[nextnext * 2 * 3 + 2]);
            this.ckgl_v[25].set(this.m_Track.rightSideVertices[nextnext * 2 * 3 + 0 + 3], this.m_Track.rightSideVertices[nextnext * 2 * 3 + 1 + 3], this.m_Track.rightSideVertices[nextnext * 2 * 3 + 2 + 3]);
            this.ckgl_v[26].set(this.m_Track.rightSideVertices[nnnext * 2 * 3 + 0], this.m_Track.rightSideVertices[nnnext * 2 * 3 + 1], this.m_Track.rightSideVertices[nnnext * 2 * 3 + 2]);
            this.ckgl_v[27].set(this.m_Track.rightSideVertices[nnnext * 2 * 3 + 0 + 3], this.m_Track.rightSideVertices[nnnext * 2 * 3 + 1 + 3], this.m_Track.rightSideVertices[nnnext * 2 * 3 + 2 + 3]);
        } else {
            TrackShortcut sc = (TrackShortcut)this.m_Track.mShortcutsArray.elementAt(nearestPoint[1] - 1);
            prev = nearestPoint[0] == 0 ? 0 : nearestPoint[0] - 1;
            prevprev = prev == 0 ? 0 : prev - 1;
            next = nearestPoint[0] >= sc.iPoints.length - 1 ? sc.iPoints.length - 1 : nearestPoint[0] + 1;
            nextnext = next == sc.iPoints.length - 1 ? sc.iPoints.length - 1 : next + 1;
            this.ckgl_v[0].set(sc.leftSideVertices[prevprev * 2 * 3 + 0], sc.leftSideVertices[prevprev * 2 * 3 + 1], sc.leftSideVertices[prevprev * 2 * 3 + 2]);
            this.ckgl_v[1].set(sc.leftSideVertices[prevprev * 2 * 3 + 0 + 3], sc.leftSideVertices[prevprev * 2 * 3 + 1 + 3], sc.leftSideVertices[prevprev * 2 * 3 + 2 + 3]);
            this.ckgl_v[2].set(sc.leftSideVertices[prev * 2 * 3 + 0], sc.leftSideVertices[prev * 2 * 3 + 1], sc.leftSideVertices[prev * 2 * 3 + 2]);
            this.ckgl_v[3].set(sc.leftSideVertices[prev * 2 * 3 + 0 + 3], sc.leftSideVertices[prev * 2 * 3 + 1 + 3], sc.leftSideVertices[prev * 2 * 3 + 2 + 3]);
            this.ckgl_v[4].set(sc.leftSideVertices[nearestPoint[0] * 2 * 3 + 0], sc.leftSideVertices[nearestPoint[0] * 2 * 3 + 1], sc.leftSideVertices[nearestPoint[0] * 2 * 3 + 2]);
            this.ckgl_v[5].set(sc.leftSideVertices[nearestPoint[0] * 2 * 3 + 0 + 3], sc.leftSideVertices[nearestPoint[0] * 2 * 3 + 1 + 3], sc.leftSideVertices[nearestPoint[0] * 2 * 3 + 2 + 3]);
            this.ckgl_v[6].set(sc.leftSideVertices[next * 2 * 3 + 0], sc.leftSideVertices[next * 2 * 3 + 1], sc.leftSideVertices[next * 2 * 3 + 2]);
            this.ckgl_v[7].set(sc.leftSideVertices[next * 2 * 3 + 0 + 3], sc.leftSideVertices[next * 2 * 3 + 1 + 3], sc.leftSideVertices[next * 2 * 3 + 2 + 3]);
            this.ckgl_v[8].set(sc.leftSideVertices[nextnext * 2 * 3 + 0], sc.leftSideVertices[nextnext * 2 * 3 + 1], sc.leftSideVertices[nextnext * 2 * 3 + 2]);
            this.ckgl_v[9].set(sc.leftSideVertices[nextnext * 2 * 3 + 0 + 3], sc.leftSideVertices[nextnext * 2 * 3 + 1 + 3], sc.leftSideVertices[nextnext * 2 * 3 + 2 + 3]);
            this.ckgl_v[10].set(sc.rightSideVertices[prevprev * 2 * 3 + 0], sc.rightSideVertices[prevprev * 2 * 3 + 1], sc.rightSideVertices[prevprev * 2 * 3 + 2]);
            this.ckgl_v[11].set(sc.rightSideVertices[prevprev * 2 * 3 + 0 + 3], sc.rightSideVertices[prevprev * 2 * 3 + 1 + 3], sc.rightSideVertices[prevprev * 2 * 3 + 2 + 3]);
            this.ckgl_v[12].set(sc.rightSideVertices[prev * 2 * 3 + 0], sc.rightSideVertices[prev * 2 * 3 + 1], sc.rightSideVertices[prev * 2 * 3 + 2]);
            this.ckgl_v[13].set(sc.rightSideVertices[prev * 2 * 3 + 0 + 3], sc.rightSideVertices[prev * 2 * 3 + 1 + 3], sc.rightSideVertices[prev * 2 * 3 + 2 + 3]);
            this.ckgl_v[14].set(sc.rightSideVertices[nearestPoint[0] * 2 * 3 + 0], sc.rightSideVertices[nearestPoint[0] * 2 * 3 + 1], sc.rightSideVertices[nearestPoint[0] * 2 * 3 + 2]);
            this.ckgl_v[15].set(sc.rightSideVertices[nearestPoint[0] * 2 * 3 + 0 + 3], sc.rightSideVertices[nearestPoint[0] * 2 * 3 + 1 + 3], sc.rightSideVertices[nearestPoint[0] * 2 * 3 + 2 + 3]);
            this.ckgl_v[16].set(sc.rightSideVertices[next * 2 * 3 + 0], sc.rightSideVertices[next * 2 * 3 + 1], sc.rightSideVertices[next * 2 * 3 + 2]);
            this.ckgl_v[17].set(sc.rightSideVertices[next * 2 * 3 + 0 + 3], sc.rightSideVertices[next * 2 * 3 + 1 + 3], sc.rightSideVertices[next * 2 * 3 + 2 + 3]);
            this.ckgl_v[18].set(sc.rightSideVertices[nextnext * 2 * 3 + 0], sc.rightSideVertices[nextnext * 2 * 3 + 1], sc.rightSideVertices[nextnext * 2 * 3 + 2]);
            this.ckgl_v[19].set(sc.rightSideVertices[nextnext * 2 * 3 + 0 + 3], sc.rightSideVertices[nextnext * 2 * 3 + 1 + 3], sc.rightSideVertices[nextnext * 2 * 3 + 2 + 3]);
        }
        int d1 = 0;
        int d2 = 0;
        int d3 = 0;
        for (int i = 0; i < this.ckgl_v.length - 2 - 2; ++i) {
            d1 = i;
            d2 = i + 1;
            d3 = i + 2;
            if (this.triangleCheck(this.ckgl_v[d1], this.ckgl_v[d2], this.ckgl_v[d3], this.ckgl_kartPos)) {
                if (i >= 14) {
                    d1 -= 14;
                    d3 -= 14;
                }
                surrPoints[0] = ppprev + (d1 >> 1);
                surrPoints[1] = ppprev + (d3 >> 1);
                if (surrPoints[0] > this.m_Track.iPoints.length - 1) {
                    surrPoints[0] = surrPoints[0] - this.m_Track.iPoints.length;
                }
                if (surrPoints[1] > this.m_Track.iPoints.length - 1) {
                    surrPoints[1] = surrPoints[1] - this.m_Track.iPoints.length;
                }
                return true;
            }
            if (i != 11) continue;
            i = 14;
        }
        return false;
    }

    private boolean checkPhysicalCollisions(PhysicalEntity entity1, PhysicalEntity entity2) {
        if (!entity1.isSleeping() && !entity2.isSleeping()) {
            Vector3D dist = new Vector3D();
            Vector3D[] kbb1 = entity1.getBoundingBox();
            Vector3D[] kbb2 = entity2.getBoundingBox();
            dist.set(entity1.getPosition());
            dist.sub(entity2.getPosition());
            if (dist.quaterLength() < (float)(225 * Track.mScale * Track.mScale)) {
                float dot;
                Vector3D vN;
                Vector3D vP1;
                Vector3D vP2;
                int j;
                boolean kol;
                Vector3D vKP;
                int i;
                boolean collision = false;
                for (i = 0; i < 4 && !collision; ++i) {
                    vKP = new Vector3D(kbb1[i]);
                    kol = true;
                    for (j = 0; j < 4; ++j) {
                        vP2 = j == 3 ? kbb2[0] : kbb2[j + 1];
                        vN = Vector3D.normalize(Vector3D.crossProduct(Vector3D.sub(vP2, vP1 = kbb2[j]), new Vector3D(0.0f, 1.0f, 0.0f)));
                        dot = Vector3D.dotProduct(vN, Vector3D.sub(vKP, vP1));
                        if (!(dot <= 0.0f)) continue;
                        kol = false;
                    }
                    if (!kol) continue;
                    collision = true;
                }
                for (i = 0; i < 4 && !collision; ++i) {
                    vKP = new Vector3D(kbb2[i]);
                    kol = true;
                    for (j = 0; j < 4; ++j) {
                        vP2 = j == 3 ? kbb1[0] : kbb1[j + 1];
                        vN = Vector3D.normalize(Vector3D.crossProduct(Vector3D.sub(vP2, vP1 = kbb1[j]), new Vector3D(0.0f, 1.0f, 0.0f)));
                        dot = Vector3D.dotProduct(vN, Vector3D.sub(vKP, vP1));
                        if (!(dot <= 0.0f)) continue;
                        kol = false;
                    }
                    if (!kol) continue;
                    collision = true;
                    break;
                }
                if (collision) {
                    boolean victim1 = false;
                    boolean victim2 = false;
                    Vector3D d = new Vector3D();
                    d.set(kbb2[6]);
                    d.sub(kbb2[5]);
                    float a2 = d.FBdir(dist);
                    d.set(kbb1[6]);
                    d.sub(kbb1[5]);
                    float a1 = d.FBdir(Vector3D.reverse(dist));
                    if (a1 > a2) {
                        victim2 = true;
                    } else {
                        victim1 = true;
                    }
                    if (!entity1.isEngineActive()) {
                        victim2 = false;
                    }
                    if (!entity2.isEngineActive()) {
                        victim1 = false;
                    }
                    if (entity1.getType() == 0) {
                        Kart e1 = (Kart)entity1;
                        if (entity2.getType() == 0) {
                            Kart e2 = (Kart)entity2;
                            e1.triggerObjectCollision(dist, e2.getVelocity(), e1.getStaticCollisionModifier(), e2.getStaticCollisionModifier(), e1.getVariableCollisionModifier(), e2.getVariableCollisionModifier(), e2.getMass(), victim1, e2.getScarred(), e2.getInvincibility(), e2.getAutopilot(), e2.getKatamari());
                            e2.triggerObjectCollision(Vector3D.reverse(dist), e1.getVelocity(), e1.getStaticCollisionModifier(), e2.getStaticCollisionModifier(), e1.getVariableCollisionModifier(), e2.getVariableCollisionModifier(), e1.getMass(), victim2, e1.getScarred(), e1.getInvincibility(), e1.getAutopilot(), e1.getKatamari());
                        }
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private void checkNearestEnemyPosition(OnRoadElement element, Kart kart, int owner) {
        if (owner != element.owner && Vector3D.sub(kart.getPosition(), element.getPosition()).isFdir(element.vDirection)) {
            if (!element.vectSet) {
                element.attackPos = kart.getPosition();
                element.attackDist = Vector3D.sub(kart.getPosition(), element.getPosition());
                element.vectSet = true;
                return;
            }
            Vector3D dist = Vector3D.sub(kart.getPosition(), element.getPosition());
            if (dist.length() < element.attackDist.length()) {
                element.attackPos = kart.getPosition();
                element.attackDist.set(dist);
            }
        }
    }

    private void checkKartItemCollisions(Kart kart, OnRoadElement element) {
        if (Math.abs(element.nearestPoint[0] - kart.nearestPoint[0]) <= 1 & !kart.isScarred && element.active) {
            Vector3D dist = Vector3D.sub(kart.getPosition(), element.getPosition());
            Vector3D oldPos = Vector3D.sub(kart.getPosition(), kart.getOldPosition());
            oldPos.scalarDiv(2.0f);
            oldPos = Vector3D.sub(kart.getPosition(), oldPos);
            Vector3D oldDist = Vector3D.sub(element.getPosition(), oldPos);
            if ((dist.quaterLength() < (float)this.mItemCollisionRadius || oldDist.quaterLength() < (float)this.mItemCollisionRadius) && element.active) {
                if (kart.collectibleCounter < Kart.MAX_COLLECTIBLES) {
                    element.itemDeActivate();
                    element.setShown();
                    kart.gatherCollectible();
                    if (kart.isPlayer) {
                        SoundManager.playSfx(15);
                    }
                } else {
                    element.setShown();
                }
            }
        }
    }

    private void checkTrackHelpersInteractions(Kart kart, TrackHelper helper) {
        if (Math.abs(kart.nearestPoint[0] - helper.nearestPoint[0]) <= 1 && !kart.isSleeping() && !helper.isSleeping()) {
            Vector3D dist = Vector3D.sub(kart.getPosition(), helper.getPosition());
            Vector3D oldDist = Vector3D.sub(Vector3D.add(kart.getPosition(), kart.getOldPosition()), helper.getPosition());
            if ((dist.quaterLength() < helper.getCollisionRadius() || oldDist.quaterLength() < helper.getCollisionRadius()) && kart.getAltitude() < Stats.TRACK_HELPERS_HEIGHT) {
                switch (helper.getType()) {
                    case 1: {
                        if (helper.nearestPoint[1] == 0) {
                            this.wayDir.set(this.m_Track.iPoints[(helper.nearestPoint[0] + 1) % this.m_Track.iPoints.length]);
                            this.wayDir.sub(this.m_Track.iPoints[helper.nearestPoint[0]]);
                        } else {
                            TrackShortcut sc = (TrackShortcut)this.m_Track.mShortcutsArray.elementAt(helper.nearestPoint[1] - 1);
                            this.wayDir.set(sc.iPoints[(helper.nearestPoint[0] + 1) % sc.iPoints.length]);
                            this.wayDir.sub(sc.iPoints[helper.nearestPoint[0]]);
                        }
                        this.kartDir.set(kart.getBoundingBox()[6]);
                        this.kartDir.sub(kart.getBoundingBox()[5]);
                        if (!this.kartDir.isFdir(this.wayDir) || kart.isHandbrakeActive()) break;
                        kart.startBoost(20.0f);
                        break;
                    }
                    case 2: {
                        if (helper.nearestPoint[1] == 0) {
                            this.wayDir.set(this.m_Track.iPoints[(helper.nearestPoint[0] + 1) % this.m_Track.iPoints.length]);
                            this.wayDir.sub(this.m_Track.iPoints[helper.nearestPoint[0]]);
                        } else {
                            TrackShortcut sc = (TrackShortcut)this.m_Track.mShortcutsArray.elementAt(helper.nearestPoint[1] - 1);
                            this.wayDir.set(sc.iPoints[(helper.nearestPoint[0] + 1) % sc.iPoints.length]);
                            this.wayDir.sub(sc.iPoints[helper.nearestPoint[0]]);
                        }
                        this.kartDir.set(kart.getBoundingBox()[6]);
                        this.kartDir.sub(kart.getBoundingBox()[5]);
                        if (this.kartDir.isFdir(this.wayDir) && kart.getForwardBackward() == 1) {
                            kart.initiateJump();
                            break;
                        }
                        kart.triggerCollision(Vector3D.normalize(dist));
                        break;
                    }
                    case 0: {
                        kart.startSlowdown(15.0f, false);
                    }
                }
                helper.used();
            }
        }
    }

    private void checkKartRespawnableItemCollisions(Kart kart, OnRoadElement element) {
        if (Math.abs(element.nearestPoint[0] - kart.nearestPoint[0]) <= 1 & !kart.isScarred) {
            Vector3D dist = Vector3D.sub(kart.getPosition(), element.getPosition());
            Vector3D oldPos = Vector3D.sub(kart.getPosition(), kart.getOldPosition());
            oldPos.scalarDiv(2.0f);
            oldPos = Vector3D.sub(kart.getPosition(), oldPos);
            Vector3D oldDist = Vector3D.sub(element.getPosition(), oldPos);
            if ((dist.quaterLength() < (float)this.mItemCollisionRadius || oldDist.quaterLength() < (float)this.mItemCollisionRadius) && element.active) {
                element.itemDeActivate();
                element.setShown();
                element.setRespawnTime(10);
                if (kart.isPlayer) {
                    SoundManager.playSfx(20);
                    SoundManager.vibration(250);
                }
                if (GameLogic.gameMode == 1) {
                    int random = this.generator.nextInt(MissionManager.itemProbability[5]) + 1;
                    for (int i = 0; i < MissionManager.itemProbability.length; ++i) {
                        if (random > MissionManager.itemProbability[i]) continue;
                        kart.setItem(i + 1, 0);
                        break;
                    }
                } else if (element.random) {
                    int random = this.generator.nextInt(100);
                    int sum = 0;
                    if (GameLogic.gameMode == 3) {
                        for (int i = 0; i < Stats.randomItemProbability[GameLogic.gameDifficulty][6].length; ++i) {
                            if (random > (sum += Stats.randomItemProbability[GameLogic.gameDifficulty][6][i])) continue;
                            kart.setItem(i + 1, 0);
                            break;
                        }
                    } else {
                        for (int i = 0; i < Stats.randomItemProbability[GameLogic.gameDifficulty][kart.kartPosition].length; ++i) {
                            if (random > (sum += Stats.randomItemProbability[GameLogic.gameDifficulty][kart.kartPosition][i])) continue;
                            kart.setItem(i + 1, 0);
                            break;
                        }
                    }
                } else if (element.boost) {
                    kart.setItem(1, 1);
                } else if (element.atack) {
                    kart.setItem(2, 1);
                } else if (element.trap) {
                    kart.setItem(3, 3);
                } else if (element.fatality) {
                    kart.setItem(4, 1);
                } else if (element.invincibility) {
                    kart.setItem(5, 1);
                } else if (element.autopilot) {
                    kart.setItem(6, 1);
                }
            }
        }
    }

    private void checkKartSpawnableItemCollisions(Kart kart, OnRoadElement element) {
        if (Math.abs(element.nearestPoint[0] - kart.nearestPoint[0]) <= 1) {
            Vector3D dist = Vector3D.sub(kart.getPosition(), element.getPosition());
            Vector3D oldPos = Vector3D.sub(kart.getPosition(), kart.getOldPosition());
            oldPos.scalarDiv(2.0f);
            oldPos = Vector3D.sub(kart.getPosition(), oldPos);
            Vector3D oldDist = Vector3D.sub(element.getPosition(), oldPos);
            if (dist.quaterLength() < (float)this.mItemCollisionRadius || oldDist.quaterLength() < (float)this.mItemCollisionRadius) {
                element.itemDeActivate();
                if (element.trap && !kart.isInvincible) {
                    kart.startEffect(0, 25);
                    if (kart.isPlayer) {
                        SoundManager.playSfx(8);
                        SoundManager.vibration(450);
                    }
                }
            }
        }
    }

    private void checkKartDynamicItemCollisions(Kart kart, OnRoadElement dynamicItems, int kartNum) {
        if (Math.abs(dynamicItems.nearestPoint[0] - kart.nearestPoint[0]) <= 1 && dynamicItems.active && kartNum != dynamicItems.owner) {
            Vector3D distance = Vector3D.sub(kart.getPosition(), dynamicItems.getPosition());
            Vector3D oldPos = Vector3D.sub(kart.getPosition(), kart.getOldPosition());
            oldPos.scalarDiv(2.0f);
            oldPos = Vector3D.sub(kart.getPosition(), oldPos);
            Vector3D oldDist = Vector3D.sub(dynamicItems.getPosition(), oldPos);
            if ((distance.quaterLength() < (float)(this.mItemCollisionRadius * 10) || oldDist.quaterLength() < (float)(this.mItemCollisionRadius * 10)) && dynamicItems.atack) {
                if (!kart.isInvincible) {
                    kart.startEffect(0, 20);
                    if (kart.isPlayer) {
                        SoundManager.playSfx(8);
                        SoundManager.vibration(2000);
                    }
                }
                dynamicItems.triggerKart();
            }
        }
    }

    private void checkKartOffroadCollisions(Kart kart, OffroadElement item, float frame) {
        if (!(kart.isSleeping() || kart.isInvincible || kart.isAutopilot)) {
            Vector3D dist = Vector3D.sub(item.getPosition(), kart.getPosition());
            Vector3D oldPos = Vector3D.sub(kart.getPosition(), kart.getOldPosition());
            oldPos.scalarDiv(2.0f);
            oldPos = Vector3D.sub(kart.getPosition(), oldPos);
            Vector3D oldDist = Vector3D.sub(item.getPosition(), oldPos);
            float mult = Math.max(1.0f, frame);
            float collisionDist = 0.0f;
            collisionDist = item.isTree ? item.getTreeCollisionQuaterDist() : item.getCollisionQuaterDist();
            if (dist.quaterLength() < collisionDist * mult) {
                if (kart.isPlayer) {
                    if (!vibrateCamera) {
                        vibrateCamera = true;
                        cameraFrameCounter = kart.actualSpeed.length();
                    }
                    if (!gForceCamera) {
                        gForceCameraVector.set(this.m_Karts[0].actualSpeed);
                        gForceCamera = true;
                        gForceCameraFrameCounter = 4.0f;
                    }
                    SoundManager.playSfx(8);
                }
                kart.triggerCollision(Vector3D.normalize(Vector3D.reverse(dist)));
            } else if (oldDist.quaterLength() < collisionDist * mult) {
                if (kart.isPlayer) {
                    if (!vibrateCamera) {
                        vibrateCamera = true;
                        cameraFrameCounter = kart.actualSpeed.length();
                    }
                    if (!gForceCamera) {
                        gForceCameraVector.set(this.m_Karts[0].actualSpeed);
                        gForceCamera = true;
                        gForceCameraFrameCounter = 4.0f;
                    }
                    SoundManager.playSfx(8);
                }
                kart.triggerCollision(Vector3D.normalize(Vector3D.reverse(oldDist)));
            }
        }
    }

    private void checkBridgeCollisions(Kart kart, TrackHelper bridge) {
        if (!kart.isSleeping()) {
            Vector3D vect1 = new Vector3D();
            Vector3D vect2 = new Vector3D();
            if (kart.side > 0 && (this.triangleCheck(this.m_pillars[bridge.num * 8 + 0].vPosition, this.m_pillars[bridge.num * 8 + 2].vPosition, this.m_pillars[bridge.num * 8 + 3].vPosition, kart.vPosition) || this.triangleCheck(this.m_pillars[bridge.num * 8 + 4].vPosition, this.m_pillars[bridge.num * 8 + 6].vPosition, this.m_pillars[bridge.num * 8 + 7].vPosition, kart.vPosition) || this.triangleCheck(this.m_pillars[bridge.num * 8 + 0].vPosition, this.m_pillars[bridge.num * 8 + 1].vPosition, this.m_pillars[bridge.num * 8 + 3].vPosition, kart.vPosition) || this.triangleCheck(this.m_pillars[bridge.num * 8 + 4].vPosition, this.m_pillars[bridge.num * 8 + 5].vPosition, this.m_pillars[bridge.num * 8 + 7].vPosition, kart.vPosition))) {
                if (kart.side == 1) {
                    vect1 = Vector3D.normalize(Vector3D.crossProduct(Vector3D.sub(this.m_pillars[bridge.num * 8 + 1].vPosition, this.m_pillars[bridge.num * 8 + 0].vPosition), new Vector3D(0.0f, 1.0f, 0.0f)));
                    kart.triggerCollision(vect1);
                } else if (kart.side == 2) {
                    vect2 = Vector3D.normalize(Vector3D.crossProduct(Vector3D.sub(this.m_pillars[bridge.num * 8 + 2].vPosition, this.m_pillars[bridge.num * 8 + 0].vPosition), new Vector3D(0.0f, 1.0f, 0.0f)));
                    kart.triggerCollision(vect2);
                } else if (kart.side == 3) {
                    vect2 = Vector3D.normalize(Vector3D.crossProduct(Vector3D.sub(this.m_pillars[bridge.num * 8 + 0].vPosition, this.m_pillars[bridge.num * 8 + 2].vPosition), new Vector3D(0.0f, 1.0f, 0.0f)));
                    kart.triggerCollision(vect2);
                } else if (kart.side == 4) {
                    vect1 = Vector3D.normalize(Vector3D.crossProduct(Vector3D.sub(this.m_pillars[bridge.num * 8 + 0].vPosition, this.m_pillars[bridge.num * 8 + 1].vPosition), new Vector3D(0.0f, 1.0f, 0.0f)));
                    kart.triggerCollision(vect1);
                }
                if (kart.isPlayer) {
                    if (!vibrateCamera) {
                        vibrateCamera = true;
                        cameraFrameCounter = kart.actualSpeed.length();
                    }
                    if (!gForceCamera) {
                        gForceCameraVector.set(this.m_Karts[0].actualSpeed);
                        gForceCamera = true;
                        gForceCameraFrameCounter = 8.0f;
                    }
                    SoundManager.playSfx(8);
                }
                kart.isBridgeCollision = true;
                return;
            }
            if (Math.abs(bridge.nearestPoint[0] - kart.nearestPoint[0]) <= 5) {
                if (this.triangleCheck(this.m_pillars[bridge.num * 8 + 0].vPosition, this.m_pillars[bridge.num * 8 + 2].vPosition, this.m_pillars[bridge.num * 8 + 3].vPosition, kart.vPosition) || this.triangleCheck(this.m_pillars[bridge.num * 8 + 4].vPosition, this.m_pillars[bridge.num * 8 + 6].vPosition, this.m_pillars[bridge.num * 8 + 7].vPosition, kart.vPosition)) {
                    if (this.triangleCheck(this.m_pillars[bridge.num * 8 + 2].vPosition, this.m_pillars[bridge.num * 8 + 3].vPosition, this.m_pillars[bridge.num * 8 + 1].vPosition, kart.vPosition) || this.triangleCheck(this.m_pillars[bridge.num * 8 + 6].vPosition, this.m_pillars[bridge.num * 8 + 7].vPosition, this.m_pillars[bridge.num * 8 + 5].vPosition, kart.vPosition)) {
                        vect1 = Vector3D.normalize(Vector3D.crossProduct(Vector3D.sub(this.m_pillars[bridge.num * 8 + 1].vPosition, this.m_pillars[bridge.num * 8 + 0].vPosition), new Vector3D(0.0f, 1.0f, 0.0f)));
                        kart.triggerCollision(vect1);
                        if (kart.isPlayer) {
                            if (!vibrateCamera) {
                                vibrateCamera = true;
                                cameraFrameCounter = kart.actualSpeed.length();
                            }
                            if (!gForceCamera) {
                                gForceCameraVector.set(this.m_Karts[0].actualSpeed);
                                gForceCamera = true;
                                gForceCameraFrameCounter = 8.0f;
                            }
                            SoundManager.playSfx(8);
                        }
                        kart.side = 1;
                        kart.isBridgeCollision = true;
                        return;
                    }
                    vect2 = Vector3D.normalize(Vector3D.crossProduct(Vector3D.sub(this.m_pillars[bridge.num * 8 + 2].vPosition, this.m_pillars[bridge.num * 8 + 0].vPosition), new Vector3D(0.0f, 1.0f, 0.0f)));
                    kart.triggerCollision(vect2);
                    if (kart.isPlayer) {
                        if (!vibrateCamera) {
                            vibrateCamera = true;
                            cameraFrameCounter = kart.actualSpeed.length();
                        }
                        if (!gForceCamera) {
                            gForceCameraVector.set(this.m_Karts[0].actualSpeed);
                            gForceCamera = true;
                            gForceCameraFrameCounter = 8.0f;
                        }
                        SoundManager.playSfx(8);
                    }
                    kart.side = 2;
                    kart.isBridgeCollision = true;
                    return;
                }
                if (this.triangleCheck(this.m_pillars[bridge.num * 8 + 0].vPosition, this.m_pillars[bridge.num * 8 + 1].vPosition, this.m_pillars[bridge.num * 8 + 3].vPosition, kart.vPosition) || this.triangleCheck(this.m_pillars[bridge.num * 8 + 4].vPosition, this.m_pillars[bridge.num * 8 + 5].vPosition, this.m_pillars[bridge.num * 8 + 7].vPosition, kart.vPosition)) {
                    if (this.triangleCheck(this.m_pillars[bridge.num * 8 + 2].vPosition, this.m_pillars[bridge.num * 8 + 3].vPosition, this.m_pillars[bridge.num * 8 + 1].vPosition, kart.vPosition) || this.triangleCheck(this.m_pillars[bridge.num * 8 + 6].vPosition, this.m_pillars[bridge.num * 8 + 7].vPosition, this.m_pillars[bridge.num * 8 + 5].vPosition, kart.vPosition)) {
                        vect2 = Vector3D.normalize(Vector3D.crossProduct(Vector3D.sub(this.m_pillars[bridge.num * 8 + 0].vPosition, this.m_pillars[bridge.num * 8 + 2].vPosition), new Vector3D(0.0f, 1.0f, 0.0f)));
                        kart.triggerCollision(vect2);
                        if (kart.isPlayer) {
                            if (!vibrateCamera) {
                                vibrateCamera = true;
                                cameraFrameCounter = kart.actualSpeed.length();
                            }
                            if (!gForceCamera) {
                                gForceCameraVector.set(this.m_Karts[0].actualSpeed);
                                gForceCamera = true;
                                gForceCameraFrameCounter = 8.0f;
                            }
                            SoundManager.playSfx(8);
                        }
                        kart.side = 3;
                        kart.isBridgeCollision = true;
                        return;
                    }
                    vect1 = Vector3D.normalize(Vector3D.crossProduct(Vector3D.sub(this.m_pillars[bridge.num * 8 + 0].vPosition, this.m_pillars[bridge.num * 8 + 1].vPosition), new Vector3D(0.0f, 1.0f, 0.0f)));
                    kart.triggerCollision(vect1);
                    if (kart.isPlayer) {
                        if (!vibrateCamera) {
                            vibrateCamera = true;
                            cameraFrameCounter = kart.actualSpeed.length();
                        }
                        if (!gForceCamera) {
                            gForceCameraVector.set(this.m_Karts[0].actualSpeed);
                            gForceCamera = true;
                            gForceCameraFrameCounter = 8.0f;
                        }
                        SoundManager.playSfx(8);
                    }
                    kart.side = 4;
                    kart.isBridgeCollision = true;
                    return;
                }
            }
        }
    }

    private void checkActiveItemCollisions(OnRoadElement dynamicItems, int[] nearestPoint) {
        Vector3D itemPos = new Vector3D(dynamicItems.getPosition());
        Vector3D dist = new Vector3D();
        float ccDist = 20.0f;
        if (nearestPoint[1] == 0) {
            int p1 = nearestPoint[0] - 1;
            if (p1 < 0) {
                p1 += this.m_Track.iPoints.length - 1;
            }
            dist.set(itemPos);
            dist.sub(this.m_Track.iPoints[p1]);
            float len1 = dist.length();
            int p2 = nearestPoint[0] + 1;
            if (p2 > this.m_Track.iPoints.length - 1) {
                p2 -= this.m_Track.iPoints.length - 1;
            }
            dist.set(itemPos);
            dist.sub(this.m_Track.iPoints[p2]);
            float len2 = dist.length();
            if (len1 > len2) {
                p1 = nearestPoint[0];
            } else {
                p2 = nearestPoint[0];
            }
            Vector3D vP1 = new Vector3D(this.m_Track.leftSideVertices[p1 * 2 * 3 + 0], this.m_Track.leftSideVertices[p1 * 2 * 3 + 1], this.m_Track.leftSideVertices[p1 * 2 * 3 + 2]);
            Vector3D vP2 = new Vector3D(this.m_Track.leftSideVertices[p2 * 2 * 3 + 0], this.m_Track.leftSideVertices[p2 * 2 * 3 + 1], this.m_Track.leftSideVertices[p2 * 2 * 3 + 2]);
            Vector3D vN = Vector3D.normalize(Vector3D.crossProduct(Vector3D.sub(vP2, vP1), new Vector3D(0.0f, 1.0f, 0.0f)));
            float dot = Vector3D.dotProduct(vN, Vector3D.sub(itemPos, vP1));
            Vector3D vD = Vector3D.sub(this.m_Track.iPoints[p1], itemPos);
            if (dot < ccDist) {
                Vector3D r = dynamicItems.getDirection();
                dynamicItems.vPosition.sub(r);
                float n = 2.0f * Vector3D.dotProduct(vN, r);
                vN.scalarMul(n);
                r.sub(vN);
                dynamicItems.updateDirection(r);
                return;
            }
            vP1 = new Vector3D(this.m_Track.rightSideVertices[p1 * 2 * 3 + 0 + 3], this.m_Track.rightSideVertices[p1 * 2 * 3 + 1 + 3], this.m_Track.rightSideVertices[p1 * 2 * 3 + 2 + 3]);
            vP2 = new Vector3D(this.m_Track.rightSideVertices[p2 * 2 * 3 + 0 + 3], this.m_Track.rightSideVertices[p2 * 2 * 3 + 1 + 3], this.m_Track.rightSideVertices[p2 * 2 * 3 + 2 + 3]);
            vN = Vector3D.normalize(Vector3D.crossProduct(Vector3D.sub(vP1, vP2), new Vector3D(0.0f, 1.0f, 0.0f)));
            dot = Vector3D.dotProduct(vN, Vector3D.sub(itemPos, vP1));
            vD = Vector3D.sub(this.m_Track.iPoints[p1], itemPos);
            if (dot < ccDist) {
                Vector3D r = dynamicItems.getDirection();
                dynamicItems.vPosition.sub(r);
                float n = 2.0f * Vector3D.dotProduct(vN, r);
                vN.scalarMul(n);
                r.sub(vN);
                dynamicItems.updateDirection(r);
                return;
            }
        } else {
            int p1;
            float minLen = 1.0E9f;
            for (int j = 0; j < this.m_Track.mShortcutsArray.size(); ++j) {
                TrackShortcut sc = (TrackShortcut)this.m_Track.mShortcutsArray.elementAt(j);
                for (int i = 0; i < sc.iPoints.length - 1; ++i) {
                    this.cnpDist.set(itemPos);
                    this.cnpDist.sub(sc.iPoints[i]);
                    float len = this.cnpDist.quaterLength();
                    if (!(len < minLen)) continue;
                    minLen = len;
                    nearestPoint[0] = i;
                    nearestPoint[1] = j + 1;
                }
            }
            TrackShortcut sc = (TrackShortcut)this.m_Track.mShortcutsArray.elementAt(nearestPoint[1] - 1);
            if (nearestPoint[0] == 0) {
                nearestPoint[0] = 1;
            }
            if (nearestPoint[0] >= sc.iPoints.length - 1) {
                nearestPoint[0] = sc.iPoints.length - 2;
            }
            if ((p1 = nearestPoint[0] - 1) < 0) {
                p1 = 0;
            } else if (p1 > sc.iPoints.length - 1) {
                p1 = sc.iPoints.length - 1;
            }
            dist.set(itemPos);
            dist.sub(sc.iPoints[p1]);
            float len1 = dist.length();
            int p2 = nearestPoint[0] + 1;
            if (p2 > sc.iPoints.length - 1) {
                p2 = sc.iPoints.length - 1;
            } else if (p2 < 0) {
                p2 += sc.iPoints.length - 1;
            }
            dist.set(itemPos);
            dist.sub(sc.iPoints[p2]);
            float len2 = dist.length();
            if (len1 > len2) {
                p1 = nearestPoint[0];
            } else {
                p2 = nearestPoint[0];
            }
            Vector3D vP1 = new Vector3D(sc.leftSideVertices[p1 * 2 * 3 + 0], sc.leftSideVertices[p1 * 2 * 3 + 1], sc.leftSideVertices[p1 * 2 * 3 + 2]);
            Vector3D vP2 = new Vector3D(sc.leftSideVertices[p2 * 2 * 3 + 0], sc.leftSideVertices[p2 * 2 * 3 + 1], sc.leftSideVertices[p2 * 2 * 3 + 2]);
            Vector3D vN = Vector3D.normalize(Vector3D.crossProduct(Vector3D.sub(vP2, vP1), new Vector3D(0.0f, 1.0f, 0.0f)));
            float dot = Vector3D.dotProduct(vN, Vector3D.sub(itemPos, vP1));
            Vector3D vD = Vector3D.sub(sc.iPoints[p1], itemPos);
            if (dot < ccDist) {
                Vector3D r = dynamicItems.getDirection();
                dynamicItems.vPosition.sub(r);
                float n = 2.0f * Vector3D.dotProduct(vN, r);
                vN.scalarMul(n);
                r.sub(vN);
                dynamicItems.updateDirection(r);
                return;
            }
            vP1 = new Vector3D(sc.rightSideVertices[p1 * 2 * 3 + 0 + 3], sc.rightSideVertices[p1 * 2 * 3 + 1 + 3], sc.rightSideVertices[p1 * 2 * 3 + 2 + 3]);
            vP2 = new Vector3D(sc.rightSideVertices[p2 * 2 * 3 + 0 + 3], sc.rightSideVertices[p2 * 2 * 3 + 1 + 3], sc.rightSideVertices[p2 * 2 * 3 + 2 + 3]);
            vN = Vector3D.normalize(Vector3D.crossProduct(Vector3D.sub(vP1, vP2), new Vector3D(0.0f, 1.0f, 0.0f)));
            dot = Vector3D.dotProduct(vN, Vector3D.sub(itemPos, vP1));
            vD = Vector3D.sub(sc.iPoints[p1], itemPos);
            if (dot < ccDist) {
                Vector3D r = dynamicItems.getDirection();
                dynamicItems.vPosition.sub(r);
                float n = 2.0f * Vector3D.dotProduct(vN, r);
                vN.scalarMul(n);
                r.sub(vN);
                dynamicItems.updateDirection(r);
                return;
            }
        }
    }

    private boolean checkCameraCollisions() {
        Vector3D itemPos = new Vector3D(sv_p);
        Vector3D dist = new Vector3D();
        int[] nearestPoint = this.checkNearestPoint(sv_p);
        float ccDist = 20 * Track.mScale;
        if (nearestPoint[1] == 0 && !this.m_Karts[0].isOnShortcut) {
            int p1 = nearestPoint[0] - 1;
            if (p1 < 0) {
                p1 += this.m_Track.iPoints.length - 1;
            }
            dist.set(itemPos);
            dist.sub(this.m_Track.iPoints[p1]);
            float len1 = dist.length();
            int p2 = nearestPoint[0] + 1;
            if (p2 > this.m_Track.iPoints.length - 1) {
                p2 -= this.m_Track.iPoints.length - 1;
            }
            dist.set(itemPos);
            dist.sub(this.m_Track.iPoints[p2]);
            float len2 = dist.length();
            if (len1 > len2) {
                p1 = nearestPoint[0];
            } else {
                p2 = nearestPoint[0];
            }
            Vector3D vP1 = new Vector3D(this.m_Track.leftSideVertices[p1 * 2 * 3 + 0], this.m_Track.leftSideVertices[p1 * 2 * 3 + 1], this.m_Track.leftSideVertices[p1 * 2 * 3 + 2]);
            Vector3D vP2 = new Vector3D(this.m_Track.leftSideVertices[p2 * 2 * 3 + 0], this.m_Track.leftSideVertices[p2 * 2 * 3 + 1], this.m_Track.leftSideVertices[p2 * 2 * 3 + 2]);
            Vector3D vN = Vector3D.normalize(Vector3D.crossProduct(Vector3D.sub(vP2, vP1), new Vector3D(0.0f, 1.0f, 0.0f)));
            float dot = Vector3D.dotProduct(vN, Vector3D.sub(itemPos, vP1));
            Vector3D vD = Vector3D.sub(this.m_Track.iPoints[p1], itemPos);
            if (dot < ccDist && vD.length() > this.m_Track.iPointsWidth[p1] + this.m_Track.roadSideWidth / 2.0f) {
                sv_p.add(Vector3D.scalarMul(Math.abs(dot - ccDist), vN));
                return true;
            }
            vP1 = new Vector3D(this.m_Track.rightSideVertices[p1 * 2 * 3 + 0 + 3], this.m_Track.rightSideVertices[p1 * 2 * 3 + 1 + 3], this.m_Track.rightSideVertices[p1 * 2 * 3 + 2 + 3]);
            vP2 = new Vector3D(this.m_Track.rightSideVertices[p2 * 2 * 3 + 0 + 3], this.m_Track.rightSideVertices[p2 * 2 * 3 + 1 + 3], this.m_Track.rightSideVertices[p2 * 2 * 3 + 2 + 3]);
            vN = Vector3D.normalize(Vector3D.crossProduct(Vector3D.sub(vP1, vP2), new Vector3D(0.0f, 1.0f, 0.0f)));
            dot = Vector3D.dotProduct(vN, Vector3D.sub(itemPos, vP1));
            vD = Vector3D.sub(this.m_Track.iPoints[p1], itemPos);
            if (dot < ccDist && vD.length() > this.m_Track.iPointsWidth[p1] + this.m_Track.roadSideWidth / 2.0f) {
                sv_p.add(Vector3D.scalarMul(Math.abs(dot - ccDist), vN));
                return true;
            }
        } else {
            int p1;
            float minLen = 1.0E9f;
            for (int j = 0; j < this.m_Track.mShortcutsArray.size(); ++j) {
                TrackShortcut sc = (TrackShortcut)this.m_Track.mShortcutsArray.elementAt(j);
                for (int i = 0; i < sc.iPoints.length - 1; ++i) {
                    this.cnpDist.set(itemPos);
                    this.cnpDist.sub(sc.iPoints[i]);
                    float len = this.cnpDist.quaterLength();
                    if (!(len < minLen)) continue;
                    minLen = len;
                    nearestPoint[0] = i;
                    nearestPoint[1] = j + 1;
                }
            }
            TrackShortcut sc = (TrackShortcut)this.m_Track.mShortcutsArray.elementAt(nearestPoint[1] - 1);
            if (nearestPoint[0] == 0) {
                nearestPoint[0] = 1;
            }
            if (nearestPoint[0] >= sc.iPoints.length - 1) {
                nearestPoint[0] = sc.iPoints.length - 2;
            }
            if ((p1 = nearestPoint[0] - 1) < 0) {
                p1 = 0;
            } else if (p1 > sc.iPoints.length - 1) {
                p1 = sc.iPoints.length - 1;
            }
            dist.set(itemPos);
            dist.sub(sc.iPoints[p1]);
            float len1 = dist.length();
            int p2 = nearestPoint[0] + 1;
            if (p2 > sc.iPoints.length - 1) {
                p2 = sc.iPoints.length - 1;
            } else if (p2 < 0) {
                p2 += sc.iPoints.length - 1;
            }
            dist.set(itemPos);
            dist.sub(sc.iPoints[p2]);
            float len2 = dist.length();
            if (len1 > len2) {
                p1 = nearestPoint[0];
            } else {
                p2 = nearestPoint[0];
            }
            Vector3D vP1 = new Vector3D(sc.leftSideVertices[p1 * 2 * 3 + 0], sc.leftSideVertices[p1 * 2 * 3 + 1], sc.leftSideVertices[p1 * 2 * 3 + 2]);
            Vector3D vP2 = new Vector3D(sc.leftSideVertices[p2 * 2 * 3 + 0], sc.leftSideVertices[p2 * 2 * 3 + 1], sc.leftSideVertices[p2 * 2 * 3 + 2]);
            Vector3D vN = Vector3D.normalize(Vector3D.crossProduct(Vector3D.sub(vP2, vP1), new Vector3D(0.0f, 1.0f, 0.0f)));
            float dot = Vector3D.dotProduct(vN, Vector3D.sub(itemPos, vP1));
            Vector3D vD = Vector3D.sub(sc.iPoints[p1], itemPos);
            if (dot < ccDist) {
                sv_p.add(Vector3D.scalarMul(Math.abs(dot - ccDist), vN));
                return true;
            }
            vP1 = new Vector3D(sc.rightSideVertices[p1 * 2 * 3 + 0 + 3], sc.rightSideVertices[p1 * 2 * 3 + 1 + 3], sc.rightSideVertices[p1 * 2 * 3 + 2 + 3]);
            vP2 = new Vector3D(sc.rightSideVertices[p2 * 2 * 3 + 0 + 3], sc.rightSideVertices[p2 * 2 * 3 + 1 + 3], sc.rightSideVertices[p2 * 2 * 3 + 2 + 3]);
            vN = Vector3D.normalize(Vector3D.crossProduct(Vector3D.sub(vP1, vP2), new Vector3D(0.0f, 1.0f, 0.0f)));
            dot = Vector3D.dotProduct(vN, Vector3D.sub(itemPos, vP1));
            vD = Vector3D.sub(sc.iPoints[p1], itemPos);
            if (dot < ccDist) {
                sv_p.add(Vector3D.scalarMul(Math.abs(dot - ccDist), vN));
                return true;
            }
        }
        return false;
    }

    private void updateLevel(OnRoadElement items, int[] nearestPoint) {
        items.setGroundLevel(this.checkGroundLevel(null, items.getPosition(), nearestPoint));
    }

    private int[] checkNearestPoint(Vector3D position) {
        float len;
        int i;
        Vector3D dist = new Vector3D();
        dist.set(position);
        dist.sub(this.m_Track.iPoints[0]);
        float minLen = 1.0E9f;
        int nearestPoint = 0;
        int nearestPart = -1;
        for (i = 1; i < this.m_Track.iPoints.length - 1; ++i) {
            dist.set(position);
            dist.sub(this.m_Track.iPoints[i]);
            len = dist.quaterLength();
            if (!(len < minLen)) continue;
            minLen = len;
            nearestPoint = i;
            nearestPart = 0;
        }
        for (int j = 0; j < this.m_Track.mShortcutsArray.size(); ++j) {
            TrackShortcut sc = (TrackShortcut)this.m_Track.mShortcutsArray.elementAt(j);
            for (int i2 = 0; i2 < sc.iPoints.length - 1; ++i2) {
                this.cnpDist.set(position);
                this.cnpDist.sub(sc.iPoints[i2]);
                len = this.cnpDist.quaterLength();
                if (!(len < minLen)) continue;
                minLen = len;
                nearestPoint = i2;
                nearestPart = j + 1;
            }
        }
        if (nearestPart == -1) {
            System.out.println("Wrong Nearest Part!");
            nearestPart = 0;
            nearestPoint = 0;
            this.cnpDist.set(position);
            this.cnpDist.sub(this.m_Track.iPoints[0]);
            minLen = this.cnpDist.quaterLength();
            for (i = 1; i < this.m_Track.iPoints.length - 1; ++i) {
                this.cnpDist.set(position);
                this.cnpDist.sub(this.m_Track.iPoints[i]);
                len = this.cnpDist.quaterLength();
                if (!(len < minLen)) continue;
                minLen = len;
                nearestPoint = i;
            }
        }
        int[] tmp = new int[]{nearestPoint, nearestPart};
        return tmp;
    }

    private int[] checkNearestPointEx(PhysicalEntity entity) {
        float len;
        Vector3D position = entity.getPosition();
        Kart k = entity.getType() == 0 ? (Kart)entity : null;
        float minLen = 1.9E8f;
        int nearestPoint = 0;
        int nearestPart = -1;
        int[] tmpNearest = new int[2];
        for (int i = 0; i < this.m_Track.iPoints.length - 1; ++i) {
            this.cnpDist.set(position);
            this.cnpDist.sub(this.m_Track.iPoints[i]);
            len = this.cnpDist.quaterLength();
            if (!(len < minLen)) continue;
            minLen = len;
            nearestPoint = i;
            nearestPart = 0;
        }
        int roadNearestPoint = nearestPoint;
        if (!entity.isOnShortcut) {
            boolean closeToShortcut = false;
            for (int j = 0; j < this.m_Track.mShortcutsArray.size(); ++j) {
                int i;
                TrackShortcut sc = (TrackShortcut)this.m_Track.mShortcutsArray.elementAt(j);
                if ((roadNearestPoint < sc.startPoints[0] || roadNearestPoint > sc.startPoints[3]) && (roadNearestPoint < sc.endPoints[0] || roadNearestPoint > sc.endPoints[3])) continue;
                for (i = 0; i < sc.iPoints.length - 1; ++i) {
                    this.cnpDist.set(position);
                    this.cnpDist.sub(sc.iPoints[i]);
                    len = this.cnpDist.quaterLength();
                    if (!(len < minLen)) continue;
                    minLen = len;
                    nearestPoint = i;
                    nearestPart = j + 1;
                }
                if (nearestPart != 0) {
                    closeToShortcut = true;
                } else {
                    tmpNearest[0] = roadNearestPoint;
                    tmpNearest[1] = 0;
                    if (this.checkIfOnRoadside(position, tmpNearest) == sc.startSide) {
                        closeToShortcut = true;
                    }
                }
                minLen = 1.9E9f;
                for (i = 0; i < sc.iPoints.length - 1; ++i) {
                    this.cnpDist.set(position);
                    this.cnpDist.sub(sc.iPoints[i]);
                    len = this.cnpDist.quaterLength();
                    if (!(len < minLen)) continue;
                    minLen = len;
                    nearestPoint = i;
                    nearestPart = j + 1;
                }
                int roadResult = this.checkMainRoadCollision(entity, roadNearestPoint, 30.0f * (float)Track.mScale);
                int scResult = this.checkShortcutCollision(entity, nearestPoint, j);
                if (roadResult > -1 && scResult == -1 && closeToShortcut) {
                    entity.isOnShortcut = true;
                    break;
                }
                nearestPart = 0;
                nearestPoint = roadNearestPoint;
            }
        } else {
            minLen = 1.9E9f;
            for (int j = 0; j < this.m_Track.mShortcutsArray.size(); ++j) {
                TrackShortcut sc = (TrackShortcut)this.m_Track.mShortcutsArray.elementAt(j);
                for (int i = 0; i < sc.iPoints.length - 1; ++i) {
                    this.cnpDist.set(position);
                    this.cnpDist.sub(sc.iPoints[i]);
                    len = this.cnpDist.quaterLength();
                    if (!(len < minLen)) continue;
                    minLen = len;
                    nearestPoint = i;
                    nearestPart = j + 1;
                }
            }
            int mr = this.checkMainRoadCollision(entity, roadNearestPoint, 20.0f * (float)Track.mScale);
            if (mr == -1) {
                entity.isOnShortcut = false;
                nearestPart = 0;
                nearestPoint = roadNearestPoint;
            }
        }
        if (nearestPart == -1) {
            System.out.println("Wrong Nearest Part Ex!");
            nearestPart = 0;
            nearestPoint = 0;
            this.cnpDist.set(position);
            this.cnpDist.sub(this.m_Track.iPoints[0]);
            minLen = this.cnpDist.quaterLength();
            for (int i = 1; i < this.m_Track.iPoints.length - 1; ++i) {
                this.cnpDist.set(position);
                this.cnpDist.sub(this.m_Track.iPoints[i]);
                len = this.cnpDist.quaterLength();
                if (!(len < minLen)) continue;
                minLen = len;
                nearestPoint = i;
            }
            entity.setPosition(this.m_Track.iPoints[nearestPoint]);
            entity.stopKart(0);
        }
        if (nearestPart == 0) {
            if (nearestPoint < 0) {
                nearestPoint = this.m_Track.iPoints.length - 1 + nearestPoint;
            } else if (nearestPoint > this.m_Track.iPoints.length - 1 - 1) {
                nearestPoint -= this.m_Track.iPoints.length - 1;
            }
            entity.isOnShortcut = false;
        }
        int[] tmp = new int[]{nearestPoint, nearestPart};
        return tmp;
    }

    public void update(float frame) {
        int j;
        int i;
        Vector3D slope = new Vector3D();
        for (i = 0; i < this.m_physicalEntities.length; ++i) {
            this.m_NearestPoint[i] = this.checkNearestPointEx(this.m_physicalEntities[i]);
            this.m_physicalEntities[i].update(frame);
        }
        for (i = 0; i < this.m_physicalEntities.length; ++i) {
            for (j = i + 1; j < this.m_physicalEntities.length; ++j) {
                if (this.m_NearestPoint[i][0] != this.m_NearestPoint[j][0] && this.m_NearestPoint[i][0] - 1 != this.m_NearestPoint[j][0] && this.m_NearestPoint[i][0] + 1 != this.m_NearestPoint[j][0] || this.m_NearestPoint[i][1] != this.m_NearestPoint[j][1]) continue;
                this.checkPhysicalCollisions(this.m_physicalEntities[i], this.m_physicalEntities[j]);
            }
        }
        for (i = 0; i < this.trackHelpers.length; ++i) {
            this.trackHelpers[i].update(frame);
        }
        for (i = 0; i < this.missionDoors.length; ++i) {
            this.missionDoors[i].update(frame);
        }
        for (i = 0; i < this.m_Karts.length; ++i) {
            int temp;
            if (this.m_Karts[i].isSleeping()) continue;
            if (!this.m_Karts[i].isOnShortcut) {
                temp = this.m_Karts[i].nearestPoint[0] - 1;
                if (temp < 0) {
                    temp = 0;
                }
                if (this.m_Track.mainRoadTextureNr[temp] >= 8 && this.m_Track.mainRoadTextureNr[temp] <= 10 && !this.m_Karts[i].isGrass && this.m_Karts[i].vAltitudeVelocity.quaterLength() == 0.0f) {
                    this.m_Karts[i].startSlowdown(15.0f, true);
                }
                this.m_Karts[i].isOnRocks = this.m_Track.mainRoadTextureNr[temp] >= 4 && this.m_Track.mainRoadTextureNr[temp] <= 6 && !this.m_Karts[i].isGrass;
            } else {
                temp = this.m_Karts[i].nearestPoint[0] - 1;
                if (this.m_Karts[i].nearestPoint[1] - 1 >= 0) {
                    TrackShortcut sc = (TrackShortcut)this.m_Track.mShortcutsArray.elementAt(this.m_Karts[i].nearestPoint[1] - 1);
                    if (sc.mainRoadTextureNr[temp] >= 8 && sc.mainRoadTextureNr[temp] <= 10) {
                        this.m_Karts[i].startSlowdown(15.0f, true);
                    }
                    this.m_Karts[i].isOnRocks = sc.mainRoadTextureNr[temp] >= 4 && sc.mainRoadTextureNr[temp] <= 6;
                }
            }
            for (j = 0; j < this.missionDoors.length; ++j) {
                this.checkDoorCollsions(this.missionDoors[j], this.m_Karts[i]);
            }
            for (j = 0; j < this.trackHelpers.length; ++j) {
                this.checkTrackHelpersInteractions(this.m_Karts[i], this.trackHelpers[j]);
            }
            for (j = 0; j < this.m_StaticElements.length; ++j) {
                if (Math.abs(this.m_NearestPoint[i][0] - this.m_StaticElements[j].nearestPoint[0]) > 1 || this.m_NearestPoint[i][1] != this.m_StaticElements[j].nearestPoint[1]) continue;
                this.checkKartOffroadCollisions(this.m_Karts[i], this.m_StaticElements[j], frame);
            }
            if (GameLogic.gameMode != 2) {
                for (j = 0; j < this.m_StaticItems.length; ++j) {
                    if (Math.abs(this.m_NearestPoint[i][0] - this.m_StaticItems[j].nearestPoint[0]) > 1 || this.m_NearestPoint[i][1] != this.m_StaticItems[j].nearestPoint[1] || !this.m_StaticItems[j].active) continue;
                    this.checkKartItemCollisions(this.m_Karts[i], this.m_StaticItems[j]);
                }
                if (GameLogic.gameItems) {
                    for (j = 0; j < this.m_RespawnableItems.length; ++j) {
                        if (Math.abs(this.m_NearestPoint[i][0] - this.m_RespawnableItems[j].nearestPoint[0]) > 1 || this.m_NearestPoint[i][1] != this.m_RespawnableItems[j].nearestPoint[1] || !this.m_RespawnableItems[j].active) continue;
                        this.checkKartRespawnableItemCollisions(this.m_Karts[i], this.m_RespawnableItems[j]);
                    }
                    for (j = 0; j < this.m_SpawnableItems.length; ++j) {
                        if (Math.abs(this.m_NearestPoint[i][0] - this.m_SpawnableItems[j].nearestPoint[0]) > 1 || this.m_NearestPoint[i][1] != this.m_SpawnableItems[j].nearestPoint[1] || !this.m_SpawnableItems[j].active) continue;
                        this.checkKartSpawnableItemCollisions(this.m_Karts[i], this.m_SpawnableItems[j]);
                    }
                    for (j = 0; j < this.m_DynamicItems.length; ++j) {
                        if (Math.abs(this.m_NearestPoint[i][0] - this.m_DynamicItems[j].nearestPoint[0]) > 1 || this.m_NearestPoint[i][1] != this.m_DynamicItems[j].nearestPoint[1] || !this.m_DynamicItems[j].active) continue;
                        this.checkKartDynamicItemCollisions(this.m_Karts[i], this.m_DynamicItems[j], i);
                    }
                }
            }
            this.checkRaceState(this.m_Karts[i], this.m_NearestPoint[i]);
            this.dropItem(new Vector3D(this.m_Karts[i].getPosition()), new Vector3D(this.m_Karts[i].getDirection()), this.m_Karts[i].getDroppedItem(), this.m_Karts[i].isPlayer, i);
            if (!this.m_Karts[i].activateFatality || !this.m_Karts[i].isFatality) continue;
            for (j = 0; j < this.m_Karts.length; ++j) {
                this.m_Karts[j].isScarred = true;
                this.m_Karts[j].activateFatality = true;
            }
            this.m_Karts[i].isScarred = false;
            this.m_Karts[i].activateFatality = false;
        }
        if (this.m_Karts[0].isAutopilot && this.m_AI[0].sleeping) {
            this.m_AI[0].setAwake();
        }
        if (!this.m_Karts[0].isAutopilot && !this.m_AI[0].sleeping && GameLogic.gameState == 6) {
            this.m_AI[0].setSleep();
        }
        for (i = 0; i < this.m_physicalEntities.length; ++i) {
            this.checkTrackCollisions(this.m_physicalEntities[i], this.m_NearestPoint[i]);
            this.m_physicalEntities[i].setPhysicalConstraints(frame);
        }
        for (i = 0; i < this.m_physicalEntities.length; ++i) {
            float height = this.checkGroundLevel(slope, this.m_physicalEntities[i].getPosition(), this.m_NearestPoint[i]);
            if (height != this.m_physicalEntities[i].getPosition().gety()) {
                this.m_physicalEntities[i].setGround(height, slope);
                this.m_physicalEntities[i].setGroundConstrains(frame);
            }
            this.m_Karts[i].updateShadow();
        }
        if (GameLogic.gameMode != 2) {
            for (i = 0; i < this.m_StaticItems.length; ++i) {
                if (this.m_StaticItems[i].positionChanged) {
                    int[] nearestItemPoint = this.checkNearestPoint(this.m_StaticItems[i].getPosition());
                    this.updateLevel(this.m_StaticItems[i], nearestItemPoint);
                    this.m_StaticItems[i].setNearestPoint(nearestItemPoint);
                    this.m_StaticItems[i].update();
                    this.m_StaticItems[i].positionChanged = false;
                }
                if (this.m_StaticItems[i].shown) {
                    if (this.m_StaticItems[i].animFrame >= 3) {
                        if (this.m_StaticItems[i].animRepeat >= 3) {
                            this.m_StaticItems[i].animFrame = 1;
                            this.m_StaticItems[i].animRepeat = 0;
                            this.m_StaticItems[i].shown = false;
                            continue;
                        }
                        this.m_StaticItems[i].animFrame = 1;
                        ++this.m_StaticItems[i].animRepeat;
                        continue;
                    }
                    ++this.m_StaticItems[i].animFrame;
                    continue;
                }
                this.m_StaticItems[i].animFrame = 0;
            }
            if (GameLogic.gameItems) {
                --this.respawn;
                if (this.respawn < 1) {
                    for (i = 0; i < this.m_RespawnableItems.length; ++i) {
                        if (!this.m_RespawnableItems[i].active) {
                            --this.m_RespawnableItems[i].respawntime;
                            if (this.m_RespawnableItems[i].respawntime < 1) {
                                this.m_RespawnableItems[i].Respawn();
                            }
                        }
                        if (!this.m_RespawnableItems[i].positionChanged) continue;
                        this.m_RespawnableItems[i].update();
                        this.m_RespawnableItems[i].positionChanged = false;
                    }
                    for (i = 0; i < this.m_DynamicItems.length; ++i) {
                        if (!this.m_DynamicItems[i].active) continue;
                        --this.m_DynamicItems[i].respawntime;
                        if (this.m_DynamicItems[i].respawntime >= 1) continue;
                        this.m_DynamicItems[i].triggerWall();
                    }
                    this.respawn = 5;
                }
                for (i = 0; i < this.m_RespawnableItems.length; ++i) {
                    if (this.m_RespawnableItems[i].shown) {
                        ++this.m_RespawnableItems[i].animFrame;
                        if (this.m_RespawnableItems[i].animFrame > 3) {
                            this.m_RespawnableItems[i].animFrame = 0;
                            this.m_RespawnableItems[i].shown = false;
                        }
                    }
                    if (!this.m_RespawnableItems[i].positionChanged) continue;
                    this.m_RespawnableItems[i].update();
                    this.m_RespawnableItems[i].positionChanged = false;
                }
                for (i = 0; i < this.m_DynamicItems.length; ++i) {
                    if (!this.m_DynamicItems[i].active) continue;
                    this.m_DynamicItems[i].vectSet = false;
                    for (int j2 = 0; j2 < this.m_Karts.length; ++j2) {
                        this.checkNearestEnemyPosition(this.m_DynamicItems[i], this.m_Karts[j2], j2);
                    }
                    this.m_DynamicItems[i].updatePosition();
                    int[] nearestItemPoint = this.checkNearestPoint(this.m_DynamicItems[i].getPosition());
                    this.m_DynamicItems[i].setNearestPoint(nearestItemPoint);
                    this.updateLevel(this.m_DynamicItems[i], nearestItemPoint);
                    this.m_DynamicItems[i].vPosition.add(new Vector3D(0.0f, -180.0f, 0.0f));
                    this.checkActiveItemCollisions(this.m_DynamicItems[i], nearestItemPoint);
                    ++this.m_DynamicItems[i].animFrame;
                    if (this.m_DynamicItems[i].respawntime < 3) {
                        if (this.m_DynamicItems[i].animFrame > 8) {
                            this.m_DynamicItems[i].animFrame = 7;
                        }
                    } else if (this.m_DynamicItems[i].respawntime < 10) {
                        if (this.m_DynamicItems[i].animFrame > 7) {
                            this.m_DynamicItems[i].animFrame = 3;
                        }
                    } else if (this.m_DynamicItems[i].animFrame > 2) {
                        this.m_DynamicItems[i].animFrame = 0;
                    }
                    this.m_DynamicItems[i].update();
                }
                for (i = 0; i < this.m_SpawnableItems.length; ++i) {
                    if (this.m_SpawnableItems[i].active) {
                        ++this.m_SpawnableItems[i].updateframe;
                        if (this.m_SpawnableItems[i].updateframe < 13) {
                            this.m_SpawnableItems[i].animFrame = this.m_SpawnableItems[i].updateframe / 3;
                        } else if (this.m_SpawnableItems[i].updateframe > 35) {
                            ++this.m_SpawnableItems[i].animFrame;
                            this.m_SpawnableItems[i].updateframe = 16;
                            if (this.m_SpawnableItems[i].animFrame > 4) {
                                this.m_SpawnableItems[i].animFrame = 3;
                            }
                        }
                    }
                    if (!this.m_SpawnableItems[i].positionChanged) continue;
                    this.m_SpawnableItems[i].updateframe = 0;
                    int[] nearestItemPoint = this.checkNearestPoint(this.m_SpawnableItems[i].getPosition());
                    this.updateLevel(this.m_SpawnableItems[i], nearestItemPoint);
                    this.m_SpawnableItems[i].setNearestPoint(nearestItemPoint);
                    this.m_SpawnableItems[i].vPosition.add(new Vector3D(0.0f, -10 * Track.mScale, 0.0f));
                    this.m_SpawnableItems[i].update();
                    this.m_SpawnableItems[i].positionChanged = false;
                }
            }
        }
        if (GameLogic.gameMode != 3) {
            for (i = 1; i < this.m_Karts.length; ++i) {
                if (this.m_Karts[i].actPos < this.m_Karts[0].actPos) {
                    this.m_Karts[i].invisibleHelperBoost = 1.0f + Stats.helperBoost[GameLogic.gameDifficulty] * (float)(this.m_Karts[0].actPos - this.m_Karts[i].actPos);
                    continue;
                }
                this.m_Karts[i].invisibleHelperBoost = 1.0f - Stats.helperSlowDown[GameLogic.gameDifficulty] * (float)(this.m_Karts[i].actPos - this.m_Karts[0].actPos);
                if (!(this.m_Karts[i].invisibleHelperBoost < Stats.helperSlowDownMax[GameLogic.gameDifficulty])) continue;
                this.m_Karts[i].invisibleHelperBoost = Stats.helperSlowDownMax[GameLogic.gameDifficulty];
            }
        }
        this.checkPosition();
        if (this.camAnim) {
            this.setAnim(frame);
        } else {
            this.setView(this.m_Karts[0]);
        }
        if (this.m_Karts[0].isAutopilot) {
            this.updateSteeringWheel(this.m_Karts[0].isTurn);
        }
        RaceManager.vibrateCameraUpdate(frame);
        SoundManager.check();
    }

    public void paint(Graphics g) {
        int i;
        int bgy = 40;
        int bgx = (int)((float)this.img_bgLayer1.getWidth() - this.bgScrollAngle / 360.0f * (float)this.img_bgLayer1.getWidth());
        g.drawImage(this.img_bgLayer1, -bgx, bgy, 0);
        if (-bgx + this.img_bgLayer1.getWidth() < 240) {
            g.drawImage(this.img_bgLayer1, -bgx + this.img_bgLayer1.getWidth(), bgy, 0);
        } else if (-bgx > 0) {
            g.drawImage(this.img_bgLayer1, -bgx - this.img_bgLayer1.getWidth(), bgy, 0);
        }
        bgy = 30;
        bgx = (int)(this.bgScrollAngle / 360.0f * (float)(240 + this.img_bgLayer2.getWidth())) - this.img_bgLayer2.getWidth();
        g.drawImage(this.img_bgLayer2, bgx, bgy, 0);
        if (GameLogic.gameWorld != 1) {
            bgy = 60;
            bgx = (int)((double)this.img_bgLayer3.getWidth() - (double)this.bgScrollAngle / 360.0 * (double)this.img_bgLayer3.getWidth() * 4.0);
            g.drawImage(this.img_bgLayer3, -bgx, bgy, 0);
            g.drawImage(this.img_bgLayer3, -bgx + this.img_bgLayer3.getWidth(), bgy, 0);
            g.drawImage(this.img_bgLayer3, -bgx + this.img_bgLayer3.getWidth() * 2, bgy, 0);
            g.drawImage(this.img_bgLayer3, -bgx + this.img_bgLayer3.getWidth() * 3, bgy, 0);
            if (-bgx + this.img_bgLayer3.getWidth() * 2 < 240) {
                for (i = 1; i <= 4; ++i) {
                    g.drawImage(this.img_bgLayer3, -bgx + this.img_bgLayer3.getWidth() * i, bgy, 0);
                }
            }
            if (-bgx > 0) {
                for (i = 1; i <= 4; ++i) {
                    g.drawImage(this.img_bgLayer3, -bgx - this.img_bgLayer3.getWidth() * i, bgy, 0);
                }
            }
        }
        g3d.bind(g);
        this.m_Track.renderMainRoad(g3d, this.m_NearestPoint);
        this.m_Track.renderShortcut(g3d, this.m_NearestPoint);
        this.m_Track.renderRoadWalls(g3d, this.m_NearestPoint);
        for (i = 0; i < this.m_StaticElements.length; ++i) {
            if (!this.isInRange(this.m_StaticElements[i].vPosition, MainCanvas.VISIBILITY_SHORT_RANGE)) continue;
            this.m_StaticElements[i].render(g3d);
        }
        if (this.isInRange(this.gate.getPosition(), MainCanvas.VISIBILITY_EXTENDED_RANGE) && this.m_NearestPoint[0][1] == 0 && (this.m_NearestPoint[0][0] < 2 * this.m_Track.numInterpolationSteps || this.m_NearestPoint[0][0] > this.m_Track.iPoints.length - 3 * this.m_Track.numInterpolationSteps)) {
            this.gatePillars[0].render(g3d);
            this.gatePillars[1].render(g3d);
        }
        for (i = 0; i < this.missionDoors.length; ++i) {
            if (!this.isInRange(this.missionDoors[i].getPosition(), MainCanvas.VISIBILITY_RANGE)) continue;
            this.missionDoors[i].render(g3d);
        }
        if (this.isInRange(this.gate.getPosition(), MainCanvas.VISIBILITY_EXTENDED_RANGE) && this.m_NearestPoint[0][1] == 0 && (this.m_NearestPoint[0][0] < 2 * this.m_Track.numInterpolationSteps || this.m_NearestPoint[0][0] > this.m_Track.iPoints.length - 3 * this.m_Track.numInterpolationSteps)) {
            this.gate.render(g3d);
        }
        if (GameLogic.gameMode != 2) {
            for (i = 0; i < this.m_StaticItems.length; ++i) {
                this.m_StaticItems[i].isInSecondFlushRange = false;
                if (!this.m_StaticItems[i].active && !this.m_StaticItems[i].shown || !this.isInRange(this.m_StaticItems[i].vPosition, MainCanvas.VISIBILITY_SHORT_RANGE)) continue;
                this.flushDist.set(this.m_StaticItems[i].vPosition);
                this.flushDist.sub(camPos);
                if (this.flushDist.length() > this.flushItemsRange) {
                    this.m_StaticItems[i].render(g3d);
                    continue;
                }
                this.m_StaticItems[i].isInSecondFlushRange = true;
            }
            if (GameLogic.gameItems) {
                for (i = 0; i < this.m_DynamicItems.length; ++i) {
                    if (!this.m_DynamicItems[i].active || !this.isInRange(this.m_DynamicItems[i].vPosition, MainCanvas.VISIBILITY_EXTENDED_RANGE)) continue;
                    this.m_DynamicItems[i].render(g3d);
                }
                for (i = 0; i < this.m_RespawnableItems.length; ++i) {
                    this.m_RespawnableItems[i].isInSecondFlushRange = false;
                    if (!this.m_RespawnableItems[i].active && !this.m_RespawnableItems[i].shown || !this.isInRange(this.m_RespawnableItems[i].vPosition, MainCanvas.VISIBILITY_SHORT_RANGE)) continue;
                    this.flushDist.set(this.m_RespawnableItems[i].vPosition);
                    this.flushDist.sub(camPos);
                    if (this.flushDist.length() > this.flushItemsRange) {
                        this.m_RespawnableItems[i].render(g3d);
                        continue;
                    }
                    this.m_RespawnableItems[i].isInSecondFlushRange = true;
                }
                for (i = 0; i < this.m_SpawnableItems.length; ++i) {
                    if (!this.m_SpawnableItems[i].active || !this.isInRange(this.m_SpawnableItems[i].vPosition, MainCanvas.VISIBILITY_SHORT_RANGE)) continue;
                    this.m_SpawnableItems[i].render(g3d);
                }
            }
        }
        this.m_Karts[0].setTransformations();
        for (i = 1; i < this.m_Karts.length; ++i) {
            if (this.isInRange(this.m_Karts[i].getPosition(), MainCanvas.VISIBILITY_RANGE)) {
                this.m_Karts[i].setTransformations();
                this.renderKart[i] = true;
                continue;
            }
            this.renderKart[i] = false;
        }
        for (i = 1; i < this.m_Karts.length; ++i) {
            this.inFirstFlushKartRange[i] = false;
            if (!this.renderKart[i]) continue;
            this.flushDist.set(this.m_Karts[i].getPosition());
            this.flushDist.sub(camPos);
            if (!(this.flushDist.length() > this.flushKartRange)) continue;
            this.inFirstFlushKartRange[i] = true;
            this.m_Karts[i].render(g3d);
        }
        g3d.flush();
        for (i = 0; i < this.trackHelpers.length; ++i) {
            if (!this.isInRange(this.trackHelpers[i].getPosition(), MainCanvas.VISIBILITY_VERY_SHORT_RANGE)) continue;
            this.trackHelpers[i].render(g3d);
        }
        g3d.flush();
        if (this.m_StaticItems != null) {
            for (i = 0; i < this.m_StaticItems.length; ++i) {
                if (!this.m_StaticItems[i].isInSecondFlushRange) continue;
                this.m_StaticItems[i].render(g3d);
            }
        }
        if (this.m_RespawnableItems != null) {
            for (i = 0; i < this.m_RespawnableItems.length; ++i) {
                if (!this.m_RespawnableItems[i].isInSecondFlushRange) continue;
                this.m_RespawnableItems[i].render(g3d);
            }
        }
        for (i = 1; i < this.m_Karts.length; ++i) {
            if (!this.renderKart[i] || this.inFirstFlushKartRange[i] || Math.abs(this.m_Karts[i].nearestPoint[0] - this.m_Karts[0].nearestPoint[0]) % this.m_Track.iPoints.length > 1) continue;
            this.m_Karts[i].renderShadow(g3d);
        }
        this.m_Karts[0].renderShadow(g3d);
        g3d.flush();
        for (i = 1; i < this.m_Karts.length; ++i) {
            if (!this.renderKart[i] || this.inFirstFlushKartRange[i]) continue;
            this.m_Karts[i].render(g3d);
        }
        this.m_Karts[0].render(g3d);
        g3d.flush();
        g3d.release(g);
    }

    private boolean isInRange(Vector3D pos, float dist) {
        camDist.set(pos);
        camDist.sub(camPos);
        if (camDist.quaterLength() < dist * dist) {
            if (dist == MainCanvas.VISIBILITY_LONG_RANGE) {
                return true;
            }
            if (camDir.isFdir(camDist)) {
                return true;
            }
        }
        return false;
    }

    public void checkPosition() {
        for (int j = 0; j < this.m_Karts.length; ++j) {
            int position = 0;
            for (int i = 0; i < this.m_Karts.length; ++i) {
                if (this.m_Karts[i].actPos <= this.m_Karts[j].actPos) continue;
                ++position;
            }
            this.m_Karts[j].kartPosition = position;
        }
    }

    private void updateSteeringWheel(byte turn) {
        this.facing += turn;
        if (this.facing < 0) {
            this.rotateLeft = true;
            if (this.facing < -3) {
                this.facing = -3;
            }
            this.frameX = this.facing * -1 * frameBase;
            if (turn == 0) {
                ++this.facing;
            }
        } else if (this.facing > 0) {
            this.rotateLeft = false;
            if (this.facing > 3) {
                this.facing = 3;
            }
            this.frameX = this.facing * frameBase;
            if (turn == 0) {
                --this.facing;
            }
        } else {
            this.frameX = 0;
        }
    }

    public static Vector3D vibrateCameraPosition(float power) {
        if ((power = power * (gForceCameraFrameCounter + 1.0f) * 0.05f) > 5.0f) {
            power = 5.0f;
        }
        Random r = new Random();
        Vector3D vibrate = new Vector3D();
        vibrate.set(r.nextFloat() * power, r.nextFloat() * power, r.nextFloat() * power);
        return vibrate;
    }

    public static void vibrateCameraUpdate(float frame) {
        if (vibrateCamera && (cameraFrameCounter -= frame * 1.5f) < 0.0f) {
            cameraFrameCounter = 0.0f;
            vibrateCamera = false;
        }
        if (gForceCamera && (gForceCameraFrameCounter -= frame) < 0.0f) {
            gForceCameraFrameCounter = 0.0f;
            gForceCamera = false;
        }
    }

    private Vector3D gForceCameraPosition(Vector3D vector) {
        Vector3D gvector = new Vector3D();
        gvector.set(vector);
        gvector.scalarMul(gForceCameraFrameCounter * 0.1f);
        float length = gvector.quaterLength();
        if (length > 250.0f) {
            gvector.scalarMul(250.0f / length);
        }
        return gvector;
    }

    static {
        frameBase = 40;
        gForceCameraVector = new Vector3D();
        strItemTextureIndex = new int[]{9, 8, 27, 26, 25, 28, 20, 17, 18, 19, 24, 21, 22, 23, 16, 14, 12, 13, 15};
        sv_p = new Vector3D();
        sv_t = new Vector3D();
        sv_u = new Vector3D(0.0f, 1.0f, 0.0f);
    }
}

