/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Hashtable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class ImgFontH {
    Hashtable images;
    String text;
    int charHeight;
    int hSpace;
    int fontVSpace = 2;
    private int[] charWidths;
    private int[] charPos;
    static Font font = Font.getFont((int)0, (int)0, (int)8);

    public ImgFontH(Image image, String text, int[] charWidths, int hSpace) {
        this.setCharWidths(charWidths);
        this.charHeight = image.getHeight();
        this.setImage(image);
        this.text = text;
        this.hSpace = hSpace;
    }

    public ImgFontH(String path, String text, int[] charWidths, int hSpace) {
        this.setCharWidths(charWidths);
        try {
            Image image = Image.createImage((String)path);
            this.charHeight = image.getHeight();
            this.setImage(image);
            this.text = text;
            this.hSpace = hSpace;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ImgFontH(MIDlet midlet, String path, int[] charWidths, int hSpace) {
        this.setCharWidths(charWidths);
        try {
            int ch;
            StringBuffer str = new StringBuffer();
            DataInputStream in = new DataInputStream(midlet.getClass().getResourceAsStream(path + ".txt"));
            while ((ch = in.read()) != -1) {
                str.append((char)ch);
            }
            in.close();
            this.text = new String(str);
            Image image = Image.createImage((String)(path + ".png"));
            this.charHeight = image.getHeight();
            this.setImage(image);
            this.hSpace = hSpace;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void setImage(Image image) {
        this.setImage(image, 0);
    }

    private void setImage(Image image, int color) {
        if (this.images == null) {
            this.images = new Hashtable();
        }
        this.images.put(new Integer(color), image);
    }

    private Image getImage(int color) {
        Image image = (Image)this.images.get(new Integer(color));
        if (image == null && color != 0) {
            image = this.getImage(0);
            int width = image.getWidth();
            int height = image.getHeight();
            int[] arr = new int[width * height];
            image.getRGB(arr, 0, width, 0, 0, width, height);
            for (int i = 0; i < arr.length; ++i) {
                if (arr[i] != -16777216) continue;
                arr[i] = 0xFF000000 | color;
            }
            image = null;
            image = Image.createRGBImage((int[])arr, (int)width, (int)height, (boolean)true);
            this.setImage(image, color);
        }
        return image;
    }

    private void setCharWidths(int[] charWidths) {
        this.charWidths = charWidths;
        this.charPos = new int[this.charWidths.length];
        for (int i = 0; i < this.charPos.length; ++i) {
            this.charPos[i] = i == 0 ? 0 : this.charPos[i - 1] + this.charWidths[i - 1];
        }
    }

    public void setFontVSpace(int space) {
        this.fontVSpace = space;
    }

    public int stringWidth(String str) {
        int len = 0;
        char[] ch = str.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            int index = this.text.indexOf(ch[i]);
            if (index == -1) {
                index = this.text.indexOf(32);
            }
            if (index < 0 || index >= this.charWidths.length) continue;
            len += this.charWidths[index];
        }
        return len + ch.length * this.hSpace;
    }

    public int getHeight() {
        return this.charHeight + this.fontVSpace;
    }

    public void drawString(Graphics g, String string, int x, int y, int align) {
        this.drawString(g, string, x, y, align, 0);
    }

    public void drawString(Graphics g, String string, int x, int y, int align, int color) {
        Image image = this.getImage(color);
        char[] chars = string.toCharArray();
        int drawX = x;
        int drawY = y;
        int width = this.stringWidth(string);
        if ((align & 4) != 4) {
            if ((align & 8) == 8) {
                drawX -= width;
            } else if ((align & 1) == 1) {
                drawX -= width / 2;
            }
        }
        if ((align & 0x10) != 16 && (align & 0x20) == 32) {
            drawY -= this.getHeight();
        }
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipW = g.getClipWidth();
        int clipH = g.getClipHeight();
        int offset = 0;
        for (int i = 0; i < chars.length; ++i) {
            int index = this.text.indexOf(chars[i]);
            if (index == -1) {
                index = this.text.indexOf(32);
            }
            g.clipRect(drawX + offset, drawY, this.charWidths[index], this.charHeight);
            g.drawImage(image, drawX + offset - this.charPos[index], drawY, 20);
            offset += this.charWidths[index] + this.hSpace;
            g.setClip(clipX, clipY, clipW, clipH);
        }
    }
}

