/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class ImgFont {
    Image image;
    String text;
    int charWidth;
    int charHeight;
    int hSpace;
    int fontVSpace = 2;

    public ImgFont(Image image, String text, int hSpace) {
        this.charWidth = image.getWidth() / text.length();
        this.charHeight = image.getHeight();
        this.image = image;
        this.text = text;
        this.hSpace = hSpace;
    }

    public ImgFont(String path, String text, int hSpace) {
        try {
            Image image = Image.createImage((String)path);
            this.charWidth = image.getWidth() / text.length();
            this.charHeight = image.getHeight();
            this.image = image;
            this.text = text;
            this.hSpace = hSpace;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ImgFont(MIDlet midlet, String path, int hSpace) {
        try {
            int ch;
            StringBuffer str = new StringBuffer();
            DataInputStream in = new DataInputStream(midlet.getClass().getResourceAsStream(path + ".txt"));
            while ((ch = in.read()) != -1) {
                str.append((char)ch);
            }
            in.close();
            this.text = new String(str);
            System.out.println("Text read from file:" + this.text);
            Image image = Image.createImage((String)(path + ".png"));
            this.charWidth = image.getWidth() / this.text.length();
            this.charHeight = image.getHeight();
            this.image = image;
            this.hSpace = hSpace;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setFontVSpace(int space) {
        this.fontVSpace = space;
    }

    public int stringWidth(String str) {
        return str.length() * (this.charWidth + this.hSpace);
    }

    public int getHeight() {
        return this.charHeight + this.fontVSpace;
    }

    public void drawString(Graphics g, String string, int x, int y, int align) {
        char[] chars = string.toUpperCase().toCharArray();
        int drawX = x;
        int drawY = y;
        int width = this.stringWidth(string);
        if ((align & 4) != 4) {
            if ((align & 8) == 8) {
                drawX -= width;
            } else if ((align & 1) == 1) {
                drawX -= width / 2;
            }
        }
        if ((align & 0x10) != 16 && (align & 0x20) == 32) {
            drawY -= this.getHeight();
        }
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipW = g.getClipWidth();
        int clipH = g.getClipHeight();
        for (int i = 0; i < chars.length; ++i) {
            int index = this.text.indexOf(chars[i]);
            g.clipRect(drawX + i * (this.charWidth + this.hSpace), drawY, this.charWidth, this.charHeight);
            g.drawImage(this.image, drawX + i * (this.charWidth + this.hSpace) - index * this.charWidth, drawY, 20);
            g.setClip(clipX, clipY, clipW, clipH);
        }
    }
}

