/*
 * Decompiled with CFR 0.152.
 */
package com.wordsteps.model.exercise;

import com.wordsteps.model.Word;
import com.wordsteps.model.exercise.Exercise;
import com.wordsteps.model.exercise.tasks.FlashCardTask;
import com.wordsteps.model.exercise.tasks.SelectionTask;
import com.wordsteps.model.exercise.tasks.Task;
import com.wordsteps.model.exercise.tasks.TranslateTask;
import com.wordsteps.model.exercise.tasks.WordDataSource;
import java.util.Random;

public class ExerciseFactory {
    public static final int EXERCISE_COUNT = 5;
    public static final String EXERCISE_ID_FLASH_CARDS = "ex-1";
    public static final String EXERCISE_NAME_FLASH_CARDS = "flash.cards.title";
    public static final String EXERCISE_DETAILS_FLASH_CARDS = "flash.cards.description";
    public static final String EXERCISE_ID_DIRECT_SELECTION = "ex-2";
    public static final String EXERCISE_NAME_DIRECT_SELECTION = "translation.variants.title";
    public static final String EXERCISE_DETAILS_DIRECT_SELECTION = "translation.variants.description";
    public static final String EXERCISE_ID_REVERSE_SELECTION = "ex-3";
    public static final String EXERCISE_NAME_REVERSE_SELECTION = "word.variants.title";
    public static final String EXERCISE_DETAILS_REVERSE_SELECTION = "word.variants.description";
    public static final String EXERCISE_ID_DIRECT_TRANSLATION = "ex-4";
    public static final String EXERCISE_NAME_DIRECT_TRANSLATION = "tbw.title";
    public static final String EXERCISE_DETAILS_DIRECT_TRANSLATION = "tbw.description";
    public static final String EXERCISE_ID_REVERSE_TRANSLATION = "ex-5";
    public static final String EXERCISE_NAME_REVERSE_TRANSLATION = "wbt.title";
    public static final String EXERCISE_DETAILS_REVERSE_TRANSLATION = "wbt.description";

    public static Exercise createFlashCards() {
        return new Exercise(EXERCISE_ID_FLASH_CARDS, EXERCISE_NAME_FLASH_CARDS, EXERCISE_DETAILS_FLASH_CARDS){

            public Task[] getTasks() {
                Word[] w = this.getDictionary().getWords();
                Task[] tasks = new Task[w.length];
                int[] seq = ExerciseFactory.getRandomSequence(w.length);
                for (int i = 0; i < w.length; ++i) {
                    tasks[i] = new FlashCardTask(this, new WordDataSource.DirectTranslationDataSource(w[seq[i]]));
                }
                return tasks;
            }
        };
    }

    public static Exercise createDirectSelection() {
        return new Exercise(EXERCISE_ID_DIRECT_SELECTION, EXERCISE_NAME_DIRECT_SELECTION, EXERCISE_DETAILS_DIRECT_SELECTION){

            public Task[] getTasks() {
                Word[] w = this.getDictionary().getWords();
                Task[] tasks = new Task[w.length];
                int[] seq = ExerciseFactory.getRandomSequence(w.length);
                for (int i = 0; i < w.length; ++i) {
                    tasks[i] = new SelectionTask(this, new WordDataSource.DirectTranslationDataSource(w[seq[i]]));
                }
                return tasks;
            }
        };
    }

    public static Exercise createReverseSelection() {
        return new Exercise(EXERCISE_ID_REVERSE_SELECTION, EXERCISE_NAME_REVERSE_SELECTION, EXERCISE_DETAILS_REVERSE_SELECTION){

            public Task[] getTasks() {
                Word[] w = this.getDictionary().getWords();
                Task[] tasks = new Task[w.length];
                int[] seq = ExerciseFactory.getRandomSequence(w.length);
                for (int i = 0; i < w.length; ++i) {
                    tasks[i] = new SelectionTask(this, new WordDataSource.ReverseTranslationDataSource(w[seq[i]]));
                }
                return tasks;
            }
        };
    }

    public static Exercise createDirectTranslation() {
        return new Exercise(EXERCISE_ID_DIRECT_TRANSLATION, EXERCISE_NAME_DIRECT_TRANSLATION, EXERCISE_DETAILS_DIRECT_TRANSLATION){

            public Task[] getTasks() {
                Word[] w = this.getDictionary().getWords();
                Task[] tasks = new Task[w.length];
                int[] seq = ExerciseFactory.getRandomSequence(w.length);
                for (int i = 0; i < w.length; ++i) {
                    tasks[i] = new TranslateTask(this, new WordDataSource.DirectTranslationDataSource(w[seq[i]]));
                }
                return tasks;
            }
        };
    }

    public static Exercise createReverseTranslation() {
        return new Exercise(EXERCISE_ID_REVERSE_TRANSLATION, EXERCISE_NAME_REVERSE_TRANSLATION, EXERCISE_DETAILS_REVERSE_TRANSLATION){

            public Task[] getTasks() {
                Word[] w = this.getDictionary().getWords();
                Task[] tasks = new Task[w.length];
                int[] seq = ExerciseFactory.getRandomSequence(w.length);
                for (int i = 0; i < w.length; ++i) {
                    tasks[i] = new TranslateTask(this, new WordDataSource.ReverseTranslationDataSource(w[seq[i]]));
                }
                return tasks;
            }
        };
    }

    private static int[] getRandomSequence(int n) {
        int size = n;
        int[] result = new int[n];
        int[] temp = new int[n];
        for (int i = 0; i < n; ++i) {
            temp[i] = i;
        }
        Random rnd = new Random();
        int k = 0;
        while (size > 0) {
            int index = rnd.nextInt(size);
            result[k++] = temp[index];
            int numMoved = size - index - 1;
            if (numMoved > 0) {
                System.arraycopy(temp, index + 1, temp, index, numMoved);
            }
            temp[--size] = -1;
        }
        return result;
    }
}

