/*
 * Decompiled with CFR 0.152.
 */
package com.wordsteps.model.exercise.tasks;

import com.wordsteps.model.Word;
import com.wordsteps.model.exercise.Exercise;
import com.wordsteps.model.exercise.tasks.StatefulSelection;
import com.wordsteps.model.exercise.tasks.Task;
import com.wordsteps.model.exercise.tasks.WordDataSource;
import java.util.Random;
import java.util.Vector;

public class SelectionTask
extends Task {
    public static final int CHOICE_SIZE = 4;
    private String correctAnswer = this.getDataSource().getCorrectAnswer();

    public SelectionTask(Exercise exercise, WordDataSource dataSource) {
        super(exercise, dataSource);
    }

    public Object getStatement() {
        int i;
        Vector<Object> statement = new Vector<Object>();
        statement.addElement(this.getDataSource().getStatement());
        Vector<String> answers = new Vector<String>();
        Random rnd = new Random(System.currentTimeMillis());
        Word[] words = this.getExercise().getDictionary().getWords();
        int[] ind = new int[words.length];
        for (i = 0; i < ind.length; ++i) {
            ind[i] = i;
        }
        for (i = 0; i < ind.length; ++i) {
            int k = rnd.nextInt(ind.length);
            int tmp = ind[k];
            ind[k] = ind[i];
            ind[i] = tmp;
        }
        for (i = 0; i < Math.min(4, words.length); ++i) {
            answers.addElement(this.getDataSource().getCorrectAnswer(words[ind[i]]));
        }
        if (!answers.contains(this.correctAnswer)) {
            answers.setElementAt(this.correctAnswer, rnd.nextInt(answers.size()));
        }
        for (i = 0; i < answers.size(); ++i) {
            statement.addElement(new StatefulSelection((String)answers.elementAt(i)));
        }
        return statement;
    }

    public boolean isCorrect() {
        return this.correctAnswer.equals(this.getInput().toString());
    }

    public void applyHint() {
    }
}

