/*
 * Decompiled with CFR 0.152.
 */
package com.wordsteps.ui.common.renderers;

import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Label;
import com.sun.lwuit.List;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.list.ListCellRenderer;
import com.sun.lwuit.plaf.Border;
import com.wordsteps.model.Word;
import com.wordsteps.ui.common.TransparentLabel;
import com.wordsteps.ui.common.UIProfile;
import com.wordsteps.ui.screen.exercise.ExerciseForm;
import com.wordsteps.ui.util.ImageRegistry;

public class ExerciseListCellRenderer
implements ListCellRenderer {
    private Container container = new Container(new BorderLayout());
    private TransparentLabel exerciseName;
    private TransparentLabel exerciseStatus;
    private Label focus;

    public ExerciseListCellRenderer() {
        this.container.getStyle().setBorder(Border.createRoundBorder(10, 10, 12508914, true));
        this.container.getStyle().setBgTransparency(255);
        this.exerciseName = new TransparentLabel("");
        UIProfile.applyFont(this.exerciseName.getStyle(), "exercises.name.font");
        UIProfile.applyPadding(this.exerciseName.getStyle(), "exercises.name.padding");
        this.exerciseStatus = new TransparentLabel("");
        this.focus = new Label("");
        this.focus.getStyle().setBgColor(14608594);
        this.focus.getStyle().setBorder(Border.createRoundBorder(10, 10, 12508914, true));
        this.focus.getStyle().setMargin(0, 0, 0, 0);
        this.container.addComponent("Center", (Component)this.exerciseName);
        this.container.addComponent("East", (Component)this.exerciseStatus);
    }

    public Component getListCellRendererComponent(List list, Object o, int i, boolean bln) {
        ExerciseForm form = (ExerciseForm)o;
        this.exerciseName.setText(form.getName());
        this.exerciseName.setIcon(form.getImage());
        this.container.getStyle().setBgColor(bln ? 14608594 : 15333118);
        String exId = form.getExercise().getId();
        Word[] words = form.getExercise().getDictionary().getWords();
        int c = 0;
        for (int j = 0; j < words.length; ++j) {
            if (!((Boolean)words[j].getExercisesHashTable().get(exId)).booleanValue()) continue;
            ++c;
        }
        String statusImageName = null;
        statusImageName = c == 0 ? "start" : (c < words.length ? "in progress" : "done");
        this.exerciseStatus.setIcon(ImageRegistry.getImage(statusImageName));
        return this.container;
    }

    public Component getListFocusComponent(List list) {
        return this.focus;
    }
}

