/*
 * Decompiled with CFR 0.152.
 */
package com.wordsteps.ui.screen;

import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Form;
import com.sun.lwuit.Image;
import com.sun.lwuit.List;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.plaf.Border;
import com.sun.lwuit.plaf.UIManager;
import com.sun.lwuit.table.TableLayout;
import com.wordsteps.model.DictionaryCache;
import com.wordsteps.persistence.Configuration;
import com.wordsteps.ui.common.TransparentLabel;
import com.wordsteps.ui.common.UIProfile;
import com.wordsteps.ui.common.commands.ExitCommand;
import com.wordsteps.ui.common.renderers.ScreenListCellRenderer;
import com.wordsteps.ui.screen.CustomDictionaryListForm;
import com.wordsteps.ui.screen.DictionaryListScreenForm;
import com.wordsteps.ui.screen.DownloadScreenForm;
import com.wordsteps.ui.screen.ScreenForm;
import com.wordsteps.ui.screen.SettingsScreenForm;

public class MainScreenForm
extends ScreenForm
implements ActionListener {
    private final ScreenForm[] screenForms = new ScreenForm[]{new DownloadScreenForm(this), new CustomDictionaryListForm(this), new SettingsScreenForm(this)};
    private List menuList = new List(this.screenForms){

        protected boolean isSelectableInteraction() {
            return false;
        }
    };

    public MainScreenForm() {
        this.menuList.setListCellRenderer(new ScreenListCellRenderer());
        this.menuList.addActionListener(this);
        this.menuList.setItemGap(0);
        this.setLayout(new BorderLayout());
        TransparentLabel adv = new TransparentLabel("main.eyv");
        adv.setAlignment(3);
        adv.getStyle().setFgColor(11303559);
        UIProfile.applyFont(adv.getStyle(), "main.adv.font");
        UIProfile.applyMargin(adv.getStyle(), "main.adv.margin");
        this.addComponent("North", (Component)adv);
        this.addComponent("Center", (Component)this.menuList);
        this.createCommands();
    }

    public void createCommands() {
        this.addCommand(new ExitCommand(), 0);
        this.addCommand(new Command("command.about", 2){

            public void actionPerformed(ActionEvent evt) {
                Form aboutForm = new Form("about.title");
                aboutForm.setLayout(new BoxLayout(2));
                aboutForm.setScrollable(false);
                Container infoContainer = new Container(new BoxLayout(2));
                TransparentLabel clientName = new TransparentLabel("about.name");
                clientName.getStyle().setFgColor(4034476);
                UIProfile.applyFont(clientName.getStyle(), "preview.dicname.font");
                infoContainer.addComponent(clientName);
                Container container = new Container(new TableLayout(2, 2));
                container.addComponent(new TransparentLabel("about.version"));
                container.addComponent(new TransparentLabel(Configuration.getInstance().getMidletVersion()));
                container.addComponent(new TransparentLabel("about.website"));
                container.addComponent(new TransparentLabel("http://wordsteps.com"));
                container.getStyle().setBorder(Border.createRoundBorder(15, 15, 12508914));
                container.getStyle().setBgColor(15333118);
                infoContainer.addComponent(container);
                UIProfile.applyPadding(infoContainer.getStyle(), "form.title.padding");
                TextArea aboutText = new TextArea(UIManager.getInstance().localize("about.text", "[NULL]"), 5, 10);
                aboutText.setEditable(false);
                aboutText.getStyle().setBgTransparency(0);
                aboutText.getStyle().setBorder(null);
                UIProfile.applyFont(aboutText.getStyle(), "exercise.description.font");
                aboutForm.addComponent(infoContainer);
                aboutForm.addComponent(aboutText);
                Command c = new Command("command.ok", 3){

                    public void actionPerformed(ActionEvent evt) {
                        MainScreenForm.this.show();
                    }
                };
                aboutForm.addCommand(c);
                aboutForm.setBackCommand(c);
                aboutForm.show();
            }
        }, 1);
        this.addCommand(new Command("command.select", 7){

            public void actionPerformed(ActionEvent evt) {
                MainScreenForm.this.actionPerformed(evt);
            }
        }, 2);
    }

    public void actionPerformed(ActionEvent evt) {
        ScreenForm form = (ScreenForm)this.menuList.getSelectedItem();
        if (form instanceof DictionaryListScreenForm) {
            ((DictionaryListScreenForm)form).setDictionaries(DictionaryCache.getInstance().getDictionaries());
        }
        form.show();
    }

    public String getName() {
        return "WordSteps";
    }

    public String getShortName() {
        throw new RuntimeException("Not supported yet");
    }

    public Image getImage() {
        throw new RuntimeException("Not supported yet.");
    }

    public ScreenForm[] getScreenForms() {
        return this.screenForms;
    }
}

