/*
 * Decompiled with CFR 0.152.
 */
package com.wordsteps.ui.screen.exercise;

import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Form;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.plaf.Border;
import com.sun.lwuit.plaf.UIManager;
import com.wordsteps.model.Dictionary;
import com.wordsteps.model.DictionaryChangeListener;
import com.wordsteps.model.exercise.Exercise;
import com.wordsteps.model.exercise.tasks.Task;
import com.wordsteps.ui.common.TransparentLabel;
import com.wordsteps.ui.common.UIProfile;
import com.wordsteps.ui.dialogs.ButtonDialog;
import com.wordsteps.ui.screen.ScreenForm;
import com.wordsteps.ui.screen.exercise.ExerciseFormBundle;
import com.wordsteps.ui.util.ImageRegistry;

public abstract class ExerciseForm
extends ScreenForm
implements DictionaryChangeListener {
    protected Exercise exercise;
    protected Task[] tasks;
    protected int currentTask;
    private TransparentLabel counterLabel = new TransparentLabel("");

    public ExerciseForm(Exercise exercise, Form prevForm) {
        super(prevForm);
        this.counterLabel.setAlignment(3);
        UIProfile.applyFont(this.counterLabel.getStyle(), "exercise.progress.font");
        this.exercise = exercise;
        exercise.setDictionaryListener(this);
        this.setTitle(this.getName());
        this.getTitleComponent().setIcon(this.getImage());
    }

    public ExerciseForm(Exercise exercise) {
        this(exercise, null);
    }

    public Exercise getExercise() {
        return this.exercise;
    }

    public Image getImage() {
        return ImageRegistry.getImage(this.exercise.getId());
    }

    public String getName() {
        if (this.exercise != null) {
            return this.exercise.getName();
        }
        return "";
    }

    public String getShortName() {
        if (this.exercise != null) {
            return this.exercise.getName();
        }
        return "";
    }

    public Label getCounterComponent() {
        return this.counterLabel;
    }

    protected Component getDescriptionComponent() {
        Container container = new Container(new BoxLayout(2));
        container.getStyle().setBgColor(15335158);
        container.getStyle().setBorder(Border.createRoundBorder(15, 15, 12514014));
        TextArea description = new TextArea(UIManager.getInstance().localize(this.exercise.getDetails(), "[NULL]"));
        description.setEditable(false);
        description.setFocusable(false);
        description.setAlignment(4);
        description.getStyle().setBgTransparency(0);
        description.getStyle().setBorder(null);
        UIProfile.applyFont(description.getStyle(), "exercise.description.font");
        UIProfile.applyPadding(description.getStyle(), "exercise.description.padding");
        container.addComponent(description);
        container.addComponent(this.counterLabel);
        return container;
    }

    protected abstract void initState();

    protected void displayCurrentState() {
        StringBuffer progress = new StringBuffer(UIManager.getInstance().localize("exercise.word", "[NULL]"));
        progress.append(' ').append(this.currentTask + 1).append(' ');
        progress.append(UIManager.getInstance().localize("exercise.of", "[NULL]"));
        progress.append(' ').append(this.tasks.length);
        this.counterLabel.setText(progress.toString());
    }

    protected void nextTask() {
        if (this.currentTask == this.tasks.length - 1) {
            new ButtonDialog(UIManager.getInstance().localize("exercise.completed", "[NULL]"), ImageRegistry.getImage("information")).showPacked("Center", true);
            this.startNextExercise();
        } else {
            ++this.currentTask;
            this.displayCurrentState();
        }
    }

    protected void startNextExercise() {
        ExerciseForm next = ExerciseFormBundle.getInstance().getNextForm(this);
        if (next == null) {
            this.getPreviousScreenForm().show();
        } else {
            next.setPreviousScreenForm(this.getPreviousScreenForm());
            next.show();
        }
    }

    public void show() {
        this.initState();
        this.displayCurrentState();
        super.show();
    }

    public void dictionaryUpdated(Dictionary dic) {
        this.tasks = this.exercise.getTasks();
    }

    public void dictionaryDeleted(Dictionary dic) {
    }

    protected void checkInput(Object input) {
        this.checkInput(input, true);
    }

    protected void checkInput(Object input, boolean showDialog) {
        Task task = this.tasks[this.currentTask];
        task.setInput(input);
        if (task.check()) {
            if (showDialog) {
                new ButtonDialog(UIManager.getInstance().localize("exercise.correct", "[NULL]"), ImageRegistry.getImage("accept")).showPacked("Center", true);
            }
            this.nextTask();
        } else if (showDialog) {
            new ButtonDialog(UIManager.getInstance().localize("exercise.wrong", "[NULL]"), ImageRegistry.getImage("error")).showPacked("Center", true);
        }
    }
}

