/*
 * Decompiled with CFR 0.152.
 */
package com.wordsteps.model;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Word {
    private String word;
    private String transcription;
    private String translation;
    private Hashtable exercises = new Hashtable(5);
    private Vector exIds = new Vector();

    public Word() {
        this.exercises.put("ex-1", new Boolean(false));
        this.exercises.put("ex-2", new Boolean(false));
        this.exercises.put("ex-4", new Boolean(false));
        this.exercises.put("ex-3", new Boolean(false));
        this.exercises.put("ex-5", new Boolean(false));
    }

    public Word(String word, String translation, String transcription) {
        this();
        this.word = word;
        this.transcription = transcription;
        this.translation = translation;
    }

    public String getWord() {
        return this.word;
    }

    public void setWord(String word) {
        this.word = word;
    }

    public String getTranscription() {
        return this.transcription;
    }

    public void setTranscription(String transcription) {
        this.transcription = transcription;
    }

    public String getTranslation() {
        return this.translation;
    }

    public void setTranslation(String translation) {
        this.translation = translation;
    }

    public void addExercise(String exId) {
        this.exIds.removeAllElements();
        this.exercises.put(exId, new Boolean(true));
    }

    public Hashtable getExercisesHashTable() {
        return this.exercises;
    }

    public Vector getExercises() {
        if (this.exIds.isEmpty()) {
            Enumeration keys = this.exercises.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                Boolean b = (Boolean)this.exercises.get(key);
                if (!b.booleanValue()) continue;
                this.exIds.addElement(key);
            }
        }
        return this.exIds;
    }

    public String toString() {
        return this.word + " [" + this.transcription + "] - " + this.translation;
    }

    public boolean isLearnt() {
        return this.exIds.size() == 5;
    }
}

