/*
 * Decompiled with CFR 0.152.
 */
package com.wordsteps.ui.screen;

import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Label;
import com.sun.lwuit.List;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.list.ListCellRenderer;
import com.sun.lwuit.plaf.UIManager;
import com.wordsteps.ui.common.TransparentLabel;
import com.wordsteps.ui.screen.LanguagePair;
import com.wordsteps.ui.util.ImageRegistry;

class LanuagePairListCellRenderer
implements ListCellRenderer {
    private Container container = new Container(new BoxLayout(1));
    private TransparentLabel srcLang = new TransparentLabel("");
    private TransparentLabel dstLang = new TransparentLabel("");
    private Label focus = new Label("");

    public LanuagePairListCellRenderer() {
        this.focus.getStyle().setBgColor(14608594);
        this.container.getStyle().setMargin(0, 0, 0, 0);
        this.srcLang.getStyle().setMargin(0, 0, 0, 0);
        this.dstLang.getStyle().setMargin(0, 0, 0, 0);
        this.container.addComponent(this.srcLang);
        this.container.addComponent(this.dstLang);
    }

    public Component getListCellRendererComponent(List list, Object o, int i, boolean bln) {
        LanguagePair pair = (LanguagePair)o;
        if (pair.getSourceLanguage() == null) {
            this.srcLang.setIcon(null);
            this.srcLang.setText(UIManager.getInstance().localize("dictionaries.all", "[NULL]") + " (" + pair.count() + ')');
            this.dstLang.setIcon(null);
            this.dstLang.setText("");
        } else {
            this.srcLang.setIcon(ImageRegistry.getImage(pair.getSourceLanguage().getCode()));
            this.srcLang.setText("\u2192");
            this.dstLang.setIcon(ImageRegistry.getImage(pair.getTargetLanguage().getCode()));
            this.dstLang.setText("(" + pair.count() + ")");
        }
        return this.container;
    }

    public Component getListFocusComponent(List list) {
        return this.focus;
    }
}

