/*
 * Decompiled with CFR 0.152.
 */
package org.ksoap2;

import java.io.IOException;
import org.ksoap2.SoapFault;
import org.kxml2.kdom.Element;
import org.kxml2.kdom.Node;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class SoapEnvelope {
    public static final int VER10 = 100;
    public static final int VER11 = 110;
    public static final int VER12 = 120;
    public static final String ENV2001 = "http://www.w3.org/2001/12/soap-envelope";
    public static final String ENC2001 = "http://www.w3.org/2001/12/soap-encoding";
    public static final String ENV = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final String ENC = "http://schemas.xmlsoap.org/soap/encoding/";
    public static final String XSD = "http://www.w3.org/2001/XMLSchema";
    public static final String XSI = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XSD1999 = "http://www.w3.org/1999/XMLSchema";
    public static final String XSI1999 = "http://www.w3.org/1999/XMLSchema-instance";
    public Object bodyIn;
    public Object bodyOut;
    public Element[] headerIn;
    public Element[] headerOut;
    public String encodingStyle;
    public int version;
    public String env;
    public String enc;
    public String xsi;
    public String xsd;

    public static boolean stringToBoolean(String string) {
        if (string == null) {
            return false;
        }
        return (string = string.trim().toLowerCase()).equals("1") || string.equals("true");
    }

    public SoapEnvelope(int n) {
        this.version = n;
        if (n == 100) {
            this.xsi = XSI1999;
            this.xsd = XSD1999;
        } else {
            this.xsi = XSI;
            this.xsd = XSD;
        }
        if (n < 120) {
            this.enc = ENC;
            this.env = ENV;
        } else {
            this.enc = ENC2001;
            this.env = ENV2001;
        }
    }

    public void parse(XmlPullParser xmlPullParser) throws IOException, XmlPullParserException {
        xmlPullParser.nextTag();
        xmlPullParser.require(2, this.env, "Envelope");
        this.encodingStyle = xmlPullParser.getAttributeValue(this.env, "encodingStyle");
        xmlPullParser.nextTag();
        if (xmlPullParser.getEventType() == 2 && xmlPullParser.getNamespace().equals(this.env) && xmlPullParser.getName().equals("Header")) {
            this.parseHeader(xmlPullParser);
            xmlPullParser.require(3, this.env, "Header");
            xmlPullParser.nextTag();
        }
        xmlPullParser.require(2, this.env, "Body");
        this.encodingStyle = xmlPullParser.getAttributeValue(this.env, "encodingStyle");
        this.parseBody(xmlPullParser);
        xmlPullParser.require(3, this.env, "Body");
        xmlPullParser.nextTag();
        xmlPullParser.require(3, this.env, "Envelope");
    }

    public void parseHeader(XmlPullParser xmlPullParser) throws IOException, XmlPullParserException {
        Element element;
        int n;
        xmlPullParser.nextTag();
        Node node = new Node();
        node.parse(xmlPullParser);
        int n2 = 0;
        for (n = 0; n < node.getChildCount(); ++n) {
            element = node.getElement(n);
            if (element == null) continue;
            ++n2;
        }
        this.headerIn = new Element[n2];
        n2 = 0;
        for (n = 0; n < node.getChildCount(); ++n) {
            element = node.getElement(n);
            if (element == null) continue;
            this.headerIn[n2++] = element;
        }
    }

    public void parseBody(XmlPullParser xmlPullParser) throws IOException, XmlPullParserException {
        xmlPullParser.nextTag();
        if (xmlPullParser.getEventType() == 2 && xmlPullParser.getNamespace().equals(this.env) && xmlPullParser.getName().equals("Fault")) {
            SoapFault soapFault = new SoapFault();
            soapFault.parse(xmlPullParser);
            this.bodyIn = soapFault;
        } else {
            Node node = this.bodyIn instanceof Node ? (Node)this.bodyIn : new Node();
            node.parse(xmlPullParser);
            this.bodyIn = node;
        }
    }

    public void write(XmlSerializer xmlSerializer) throws IOException {
        xmlSerializer.setPrefix("i", this.xsi);
        xmlSerializer.setPrefix("d", this.xsd);
        xmlSerializer.setPrefix("c", this.enc);
        xmlSerializer.setPrefix("v", this.env);
        xmlSerializer.startTag(this.env, "Envelope");
        xmlSerializer.startTag(this.env, "Header");
        this.writeHeader(xmlSerializer);
        xmlSerializer.endTag(this.env, "Header");
        xmlSerializer.startTag(this.env, "Body");
        this.writeBody(xmlSerializer);
        xmlSerializer.endTag(this.env, "Body");
        xmlSerializer.endTag(this.env, "Envelope");
    }

    public void writeHeader(XmlSerializer xmlSerializer) throws IOException {
        if (this.headerOut != null) {
            for (int i = 0; i < this.headerOut.length; ++i) {
                this.headerOut[i].write(xmlSerializer);
            }
        }
    }

    public void writeBody(XmlSerializer xmlSerializer) throws IOException {
        if (this.encodingStyle != null) {
            xmlSerializer.attribute(this.env, "encodingStyle", this.encodingStyle);
        }
        ((Node)this.bodyOut).write(xmlSerializer);
    }

    public void setOutputSoapObject(Object object) {
        this.bodyOut = object;
    }
}

