/*
 * Decompiled with CFR 0.152.
 */
package simple.core;

import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import simple.core.Device;
import simple.debug.DebugOutput;
import simple.events.Event;
import simple.video.Screen;

public abstract class Application
extends MIDlet {
    private static Application pSingleton = null;
    private Device pDevice = null;
    private static long lUpdateCounter;
    private int iUpdatesPerSecond;
    private long lUpdateTicks;
    private long lRealUpdateTicks;
    private long lLastTicks;
    private boolean bApplicationActive;
    private boolean bApplicationPaused;

    private void deviceUpdate() {
        this.pDevice.update();
    }

    public Application() {
        DebugOutput.setDebugLevel(0);
        DebugOutput.traceNoIndent(0, "SIMPLE", "SIMPLE Version : 0.8.34 [2012/9/1] (C)Inlogic Software 2010-2012");
        DebugOutput.traceIn(2, "SIMPLE", "Application.Application()");
        pSingleton = this;
        DebugOutput.trace(2, "SIMPLE", "pSingleton = " + ((Object)((Object)pSingleton)).toString());
        this.pDevice = new Device(this);
        lUpdateCounter = 0L;
        this.setUpdatesPerSecond(30);
        this.bApplicationActive = false;
        this.bApplicationPaused = false;
        DebugOutput.traceOut(2, "SIMPLE", "Application.Application()");
    }

    protected void finalize() throws Throwable {
        DebugOutput.traceIn(2, "SIMPLE", "Application.~Application()");
        this.pDevice = null;
        System.gc();
        DebugOutput.traceOut(2, "SIMPLE", "Application.~Application()");
    }

    public static Application getSingleton() {
        return pSingleton;
    }

    public void setUpdatesPerSecond(int iUpdatesPerSecond) {
        DebugOutput.traceIn(2, "SIMPLE", "Application.setUpdatesPerSecond(" + Integer.toString(iUpdatesPerSecond) + ")");
        this.iUpdatesPerSecond = iUpdatesPerSecond;
        this.lUpdateTicks = 1000 / iUpdatesPerSecond;
        DebugOutput.traceOut(2, "SIMPLE", "Application.setUpdatesPerSecond()");
    }

    public int getUpdatesPerSecond() {
        return this.iUpdatesPerSecond;
    }

    public long getRealTicksPerUpdate() {
        return this.lRealUpdateTicks;
    }

    public static long getUpdateCounter() {
        return lUpdateCounter;
    }

    public Device getDevice() {
        return this.pDevice;
    }

    public void start() {
        DebugOutput.traceIn(2, "SIMPLE", "Application.start()");
        this.onStart();
        this.bApplicationActive = true;
        this.lLastTicks = this.pDevice.getTicks();
        lUpdateCounter = 0L;
        Runnable pRunnable = new Runnable(){

            public void run() {
                Application.this.pDevice.getScreen().setActive();
                do {
                    Application.this.deviceUpdate();
                    long lActualTicks = Application.this.pDevice.getTicks();
                    Application.this.lRealUpdateTicks = lActualTicks - Application.this.lLastTicks;
                    if (Application.this.lRealUpdateTicks < Application.this.lUpdateTicks) continue;
                    Application.this.lLastTicks = lActualTicks;
                    Application.this.update();
                    lUpdateCounter++;
                } while (Application.this.bApplicationActive);
                try {
                    Application.this.destroyApp(true);
                }
                catch (MIDletStateChangeException e) {
                    e.printStackTrace();
                }
                Application.this.notifyDestroyed();
            }
        };
        Thread pRunThread = new Thread(pRunnable);
        pRunThread.start();
        DebugOutput.traceOut(2, "SIMPLE", "Application.start()");
    }

    public void stop() {
        DebugOutput.traceIn(2, "SIMPLE", "Application.stop()");
        this.onStop();
        this.bApplicationActive = false;
        DebugOutput.traceOut(2, "SIMPLE", "Application.stop()");
    }

    public void pause() {
        DebugOutput.traceIn(2, "SIMPLE", "Application.pause()");
        this.onPause();
        this.bApplicationPaused = true;
        DebugOutput.traceOut(2, "SIMPLE", "Application.pause()");
    }

    public void resume() {
        if (!this.bApplicationPaused) {
            return;
        }
        DebugOutput.traceIn(2, "SIMPLE", "Application.resume()");
        this.bApplicationPaused = false;
        this.onResume();
        DebugOutput.traceOut(2, "SIMPLE", "Application.resume()");
    }

    public void repaintScreen() {
        if (this.bApplicationPaused) {
            return;
        }
        Screen pScreen = this.pDevice.getScreen();
        pScreen.repaint();
    }

    protected void destroyApp(boolean arg0) throws MIDletStateChangeException {
        this.onStop();
    }

    protected void pauseApp() {
        this.onPause();
    }

    protected void startApp() throws MIDletStateChangeException {
        this.start();
    }

    public void onStart() {
    }

    public void onStop() {
    }

    public void onPause() {
    }

    public void onResume() {
    }

    public void onEventFired(Event event) {
    }

    public abstract void paintScreen(Screen var1);

    public abstract void update();
}

