/*
 * Decompiled with CFR 0.152.
 */
package Kartmania;

import Kartmania.Application;
import Kartmania.ObjectsCache;
import Kartmania.Platform;
import Kartmania.UIListColumn;
import Kartmania.UIListItem;
import Kartmania.UIListTextItem;
import Kartmania.UIScreen;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class UIFullScreenMenuList
extends UIScreen {
    private static int COLUMN_SEPARATOR_WIDTH = 4;
    protected Vector columns = null;
    protected Vector headers = new Vector();
    protected boolean enableSelection = true;
    protected int currentItem = 0;
    protected int startItem = 0;
    protected int visibleItemsCount = 0;
    protected int numItems = 0;
    protected int centerMode = 1;
    public boolean drawColumnSeparators = false;
    public boolean showHeaders = false;

    protected boolean touchPressed(int x, int y) {
        int nCount;
        int offset = 0;
        int left = Application.screenWidth - ObjectsCache.scrollUpImg.getWidth() / 4 - ObjectsCache.scrollUpImg.getWidth();
        int right = left + ObjectsCache.scrollUpImg.getWidth();
        int top = this.positionY + 2 * this.height / 10 - offset + this.YScrollOffset - 5;
        int bottom = this.positionY + 2 * this.height / 10 - offset + this.YScrollOffset + ObjectsCache.scrollUpImg.getHeight() + 5;
        if (x >= left && x < right && y >= top && y <= bottom) {
            this.moveUp();
            return true;
        }
        top = this.positionY + 7 * this.height / 10 + offset + this.YScrollOffset - 5;
        bottom = this.positionY + 7 * this.height / 10 + offset + this.YScrollOffset + ObjectsCache.scrollUpImg.getHeight() + 5;
        if (x >= left && x < right && y >= top && y <= bottom) {
            this.moveDown();
            return true;
        }
        int fontHeight = 18;
        this.visibleItemsCount = this.clientAreaHeight / fontHeight;
        int itemsBaselineY = this.positionY + this.height / 2 - fontHeight / 2;
        this.numItems = this.getColumn((int)0).items.size();
        itemsBaselineY = this.positionY + 7 * fontHeight / 24;
        if (this.numItems < this.visibleItemsCount) {
            int nN = this.numItems * fontHeight;
            itemsBaselineY = this.positionY + this.clientAreaHeight / 2 - nN / 2;
            this.startItem = 0;
        }
        if ((nCount = this.visibleItemsCount) > this.numItems) {
            nCount = this.numItems;
        }
        left = Application.screenWidth / 2 - ObjectsCache.menuHighlight.getWidth() / 6 - ObjectsCache.menuHighlight.getWidth() / 2;
        right = Application.screenWidth / 2 + ObjectsCache.menuHighlight.getWidth() / 6 + ObjectsCache.menuHighlight.getWidth() / 2;
        for (int i = this.startItem; i < this.startItem + nCount; ++i) {
            top = itemsBaselineY + (i - this.startItem) * fontHeight;
            bottom = top + ObjectsCache.menuHighlight.getHeight();
            if (x < left || x >= right || y < top || y > bottom) continue;
            this.currentItem = i;
            return true;
        }
        return false;
    }

    protected boolean touchReleased(int x, int y) {
        int nCount;
        int fontHeight = 18;
        this.visibleItemsCount = this.clientAreaHeight / fontHeight;
        int itemsBaselineY = this.positionY + this.height / 2 - fontHeight / 2;
        this.numItems = this.getColumn((int)0).items.size();
        itemsBaselineY = this.positionY + 7 * fontHeight / 24;
        if (this.numItems < this.visibleItemsCount) {
            int nN = this.numItems * fontHeight;
            itemsBaselineY = this.positionY + this.clientAreaHeight / 2 - nN / 2;
            this.startItem = 0;
        }
        if ((nCount = this.visibleItemsCount) > this.numItems) {
            nCount = this.numItems;
        }
        int left = Application.screenWidth / 2 - ObjectsCache.menuHighlight.getWidth() / 6 - ObjectsCache.menuHighlight.getWidth() / 2;
        int right = Application.screenWidth / 2 + ObjectsCache.menuHighlight.getWidth() / 6 + ObjectsCache.menuHighlight.getWidth() / 2;
        for (int i = this.startItem; i < this.startItem + nCount; ++i) {
            int top = itemsBaselineY + (i - this.startItem) * fontHeight;
            int bottom = top + ObjectsCache.menuHighlight.getHeight();
            if (x < left || x >= right || y < top || y > bottom) continue;
            this.currentItem = i;
            this.currentItemSelected(this.currentItem);
            return true;
        }
        return false;
    }

    protected void onFocusBack() {
        this.currentItem = 0;
        this.startItem = 0;
    }

    public UIFullScreenMenuList(Vector _columns) {
        this.showScrollbars = true;
        this.columns = _columns;
        this.currentItem = 0;
        this.startItem = 0;
    }

    public UIFullScreenMenuList() {
        this.showScrollbars = true;
        this.columns = new Vector();
        this.columns.addElement(new UIListColumn(4096L, 1));
        this.currentItem = 0;
        this.startItem = 0;
    }

    protected UIListColumn getColumn(int id) {
        return (UIListColumn)this.columns.elementAt(id);
    }

    protected void moveUp() {
        int numElements = this.getColumn((int)0).items.size();
        if (this.currentItem > 0) {
            int prevItem = this.currentItem--;
            this.currentItemChanged(prevItem, this.currentItem);
            if (this.numItems > this.visibleItemsCount && this.startItem > this.currentItem) {
                this.startItem = this.currentItem;
            }
        } else {
            this.currentItemChanged(this.currentItem, numElements - 1);
            this.currentItem = numElements - 1;
            if (this.numItems > this.visibleItemsCount) {
                this.startItem = this.numItems - this.visibleItemsCount;
            }
        }
    }

    protected void moveDown() {
        int numElements = this.getColumn((int)0).items.size();
        if (this.currentItem < numElements - 1) {
            int prevItem = this.currentItem++;
            this.currentItemChanged(prevItem, this.currentItem);
            if (this.numItems > this.visibleItemsCount && this.currentItem >= this.startItem + this.visibleItemsCount) {
                this.startItem = this.currentItem - this.visibleItemsCount + 1;
            }
        } else {
            this.currentItemChanged(this.currentItem, 0);
            this.currentItem = 0;
            this.startItem = 0;
        }
    }

    protected void keyPressed(int gameAction) {
    }

    public void updateSize() {
        int nAreaHeight = Application.screenHeight - 18;
        int topOfClientArea = Application.screenHeight - 18 - nAreaHeight;
        this.positionX = 0;
        this.positionY = topOfClientArea;
        this.width = Application.screenWidth;
        this.height = nAreaHeight;
        if (this.windowCaption != null) {
            this.positionY += this.windowCaption.getHeight();
            this.height -= this.windowCaption.getHeight();
        }
    }

    public void paint(Graphics g) {
        int nAreaHeight = Application.screenHeight - 18;
        int topOfClientArea = Application.screenHeight - 18 - nAreaHeight;
        g.setColor(3151637);
        g.fillRect(0, topOfClientArea, Application.screenWidth, nAreaHeight);
        if (this.windowCaption != null) {
            this.windowCaption.draw(g);
        }
        this.updateSize();
        this.draw(g);
    }

    public void draw(Graphics g) {
        int nCount;
        int fontHeight = 18;
        g.setClip(this.positionX + this.clientAreaX, this.positionY + this.clientAreaY, this.clientAreaWidth, this.clientAreaHeight);
        this.visibleItemsCount = this.clientAreaHeight / fontHeight;
        int itemsBaselineY = this.positionY + this.height / 2 - fontHeight / 2;
        this.numItems = this.getColumn((int)0).items.size();
        itemsBaselineY = this.positionY + 7 * fontHeight / 24;
        if (this.numItems < this.visibleItemsCount) {
            int nN = this.numItems * fontHeight;
            itemsBaselineY = this.positionY + this.clientAreaHeight / 2 - nN / 2;
            this.startItem = 0;
        }
        if ((nCount = this.visibleItemsCount) > this.numItems) {
            nCount = this.numItems;
        }
        for (int i = this.startItem; i < this.startItem + nCount; ++i) {
            int itemIndex = i;
            int xx = 0;
            int yPosition = itemsBaselineY + (i - this.startItem) * fontHeight;
            if (i == this.currentItem) {
                g.drawImage(ObjectsCache.menuHighlight, Application.screenWidth / 2 - ObjectsCache.menuHighlight.getWidth() / 6, yPosition, 17);
                g.drawImage(ObjectsCache.menuHighlight, Application.screenWidth / 2 + ObjectsCache.menuHighlight.getWidth() / 6, yPosition, 17);
                g.drawImage(ObjectsCache.menuHighlight, Application.screenWidth / 2, yPosition, 17);
            }
            for (int cc = 0; cc < this.columns.size(); ++cc) {
                UIListColumn column = this.getColumn(cc);
                long _width = (long)this.clientAreaWidth * column.width;
                UIListItem item = (UIListItem)column.items.elementAt(itemIndex);
                if (item.isVisible()) {
                    item.draw(g, xx, yPosition, (int)(_width / 4096L), fontHeight, column.alignment);
                }
                xx = (int)((long)xx + (_width / 4096L + (long)COLUMN_SEPARATOR_WIDTH));
            }
        }
        if (this.showHeaders) {
            int xx = this.positionX + this.clientAreaX;
            for (int cc = 0; cc < this.columns.size(); ++cc) {
                UIListColumn column = this.getColumn(cc);
                long _width = (long)this.clientAreaWidth * column.width;
                if (column.alignment == 1) {
                    UIScreen.drawString(g, (String)this.headers.elementAt(cc), xx + (int)(_width / 4096L) / 2, this.positionY + this.clientAreaY, 17, 0);
                } else {
                    UIScreen.drawString(g, (String)this.headers.elementAt(cc), xx, this.positionY + this.clientAreaY, 20, 0);
                }
                xx = (int)((long)xx + _width / 4096L);
                xx += COLUMN_SEPARATOR_WIDTH;
            }
        }
        g.setClip(0, 0, Application.screenWidth, Application.screenHeight);
        this.postDraw(g);
    }

    public void autoSize() {
        if (!this.smallWnd) {
            this.clientAreaX = Platform.WND_MARGIN_LEFT;
            this.clientAreaWidth = this.width - Platform.WND_MARGIN_LEFT - Platform.WND_MARGIN_RIGHT;
            this.clientAreaY = Platform.WND_MARGIN_TOP;
            this.clientAreaHeight = this.height - Platform.WND_MARGIN_TOP - Platform.WND_MARGIN_BOTTOM;
        } else {
            this.clientAreaX = 7;
            this.clientAreaWidth = this.width - 7 - 0;
            this.clientAreaY = 0;
            this.clientAreaHeight = this.height - 0 - 9;
        }
    }

    public void postDraw(Graphics g) {
    }

    protected void leftSoftButton() {
    }

    protected void rightSoftButton() {
    }

    public abstract void currentItemChanged(int var1, int var2);

    public abstract void currentItemSelected(int var1);

    public void clearList() {
        for (int i = 0; i < this.columns.size(); ++i) {
            this.getColumn(i).empty();
        }
    }

    public void append(String newItem, Image img) {
        this.getColumn((int)0).items.addElement(new UIListTextItem(newItem));
    }

    public void append(UIListItem item, int columnID) {
        this.getColumn((int)columnID).items.addElement(item);
    }

    public void append(String newItem) {
        this.getColumn((int)0).items.addElement(new UIListTextItem(newItem));
    }

    protected void keyReleased(int keyCode) {
        int gameAction = this.parentCanvas.getGameAction(keyCode);
        if (keyCode == 50) {
            gameAction = 1;
        } else if (keyCode == 56) {
            gameAction = 6;
        } else if (keyCode == 52) {
            gameAction = 2;
        } else if (keyCode == 54) {
            gameAction = 5;
        } else if (keyCode == 53) {
            gameAction = 8;
        }
        if (this.enableSelection) {
            switch (gameAction) {
                case 1: {
                    this.moveUp();
                    break;
                }
                case 6: {
                    this.moveDown();
                    break;
                }
                case 8: {
                    if (this.currentItem == -1) break;
                    this.currentItemSelected(this.currentItem);
                }
            }
        }
    }

    public void setCenterMode(int mode) {
        this.centerMode = mode;
    }
}

