/*
 * Decompiled with CFR 0.152.
 */
package MovingBall;

import java.util.Vector;
import javax.microedition.lcdui.CustomItem;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class CustomList
extends CustomItem {
    private String[] strData;
    private int listHeight;
    private int listWidth;
    private int numRows = 6;
    private int numColumns = 1;
    private int hRect;
    private int wRect;
    private int xCurrent = 0;
    private int yCurrent = 0;

    public CustomList(String title, String[] strArray, int width, int height, int[] flags) {
        super("");
        this.strData = strArray;
        this.hRect = height / 6;
        this.wRect = width - 2;
    }

    protected int getMinContentHeight() {
        return this.numRows * this.hRect + 1;
    }

    protected int getMinContentWidth() {
        return this.numColumns * this.wRect + 2;
    }

    protected int getPrefContentHeight(int arg0) {
        return this.numRows * this.hRect + 1;
    }

    protected int getPrefContentWidth(int arg0) {
        return this.numColumns * this.wRect + 2;
    }

    public void paint(Graphics g, int w, int h) {
        int i;
        Font font = g.getFont();
        for (i = 0; i <= this.numRows; ++i) {
            g.drawLine(0, i * this.hRect, this.numColumns * this.wRect, i * this.hRect);
        }
        for (i = 0; i <= this.numColumns; ++i) {
            g.drawLine(i * this.wRect, 0, i * this.wRect, this.numRows * this.hRect);
        }
        int oldColor = g.getColor();
        g.setColor(0xD0D0D0);
        g.fillRect(this.xCurrent * this.wRect + 1, this.yCurrent * this.hRect + 1, this.wRect - 1, this.hRect - 1);
        g.setColor(oldColor);
        for (int i2 = 0; i2 < this.numRows; ++i2) {
            String[] splitArray = this.createArrayOfStrings(this.strData[i2], '@');
            for (int j = 0; j < this.numColumns; ++j) {
                int oldClipX = g.getClipX();
                int oldClipY = g.getClipY();
                int oldClipWidth = g.getClipWidth();
                int oldClipHeight = g.getClipHeight();
                int x1 = j * this.wRect + 2;
                g.drawString(splitArray[0], x1, i2 * this.hRect + font.getHeight(), 36);
                int x2 = this.getMinContentWidth() - (font.stringWidth(splitArray[1]) + font.charWidth(' '));
                g.drawString(splitArray[1], x2, i2 * this.hRect + font.getHeight(), 40);
                g.drawString(splitArray[2], x1, i2 * this.hRect + 2 * font.getHeight(), 36);
            }
        }
    }

    private String[] createArrayOfStrings(String str, char ch) {
        Vector<String> vector = new Vector<String>();
        int index = str.lastIndexOf(ch);
        Object[] strArray = null;
        for (int i = 0; i < str.length(); ++i) {
            if (index < 0) {
                vector.addElement(str);
                break;
            }
            index = str.indexOf(ch);
            if (index <= 0) continue;
            String elemStr = str.substring(0, index);
            str = str.substring(index + 1, str.length());
            vector.addElement(elemStr);
        }
        strArray = new String[vector.size()];
        vector.copyInto(strArray);
        return strArray;
    }

    protected boolean traverse(int dir, int viewportWidth, int viewportHeight, int[] visRect_inout) {
        switch (dir) {
            case 6: {
                if (this.yCurrent >= this.numRows - 1) break;
                ++this.yCurrent;
                this.repaint(this.xCurrent * this.wRect, (this.yCurrent - 1) * this.hRect, this.wRect, this.hRect);
                this.repaint(this.xCurrent * this.wRect, this.yCurrent * this.hRect, this.wRect, this.hRect);
                break;
            }
            case 1: {
                if (this.yCurrent <= 0) break;
                --this.yCurrent;
                this.repaint(this.xCurrent * this.wRect, (this.yCurrent + 1) * this.hRect, this.wRect, this.hRect);
                this.repaint(this.xCurrent * this.wRect, this.yCurrent * this.hRect, this.wRect, this.hRect);
            }
        }
        visRect_inout[0] = this.xCurrent;
        visRect_inout[1] = this.yCurrent;
        visRect_inout[2] = this.wRect;
        visRect_inout[3] = this.hRect;
        return true;
    }
}

