/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.core_gui;

import baltorogames.core.Utils;
import baltorogames.core_gui.UIButton;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.FXUtility;

public class UIAnimatedButtonH
extends UIButton {
    private int animRange = 3;
    private int animDir = 1;

    public UIAnimatedButtonH() {
    }

    public void setAnimDir(int n) {
        this.animDir = n;
    }

    public UIAnimatedButtonH(int n, int n2, int n3, int n4, int n5) {
        this.top = n2;
        this.left = n - this.animRange;
        this.bottom = n4;
        this.right = n3 + this.animRange;
        this.buttonID = n5;
        this.isSelected = false;
        this.isChecked = false;
        this.isVisible = true;
        this.isActive = true;
    }

    public UIAnimatedButtonH(int n, int n2, String string, String string2, int n3) {
        this.buttonID = n3;
        this.textures = new CGTexture[2];
        this.textures[0] = TextureManager.AddTexture(string);
        this.textures[1] = TextureManager.AddTexture(string2);
        this.top = n2;
        this.left = n - this.animRange;
        this.bottom = this.top + this.textures[0].GetHeight();
        this.right = this.left + this.textures[0].GetWidth() + 2 * this.animRange;
        this.buttonID = n3;
        this.isSelected = false;
        this.isChecked = false;
        this.isVisible = true;
        this.isActive = true;
    }

    public UIAnimatedButtonH(int n, int n2, CGTexture cGTexture, CGTexture cGTexture2, int n3) {
        this.buttonID = n3;
        this.top = n2;
        this.left = n - this.animRange;
        if (cGTexture != null && cGTexture2 != null) {
            this.textures = new CGTexture[2];
            this.textures[0] = cGTexture;
            this.textures[1] = cGTexture2;
            this.bottom = this.top + this.textures[0].GetHeight();
            this.right = this.left + this.textures[0].GetWidth() + 2 * this.animRange;
        } else {
            this.textures = null;
            this.bottom = this.top + 10;
            this.right = this.left + 10 + 2 * this.animRange;
        }
        this.buttonID = n3;
        this.isSelected = false;
        this.isVisible = true;
        this.isActive = true;
    }

    public void setPosition(int n, int n2, int n3, int n4) {
        this.top = n2;
        this.left = n - this.animRange;
        this.bottom = n4;
        this.right = n3 + this.animRange;
    }

    public void setPosition(int n, int n2) {
        int n3 = this.right - this.left;
        int n4 = this.bottom - this.top;
        this.top = n2;
        this.left = n - this.animRange;
        this.bottom = this.top + n4;
        this.right = this.left + n3;
    }

    public void setLeft(int n) {
        int n2 = this.right - this.left;
        this.left = n - this.animRange;
        this.right = this.left + n2;
    }

    public void setTop(int n) {
        int n2 = this.bottom - this.top;
        this.top = n;
        this.bottom = this.top + n2;
    }

    public void setTextures(CGTexture cGTexture, CGTexture cGTexture2) {
        this.textures = new CGTexture[2];
        this.textures[0] = cGTexture;
        this.textures[1] = cGTexture2;
        this.bottom = this.top + this.textures[0].GetHeight();
        this.right = this.left + this.textures[0].GetWidth() + 2 * this.animRange;
    }

    public void setTextures(String string, String string2) {
        this.textures = new CGTexture[2];
        this.textures[0] = TextureManager.AddTexture(string);
        this.textures[1] = TextureManager.AddTexture(string2);
        this.bottom = this.top + this.textures[0].GetHeight();
        this.right = this.left + this.textures[0].GetWidth() + 2 * this.animRange;
    }

    public void draw() {
        if (this.isVisible) {
            int n = (int)((long)(this.animDir * this.animRange) * FXUtility.m_SinX[this.ownScreen.getLifeTime() / 2 % 360]) / 4096;
            int n2 = this.left + this.animRange + n;
            if (!this.isSelected && this.textures[0] != null) {
                Graphic2D.DrawImage(this.textures[0], n2, this.top, 20);
            } else if (this.isSelected && this.textures[1] != null) {
                Graphic2D.DrawImage(this.textures[1], n2, this.top, 20);
            }
            if (this.caption != null && this.caption.length() > 0) {
                Utils.drawString(this.caption, (n2 + this.right) / 2, (this.top + this.bottom) / 2, 3, this.fontID);
            }
        }
    }
}

