/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIAnimatedButtonH;
import baltorogames.core_gui.UIButton;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gui.LoadingLevelScreen;
import baltorogames.project_gui.MainUSRScreen;
import baltorogames.project_gui.SelectTrack;
import baltorogames.project_gui.UICaptionThick;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;

public class SelectEvent
extends MainUSRScreen {
    public static int NUM_MENU_ELEMENTS = 3;
    private final int LEFT_ARROW_ID;
    private final int RIGHT_ARROW_ID;
    private int currentMenuElement = 0;
    private CGTexture eventTexture;
    private CGTexture cityTexture;
    private CGTexture cityName;
    private String eventName;
    private int _selectedCity;

    public void autoSize() {
    }

    public SelectEvent(int n) {
        this.LEFT_ARROW_ID = 100;
        this.RIGHT_ARROW_ID = 101;
        this._selectedCity = n;
        this.drawFP = false;
        this.drawCash = false;
        this.drawStrip2 = false;
        this.drawLogo = false;
        this.drawStrip1 = true;
        this.cityTexture = TextureManager.AddTexture("/city_" + (CGEngine.selectedTrack + 1) + "_ico.png");
        this.cityName = TextureManager.AddTexture("/city_" + (CGEngine.selectedTrack + 1) + "_name.png");
        this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        this.setCaptionThick(new UICaptionThick(ApplicationData.lp.getTranslatedString(Options.languageID, "ID_SELECT_CAR")));
        int n2 = ApplicationData.screenHeight / 2 - ObjectsCache.scrollRightImg.GetHeight() / 2 + this.cityTexture.GetHeight();
        int n3 = 0;
        int n4 = ApplicationData.screenWidth - ObjectsCache.scrollRightImg.GetWidth();
        this.updateScreenInfo();
        this.strip2Y = (ApplicationData.screenHeight - ObjectsCache.menuFooterImage.GetHeight() + ApplicationData.screenHeight / 2 + this.eventTexture.GetHeight() / 2) / 2;
        this.strip1Y = (ApplicationData.screenHeight / 2 - this.cityTexture.GetHeight() / 2) / 2;
        UIAnimatedButtonH uIAnimatedButtonH = new UIAnimatedButtonH(n4, n2, ObjectsCache.scrollRightImg, ObjectsCache.scrollRightWImg, 101);
        uIAnimatedButtonH.setScreen(this);
        uIAnimatedButtonH.setAnimDir(1);
        this.addButton(uIAnimatedButtonH);
        UIAnimatedButtonH uIAnimatedButtonH2 = new UIAnimatedButtonH(n3, n2, ObjectsCache.scrollLeftImg, ObjectsCache.scrollLeftWImg, 100);
        uIAnimatedButtonH2.setScreen(this);
        uIAnimatedButtonH2.setAnimDir(-1);
        this.addButton(uIAnimatedButtonH2);
    }

    public void onUpdate(int n) {
        this.lifeTime += n;
    }

    public void draw() {
        Graphic2D.DrawImage(this.cityTexture, ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2, 3);
        Graphic2D.DrawImage(this.eventTexture, ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2 + this.cityTexture.GetHeight(), 3);
        Graphic2D.DrawImage(this.cityName, ApplicationData.screenWidth, this.strip1Y - MainUSRScreen.getStrip1Height() / 2, 24);
        Utils.drawString(this.eventName, ApplicationData.screenWidth, this.strip1Y - MainUSRScreen.getStrip1Height() / 2 + this.cityName.GetHeight(), 24, 0);
    }

    public boolean rightSoftButton() {
        UIScreen.SetCurrentScreen(new SelectTrack(this._selectedCity));
        return true;
    }

    public boolean leftSoftButton() {
        if (ApplicationData.demoEnabled && ApplicationData.demoLevelLimited && !ApplicationData.demoExpired && --ApplicationData.demoLevelsLeft == 0) {
            ApplicationData.demoExpired = true;
        }
        CGEngine.selectedRaceType = this.currentMenuElement;
        UIScreen.SetCurrentScreen(new LoadingLevelScreen());
        return true;
    }

    public boolean selectLeftAction() {
        UIButton uIButton = this.findByID(100);
        if (uIButton != null) {
            uIButton.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean selectRightAction() {
        UIButton uIButton = this.findByID(101);
        if (uIButton != null) {
            uIButton.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean actionSoftButton(int n, boolean bl) {
        if (super.actionSoftButton(n, bl)) {
            return true;
        }
        if (!bl) {
            this.unselectAllButtons();
            if (n == 100) {
                this.onLeftAction();
                return true;
            }
            if (n == 101) {
                this.onRightAction();
                return true;
            }
        }
        return false;
    }

    public boolean onRightAction() {
        ++this.currentMenuElement;
        if (this.currentMenuElement >= NUM_MENU_ELEMENTS) {
            this.currentMenuElement = 0;
        }
        this.updateScreenInfo();
        return true;
    }

    public boolean onLeftAction() {
        --this.currentMenuElement;
        if (this.currentMenuElement < 0) {
            this.currentMenuElement = NUM_MENU_ELEMENTS - 1;
        }
        this.updateScreenInfo();
        return true;
    }

    private void updateScreenInfo() {
        CGUserCareer.currentBabe = this.currentMenuElement;
        this.eventTexture = TextureManager.AddTexture("/event_" + (this.currentMenuElement + 1) + "_ico.png");
        this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        this.eventName = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_EVENT_NAME_" + this.currentMenuElement);
    }

    public boolean onFireAction() {
        return this.leftSoftButton();
    }
}

