/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gui.MainScreen;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;
import java.util.Vector;

public class CarUnlockScreen
extends MainScreen {
    private CGTexture icon;
    private Vector mainText;
    int textHeight;
    UIScreen nextScreen;

    public CarUnlockScreen(UIScreen uIScreen, int n) {
        this.drawLogo = false;
        this.nextScreen = uIScreen;
        this.updateInfoShown(n);
    }

    public void draw() {
        Graphic2D.DrawImage(this.icon, ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2, 33);
        int n = (ApplicationData.screenHeight - ObjectsCache.menuFooterImage.GetHeight() + this.icon.GetHeight()) / 2;
        this.drawMainText(ApplicationData.screenHeight / 2 + this.icon.GetHeight() / 10);
    }

    private void updateInfoShown(int n) {
        this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, null, null);
        String string = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_CAR_UNLOCK_" + (n + 1));
        this.mainText = Utils.splitText(string, "+", ApplicationData.screenWidth, 2);
        this.textHeight = (this.mainText.size() + 1) * ApplicationData.smallGreyFont.getFontHeight();
        this.icon = TextureManager.AddTexture("/car_" + (n + 1) + ".png");
        if (this.icon == null) {
            this.icon = TextureManager.AddTexture("/car_1.png");
        }
    }

    private void drawMainText(int n) {
        int n2 = ApplicationData.smallGreyFont.getFontHeight();
        Graphic2D.SetClip(0, 0, ApplicationData.screenWidth, ApplicationData.screenHeight);
        for (int i = 0; i < this.mainText.size(); ++i) {
            int n3 = n + i * n2 - this.mainText.size() * n2 / 2;
            Utils.drawString((String)this.mainText.elementAt(i), ApplicationData.screenWidth / 2, n3, 17, 2);
        }
    }

    public boolean leftSoftButton() {
        UIScreen.SetCurrentScreen(this.nextScreen);
        return true;
    }

    public boolean rightSoftButton() {
        return false;
    }
}

