/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIAnimatedButtonH;
import baltorogames.core_gui.UIButton;
import baltorogames.core_gui.UIScreen;
import baltorogames.project_gui.CarSelectionScreen;
import baltorogames.project_gui.HintScreen;
import baltorogames.project_gui.MainMenu;
import baltorogames.project_gui.MainScreen;
import baltorogames.project_gui.SelectTrack;
import baltorogames.project_gui.UICaptionThick;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;

public class SelectHotSeatPlayers
extends MainScreen {
    public int numberOfPlayers = SelectTrack.numHSplayers;
    private int MAX_NUM_HS_PLAYERS = 5;
    private final int LEFT_ARROW_ID;
    private final int RIGHT_ARROW_ID;

    public void autoSize() {
    }

    public SelectHotSeatPlayers() {
        this.LEFT_ARROW_ID = 100;
        this.RIGHT_ARROW_ID = 101;
        this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK);
        this.setCaptionThick(new UICaptionThick(ApplicationData.lp.getTranslatedString(Options.languageID, "ID_HOTSEAT")));
        int n = ApplicationData.screenHeight - 64 - 140;
        int n2 = n + 46;
        int n3 = ApplicationData.screenWidth / 2 - ObjectsCache.scrollRightWImg.GetWidth() * 2;
        int n4 = ApplicationData.screenWidth / 2 + ObjectsCache.scrollRightWImg.GetWidth();
        UIAnimatedButtonH uIAnimatedButtonH = new UIAnimatedButtonH(n3, n2, ObjectsCache.scrollLeftImg, ObjectsCache.scrollLeftWImg, 101);
        uIAnimatedButtonH.setScreen(this);
        uIAnimatedButtonH.setAnimDir(1);
        this.addButton(uIAnimatedButtonH);
        UIAnimatedButtonH uIAnimatedButtonH2 = new UIAnimatedButtonH(n4, n2, ObjectsCache.scrollRightImg, ObjectsCache.scrollRightWImg, 100);
        uIAnimatedButtonH2.setScreen(this);
        uIAnimatedButtonH2.setAnimDir(-1);
        this.addButton(uIAnimatedButtonH2);
    }

    public void draw() {
        int n = ApplicationData.screenHeight - 64 - 140 + 46;
        Utils.drawString(ApplicationData.defaultFont.encodeDynamicString("" + this.numberOfPlayers), ApplicationData.screenWidth / 2, n + ObjectsCache.scrollRightImg.GetHeight() / 2 - ApplicationData.defaultFont.getFontHeight() / 2, 17, 0);
        Utils.drawStringML(ApplicationData.lp.getTranslatedString(Options.languageID, "ID_SELECT_HS_PLAYERS"), ApplicationData.screenWidth / 2, n + ObjectsCache.scrollRightImg.GetHeight() * 2, 3, 0, ApplicationData.screenWidth);
    }

    public boolean leftSoftButton() {
        SelectTrack.numHSplayers = this.numberOfPlayers;
        UIScreen.SetCurrentScreen(new CarSelectionScreen());
        return true;
    }

    public boolean rightSoftButton() {
        HintScreen.showHintedScreen(this, new MainMenu(), HintScreen.ID_HINT_HOTSEAT, "GAME_TYPE_HOT_SEAT");
        return true;
    }

    public boolean selectLeftAction() {
        UIButton uIButton = this.findByID(100);
        if (uIButton != null) {
            uIButton.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean selectRightAction() {
        UIButton uIButton = this.findByID(101);
        if (uIButton != null) {
            uIButton.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean actionSoftButton(int n, boolean bl) {
        if (super.actionSoftButton(n, bl)) {
            return true;
        }
        if (!bl) {
            this.unselectAllButtons();
            if (n == 100) {
                this.onLeftAction();
                return true;
            }
            if (n == 101) {
                this.onRightAction();
                return true;
            }
        }
        return false;
    }

    public boolean onLeftAction() {
        --this.numberOfPlayers;
        if (this.numberOfPlayers < 2) {
            this.numberOfPlayers = this.MAX_NUM_HS_PLAYERS;
        }
        return true;
    }

    public boolean onRightAction() {
        ++this.numberOfPlayers;
        if (this.numberOfPlayers > this.MAX_NUM_HS_PLAYERS) {
            this.numberOfPlayers = 2;
        }
        return true;
    }

    public boolean onFireAction() {
        return this.leftSoftButton();
    }
}

