/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.TouchCommand;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIScreen;
import baltorogames.gameplay.Game;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.project_gui.MainHintTextBox;
import baltorogames.project_gui.MainScreen;
import baltorogames.project_gui.UICaptionThick;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;
import baltorogames.system.Platform;
import java.util.Vector;

public class HintScreen
extends MainScreen {
    public static int ID_HINT_HOTSEAT = 0;
    public static int ID_HINT_ENTER_CHAMPIONSHIPS = 1;
    public static int ID_HINT_ENTER_CAREER_SCREEN = 2;
    public static int ID_HINT_ENTER_GARAGE = 3;
    public static int ID_HINT_MULTIPLAYER = 4;
    public static int ID_HINT_ENTER_SINGLE_RACE = 5;
    public static int ID_HINT_ENTER_TIME_ATTACK = 6;
    public static int ID_HINT_LOCAL_RESULTS = 7;
    public static int ID_HINT_WORLD_RESULTS = 8;
    public static int ID_HINT_ENTER_SYNCHRONIZATION = 9;
    public static int ID_HINT_END_OF_CHAMPIONSHIPS = 10;
    public static int ID_GAME_OVER = 11;
    public static int ID_HINT_START_LEAGUE1 = 12;
    public static int ID_HINT_START_LEAGUE2 = 13;
    public static int ID_HINT_START_LEAGUE3 = 14;
    public static int ID_HINT_PROMOTED_TO_ADV_LEAGUE = 15;
    public static int ID_HINT_PROMOTED_TO_MAS_LEAGUE = 16;
    public static int ID_HINT_FAILED_TO_PROMOTE = 17;
    public static int ID_HINT_PROMOTED_TO_ADV_LEAGUEB = 18;
    public static int ID_HINT_PROMOTED_TO_MAS_LEAGUEB = 19;
    public static int ID_HINT_FAILED_CHAMPIONSHIPS = 20;
    public static int ID_HINT_GOLD_IN_CHAMPIONSHIPS = 21;
    public static int ID_HINT_NOT_IN_DEMO = 22;
    public static int ID_HINT_QUALIFICATIONS = 23;
    public static int ID_HINT_SPONSORED_KART_2 = 24;
    public static int ID_HINT_SPONSORED_KART_3 = 25;
    public static int ID_HINT_SILVER_IN_CHAMPIONSHIPS = 26;
    public static int ID_HINT_BRONZE_IN_CHAMPIONSHIPS = 27;
    public static int ID_HINT_NO_TROPHY_IN_CHAMPIONSHIPS = 28;
    public static int ID_HINT_WATCH_YOUR_TYRES = 29;
    public static int ID_HINT_WATCH_YOUR_DAMAGES = 30;
    public static int ID_HINT_YOU_DESTROYED_CAR = 31;
    public static int ID_HINT_YOUR_TYRES_EXPLODED = 32;
    private static final int MAX_NUM_HINTS = 33;
    public static String[] hintsTexts = new String[]{"ID_HINT_HOTSEAT", "ID_HINT_ENTER_CHAMPIONSHIPS", "ID_HINT_ENTER_CAREER_SCREEN", "ID_HINT_ENTER_GARAGE", "ID_HINT_MULTIPLAYER", "ID_HINT_ENTER_SINGLE_RACE", "ID_HINT_ENTER_TIME_ATTACK", "ID_HINT_LOCAL_RESULTS", "ID_HINT_WORLD_RESULTS", "ID_HINT_ENTER_SYNCHRONIZATION", "ID_HINT_END_OF_CHAMPIONSHIPS", "ID_GAME_OVER", "ID_HINT_START_LEAGUE1", "ID_HINT_START_LEAGUE2", "ID_HINT_START_LEAGUE3", "ID_HINT_PROMOTED_TO_NEXT_LEAGUE1", "ID_HINT_PROMOTED_TO_NEXT_LEAGUE2", "ID_HINT_FAILED_TO_PROMOTE", "ID_HINT_PROMOTED_TO_NEXT_LEAGUE1B", "ID_HINT_PROMOTED_TO_NEXT_LEAGUE2B", "ID_HINT_FAILED_CHAMPIONSHIPS", "ID_HINT_GOLD_IN_CHAMPIONSHIPS", "ID_HINT_NOT_IN_DEMO", "ID_HINT_QUALIFICATIONS", "ID_HINT_SPONSORED_KART1", "ID_HINT_SPONSORED_KART2", "ID_HINT_SILVER_IN_CHAMPIONSHIPS", "ID_HINT_BRONZE_IN_CHAMPIONSHIPS", "ID_HINT_NO_TROPHY_IN_CHAMPIONSHIPS", "ID_HINT_WATCH_YOUR_TYRES", "ID_HINT_WATCH_YOUR_DAMAGES", "ID_HINT_YOU_DESTROYED_CAR", "ID_HINT_YOUR_TYRES_EXPLODED"};
    UIScreen comeBackScreen;
    UIScreen nextScreen;
    int hintID;
    Vector mainText;
    private boolean scrollable = false;
    private final int SCROLL_SPEED;
    private int scrollOffset = 0;
    private int textHeight;
    private int askAreaHeight = 0;
    private int mainTextArea;

    public static void showHintedScreen(UIScreen uIScreen, UIScreen uIScreen2, int n, String string) {
        MainHintTextBox mainHintTextBox = new MainHintTextBox(uIScreen, uIScreen2, n, string);
        mainHintTextBox.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        mainHintTextBox.autoSize();
        mainHintTextBox.setBackground(false);
        mainHintTextBox.setText(ApplicationData.lp.getTranslatedString(Options.languageID, hintsTexts[n]));
        UIScreen.SetCurrentScreen(mainHintTextBox);
    }

    public HintScreen(UIScreen uIScreen, UIScreen uIScreen2, int n, String string) {
        this.SCROLL_SPEED = 1;
        this.init(uIScreen, uIScreen2, n, string);
    }

    public void init(UIScreen uIScreen, UIScreen uIScreen2, int n, String string) {
        this.comeBackScreen = uIScreen2;
        this.nextScreen = uIScreen;
        this.hintID = n;
        if (ApplicationData.generalGameMode == 4) {
            // empty if block
        }
        this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        this.setCaptionThick(new UICaptionThick(ApplicationData.lp.getTranslatedString(Options.languageID, string)));
        this.autoSize();
        this.mainTextArea = this.clientAreaHeight - this.askAreaHeight;
        this.mainText = Utils.splitText(ApplicationData.lp.getTranslatedString(Options.languageID, hintsTexts[this.hintID]), "+", ApplicationData.screenWidth, 2);
        this.textHeight = (this.mainText.size() + 1) * ApplicationData.smallGreyFont.getFontHeight();
        this.checkIfScrollsAreNeeded();
        this.mainText = Utils.splitText(ApplicationData.lp.getTranslatedString(Options.languageID, hintsTexts[this.hintID]), "+", ApplicationData.screenWidth - Platform.VSCROLLBARS_WIDTH, 2);
        this.textHeight = (this.mainText.size() + 1) * ApplicationData.smallGreyFont.getFontHeight() - ApplicationData.smallGreyFont.getFontSpacing();
    }

    public void draw() {
        int n = ApplicationData.screenHeight - 32;
        if (!this.scrollable) {
            Utils.drawString(this.mainText, ApplicationData.screenWidth >> 1, n - 42, 3, 2);
        } else {
            this.drawMainText(n);
        }
    }

    private boolean checkIfScrollsAreNeeded() {
        this.showScrollbars = this.scrollable = this.textHeight > this.mainTextArea;
        return this.scrollable;
    }

    private void drawMainText(int n) {
        int n2 = ApplicationData.smallGreyFont.getFontHeight();
        int n3 = 0;
        if (!this.scrollable) {
            n3 = (this.mainTextArea - n2 * this.mainText.size()) / 2;
        }
        Graphic2D.SetClip(this.positionX + Platform.WND_MARGIN_LEFT, this.positionY + Platform.WND_MARGIN_TOP + 1, this.width - Platform.WND_MARGIN_LEFT - Platform.WND_MARGIN_RIGHT, this.mainTextArea);
        for (int i = 0; i < this.mainText.size(); ++i) {
            int n4 = this.positionY + this.clientAreaY + i * n2 + this.scrollOffset + n3 + 1;
            if (n4 < 0 || n4 > ApplicationData.screenHeight) continue;
            if (!this.showScrollbars) {
                Utils.drawString((String)this.mainText.elementAt(i), this.positionX + this.width / 2, n4, 17, 2);
                continue;
            }
            Utils.drawString((String)this.mainText.elementAt(i), this.positionX + this.width / 2 - Platform.VSCROLLBARS_WIDTH / 2, n4, 17, 2);
        }
    }

    public boolean rightSoftButton() {
        if (this.comeBackScreen == null) {
            return false;
        }
        if (ApplicationData.generalGameMode == 4) {
            // empty if block
        }
        UIScreen.SetCurrentScreen(this.comeBackScreen);
        return true;
    }

    public boolean leftSoftButton() {
        if (this.nextScreen == null) {
            return false;
        }
        if (ApplicationData.generalGameMode == 4) {
            // empty if block
        }
        UIScreen.SetCurrentScreen(this.nextScreen);
        return true;
    }

    public void onUpdate(int n) {
        super.onUpdate(n);
        if (this.scrollable) {
            int n2;
            int n3;
            if (ApplicationData.isUpPressed() && this.scrollOffset < 0) {
                this.scrollOffset += n * 1 / 10;
            }
            if (ApplicationData.isDownPressed() && this.scrollOffset > (n3 = -(n2 = ApplicationData.smallGreyFont.getFontHeight()) * (this.mainText.size() + 1 - this.mainTextArea / n2))) {
                this.scrollOffset -= n * 1 / 10;
            }
        }
    }

    public void autoSize() {
        this.clientAreaX = Platform.WND_MARGIN_LEFT;
        this.clientAreaWidth = this.width - Platform.WND_MARGIN_LEFT - Platform.WND_MARGIN_RIGHT;
        this.clientAreaY = Platform.WND_MARGIN_TOP;
        this.clientAreaHeight = this.height - Platform.WND_MARGIN_TOP - Platform.WND_MARGIN_BOTTOM;
    }

    public boolean keyTouchEvent(TouchCommand touchCommand) {
        super.keyTouchEvent(touchCommand);
        if (touchCommand.onPressed == 1) {
            this.updateTouchKeyStates(touchCommand.areaX, touchCommand.areaY);
        } else {
            this.clearTouchKeyStates();
        }
        return true;
    }

    private void clearTouchKeyStates() {
        Game.rightTouchKeyPressed = false;
        Game.leftTouchKeyPressed = false;
        Game.downTouchKeyPressed = false;
        Game.upTouchKeyPressed = false;
    }

    private void updateTouchKeyStates(int n, int n2) {
        int n3 = ApplicationData.screenHeight - 32 - 85;
        int n4 = (ApplicationData.screenHeight + n3) / 2;
        if (n2 < n4) {
            Game.upTouchKeyPressed = true;
        } else {
            Game.downTouchKeyPressed = true;
        }
    }
}

