/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.project_gameplay.CGBillboardObject;
import baltorogames.project_gameplay.CGTrackNode;
import baltorogames.project_gameplay.CGTrackPiece;
import baltorogames.project_gameplay.FXUtility;
import baltorogames.project_gameplay.MathEx;
import baltorogames.project_gameplay.Matrix22FX;
import baltorogames.project_gameplay.Vector2FX;
import baltorogames.project_gameplay.Vector3FX;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;

class CGTrack {
    public static final int eTrackHalfHeight = 150;
    public static boolean m_bInvertTrackFlag = false;
    public static int m_nLastTrackIndex = -1;
    public static final long __DEFAULT_CAMERA_ANGLE__ = 12L;
    public long m_fxCameraAngle = 0L;
    public long m_fxCurrentCameraAngle = 4096000L;
    Vector3FX g_v3 = new Vector3FX();
    Vector2FX g_vvv = new Vector2FX();
    Vector arrCurrentPieces = new Vector(3, 2);
    Matrix22FX matTr = new Matrix22FX();
    Vector2FX vecIn = new Vector2FX();
    Vector2FX vecOut = new Vector2FX();
    Vector3FX vecPos3D = new Vector3FX();
    Matrix22FX g_matR = new Matrix22FX();
    public static long __MAX_DISTANCE__ = 50L;
    public static long __MAX_DELTA_ANGLE__ = 8192L;
    public long m_fxTrackFinishDist = 0L;
    public int m_nCurrentCheckPointIndex = 0;
    public int[] m_arrCheckPointsDistance = null;
    public int[] m_arrCheckPointsTime = null;
    public int m_nCurrentStoneIndex = 0;
    public int[] m_arrStonesDistance = new int[200];
    public long[] arrRadarDistance = new long[2];
    public CGTrackNode m_pFirstTrackNode = null;
    public CGTrackNode m_pSecondTrackNode;
    public CGTrackNode m_pThirdTrackNode;
    public CGTrackNode m_pFourthTrackNode;
    public long m_fxTrackLength;
    public CGTrackPiece[] m_arrTrackPieces;
    public Vector m_arrCurrentObjects = new Vector();
    public Vector2FX m_vecLastCameraDir = new Vector2FX();

    public CGTrackNode FindPlaceOnTrack(long l, long l2, CGTrackNode cGTrackNode, Vector2FX vector2FX, Vector2FX vector2FX2) {
        CGTrackNode cGTrackNode2 = cGTrackNode;
        if (cGTrackNode2 == null) {
            cGTrackNode2 = l < this.m_fxTrackLength / 4L + 204800L ? this.m_pFirstTrackNode : (l < this.m_fxTrackLength / 2L + 204800L ? this.m_pSecondTrackNode : (l < 3L * this.m_fxTrackLength / 4L + 204800L ? this.m_pThirdTrackNode : this.m_pFourthTrackNode));
        }
        CGTrackNode cGTrackNode3 = cGTrackNode2;
        while (true) {
            if (cGTrackNode2.m_fxDistanceFromStart > l) {
                cGTrackNode2 = cGTrackNode2.m_pPrev;
                break;
            }
            if (cGTrackNode2.m_pNext == null || cGTrackNode2.m_pNext.m_fxDistanceFromStart <= cGTrackNode2.m_fxDistanceFromStart) break;
            cGTrackNode2 = cGTrackNode2.m_pNext;
        }
        if (cGTrackNode2 == null) {
            return null;
        }
        long l3 = l - cGTrackNode2.m_fxDistanceFromStart;
        vector2FX2.x = cGTrackNode2.m_pNext.m_fxX - cGTrackNode2.m_fxX;
        vector2FX2.y = cGTrackNode2.m_pNext.m_fxZ - cGTrackNode2.m_fxZ;
        vector2FX2.Normalize();
        vector2FX.x = cGTrackNode2.m_fxX + l3 * vector2FX2.x / 4096L;
        vector2FX.y = cGTrackNode2.m_fxZ + l3 * vector2FX2.y / 4096L;
        vector2FX.x += l2 * 150L * vector2FX2.y / 4096L;
        vector2FX.y += l2 * 150L * -vector2FX2.x / 4096L;
        return cGTrackNode2;
    }

    public CGTrackNode FindPlaceOnTrack3D(long l, long l2, CGTrackNode cGTrackNode, Vector3FX vector3FX, Vector2FX vector2FX) {
        CGTrackNode cGTrackNode2 = cGTrackNode;
        if (cGTrackNode2 == null) {
            cGTrackNode2 = l < this.m_fxTrackLength / 4L + 204800L ? this.m_pFirstTrackNode : (l < this.m_fxTrackLength / 2L + 204800L ? this.m_pSecondTrackNode : (l < 3L * this.m_fxTrackLength / 4L + 204800L ? this.m_pThirdTrackNode : this.m_pFourthTrackNode));
        }
        CGTrackNode cGTrackNode3 = cGTrackNode2;
        while (true) {
            if (cGTrackNode2.m_fxDistanceFromStart > l) {
                cGTrackNode2 = cGTrackNode2.m_pPrev;
                break;
            }
            if (cGTrackNode2.m_pNext == null || cGTrackNode2.m_pNext.m_fxDistanceFromStart <= cGTrackNode2.m_fxDistanceFromStart) break;
            cGTrackNode2 = cGTrackNode2.m_pNext;
        }
        if (cGTrackNode2 == null) {
            return null;
        }
        long l3 = l - cGTrackNode2.m_fxDistanceFromStart;
        this.g_v3.x = cGTrackNode2.m_pNext.m_fxX - cGTrackNode2.m_fxX;
        this.g_v3.y = cGTrackNode2.m_pNext.m_fxY - cGTrackNode2.m_fxY;
        this.g_v3.z = cGTrackNode2.m_pNext.m_fxZ - cGTrackNode2.m_fxZ;
        this.g_v3.Normalize();
        vector3FX.x = cGTrackNode2.m_fxX + l3 * this.g_v3.x / 4096L;
        vector3FX.y = cGTrackNode2.m_fxY + l3 * this.g_v3.y / 4096L;
        vector3FX.z = cGTrackNode2.m_fxZ + l3 * this.g_v3.z / 4096L;
        vector2FX.x = cGTrackNode2.m_pNext.m_fxX - cGTrackNode2.m_fxX;
        vector2FX.y = cGTrackNode2.m_pNext.m_fxZ - cGTrackNode2.m_fxZ;
        vector2FX.Normalize();
        this.g_vvv.y = Math.abs(cGTrackNode2.m_pNext.m_fxDistanceFromStart - cGTrackNode2.m_fxDistanceFromStart);
        this.g_vvv.x = cGTrackNode2.m_pNext.m_fxY - cGTrackNode2.m_fxY;
        this.g_vvv.Normalize();
        long l4 = Vector2FX.AngleFromVector(this.g_vvv);
        this.m_fxCameraAngle = l4 - 49152L;
        if (this.m_fxCameraAngle > 737280L) {
            this.m_fxCameraAngle -= 1474560L;
        }
        vector3FX.x += l2 * 150L * vector2FX.y / 4096L;
        vector3FX.z += l2 * 150L * -vector2FX.x / 4096L;
        return cGTrackNode2;
    }

    public CGTrackNode PrepareTrackForCamera(long l, long l2, CGTrackNode cGTrackNode, long l3, Vector2FX vector2FX, Vector2FX vector2FX2, CGBillboardObject[] cGBillboardObjectArray, int n) {
        int n2;
        int n3;
        CGTrackNode cGTrackNode2 = this.FindPlaceOnTrack3D(l, l2, cGTrackNode, this.vecPos3D, vector2FX2);
        if (cGTrackNode2 == null) {
            return null;
        }
        if (this.m_fxCurrentCameraAngle == 4096000L) {
            this.m_fxCurrentCameraAngle = this.m_fxCameraAngle;
        } else {
            if (this.m_fxCurrentCameraAngle > 737280L) {
                this.m_fxCurrentCameraAngle -= 1474560L;
            }
            if (Math.abs(this.m_fxCurrentCameraAngle - this.m_fxCameraAngle) > 49152L) {
                this.m_fxCameraAngle = this.m_fxCameraAngle > this.m_fxCurrentCameraAngle ? this.m_fxCurrentCameraAngle + 49152L : this.m_fxCurrentCameraAngle - 49152L;
            }
            this.m_fxCurrentCameraAngle = (3L * this.m_fxCurrentCameraAngle + this.m_fxCameraAngle) / 4L;
            if (this.m_fxCurrentCameraAngle < 0L) {
                this.m_fxCurrentCameraAngle += 1474560L;
                if (this.m_fxCurrentCameraAngle < 0L) {
                    this.m_fxCurrentCameraAngle += 1474560L;
                }
            } else if (this.m_fxCurrentCameraAngle >= 1474560L) {
                this.m_fxCurrentCameraAngle -= 1474560L;
                if (this.m_fxCurrentCameraAngle >= 1474560L) {
                    this.m_fxCurrentCameraAngle -= 1474560L;
                }
            }
            if (this.m_fxCurrentCameraAngle > 737280L && this.m_fxCurrentCameraAngle < 0x140000L) {
                this.m_fxCurrentCameraAngle = 0x140000L;
            }
            if (this.m_fxCurrentCameraAngle < 737280L && this.m_fxCurrentCameraAngle > 122880L) {
                this.m_fxCurrentCameraAngle = 122880L;
            }
        }
        this.vecPos3D.y += 20480L;
        if (this.m_vecLastCameraDir.x > -40960L) {
            vector2FX2.x = (4096L * vector2FX2.x + 4096L * this.m_vecLastCameraDir.x) / 8192L;
            vector2FX2.y = (4096L * vector2FX2.y + 4096L * this.m_vecLastCameraDir.y) / 8192L;
            vector2FX2.Normalize();
        }
        this.m_vecLastCameraDir.x = vector2FX2.x;
        this.m_vecLastCameraDir.y = vector2FX2.y;
        this.arrCurrentPieces.removeAllElements();
        Matrix22FX.GetTransformMatrix(vector2FX2, this.matTr);
        CGTrackNode cGTrackNode3 = cGTrackNode2;
        if (cGTrackNode3.m_pPrev != null) {
            cGTrackNode3 = cGTrackNode3.m_pPrev;
        }
        this.arrCurrentPieces.addElement(cGTrackNode3.m_pTrackPiece);
        CGTrackPiece cGTrackPiece = cGTrackNode3.m_pTrackPiece;
        CGTrackNode cGTrackNode4 = cGTrackNode3;
        int n4 = 0;
        long l4 = 0L;
        while (true) {
            this.vecIn.x = cGTrackNode3.m_fxX - this.vecPos3D.x;
            this.vecIn.y = cGTrackNode3.m_fxZ - this.vecPos3D.z;
            this.matTr.MatrixF22_Mul_VectorF2(this.vecIn, this.vecOut);
            cGTrackNode3.m_fxTrX = this.vecOut.x;
            cGTrackNode3.m_fxTrY = cGTrackNode3.m_fxY - this.vecPos3D.y;
            cGTrackNode3.m_fxTrZ = this.vecOut.y;
            this.g_matR.MatrixF22_Rot(this.m_fxCurrentCameraAngle);
            this.vecIn.x = cGTrackNode3.m_fxTrY;
            this.vecIn.y = cGTrackNode3.m_fxTrZ;
            this.g_matR.MatrixF22_Mul_VectorF2(this.vecIn, this.vecOut);
            cGTrackNode3.m_fxTrY = this.vecOut.x;
            cGTrackNode3.m_fxTrZ = this.vecOut.y;
            if (cGTrackNode3.m_pTrackPiece != cGTrackPiece) {
                this.arrCurrentPieces.addElement(cGTrackNode3.m_pTrackPiece);
                cGTrackPiece = cGTrackNode3.m_pTrackPiece;
            }
            if (cGTrackNode3.m_fxTrZ > l3 || l4 > l3 || cGTrackNode3.m_pNext == null || cGTrackNode3.m_pNext == cGTrackNode4) break;
            cGTrackNode3 = cGTrackNode3.m_pNext;
            ++n4;
            l4 += cGTrackNode3.m_fxDistanceFromPrev;
        }
        this.m_arrCurrentObjects.removeAllElements();
        for (n3 = 0; n3 < n; ++n3) {
            this.m_arrCurrentObjects.addElement(cGBillboardObjectArray[n3]);
        }
        n3 = this.arrCurrentPieces.size();
        for (n2 = 0; n2 < n3; ++n2) {
            int n5 = ((CGTrackPiece)this.arrCurrentPieces.elementAt(n2)).GetObjectsSize();
            for (int i = 0; i < n5; ++i) {
                this.m_arrCurrentObjects.addElement(((CGTrackPiece)this.arrCurrentPieces.elementAt(n2)).GetObject(i));
            }
        }
        n3 = this.m_arrCurrentObjects.size();
        for (n2 = 0; n2 < n3; ++n2) {
            CGBillboardObject cGBillboardObject = (CGBillboardObject)this.m_arrCurrentObjects.elementAt(n2);
            this.vecIn.x = cGBillboardObject.m_fxX - this.vecPos3D.x;
            this.vecIn.y = cGBillboardObject.m_fxZ - this.vecPos3D.z;
            this.matTr.MatrixF22_Mul_VectorF2(this.vecIn, this.vecOut);
            cGBillboardObject.m_fxTrX = this.vecOut.x;
            cGBillboardObject.m_fxTrY = cGBillboardObject.m_fxY - this.vecPos3D.y;
            cGBillboardObject.m_fxTrZ = this.vecOut.y;
            this.g_matR.MatrixF22_Rot(this.m_fxCurrentCameraAngle);
            this.vecIn.x = cGBillboardObject.m_fxTrY;
            this.vecIn.y = cGBillboardObject.m_fxTrZ;
            this.g_matR.MatrixF22_Mul_VectorF2(this.vecIn, this.vecOut);
            cGBillboardObject.m_fxTrY = this.vecOut.x;
            cGBillboardObject.m_fxTrZ = this.vecOut.y;
        }
        return cGTrackNode2;
    }

    public long GetVelocityFactorForDistance(long l, long l2, CGTrackNode cGTrackNode, Vector2FX vector2FX, Vector2FX vector2FX2) {
        CGTrackNode cGTrackNode2 = this.FindPlaceOnTrack(l, l2, cGTrackNode, vector2FX, vector2FX2);
        if (cGTrackNode2 == null) {
            return 4096L;
        }
        cGTrackNode = cGTrackNode2;
        return (cGTrackNode2.m_fxVelocityFactor + cGTrackNode2.m_pNext.m_fxVelocityFactor + cGTrackNode2.m_pNext.m_pNext.m_fxVelocityFactor + cGTrackNode2.m_pNext.m_pNext.m_pNext.m_fxVelocityFactor) / 4L;
    }

    public CGTrackNode GetXForZ(long l, CGTrackNode cGTrackNode, Vector2FX vector2FX) {
        CGTrackNode cGTrackNode2 = cGTrackNode;
        int n = 0;
        while (cGTrackNode2.m_fxTrZ <= l) {
            cGTrackNode2 = cGTrackNode2.m_pNext;
            if (++n <= 60) continue;
            return null;
        }
        long l2 = cGTrackNode2.m_pPrev.m_fxTrX;
        long l3 = cGTrackNode2.m_pPrev.m_fxTrY;
        long l4 = cGTrackNode2.m_pPrev.m_fxTrZ;
        long l5 = cGTrackNode2.m_fxTrX;
        long l6 = cGTrackNode2.m_fxTrY;
        long l7 = cGTrackNode2.m_fxTrZ;
        vector2FX.x = ((l5 - l2) * (l - l4) + l2 * (l7 - l4)) / (l7 - l4);
        vector2FX.y = ((l6 - l3) * (l - l4) + l3 * (l7 - l4)) / (l7 - l4);
        return cGTrackNode2.m_pPrev;
    }

    long GetZForRay(long l, long l2, long l3, long l4, CGTrackNode cGTrackNode) {
        CGTrackNode cGTrackNode2 = this.m_pFirstTrackNode;
        if (cGTrackNode != null) {
            cGTrackNode2 = cGTrackNode;
        }
        CGTrackNode cGTrackNode3 = cGTrackNode2;
        do {
            if ((float)cGTrackNode2.m_fxTrZ >= 0.0f || cGTrackNode2.m_pNext.m_fxTrZ >= 0L) {
                if (cGTrackNode2.m_fxTrZ < cGTrackNode2.m_pNext.m_fxTrZ) {
                    long l5 = MathEx.CheckSections(l, l2, l3, l4, cGTrackNode2.m_fxTrY, cGTrackNode2.m_fxTrZ, cGTrackNode2.m_pNext.m_fxTrY, cGTrackNode2.m_pNext.m_fxTrZ);
                    if (l5 >= 0L) {
                        return l2 + l5 * (l4 - l2) / 4096L;
                    }
                } else {
                    int n = 0;
                    ++n;
                }
            }
            if (cGTrackNode2.m_fxTrZ <= 3686400L) continue;
            return -4096L;
        } while ((cGTrackNode2 = cGTrackNode2.m_pNext) != null && cGTrackNode2 != cGTrackNode3);
        return -4096L;
    }

    protected void DeleteTrack() {
        this.m_pFirstTrackNode = null;
    }

    protected void InitFirstNode(long l, long l2, long l3, CGTrackPiece cGTrackPiece) {
        this.m_pFirstTrackNode = new CGTrackNode();
        this.m_pFirstTrackNode.m_fxX = l;
        this.m_pFirstTrackNode.m_fxY = l2;
        this.m_pFirstTrackNode.m_fxZ = l3;
        this.m_pFirstTrackNode.m_fxDistanceFromStart = 0L;
        this.m_pFirstTrackNode.m_pNext = null;
        this.m_pFirstTrackNode.m_pPrev = null;
        this.m_pFirstTrackNode.m_pTrackPiece = cGTrackPiece;
        this.m_pFirstTrackNode.m_fxVelocityFactor = 4096L;
        this.m_fxTrackLength = 0L;
        this.m_vecLastCameraDir.x = -409600L;
        this.m_vecLastCameraDir.y = -409600L;
    }

    protected int GetNodesSize() {
        if (this.m_pFirstTrackNode == null) {
            return 0;
        }
        int n = 1;
        CGTrackNode cGTrackNode = this.m_pFirstTrackNode;
        while (cGTrackNode.m_pNext != null && cGTrackNode.m_pNext != this.m_pFirstTrackNode) {
            cGTrackNode = cGTrackNode.m_pNext;
            ++n;
        }
        return n;
    }

    CGTrackNode FindFirstNodeOfTrackPiece(CGTrackPiece cGTrackPiece) {
        if (this.m_pFirstTrackNode == null) {
            return null;
        }
        CGTrackNode cGTrackNode = this.m_pFirstTrackNode;
        do {
            if (cGTrackNode.m_pTrackPiece != cGTrackPiece) continue;
            return cGTrackNode;
        } while ((cGTrackNode = cGTrackNode.m_pNext) != null);
        return null;
    }

    CGTrackNode GetNode(int n) {
        if (this.m_pFirstTrackNode == null) {
            return null;
        }
        int n2 = 0;
        CGTrackNode cGTrackNode = this.m_pFirstTrackNode;
        while (n2 != n) {
            cGTrackNode = cGTrackNode.m_pNext;
            if (cGTrackNode == null) {
                return null;
            }
            ++n2;
        }
        return cGTrackNode;
    }

    protected CGTrackNode GetLastNode() {
        if (this.m_pFirstTrackNode == null) {
            return null;
        }
        CGTrackNode cGTrackNode = this.m_pFirstTrackNode;
        while (cGTrackNode.m_pNext != null && cGTrackNode.m_pNext != this.m_pFirstTrackNode) {
            cGTrackNode = cGTrackNode.m_pNext;
        }
        return cGTrackNode;
    }

    protected CGTrackNode AddNode(long l, long l2, long l3) {
        if (this.m_pFirstTrackNode == null) {
            System.out.println("ERROR: m_pFirstTrackNode is null...");
        }
        CGTrackNode cGTrackNode = this.m_pFirstTrackNode;
        while (cGTrackNode.m_pNext != null) {
            cGTrackNode = cGTrackNode.m_pNext;
        }
        long l4 = FXUtility.Sqrt((l - cGTrackNode.m_fxX) * (l - cGTrackNode.m_fxX) / 4096L + (l2 - cGTrackNode.m_fxY) * (l2 - cGTrackNode.m_fxY) / 4096L + (l3 - cGTrackNode.m_fxZ) * (l3 - cGTrackNode.m_fxZ) / 4096L);
        cGTrackNode.m_pNext = new CGTrackNode();
        cGTrackNode.m_pNext.m_fxX = l;
        cGTrackNode.m_pNext.m_fxY = l2;
        cGTrackNode.m_pNext.m_fxZ = l3;
        cGTrackNode.m_pNext.m_fxVelocityFactor = 4096L;
        cGTrackNode.m_pNext.m_fxDistanceFromStart = cGTrackNode.m_fxDistanceFromStart + l4;
        cGTrackNode.m_pNext.m_fxDistanceFromPrev = l4;
        cGTrackNode.m_pNext.m_pNext = null;
        cGTrackNode.m_pNext.m_pPrev = cGTrackNode;
        this.m_fxTrackLength = cGTrackNode.m_pNext.m_fxDistanceFromStart;
        return cGTrackNode.m_pNext;
    }

    protected void AddStraightLine(long l, long l2, CGTrackPiece cGTrackPiece) {
        int n = this.GetNodesSize();
        if (n == 0) {
            this.InitFirstNode(0L, 0L, 0L, cGTrackPiece);
            n = 1;
        }
        long l3 = this.GetLastNode().m_fxX;
        long l4 = this.GetLastNode().m_fxY;
        long l5 = this.GetLastNode().m_fxZ;
        long l6 = __MAX_DISTANCE__ * 4096L;
        int n2 = (int)(l / l6);
        long l7 = 0L;
        long l8 = l4;
        if (n == 1) {
            do {
                if ((l7 += l6) > l) {
                    l7 = l;
                }
                long l9 = 4096L * l7 / l;
                long l10 = this.GetBezierValueFor(l9);
                l8 = l10 * l2 / 4096L;
                CGTrackNode cGTrackNode = this.AddNode(0L, l4 + l8, l7);
                cGTrackNode.m_pTrackPiece = cGTrackPiece;
            } while (l7 < l);
        } else {
            CGTrackNode cGTrackNode = this.GetNode(n - 2);
            CGTrackNode cGTrackNode2 = this.GetNode(n - 1);
            Vector2FX vector2FX = new Vector2FX();
            vector2FX.x = cGTrackNode2.m_fxX - cGTrackNode.m_fxX;
            vector2FX.y = cGTrackNode2.m_fxZ - cGTrackNode.m_fxZ;
            vector2FX.Normalize();
            do {
                if ((l7 += l6) > l) {
                    l7 = l;
                }
                long l11 = 4096L * l7 / l;
                long l12 = this.GetBezierValueFor(l11);
                l8 = l12 * l2 / 4096L;
                CGTrackNode cGTrackNode3 = this.AddNode(cGTrackNode2.m_fxX + vector2FX.x * l7 / 4096L, cGTrackNode2.m_fxY + l8, cGTrackNode2.m_fxZ + vector2FX.y * l7 / 4096L);
                cGTrackNode3.m_pTrackPiece = cGTrackPiece;
            } while (l7 < l);
        }
    }

    protected void AddCurveLine(long l, long l2, long l3, CGTrackPiece cGTrackPiece) {
        Object object;
        long l4 = l * 4096L / __MAX_DELTA_ANGLE__;
        long l5 = FXUtility.abs(l2 * 4096L / l4);
        int n = this.GetNodesSize();
        long l6 = 0L;
        if (n == 0) {
            this.InitFirstNode(0L, 0L, 0L, cGTrackPiece);
            n = 1;
        }
        if (n != 1) {
            CGTrackNode cGTrackNode = this.GetNode(n - 2);
            CGTrackNode cGTrackNode2 = this.GetNode(n - 1);
            object = new Vector2FX();
            ((Vector2FX)object).x = cGTrackNode2.m_fxX - cGTrackNode.m_fxX;
            ((Vector2FX)object).y = cGTrackNode2.m_fxZ - cGTrackNode.m_fxZ;
            ((Vector2FX)object).Normalize();
            l6 = Vector2FX.AngleFromVector((Vector2FX)object);
        }
        long l7 = l6 + l;
        object = this.GetNode(n - 1);
        CGTrackNode cGTrackNode = this.GetNode(n - 1);
        long l8 = 0L;
        while (true) {
            l8 += __MAX_DELTA_ANGLE__;
            if (l > 0L ? (l6 += __MAX_DELTA_ANGLE__) > l7 : (l6 -= __MAX_DELTA_ANGLE__) < l7) break;
            Vector2FX vector2FX = new Vector2FX();
            Vector2FX.VectorFromAngle(l6, vector2FX);
            long l9 = 4096L * l8 / Math.abs(l);
            long l10 = this.GetBezierValueFor(l9);
            long l11 = l10 * l3 / 4096L;
            CGTrackNode cGTrackNode3 = this.AddNode(cGTrackNode.m_fxX + vector2FX.x * l5 / 4096L, ((CGTrackNode)object).m_fxY + l11, cGTrackNode.m_fxZ + vector2FX.y * l5 / 4096L);
            cGTrackNode3.m_pTrackPiece = cGTrackPiece;
            if (FXUtility.abs(cGTrackNode3.m_fxX - this.m_pFirstTrackNode.m_fxX) < 819L && FXUtility.abs(cGTrackNode3.m_fxY - this.m_pFirstTrackNode.m_fxY) < 819L && FXUtility.abs(cGTrackNode3.m_fxZ - this.m_pFirstTrackNode.m_fxZ) < 819L) {
                CGTrackNode cGTrackNode4 = cGTrackNode3.m_pPrev;
                cGTrackNode4.m_pNext = this.m_pFirstTrackNode;
                this.m_pFirstTrackNode.m_pPrev = cGTrackNode4;
                long l12 = FXUtility.Sqrt((cGTrackNode4.m_fxX - this.m_pFirstTrackNode.m_fxX) * (cGTrackNode4.m_fxX - this.m_pFirstTrackNode.m_fxX) / 4096L + (cGTrackNode4.m_fxZ - this.m_pFirstTrackNode.m_fxZ) * (cGTrackNode4.m_fxZ - this.m_pFirstTrackNode.m_fxZ) / 4096L);
                this.m_fxTrackLength = cGTrackNode4.m_fxDistanceFromStart + l12;
                break;
            }
            cGTrackNode = cGTrackNode3;
        }
    }

    protected void AddBezierCurve(int n, CGTrackPiece cGTrackPiece) {
        long l;
        int n2 = this.GetNodesSize();
        if (n2 < 2) {
            return;
        }
        CGTrackNode cGTrackNode = this.GetLastNode();
        Vector3FX vector3FX = new Vector3FX();
        vector3FX.x = cGTrackNode.m_fxX;
        vector3FX.y = cGTrackNode.m_fxY;
        vector3FX.z = cGTrackNode.m_fxZ;
        Vector3FX vector3FX2 = new Vector3FX();
        vector3FX2.x = this.m_pFirstTrackNode.m_fxX;
        vector3FX2.y = this.m_pFirstTrackNode.m_fxY;
        vector3FX2.z = this.m_pFirstTrackNode.m_fxZ;
        Vector3FX vector3FX3 = new Vector3FX();
        vector3FX3.x = vector3FX2.x - vector3FX.x;
        vector3FX3.y = vector3FX2.y - vector3FX.y;
        vector3FX3.z = vector3FX2.z - vector3FX.z;
        long l2 = vector3FX3.Normalize();
        Vector3FX vector3FX4 = new Vector3FX();
        vector3FX4.x = vector3FX.x - cGTrackNode.m_pPrev.m_fxX;
        vector3FX4.y = vector3FX.y - cGTrackNode.m_pPrev.m_fxY;
        vector3FX4.z = vector3FX.z - cGTrackNode.m_pPrev.m_fxZ;
        vector3FX4.Normalize();
        vector3FX4.x *= 1638L * l2 / 4096L;
        vector3FX4.x /= 4096L;
        vector3FX4.y *= 1638L * l2 / 4096L;
        vector3FX4.y /= 4096L;
        vector3FX4.z *= 1638L * l2 / 4096L;
        vector3FX4.z /= 4096L;
        vector3FX4.x += vector3FX.x;
        vector3FX4.y += vector3FX.y;
        vector3FX4.z += vector3FX.z;
        Vector3FX vector3FX5 = new Vector3FX();
        vector3FX5.x = vector3FX2.x - this.m_pFirstTrackNode.m_pNext.m_fxX;
        vector3FX5.y = vector3FX2.y - this.m_pFirstTrackNode.m_pNext.m_fxY;
        vector3FX5.z = vector3FX2.z - this.m_pFirstTrackNode.m_pNext.m_fxZ;
        vector3FX5.Normalize();
        vector3FX5.x *= 1638L * l2 / 4096L;
        vector3FX5.x /= 4096L;
        vector3FX5.y *= 1638L * l2 / 4096L;
        vector3FX5.y /= 4096L;
        vector3FX5.z *= 1638L * l2 / 4096L;
        vector3FX5.z /= 4096L;
        vector3FX5.x += vector3FX2.x;
        vector3FX5.y += vector3FX2.y;
        vector3FX5.z += vector3FX2.z;
        long l3 = vector3FX.x;
        long l4 = vector3FX.y;
        long l5 = vector3FX.z;
        long l6 = 8192L;
        long l7 = l6 / 10L;
        for (long i = l = (long)(4096 / n); i <= 4096L; i += l) {
            long l8 = i * i / 4096L;
            long l9 = i * l8 / 4096L;
            long l10 = 4096L - i;
            long l11 = l10 * l10 / 4096L;
            long l12 = l10 * l11 / 4096L;
            long l13 = l12 * vector3FX.x + 3L * i * l11 * vector3FX4.x / 4096L + 3L * l8 * l10 * vector3FX5.x / 4096L + l9 * vector3FX2.x;
            long l14 = l12 * vector3FX.y + 3L * i * l11 * vector3FX4.y / 4096L + 3L * l8 * l10 * vector3FX5.y / 4096L + l9 * vector3FX2.y;
            long l15 = l12 * vector3FX.z + 3L * i * l11 * vector3FX4.z / 4096L + 3L * l8 * l10 * vector3FX5.z / 4096L + l9 * vector3FX2.z;
            long l16 = FXUtility.Sqrt(((l13 /= 4096L) - l3) * (l13 - l3) / 4096L + ((l15 /= 4096L) - l5) * (l15 - l5) / 4096L);
            l3 = l13;
            l4 = l14 /= 4096L;
            l5 = l15;
            CGTrackNode cGTrackNode2 = this.AddNode(l13, l14, l15);
            cGTrackNode2.m_pTrackPiece = cGTrackPiece;
            long l17 = FXUtility.Sqrt((cGTrackNode2.m_fxX - this.m_pFirstTrackNode.m_fxX) * (cGTrackNode2.m_fxX - this.m_pFirstTrackNode.m_fxX) / 4096L + (cGTrackNode2.m_fxZ - this.m_pFirstTrackNode.m_fxZ) * (cGTrackNode2.m_fxZ - this.m_pFirstTrackNode.m_fxZ) / 4096L);
            if (l17 > 122880L) continue;
            CGTrackNode cGTrackNode3 = cGTrackNode2.m_pPrev;
            l17 = FXUtility.Sqrt((cGTrackNode3.m_fxX - this.m_pFirstTrackNode.m_fxX) * (cGTrackNode3.m_fxX - this.m_pFirstTrackNode.m_fxX) / 4096L + (cGTrackNode3.m_fxZ - this.m_pFirstTrackNode.m_fxZ) * (cGTrackNode3.m_fxZ - this.m_pFirstTrackNode.m_fxZ) / 4096L);
            this.m_fxTrackLength = cGTrackNode3.m_fxDistanceFromStart + l17;
            cGTrackNode3.m_pNext = this.m_pFirstTrackNode;
            this.m_pFirstTrackNode.m_pPrev = cGTrackNode3;
            this.m_pFirstTrackNode.m_fxDistanceFromPrev = l17;
            return;
        }
    }

    long GetBezierValueFor(long l) {
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 4096L;
        long l5 = 4096L;
        long l6 = l3;
        long l7 = l5;
        if (l <= 0L) {
            return l3;
        }
        if (l >= 4096L) {
            return l5;
        }
        long l8 = l;
        long l9 = l8 * l8 / 4096L;
        long l10 = l8 * l9 / 4096L;
        long l11 = 4096L - l8;
        long l12 = l11 * l11 / 4096L;
        long l13 = l11 * l12 / 4096L;
        long l14 = l13 * l3 + 3L * l8 * l12 * l6 / 4096L + 3L * l9 * l11 * l7 / 4096L + l10 * l5;
        return l14 /= 4096L;
    }

    protected void CreateTrackFromPieces() {
        System.out.println("CreateTrackFromPieces...");
        int n = 3;
        int n2 = 10;
        this.DeleteTrack();
        int n3 = this.m_arrTrackPieces.length;
        for (int i = 0; i < n3; ++i) {
            CGTrackPiece cGTrackPiece = this.m_arrTrackPieces[i];
            if (cGTrackPiece.m_nPieceType == CGTrackPiece.TRACK_PIECE_LINE) {
                this.AddStraightLine(cGTrackPiece.m_nPieceLength * 4096, cGTrackPiece.m_nPieceHeight * 4096, cGTrackPiece);
                continue;
            }
            if (cGTrackPiece.m_nPieceType == CGTrackPiece.TRACK_PIECE_TURN) {
                this.AddCurveLine(cGTrackPiece.m_nPieceAngle * 4096, cGTrackPiece.m_nPieceLength * 4096, cGTrackPiece.m_nPieceHeight * 4096, cGTrackPiece);
                continue;
            }
            if (cGTrackPiece.m_nPieceType != CGTrackPiece.TRACK_PIECE_BEZIER) continue;
            this.AddBezierCurve(cGTrackPiece.m_nPieceBezierSize, cGTrackPiece);
        }
        this.m_fxTrackLength = this.m_pFirstTrackNode.m_pPrev.m_fxDistanceFromStart + FXUtility.Sqrt((this.m_pFirstTrackNode.m_fxX - this.m_pFirstTrackNode.m_pPrev.m_fxX) * (this.m_pFirstTrackNode.m_fxX - this.m_pFirstTrackNode.m_pPrev.m_fxX) / 4096L + (this.m_pFirstTrackNode.m_fxZ - this.m_pFirstTrackNode.m_pPrev.m_fxZ) * (this.m_pFirstTrackNode.m_fxZ - this.m_pFirstTrackNode.m_pPrev.m_fxZ) / 4096L);
        System.out.println("CalculateVelocityFactors...");
        this.CalculateVelocityFactors();
        System.out.println("...OK");
    }

    void SetFinishDistance(long l) {
        this.m_fxTrackFinishDist = l;
        this.arrRadarDistance[0] = this.m_fxTrackFinishDist / 3L;
        this.arrRadarDistance[1] = 2L * this.m_fxTrackFinishDist / 3L;
    }

    protected void CalculateVelocityFactors() {
        this.m_pSecondTrackNode = null;
        this.m_pThirdTrackNode = null;
        this.m_pFourthTrackNode = null;
        CGTrackNode cGTrackNode = this.m_pFirstTrackNode;
        while (true) {
            boolean bl = false;
            if (cGTrackNode.m_pNext == null || cGTrackNode.m_pNext == this.m_pFirstTrackNode) {
                bl = true;
            }
            if (this.m_pSecondTrackNode == null && cGTrackNode.m_fxDistanceFromStart > this.m_fxTrackLength / 4L) {
                this.m_pSecondTrackNode = cGTrackNode.m_pPrev.m_pPrev.m_pPrev;
            }
            if (this.m_pThirdTrackNode == null && cGTrackNode.m_fxDistanceFromStart > this.m_fxTrackLength / 2L) {
                this.m_pThirdTrackNode = cGTrackNode.m_pPrev.m_pPrev.m_pPrev;
            }
            if (this.m_pFourthTrackNode == null && cGTrackNode.m_fxDistanceFromStart > 3L * this.m_fxTrackLength / 4L) {
                this.m_pFourthTrackNode = cGTrackNode.m_pPrev.m_pPrev.m_pPrev;
            }
            long l = 4096L;
            if (cGTrackNode.m_pPrev != null && cGTrackNode.m_pNext != null) {
                Vector2FX vector2FX = new Vector2FX();
                vector2FX.x = cGTrackNode.m_fxX - cGTrackNode.m_pPrev.m_fxX;
                vector2FX.y = cGTrackNode.m_fxZ - cGTrackNode.m_pPrev.m_fxZ;
                long l2 = vector2FX.Normalize();
                Vector2FX vector2FX2 = new Vector2FX();
                vector2FX2.x = cGTrackNode.m_pNext.m_fxX - cGTrackNode.m_fxX;
                vector2FX2.y = cGTrackNode.m_pNext.m_fxZ - cGTrackNode.m_fxZ;
                long l3 = vector2FX2.Normalize();
                long l4 = (vector2FX.x * vector2FX2.x + vector2FX.y * vector2FX2.y) / 4096L;
                if ((l4 = FXUtility.ArcCos(l4)) > 737280L) {
                    l4 = 1474560L - l4;
                }
                l = 4096L * FXUtility.abs(l4) / (l3 + l2);
                long l5 = Vector2FX.AngleFromVector(vector2FX);
                long l6 = Vector2FX.AngleFromVector(vector2FX2);
                cGTrackNode.m_fxVelocityFactor = FXUtility.abs(l);
                Vector2FX vector2FX3 = new Vector2FX();
                vector2FX3.y = Math.abs(cGTrackNode.m_pNext.m_fxZ - cGTrackNode.m_fxZ);
                vector2FX3.x = cGTrackNode.m_pNext.m_fxY - cGTrackNode.m_fxY;
                vector2FX3.Normalize();
                l4 = Vector2FX.AngleFromVector(vector2FX3);
                if (l4 > 819200L) {
                    l4 -= 1474560L;
                }
                l4 = l4 > 0L ? (l4 /= 180L) : (l4 /= 120L);
                cGTrackNode.m_fxVelocityFactor += (long)((int)l4);
                cGTrackNode.m_fxVelocityFactor *= 2L;
                cGTrackNode.m_fxVelocityFactor /= 3L;
                if (cGTrackNode.m_fxVelocityFactor > 2048L) {
                    cGTrackNode.m_fxVelocityFactor = 2048L;
                }
                if (cGTrackNode.m_fxVelocityFactor < 0L) {
                    cGTrackNode.m_fxVelocityFactor = 0L;
                }
            }
            if (bl) break;
            cGTrackNode = cGTrackNode.m_pNext;
        }
    }

    public void deSerialize(DataInputStream dataInputStream) throws IOException {
        System.out.println("Track.deSerialize");
        System.out.println("int bTrackPieces = (int)dis.readByte();");
        int n = dataInputStream.readByte();
        System.out.println("...OK");
        this.m_arrTrackPieces = new CGTrackPiece[n];
        for (int i = 0; i < n; ++i) {
            System.out.println("deSerialize piecetrack " + (i + 1) + " / " + n);
            this.m_arrTrackPieces[i] = new CGTrackPiece();
            this.m_arrTrackPieces[i].deSerialize(dataInputStream);
        }
        this.CreateTrackFromPieces();
    }

    public void ResetObj() {
        CGTrackNode cGTrackNode;
        this.m_pSecondTrackNode = null;
        this.m_pThirdTrackNode = null;
        this.m_pFourthTrackNode = null;
        this.m_arrCurrentObjects.removeAllElements();
        int n = this.m_arrTrackPieces.length;
        for (int i = 0; i < n; ++i) {
            this.m_arrTrackPieces[i].ResetObj();
            this.m_arrTrackPieces[i] = null;
        }
        this.m_arrTrackPieces = null;
        CGTrackNode cGTrackNode2 = cGTrackNode = this.m_pFirstTrackNode;
        do {
            cGTrackNode2.m_pPrev = null;
            cGTrackNode2 = cGTrackNode2.m_pNext;
            cGTrackNode2.ResetObj();
            cGTrackNode2.m_pPrev = null;
        } while (cGTrackNode2 != cGTrackNode);
        cGTrackNode2.m_pNext = null;
        cGTrackNode2 = null;
        this.m_pFirstTrackNode = null;
    }
}

