/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UICheckButton;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gui.GeneralListForCareer;
import baltorogames.project_gui.LoadingLevelScreen;
import baltorogames.project_gui.MainUSRScreen;
import baltorogames.project_gui.SelectGameMode;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;
import java.util.Vector;

public class CareerScreen
extends MainUSRScreen {
    private final int BUTTON_ARROWLEFT_ID;
    private final int BUTTON_ARROWRIGHT_ID;
    private final int BUTTON_GARAGE_ID;
    private final int BUTTON_PLAY_ID;
    private final int BUTTON_RANKING_ID;
    public static int NUM_MENU_ELEMENTS = 2;
    private int menuID = 0;
    private int visibleButtons = NUM_MENU_ELEMENTS;
    private int buttonOffset;
    private int firstButtonX;
    private int firstButtonY;
    private int secondButtonX;
    private CGTexture cityName;
    private String eventType;
    private CGTexture countryImage = null;
    private CGTexture[] iconImages = new CGTexture[2];
    private CGTexture[] iconSelImages = new CGTexture[2];
    private Vector textLines;

    public CareerScreen() {
        this.BUTTON_ARROWLEFT_ID = 50;
        this.BUTTON_ARROWRIGHT_ID = 51;
        this.BUTTON_GARAGE_ID = 100;
        this.BUTTON_PLAY_ID = 101;
        this.BUTTON_RANKING_ID = 102;
        if (CGUserCareer.m_nRaceID < 0) {
            CGUserCareer.m_nRaceID = 0;
        }
        this.iconImages[0] = TextureManager.AddTexture("/c_race.png");
        this.iconImages[1] = TextureManager.AddTexture("/c_stats.png");
        this.iconSelImages[0] = TextureManager.AddTexture("/c_race_s.png");
        this.iconSelImages[1] = TextureManager.AddTexture("/c_stats_s.png");
        this.countryImage = TextureManager.AddTexture("/city_" + CGUserCareer.getCityFromRaceID(CGUserCareer.m_nRaceID) + "_ico.png");
        this.cityName = TextureManager.AddTexture("/city_" + CGUserCareer.getCityFromRaceID(CGUserCareer.m_nRaceID) + "_name.png");
        this.eventType = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_EVENT_NAME_" + CGUserCareer.getEventFromRaceID(CGUserCareer.m_nRaceID));
        this.textLines = Utils.splitText(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_LOADING_HINT_RACE"), "+");
        ApplicationData.defaultFont.encodeDynamicString(" " + CGUserCareer.GetPoints());
        this.drawLogo = false;
        this.drawStrip1 = true;
        this.drawStrip2 = true;
        this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        this.strip2Y = ApplicationData.screenHeight - 2 * ObjectsCache.menuFooterImage.GetHeight();
        this.strip1Y = 36 + MainUSRScreen.getStrip1Height() / 2;
        if (CGUserCareer.m_nRaceID < 0) {
            CGUserCareer.m_nRaceID = 0;
        }
        int n = this.strip2Y;
        int n2 = this.iconImages[0].GetWidth() / 5;
        int n3 = ApplicationData.screenWidth / 2 - this.iconImages[0].GetWidth();
        UICheckButton uICheckButton = new UICheckButton(n3, n -= this.iconImages[0].GetHeight() / 2, this.iconImages[0], this.iconSelImages[0], this.iconImages[0], 100);
        uICheckButton.setScreen(this);
        this.addButton(uICheckButton);
        uICheckButton = new UICheckButton(n3 += n2 + this.iconImages[0].GetWidth(), n, this.iconImages[1], this.iconSelImages[1], this.iconImages[1], 101);
        uICheckButton.setScreen(this);
        this.addButton(uICheckButton);
        this.updateCheck();
    }

    protected void updateCheck() {
        ((UICheckButton)this.findByID(100)).setCheck(false);
        ((UICheckButton)this.findByID(101)).setCheck(false);
        ((UICheckButton)this.findByID(100 + this.menuID)).setCheck(true);
    }

    protected void findCheck() {
        this.menuID = 0;
        if (((UICheckButton)this.findByID(101)).getCheck()) {
            this.menuID = 1;
        }
    }

    public void autoSize() {
    }

    public void draw() {
        if (this.countryImage != null) {
            Graphic2D.DrawImage(this.countryImage, ApplicationData.screenWidth, this.strip1Y, 10);
        }
        Graphic2D.DrawImage(this.cityName, 0, this.strip1Y - MainUSRScreen.getStrip1Height() / 2, 20);
    }

    public boolean rightSoftButton() {
        UIScreen.SetCurrentScreen(new SelectGameMode());
        return true;
    }

    public boolean leftSoftButton() {
        if (this.menuID == 1) {
            UIScreen.SetCurrentScreen(new GeneralListForCareer());
            return true;
        }
        if (this.menuID == 0) {
            CGEngine.selectedTrack = CGUserCareer.m_nRaceID / 3;
            CGEngine.selectedRaceType = CGEngine.raceIDtoRaceType[CGUserCareer.m_nRaceID];
            UIScreen.SetCurrentScreen(new LoadingLevelScreen());
            return true;
        }
        return false;
    }

    public boolean onFireAction() {
        return this.leftSoftButton();
    }

    public boolean onLeftAction() {
        if (this.visibleButtons == 2) {
            if (this.buttonOffset == this.menuID) {
                --this.menuID;
                --this.buttonOffset;
                if (this.menuID < 0) {
                    this.menuID = NUM_MENU_ELEMENTS - 1;
                }
                if (this.buttonOffset < 0) {
                    this.buttonOffset = NUM_MENU_ELEMENTS - 1;
                }
            } else {
                --this.menuID;
                if (this.menuID < 0) {
                    this.menuID = NUM_MENU_ELEMENTS - 1;
                }
            }
        } else {
            --this.menuID;
            if (this.menuID < 0) {
                this.menuID = NUM_MENU_ELEMENTS - 1;
            }
        }
        this.updateCheck();
        return true;
    }

    public boolean onRightAction() {
        if (this.visibleButtons == 2) {
            if (this.buttonOffset != this.menuID) {
                ++this.menuID;
                ++this.buttonOffset;
                if (this.menuID >= NUM_MENU_ELEMENTS) {
                    this.menuID = 0;
                }
                if (this.buttonOffset >= NUM_MENU_ELEMENTS) {
                    this.buttonOffset = 0;
                }
            } else {
                ++this.menuID;
                if (this.menuID >= NUM_MENU_ELEMENTS) {
                    this.menuID = 0;
                }
            }
        } else {
            ++this.menuID;
            if (this.menuID >= NUM_MENU_ELEMENTS) {
                this.menuID = 0;
            }
        }
        this.updateCheck();
        return true;
    }

    public boolean actionSoftButton(int n, boolean bl) {
        if (bl && n >= 100 && n <= 102) {
            this.uncheckAllButtons();
        }
        if (super.actionSoftButton(n, bl)) {
            this.findCheck();
            return true;
        }
        if (!bl) {
            this.unselectAllButtons();
        }
        return false;
    }
}

