/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gui.MainScreen;
import baltorogames.project_gui.UICaptionThick;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;
import java.util.Vector;

public class EndOfCareerScreen
extends MainScreen {
    private int seasonPos = -1;
    private String message;
    private Vector mainText;
    private int textHeight;
    private CGTexture trophyTexture = null;

    public EndOfCareerScreen(int n) {
        this.setCaptionThick(new UICaptionThick(ApplicationData.lp.getTranslatedString(Options.languageID, "ID_END_OF_CAREER")));
        this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, null, null);
        this.setDrawTitle(false);
        this.seasonPos = n;
        this.trophyTexture = null;
        if (this.seasonPos == 0) {
            this.trophyTexture = TextureManager.AddTexture("/trophy_1.png");
            CGUserCareer.unlockCar();
        } else if (this.seasonPos == 1) {
            this.trophyTexture = TextureManager.AddTexture("/trophy_2.png");
            CGUserCareer.unlockCar();
        } else if (this.seasonPos == 2) {
            this.trophyTexture = TextureManager.AddTexture("/trophy_3.png");
            CGUserCareer.unlockCar();
        } else {
            this.message = ApplicationData.lp.getTranslatedString(Options.languageID, "ID_NO_PODIUM");
        }
        this.message = ApplicationData.lp.getTranslatedString(Options.languageID, "ID_CONGRATULATIONS");
        this.mainText = Utils.splitText(this.message, "+", ApplicationData.screenWidth, 2);
        this.textHeight = (this.mainText.size() + 1) * ApplicationData.smallGreyFont.getFontHeight();
    }

    public void onUpdate(int n) {
        this.lifeTime += n;
    }

    public boolean leftSoftButton() {
        CGUserCareer.Reset();
        CGUserCareer.m_nRaceID = 0;
        UIScreen.SetCurrentScreen(null);
        ApplicationData.goToMainMenu();
        return true;
    }

    public void drawWindowBackground() {
        super.drawWindowBackground();
    }

    public void draw() {
        int n = 9 * ApplicationData.getFontByID(0).getFontHeight() / 10;
        if (this.trophyTexture != null) {
            int n2 = ApplicationData.screenHeight / 2 - ObjectsCache.menuFooterImage.GetHeight();
            Graphic2D.DrawImage(this.trophyTexture, ApplicationData.screenWidth / 2, n2, 3);
            n2 += this.trophyTexture.GetHeight() / 2;
            Utils.drawString(this.message, ApplicationData.screenWidth / 2, n2 += 3 * n, 33, 0);
        } else {
            int n3 = ApplicationData.screenHeight - ObjectsCache.menuFooterImage.GetHeight() - (ApplicationData.screenHeight - ObjectsCache.menuFooterImage.GetHeight()) / 2;
            Utils.drawString(this.message, ApplicationData.screenWidth / 2, n3, 33, 0);
        }
    }

    public boolean rightSoftButton() {
        return false;
    }
}

