/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import main.TTimesRecordVector;

public class ArcadeRMS {
    public static final int MAX_ARCADE_ENTRIES = 4;
    public static final String ARCADERMS = "agrbt";
    private static RecordStore recordStore = null;
    public static String m_sDriver;
    public static int m_iTime;
    public static int m_iAs;
    private static int[] m_iPosition;

    public static int GetBestTime(int p_iTrack) {
        int iBestTime = Integer.MAX_VALUE;
        if (ArcadeRMS.openStore(false, p_iTrack)) {
            for (int iIndex = 1; iIndex <= 4; ++iIndex) {
                ArcadeRMS.GetTrackRecord(iIndex);
                if (m_iTime == 0 || m_iTime >= iBestTime) continue;
                iBestTime = m_iTime;
            }
            ArcadeRMS.close();
            if (iBestTime == Integer.MAX_VALUE) {
                return 0;
            }
            return iBestTime;
        }
        return 0;
    }

    public static boolean SetScore(int p_iTrack, int p_iCat, String p_sDriver, int p_iTime) {
        boolean aChange = false;
        if (ArcadeRMS.openStore(false, p_iTrack)) {
            int iIndex;
            int[] iCategoria = new int[4];
            int[] iTime = new int[4];
            String[] sDriver = new String[4];
            boolean aRet = true;
            for (iIndex = 0; iIndex < 4 && (aRet = ArcadeRMS.GetTrackRecord(iIndex + 1)); ++iIndex) {
                iCategoria[iIndex] = m_iAs;
                sDriver[iIndex] = m_sDriver;
                iTime[iIndex] = m_iTime;
            }
            for (iIndex = 0; iIndex < 4; ++iIndex) {
                if (iTime[iIndex] != 0 && p_iTime >= iTime[iIndex]) continue;
                for (int iIndex2 = 3; iIndex2 > iIndex; --iIndex2) {
                    m_iAs = iCategoria[iIndex2 - 1];
                    m_sDriver = sDriver[iIndex2 - 1];
                    m_iTime = iTime[iIndex2 - 1];
                    iCategoria[iIndex2] = m_iAs;
                    sDriver[iIndex2] = m_sDriver;
                    iTime[iIndex2] = m_iTime;
                }
                iCategoria[iIndex] = p_iCat;
                sDriver[iIndex] = p_sDriver;
                iTime[iIndex] = p_iTime;
                ArcadeRMS.m_iPosition[p_iTrack - 1] = iIndex;
                aChange = true;
                break;
            }
            if (aChange) {
                for (iIndex = 0; iIndex < 4; ++iIndex) {
                    ArcadeRMS.SetTrackRecord(iIndex + 1, iCategoria[iIndex], sDriver[iIndex], iTime[iIndex]);
                }
            }
            ArcadeRMS.close();
            return true;
        }
        return false;
    }

    public static int GetWorstBestTime(int p_iTrack) {
        int worstbesttime = 0;
        if (ArcadeRMS.openStore(false, p_iTrack)) {
            for (int iIndex = 1; iIndex <= 4; ++iIndex) {
                ArcadeRMS.GetTrackRecord(iIndex);
                if (m_iTime == 0) {
                    worstbesttime = 0;
                    break;
                }
                if (m_iTime <= worstbesttime) continue;
                worstbesttime = m_iTime;
            }
            ArcadeRMS.close();
            return worstbesttime;
        }
        return 0;
    }

    public static boolean SetTrackRecord(int aTrackId, int aCat, String aPlayerName, int aTime) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(baos);
        try {
            outputStream.writeInt(aCat);
            outputStream.writeUTF(aPlayerName);
            outputStream.writeInt(aTime);
            byte[] b = baos.toByteArray();
            recordStore.setRecord(aTrackId, b, 0, b.length);
            outputStream.close();
            baos.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean GetTrackRecord(int aId) {
        m_iTime = 0;
        try {
            byte[] aByte = recordStore.getRecord(aId);
            if (aByte == null) {
                return false;
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(aByte);
            DataInputStream inputStream = new DataInputStream(bais);
            m_iAs = inputStream.readInt();
            m_sDriver = inputStream.readUTF();
            m_iTime = inputStream.readInt();
            inputStream.close();
            bais.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void close() {
        try {
            recordStore.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public static boolean createStore(int p_iTrack) {
        if (ArcadeRMS.openStore(true, p_iTrack)) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream outputStream = new DataOutputStream(baos);
            try {
                try {
                    for (int iIndex = 1; iIndex <= 4; ++iIndex) {
                        baos.reset();
                        outputStream.writeInt(0);
                        outputStream.writeUTF("empty" + iIndex);
                        outputStream.writeInt(0);
                        byte[] b = baos.toByteArray();
                        recordStore.addRecord(b, 0, b.length);
                    }
                    ArcadeRMS.close();
                    return true;
                }
                catch (RecordStoreException rse) {
                    return false;
                }
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }

    public static boolean openStore(boolean p_bCreate, int p_iTrack) {
        try {
            recordStore = RecordStore.openRecordStore((String)(ARCADERMS + p_iTrack), (boolean)p_bCreate);
            return true;
        }
        catch (RecordStoreException rse) {
            recordStore = null;
            return false;
        }
    }

    public static boolean deleteStore(int p_iTrack) {
        if (ArcadeRMS.openStore(false, p_iTrack)) {
            for (int iIndex = 0; iIndex < 4; ++iIndex) {
                ArcadeRMS.SetTrackRecord(iIndex + 1, 0, "empty", 0);
            }
        }
        return true;
    }

    static synchronized void LoadPersonalTimes(int p_iTrack, TTimesRecordVector pRTV) {
        pRTV.iHowMany = 0;
        if (ArcadeRMS.openStore(false, p_iTrack)) {
            for (int iIndex = 1; iIndex <= 4 && ArcadeRMS.GetTrackRecord(iIndex); ++iIndex) {
                pRTV.tTimes[iIndex - 1].iIndex = iIndex - 1;
                pRTV.tTimes[iIndex - 1].iRacer = m_iAs;
                pRTV.tTimes[iIndex - 1].iTime = m_iTime;
                pRTV.tTimes[iIndex - 1].sName = m_sDriver;
                ++pRTV.iHowMany;
            }
        }
    }

    public static int GetPosition(int p_iTrack) {
        return m_iPosition[p_iTrack - 1];
    }

    static {
        m_iPosition = new int[3];
    }
}

