/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Background;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Group;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Object3D;
import javax.microedition.m3g.World;
import javax.microedition.midlet.MIDlet;
import main.ArcadeRMS;
import main.BestTimesMenu;
import main.CBezierTrack;
import main.CCar;
import main.CCarAI;
import main.CLapControl;
import main.ChallengeRMS;
import main.CircuitsMenu;
import main.Colisions;
import main.Dialog;
import main.DialogChallenge;
import main.DialogResource;
import main.EnterInitials;
import main.GameMIDlet;
import main.GameSettings;
import main.HelpMenu;
import main.InGamePauseMenu;
import main.KeyState;
import main.LanguageManager;
import main.LoaderObject;
import main.MainMenu;
import main.Menu;
import main.MyMath;
import main.Platform;
import main.QuickRaceMenu;
import main.RiderMenu;
import main.SettingsMenu;
import main.Sound;
import main.Symbian;
import main.TCamera;
import main.TData;
import main.TRaceInfo;
import main.TRaceTimes;
import main.TTimesRecordVector;
import main.TTrackInfo;
import main.Utils;
import main.Window;
import main.swvOrientation;
import main.swvVector3D;

public class CartoonRacer
extends Canvas {
    public static boolean ms_bLeftButtonPressed;
    public static boolean ms_bRightButtonPressed;
    public static boolean ms_bBreakButtonPressed;
    public static boolean ON_EMULATOR;
    public static boolean SUN_EMULATOR;
    public static boolean DEBUG;
    public static boolean CONSOLE;
    public static boolean USE_TRY;
    public static final boolean TRACE_ERROR = false;
    public static final int ROCKET_COUNTDOWN = 5;
    public static final boolean ONLY_ONE_BACKGROUND = true;
    public static final float INITIAL_START_ANGLE = -0.7854f;
    public static final int MIN_DELTATIME_TO_BE_PLAYABLE = 175;
    public GameMIDlet m_midlet = null;
    public Graphics3D ms_g3d = null;
    private int m_currentTime = 0;
    private int m_iDemoTime = 0;
    private int m_iRaceTime = 0;
    private int m_iBombChaseTime = 0;
    private int m_iSkidTime = 0;
    private int m_iCountDownTime = 0;
    private long m_lastFrame;
    private int m_deltaTime;
    private int m_iValidity;
    private int m_iTiempo2D = 0;
    private int m_iTiempoSR = 0;
    private int m_iTiempo3D = 0;
    private int m_iTiempoUBR = 0;
    private int m_iTrackForBestTimes;
    public boolean m_bGameInPauseMenu;
    public boolean m_bWaiting;
    public boolean m_bNoKeyForSuppressKeyEvent = true;
    public World m_world = null;
    public World m_raceworldsafecoy = null;
    private int m_oldGameState;
    private int m_oldInRaceGameState;
    private int m_oldCurrentTime;
    private int m_iKindOfRace = -1;
    public int m_iClipWidth = 0;
    public int m_iPosX = 0;
    public int m_iClipHeight = 0;
    public int m_iPosY = 0;
    private Sound m_sound = null;
    private boolean m_bSoundStartRace = false;
    private boolean m_bGo = false;
    public static boolean bRedrawFullInGameInterface;
    public Image m_layerImage = null;
    public static Image ms_CalaveraImage;
    public Graphics m_layerImageGC = null;
    private boolean mNeedsResume = false;
    private boolean mStartApp = false;
    private Timer myTimer = null;
    private String mPauseAppTextStr = null;
    private String mPauseAppSKLeftStr = null;
    private String mStartTextStr = null;
    private String mStartSKLeftStr = null;
    private String mStartSKRightStr = null;
    private static final int PAUSEAPP_SKLEFTPOSX = 4;
    private static final int PAUSEAPP_SKPOSY = 240;
    private static final int PAUSEAPP_TEXT_BASE_X = 160;
    private static final Font PAUSEAPP_TEXT_FONT;
    static boolean TOUCHSCREEN_SUPPORTED;
    static final int ACTION_UP = 0;
    static final int ACTION_DOWN = 1;
    static final int ACTION_MOVE = 2;
    static int ms_iScreenTouched_X;
    static int ms_iScreenTouched_Y;
    static int ms_iScreenOrigin_X;
    static int ms_iScreenOrigin_Y;
    static int ms_iScreenTouched_Map;
    static int ms_iScreenTouched_Frames;
    static boolean ms_bScreenTouchReset;
    public static int ms_iMenuTouchedIndex;
    public static boolean ms_iGamePadTouched;
    static final int TOUCH_L_SOFTK = 0;
    static final int TOUCH_R_SOFTK = 1;
    static boolean ms_bSoftLeft;
    static boolean ms_bSoftRight;
    public static final float FACTOR_0 = 0.3f;
    public static final float FACTOR_1 = 0.3333f;
    public static final float FACTOR_2 = 0.2f;
    String m_sString = "";
    int m_iGameState;
    int m_iGameStateAnt = -1;
    int m_iPreloadGameState;
    int m_iRacer = 0;
    int m_iTrack;
    boolean m_bChallenge = false;
    static Image ms_vKitmakerLogo;
    static Image ms_vSplashScreen;
    static final long KITMAKER_TIME = 3000L;
    static final long SPLASHSC_TIME = 3000L;
    LoaderObject m_LoaderIntro = null;
    LoaderObject m_LoaderRacers = null;
    LoaderObject[] m_RaceLoader;
    Colisions m_Colisiones = null;
    int m_iProgress;
    int m_iPersistentProgress;
    private Camera[] m_Camera = null;
    private Camera m_hInRaceCamera = null;
    private boolean m_bRearCamera = false;
    private Menu m_CurrentMenu;
    private Dialog m_CurrentDialog = null;
    Command leftSoftCommand = null;
    Command rightSoftCommand = null;
    private boolean m_menu_keys_nrep = true;
    private float m_fBombFade;
    private int m_iSKLLong;
    private int m_iSKRLong;
    private int m_iSKLDespla;
    private int m_iSKRDespla;
    private TRaceInfo m_tRaceInfo = null;
    private TCamera m_tCamera = null;
    private TRaceTimes m_tRaceTimes = null;
    private CCar m_UserCar = null;
    private CCarAI[] m_AICar = null;
    private CBezierTrack m_BezierTrack = null;
    private Window m_Window = null;
    private CLapControl m_Lapcontrol = null;
    private TTimesRecordVector m_tPersonalTimes = null;
    private boolean m_bBestTimeInRace = false;
    private boolean m_bWinRace = false;
    private static final int N_LAYOUT_IMAGES = 8;
    public static Image[] m_Image;
    public static final int INDEX_IMAGE_MENU_LAYOUT_TOP = 0;
    public static final int INDEX_IMAGE_MENUBACKGROUND_LAYOUT = 1;
    public static final int INDEX_IMAGE_ARROW_180_UP = 2;
    public static final int INDEX_IMAGE_ARROW_UP = 3;
    public static final int INDEX_IMAGE_ARROW_180_DOWN = 4;
    public static final int INDEX_IMAGE_ARROW_DOWN = 5;
    public static final int INDEX_IMAGE_MENU_LEFT = 6;
    public static final int INDEX_IMAGE_MENU_RIGHT = 7;
    Image2D m_I2DBackForSelect = null;
    private Node[] m_IntroHeads = null;
    protected ChallengeRMS m_ChallengeRMS = null;
    protected GameSettings m_GameSettingsRMS = null;
    private Background mBackground = null;
    private float mBackgroundCropX = 0.0f;
    private int m_iBackgroundWidth;
    private int m_iBackgroundHeight;
    private static final int BACKGROUNDROTATIONSPEED = 88;

    public void initYesNoCommands() {
        if (TData.yesCommand == null) {
            TData.yesCommand = new Command(LanguageManager.GetString("M31"), 4, 3);
        }
        if (TData.noCommand == null) {
            TData.noCommand = new Command(LanguageManager.GetString("M32"), 2, 3);
        }
    }

    public void initCommands() {
        this.initYesNoCommands();
        TData.skipCommand = new Command(LanguageManager.GetString("M84"), 8, 3);
        TData.quitCommand = new Command(LanguageManager.GetString("M8"), 7, 1);
        TData.cancelCommand = new Command(LanguageManager.GetString("M80"), 3, 1);
        TData.backCommand = new Command(LanguageManager.GetString("M83"), 2, 2);
        TData.exitraceCommand = new Command(LanguageManager.GetString("M190"), 2, 2);
        TData.selectCommand = new Command(LanguageManager.GetString("M14"), 8, 3);
        TData.okCommand = new Command(LanguageManager.GetString("M82"), 4, 3);
        TData.helpCommand = new Command(LanguageManager.GetString("M6"), 5, 3);
        TData.raceCommand = new Command(LanguageManager.GetString("M82"), 8, 3);
        TData.pauseCommand = new Command(LanguageManager.GetString("M86"), 8, 3);
        TData.continueCommand = new Command(LanguageManager.GetString("M42"), 8, 3);
        TData.nextCharSetCommand = new Command(LanguageManager.GetString("M85"), 1, 3);
        TData.uploadCommand = new Command(LanguageManager.GetString("M24"), 8, 3);
        TData.changeCommand = new Command(LanguageManager.GetString("M17"), 4, 3);
        TData.emptyleftCommand = new Command("", 2, 2);
        TData.emptyrightCommand = new Command("", 4, 3);
    }

    public CartoonRacer(GameMIDlet m) {
        this.m_midlet = m;
        this.setFullScreenMode(true);
        Display.getDisplay((MIDlet)this.m_midlet).setCurrent((Displayable)this);
        TData.SetDisplay(Display.getDisplay((MIDlet)this.m_midlet));
    }

    public void pauseApp() {
        if (this.myTimer != null) {
            this.myTimer.cancel();
            this.myTimer = null;
        }
        this.m_oldGameState = this.m_iGameState;
        this.m_oldCurrentTime = this.m_currentTime;
        if (GameSettings.m_bSound && this.m_sound != null && this.m_sound.getState() == 400) {
            this.m_sound.stop();
        }
    }

    public void resumeApp() {
        bRedrawFullInGameInterface = true;
        this.mNeedsResume = true;
    }

    protected void showNotify() {
        this.m_midlet.applicationResume();
    }

    protected void hideNotify() {
        this.m_midlet.applicationPause();
    }

    private void finishResumingApp() {
        this.mNeedsResume = false;
        KeyState.resetActionKeys();
        if (GameSettings.m_bSound) {
            if (this.myTimer == null) {
                this.myTimer = new Timer();
                this.myTimer.schedule((TimerTask)new doSoundStuff(), 2000L);
            } else {
                this.myTimer.cancel();
                this.myTimer = null;
            }
        }
        this.changeMode(this.m_oldGameState);
    }

    public void startApp(boolean b) {
        this.mStartApp = true;
        try {
            ms_CalaveraImage = Image.createImage((String)"/calavera.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        TData.SetCanvas(this);
        KeyState.Init();
        this.prepareEnableSounds();
        this.TouchScreenCheck();
        Platform.SetLightOn();
    }

    private void initApp() {
        this.mStartSKRightStr = null;
        this.mStartSKLeftStr = null;
        this.mStartTextStr = null;
        TData.Init();
        this.setViewportValues(0, 0, 320, 240);
        this.ms_g3d = Graphics3D.getInstance();
        if (m_Image == null) {
            m_Image = new Image[8];
        }
        this.m_tRaceInfo = new TRaceInfo();
        this.m_tRaceTimes = new TRaceTimes();
        this.m_tCamera = new TCamera();
        int iIndex = m_Image.length;
        while (--iIndex >= 0) {
            CartoonRacer.m_Image[iIndex] = null;
        }
        Sound.Init();
        this.initCommands();
    }

    public World getWorld() {
        return this.m_world;
    }

    public int getDeltaTime() {
        return this.m_deltaTime;
    }

    public void manageInRaceSound(int iID) {
        if (GameSettings.m_bSound && this.m_sound != null) {
            if (this.m_iKindOfRace != 2) {
                if (this.m_sound.getID() != 1 && this.m_sound.getState() != 400) {
                    this.m_sound.play();
                }
            } else if (this.m_sound.getID() == iID) {
                if (this.m_sound.getState() != 400) {
                    this.m_sound.play();
                }
            } else if (this.m_sound.getID() != 1 && (this.m_sound.getState() != 400 || iID == 4 || this.m_sound.getID() == 2 && iID == 3)) {
                this.loadSound(iID);
                if (this.m_sound != null) {
                    this.m_sound.play();
                }
            }
        }
    }

    public void loadSound(int iID) {
        if (this.m_sound != null) {
            this.m_sound.destroy(false);
            this.m_sound = null;
            Platform.SystemGc();
            this.m_sound = new Sound(iID);
        } else {
            this.m_sound = new Sound(iID);
        }
    }

    public Sound getSound() {
        return this.m_sound;
    }

    public void unloadImagesForEnterInitials() {
        CartoonRacer.m_Image[4] = null;
        CartoonRacer.m_Image[2] = null;
        CartoonRacer.m_Image[5] = null;
        CartoonRacer.m_Image[3] = null;
    }

    public synchronized void loadImagesForEnterInitials() {
        try {
            if (m_Image[3] == null) {
                CartoonRacer.m_Image[3] = Image.createImage((String)"/arrow_up.png");
            }
            if (m_Image[5] == null) {
                CartoonRacer.m_Image[5] = Image.createImage((String)"/arrow_down.png");
            }
            if (m_Image[2] == null) {
                CartoonRacer.m_Image[2] = Image.createImage((Image)m_Image[3], (int)0, (int)0, (int)m_Image[3].getWidth(), (int)m_Image[3].getHeight(), (int)3);
            }
            if (m_Image[4] == null) {
                CartoonRacer.m_Image[4] = Image.createImage((Image)m_Image[5], (int)0, (int)0, (int)m_Image[5].getWidth(), (int)m_Image[5].getHeight(), (int)3);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void unloadImagesForMenuBackground() {
        CartoonRacer.m_Image[1] = null;
    }

    public void unloadImagesForMenu() {
    }

    public synchronized void loadImagesForMenu() {
        try {
            if (m_Image[0] == null) {
                CartoonRacer.m_Image[0] = Image.createImage((String)"/banda_superior.png");
            }
            if (m_Image[6] == null) {
                CartoonRacer.m_Image[6] = Image.createImage((String)"/hueso1.png");
            }
            if (m_Image[7] == null) {
                CartoonRacer.m_Image[7] = Image.createImage((String)"/hueso2.png");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setViewportValues(int a, int b, int c, int d) {
        this.m_iPosX = a;
        this.m_iPosY = b;
        this.m_iClipWidth = c;
        int n = this.m_iClipHeight = d == 0 ? 1 : d;
        if (this.m_world != null && this.m_iClipHeight > 0) {
            Utils.setAspectRatioActiveCamera(this.m_world, (float)this.m_iClipWidth / (float)this.m_iClipHeight);
        }
    }

    public synchronized void launchIntro() {
        this.m_world = null;
        this.m_world = this.m_LoaderIntro.world();
        int ih = this.m_world.getBackground().getImage().getHeight();
        int iw = this.m_world.getBackground().getImage().getWidth();
        this.m_world.getBackground().setImageMode(32, 32);
        this.m_world.getBackground().setCrop(0, 0, iw, ih);
        Utils.startAnimation((Object3D)this.m_world, 253469715, 0);
        Utils.stopAnimation((Object3D)this.m_world, 533981023);
        this.m_IntroHeads = new Node[4];
        this.m_IntroHeads[0] = (Node)this.m_world.find(587162922);
        this.m_IntroHeads[1] = (Node)this.m_world.find(496410653);
        this.m_IntroHeads[2] = (Node)this.m_world.find(506242404);
        this.m_IntroHeads[3] = (Node)this.m_world.find(557667669);
        ((Mesh)this.m_world.find(500627546)).getAppearance(0).setLayer(1);
        this.m_IntroHeads[1].setRenderingEnable(true);
        this.m_IntroHeads[1].setRenderingEnable(false);
        this.m_IntroHeads[2].setRenderingEnable(false);
        this.m_IntroHeads[3].setRenderingEnable(false);
        if (GameSettings.m_bSound && this.m_sound != null) {
            this.m_sound.play();
        }
    }

    public synchronized void prepareEnableSounds() {
        LanguageManager.Init("/", "en", this.m_midlet);
        this.changeMode(-2);
    }

    public synchronized void prepareSetSoundAndContinue(boolean bSound) {
        GameSettings.m_bSound = bSound;
        this.changeMode(0);
    }

    public synchronized void manageLoadIntroFiles() {
        if (this.m_LoaderIntro == null) {
            this.m_LoaderIntro = new LoaderObject("/carintro", 0, 0);
        } else if (this.m_LoaderIntro.finished() && this.m_iGameState == 0 && this.m_currentTime > 200) {
            this.prepareKitmakerLogo();
        }
    }

    public synchronized void prepareKitmakerLogo() {
        this.initApp();
        this.m_GameSettingsRMS = new GameSettings();
        if (this.m_GameSettingsRMS == null) {
            this.exitGame();
            return;
        }
        if (this.m_LoaderIntro.world() == null) {
            this.exitGame();
            return;
        }
        try {
            ms_vKitmakerLogo = Image.createImage((String)"/kitmaker.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (GameSettings.m_bSound) {
            this.loadSound(0);
        }
        this.changeMode(1);
    }

    public synchronized void prepareSplashScreen() {
        try {
            ms_vSplashScreen = Image.createImage((String)"/cover.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.changeMode(2);
    }

    public synchronized void prepareIntroAnim() {
        this.launchIntro();
        this.setViewportValues(0, 0, 320, 240);
        this.addCommand(TData.skipCommand);
        this.changeMode(3);
    }

    boolean gameInPauseMenu() {
        return this.m_bGameInPauseMenu;
    }

    public synchronized void prepareMenuSettings() {
        if (!this.m_bGameInPauseMenu) {
            this.m_world = null;
        }
        this.loadImagesForMenu();
        this.removeCanvasCommands();
        this.addCommand(TData.selectCommand);
        this.addCommand(TData.backCommand);
        this.m_CurrentMenu = new SettingsMenu(Platform.FONT_MENU, m_Image[0]);
        this.changeMode(30);
    }

    public synchronized void prepareMenuHelp() {
        if (!this.m_bGameInPauseMenu) {
            this.m_world = null;
        }
        this.loadImagesForMenu();
        this.removeCanvasCommands();
        this.addCommand(TData.okCommand);
        this.addCommand(TData.backCommand);
        this.m_CurrentMenu = new HelpMenu(Platform.FONT_MENU, m_Image[0]);
        this.changeMode(27);
    }

    public synchronized void prepareMenuInGamePause() {
        this.loadImagesForMenu();
        this.removeCanvasCommands();
        this.addCommand(TData.selectCommand);
        this.m_CurrentMenu = new InGamePauseMenu(Platform.FONT_MENU, m_Image[0]);
        this.m_bGameInPauseMenu = true;
        this.changeMode(99);
    }

    public synchronized void prepareMenuCircuits() {
        this.m_world = null;
        this.m_world = this.m_LoaderRacers.world();
        this.m_CurrentMenu = new CircuitsMenu(Platform.FONT_MENU, m_Image[0], -1);
        this.changeMode(24);
    }

    public synchronized void prepareMenuRider() {
        this.setViewportValues(0, 0, 320, 240);
        this.unloadImagesForMenu();
        this.m_world = null;
        this.m_world = this.m_LoaderRacers.world();
        this.m_CurrentMenu = new RiderMenu(Platform.FONT_MENU, m_Image[0]);
        this.changeMode(23);
    }

    public synchronized void prepareBestTimesMenu() {
        this.removeCanvasCommands();
        this.loadImagesForMenu();
        this.m_world = null;
        this.addCommand(TData.okCommand);
        this.addCommand(TData.backCommand);
        this.m_CurrentMenu = new BestTimesMenu(Platform.FONT_MENU, m_Image[0]);
        this.changeMode(25);
    }

    synchronized void prepareDlgExitGame() {
        if (this.m_LoaderRacers == null) {
            this.preparePreloadRacers(55);
        } else {
            this.loadRacerChallenge();
            this.removeCanvasCommands();
            this.addCommand(TData.yesCommand);
            this.addCommand(TData.noCommand);
            this.launchDlgBubble(LanguageManager.GetString("M26"), 55);
        }
    }

    synchronized void prepareDlgDeleteRecordsConfirmation() {
        if (this.m_LoaderRacers == null) {
            this.preparePreloadRacers(63);
        } else {
            this.loadRacerChallenge();
            this.removeCanvasCommands();
            this.addCommand(TData.yesCommand);
            this.addCommand(TData.noCommand);
            this.launchDlgBubble(LanguageManager.GetString("M191"), 63);
        }
    }

    void setTrackForBestTimes(int aTrack) {
        this.m_iTrackForBestTimes = aTrack;
    }

    synchronized void prepareBestTimesMenuPersonal() {
        this.removeCanvasCommands();
        this.unloadImagesForMenu();
        if (this.m_LoaderRacers == null) {
            this.preparePreloadRacers(19);
        } else {
            if (this.m_tPersonalTimes != null) {
                this.m_tPersonalTimes.destroy();
                this.m_tPersonalTimes = null;
            }
            this.m_tPersonalTimes = new TTimesRecordVector();
            this.m_world = this.m_LoaderRacers.world();
            Background aBack = this.m_world.getBackground();
            if (this.m_I2DBackForSelect == null) {
                this.m_I2DBackForSelect = (Image2D)Utils.LoadScene("/backforselect");
            }
            aBack.setImage(this.m_I2DBackForSelect);
            aBack = null;
            ((Node)this.m_world.find(956683772)).setRenderingEnable(false);
            ((Node)this.m_world.find(963976961)).setRenderingEnable(false);
            ((Node)this.m_world.find(755899032)).setRenderingEnable(false);
            this.m_world.setActiveCamera((Camera)this.m_world.find(1039097126));
            this.setViewportValues(0, 0, 320, 240);
            this.m_iGameState = 26;
            this.m_CurrentMenu = new CircuitsMenu(Platform.FONT_MENU, m_Image[0], this.m_iTrackForBestTimes);
            this.changeMode(26);
        }
    }

    void preparePlayCountDown() {
        this.m_bSoundStartRace = false;
        this.m_bGo = false;
        if (GameSettings.m_bSound) {
            this.loadSound(1);
        }
        this.m_tCamera.oYaw.angle = 0.0f;
        Symbian.transform_setOrientation(this.m_tCamera.hYaw, this.m_tCamera.oYaw);
        this.m_iCountDownTime = 0;
        this.m_UserCar.updateBackHead(0.0f);
        if (this.m_AICar != null) {
            int iIndex = this.m_AICar.length;
            while (--iIndex >= 0) {
                this.m_AICar[iIndex].updateBackHead(0.0f);
            }
        }
        this.changeMode(113);
    }

    void preparePlayRacing() {
        this.m_UserCar.shiftGearUp();
        this.m_bGo = true;
        ms_iGamePadTouched = false;
        this.changeMode(114);
    }

    public synchronized void prepareEnterName() {
        this.removeCanvasCommands();
        this.loadImagesForEnterInitials();
        EnterInitials enterInitialsDialog = new EnterInitials(160, 72, Platform.FONT_DLG, (Object)this, m_Image[0], LanguageManager.GetString("M66"));
        this.m_CurrentDialog = enterInitialsDialog;
        this.addCommand(TData.okCommand);
        this.addCommand(TData.nextCharSetCommand);
        this.changeMode(81);
    }

    public void drawLoading(Graphics g) {
        if (this.m_iGameState < 3 || this.m_iGameStateAnt > 9) {
            g.setStrokeStyle(0);
            g.setColor(0);
            g.fillRect(0, 0, 320, 240);
            if (m_Image != null && m_Image[0] != null) {
                g.drawImage(m_Image[0], 160, 0, 17);
            }
        }
        this.m_bWaiting = true;
        if (this.m_iGameState >= 3 || this.m_iGameState == 0) {
            Utils.drawWaiting(g, 240);
        }
    }

    public void drawGo(Graphics g) {
        Font aFont = g.getFont();
        g.setFont(Platform.FONT_SYSTEM_BOLD_LARGE);
        if (this.m_iRaceTime <= 1500) {
            g.setColor(16711749);
            g.drawString(LanguageManager.GetString("M74"), 160, 96, 33);
        } else if (this.m_bGo) {
            this.m_bGo = false;
            int iCharsWidth = g.getFont().stringWidth(LanguageManager.GetString("M74"));
            int iCharHeight = g.getFont().getHeight() + 0;
            g.setColor(3102130);
            g.fillRect(160 - (iCharsWidth >> 1), 96 - iCharHeight, iCharsWidth, iCharHeight);
            this.m_Window.repaint();
        }
        g.setFont(aFont);
    }

    public void drawCountDown(Graphics g) {
        Font aFont = g.getFont();
        g.setFont(Platform.FONT_SYSTEM_BOLD_LARGE);
        int i = (this.m_iCountDownTime - 1500) / 1000;
        if (this.m_iCountDownTime - 1500 >= -300 && i != 3) {
            int iCharWidth = g.getFont().charWidth('0');
            int iCharHeight = g.getFont().getHeight() + 0;
            g.setColor(3102130);
            g.fillRect(160 - (iCharWidth >> 1), 96 - iCharHeight, iCharWidth, iCharHeight);
            g.setColor(16711749);
            g.drawChar((char)(48 + (3 - (this.m_iCountDownTime - 1500) / 1000)), 160, 96, 33);
        }
        g.setFont(aFont);
    }

    public void destroyApp(boolean unconditional) {
        if (this.m_LoaderRacers != null) {
            this.m_LoaderRacers.destroy();
            this.m_LoaderRacers = null;
        }
        if (this.m_Window != null) {
            this.m_Window.destroy();
            this.m_Window = null;
        }
        Platform.SetLightOff();
        if (this.m_sound != null) {
            this.m_sound.destroy(true);
            this.m_sound = null;
        }
    }

    public void removeCanvasCommands() {
        this.removeCommand(TData.yesCommand);
        this.removeCommand(TData.noCommand);
        if (TData.skipCommand != null) {
            this.removeCommand(TData.skipCommand);
            this.removeCommand(TData.quitCommand);
            this.removeCommand(TData.backCommand);
            this.removeCommand(TData.cancelCommand);
            this.removeCommand(TData.exitraceCommand);
            this.removeCommand(TData.helpCommand);
            this.removeCommand(TData.okCommand);
            this.removeCommand(TData.selectCommand);
            this.removeCommand(TData.raceCommand);
            this.removeCommand(TData.changeCommand);
            this.removeCommand(TData.pauseCommand);
            this.removeCommand(TData.continueCommand);
            this.removeCommand(TData.nextCharSetCommand);
            this.removeCommand(TData.emptyleftCommand);
            this.removeCommand(TData.emptyrightCommand);
            this.removeCommand(TData.uploadCommand);
        }
        this.m_iSKLDespla = 2;
        this.m_iSKRDespla = 2;
    }

    public synchronized void changeMode(int mode) {
        if (mode == this.m_iGameState) {
            this.m_currentTime = this.m_oldCurrentTime;
        } else if (mode <= 3 || mode >= 9) {
            this.m_currentTime = 0;
        }
        this.m_iGameStateAnt = this.m_iGameState;
        this.m_iGameState = mode;
        this.m_deltaTime = 0;
        this.m_lastFrame = 0L;
        if (this.m_iGameState < 114 || this.m_iGameStateAnt > 116) {
            Platform.SystemGc();
        }
    }

    public void processInGameKeyboard() {
        if (KeyState.m_leftPressed || ms_bLeftButtonPressed) {
            this.m_UserCar.turnLeft();
            if (this.m_UserCar.getGear() == 0) {
                this.m_UserCar.shiftGearUp();
            }
            KeyState.updateActions();
        } else if (KeyState.m_rightPressed || ms_bRightButtonPressed) {
            this.m_UserCar.turnRight();
            if (this.m_UserCar.getGear() == 0) {
                this.m_UserCar.shiftGearUp();
            }
            KeyState.updateActions();
        }
        if (KeyState.m_downPressed || ms_bBreakButtonPressed) {
            this.m_UserCar.brake();
            KeyState.updateActions();
        }
        if (KeyState.m_softBrakePressed) {
            this.m_UserCar.softBrake();
            KeyState.updateActions();
        }
        if (KeyState.m_firePressed) {
            if (!KeyState.m_firePressedRepeat) {
                KeyState.m_firePressedRepeat = true;
                this.m_UserCar.setUsePowerUp();
            }
            KeyState.releasefire();
        }
        if (KeyState.m_camSwitchPressed) {
            if (this.m_hInRaceCamera == this.m_Camera[0]) {
                this.setRearCamera();
            }
            KeyState.updateActions();
        }
    }

    public void updateCarsAndMore(int pDeltaTime) {
        CCar aCar = this.m_UserCar;
        aCar.updateDynamics(pDeltaTime, this.m_iRaceTime);
        if (this.m_iGameState == 116) {
            if (this.m_hInRaceCamera != this.m_Camera[0]) {
                this.restoreCamera();
            }
            if (this.m_iKindOfRace == 3) {
                if (this.m_fBombFade == 0.0f) {
                    this.m_fBombFade = 1.0f;
                    if (GameSettings.m_bVibra) {
                        this.m_UserCar.vibrate(0);
                        TData.GetDisplay().vibrate(2000);
                    }
                    this.m_UserCar.getSpinTransform().setRenderingEnable(false);
                    this.m_AICar[0].getSpinTransform().setRenderingEnable(false);
                    ((Node)this.m_world.find(this.m_tRaceInfo.iIDTrack)).setRenderingEnable(false);
                } else {
                    this.m_fBombFade = 0.45f + Utils.m_Random.nextFloat() * 0.55f;
                }
            }
            this.updateCameraFinishRace();
        } else {
            this.updateCamera();
        }
        this.manageAI(pDeltaTime, this.m_iRaceTime);
        if (!aCar.getHasFinishedRace()) {
            this.m_Lapcontrol.update(this.m_iRaceTime);
        } else {
            this.m_Lapcontrol.update(this.m_iRaceTime + this.m_currentTime);
        }
        this.m_Window.setSpeed(aCar.getSpeed());
        this.m_Window.setGear(aCar.getGear());
        this.m_Window.setGearPercent(aCar.getGearPercent());
        this.m_Window.setLap(this.m_Lapcontrol.getCurrentLap(0));
        int iRaceTime = this.m_iKindOfRace == 3 ? this.m_iBombChaseTime - this.m_iRaceTime : (this.m_bChallenge && this.m_iKindOfRace == 0 ? 165000 - this.m_iRaceTime : this.m_iRaceTime);
        this.m_Window.setRaceTime(iRaceTime);
    }

    public int getBombChaseTime() {
        return this.m_iBombChaseTime;
    }

    public void loadKindOfRaceSound() {
        this.loadSound(2);
    }

    public void updateRace(int pDeltaTime) {
        if (GameSettings.m_bSound && this.m_iRaceTime >= 1000 && this.m_bSoundStartRace) {
            this.m_bSoundStartRace = false;
            this.loadKindOfRaceSound();
        }
        this.updateCarsAndMore(pDeltaTime);
        if (this.m_UserCar.getHasFinishedRace()) {
            this.doStartToFinishRace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doStartToFinishRace() {
        this.m_UserCar.vibrate(0);
        if (this.m_iKindOfRace == 3 && GameSettings.m_bSound) {
            CartoonRacer cartoonRacer = this;
            synchronized (cartoonRacer) {
                if (this.m_sound == null || this.m_sound != null && this.m_sound.getID() != 4) {
                    this.loadSound(4);
                    if (this.m_sound != null) {
                        this.m_sound.play();
                    }
                }
            }
        }
        this.changeMode(116);
    }

    private void manageAI(int pDeltaTime, int iRaceTime) {
        if (this.m_AICar == null || pDeltaTime == 0) {
            return;
        }
        int iIndex = this.m_AICar.length;
        while (--iIndex >= 0) {
            this.m_AICar[iIndex].updateDynamics(pDeltaTime, iRaceTime);
        }
    }

    private void printInfo() {
        String s = "";
        for (int aIndex = 0; aIndex < 4; ++aIndex) {
            s = "Racer " + (aIndex + 1) + "; ";
            for (int iIndice2 = 0; iIndice2 < 3; ++iIndice2) {
                s = s + TData.m_fRIDER_ATTR_FACTOR[aIndex][iIndice2] + "\t";
            }
        }
    }

    public void executeOnce() {
        Display display = Display.getDisplay((MIDlet)this.m_midlet);
        if (display.getCurrent() == this) {
            long frm = System.currentTimeMillis();
            this.m_deltaTime = this.m_lastFrame == 0L ? 0 : (int)(frm - this.m_lastFrame);
            if (this.m_iGameState >= 114 && this.m_deltaTime > 175) {
                this.m_deltaTime = 175;
            }
            this.m_lastFrame = frm;
            this.repaint();
            this.serviceRepaints();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        CartoonRacer cartoonRacer = this;
        synchronized (cartoonRacer) {
            this.paintAll(g);
        }
        KeyState.KeyReleased(-6);
        KeyState.KeyReleased(-7);
    }

    private void paintStartScreen(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, 320, 240);
        g.setColor(16711749);
        if (this.mStartSKLeftStr == null) {
            this.mStartSKLeftStr = LanguageManager.GetString("M31");
        } else {
            g.drawString(this.mStartSKLeftStr, 4, 240, 36);
        }
        if (this.mStartSKRightStr == null) {
            this.mStartSKRightStr = LanguageManager.GetString("M32");
        } else {
            g.drawString(this.mStartSKRightStr, 316, 240, 40);
        }
        g.setColor(0xFFFFFF);
        if (this.mStartTextStr == null) {
            this.mStartTextStr = LanguageManager.GetString("M0");
        } else {
            g.drawString(this.mStartTextStr, 160, 120, 17);
        }
    }

    private void paintPauseAppScreen(Graphics g) {
        g.setColor(148633);
        g.fillRect(0, 0, 320, 240);
        g.setFont(PAUSEAPP_TEXT_FONT);
        g.setColor(13696001);
        if (this.mPauseAppSKLeftStr == null) {
            this.mPauseAppSKLeftStr = LanguageManager.GetString("M82");
        } else {
            g.drawString(this.mPauseAppSKLeftStr, 4, 240, 36);
        }
        if (this.mPauseAppTextStr == null) {
            this.mPauseAppTextStr = LanguageManager.GetString("M42").toUpperCase();
        } else {
            g.drawString(this.mPauseAppTextStr, 160, 120, 17);
        }
    }

    public void paintAll(Graphics g) {
        boolean bRender3D;
        if (this.mStartApp || this.mNeedsResume) {
            if (this.mNeedsResume) {
                this.paintPauseAppScreen(g);
            } else {
                this.paintStartScreen(g);
                this.m_currentTime += this.m_deltaTime;
                this.manageLoadIntroFiles();
            }
            return;
        }
        if (CONSOLE) {
            this.m_iTiempoUBR = (int)System.currentTimeMillis();
        }
        if (USE_TRY) {
            try {
                if (this.m_deltaTime > 0) {
                    this.updateBeforeRender(this.m_deltaTime);
                }
            }
            catch (Exception e) {}
        } else {
            this.updateBeforeRender(this.m_deltaTime);
        }
        if (CONSOLE) {
            this.m_iTiempoUBR = (int)System.currentTimeMillis() - this.m_iTiempoUBR;
            this.m_iTiempo3D = (int)System.currentTimeMillis();
        }
        if (this.m_bGameInPauseMenu) {
            bRender3D = this.m_iGameState == 99 || this.m_iGameState == 27 ? false : this.m_iGameState == 70 || this.m_iGameState == 71 || this.m_iGameState == 72 || this.m_iGameState == 73 || this.m_iGameState == 47;
        } else {
            boolean bl = bRender3D = this.m_iGameState < 100 || this.m_iGameState > 111;
        }
        if (this.m_world != null && bRender3D) {
            this.ms_g3d.bindTarget((Object)g);
            this.ms_g3d.setViewport(this.m_iPosX, this.m_iPosY, this.m_iClipWidth, this.m_iClipHeight);
            this.ms_g3d.render(this.m_world);
            this.ms_g3d.releaseTarget();
        }
        if (CONSOLE) {
            this.m_iTiempo3D = (int)System.currentTimeMillis() - this.m_iTiempo3D;
            this.m_iTiempo2D = (int)System.currentTimeMillis();
        }
        if (USE_TRY) {
            try {
                this.draw2D(g);
            }
            catch (Exception exception) {}
        } else {
            this.draw2D(g);
        }
        if (CONSOLE) {
            this.m_iTiempo2D = (int)System.currentTimeMillis() - this.m_iTiempo2D;
            this.showConsoleInfo(g);
        }
        this.m_currentTime += this.m_deltaTime;
        if (this.m_iGameState == 114) {
            this.m_iRaceTime += this.m_deltaTime;
        } else if (this.m_iGameState == 113) {
            this.m_iCountDownTime += this.m_deltaTime;
        }
    }

    public void drawSoftKeys(Graphics g, boolean bRepaint) {
        if (this.m_bWaiting) {
            return;
        }
        g.setFont(Platform.SoftKeyFont);
        int ychange = 0;
        if (this.m_iSKLDespla > 0) {
            this.m_iSKLDespla -= this.m_iSKLDespla >> 1;
        }
        if (this.m_iSKRDespla > 0) {
            this.m_iSKRDespla -= this.m_iSKRDespla >> 1;
        }
        if (this.leftSoftCommand == null && this.rightSoftCommand == null) {
            return;
        }
        if (this.m_world == null || bRepaint) {
            g.setColor(0x101010);
            g.setStrokeStyle(0);
            if (this.leftSoftCommand != null) {
                g.fillRect(0, 224, g.getFont().stringWidth(this.leftSoftCommand.getLabel()) + 4, 16);
            }
            if (this.rightSoftCommand != null) {
                g.fillRect(320 - g.getFont().stringWidth(this.rightSoftCommand.getLabel()) - 4, 224, g.getFont().stringWidth(this.rightSoftCommand.getLabel()) + 4, 16);
            }
        }
        if (this.m_world != null) {
            g.setColor(0);
            if (this.leftSoftCommand != null) {
                g.drawString(this.leftSoftCommand.getLabel(), 4 - this.m_iSKLDespla + 1, 240 + ychange + 1, 36);
            }
            if (this.rightSoftCommand != null) {
                g.drawString(this.rightSoftCommand.getLabel(), 316 + this.m_iSKRDespla - 1, 240 + ychange + 1, 40);
            }
        }
        g.setColor(16711749);
        if (this.leftSoftCommand != null) {
            g.drawString(this.leftSoftCommand.getLabel(), 4 - this.m_iSKLDespla, 240 + ychange, 36);
        }
        if (this.rightSoftCommand != null) {
            g.drawString(this.rightSoftCommand.getLabel(), 316 + this.m_iSKRDespla, 240 + ychange, 40);
        }
    }

    public void changeToCameraRace() {
        Symbian.view_setCamera(this.m_world, (Object3D)this.m_Camera[0]);
        this.setViewportValues(0, 96, 320, 144);
    }

    public void updateBeforeRender(int pDeltaTime) {
        if (this.m_iGameState == 114) {
            if (KeyState.m_keyPressed || ms_iGamePadTouched) {
                this.processInGameKeyboard();
                if (!KeyState.m_camSwitchPressed && this.m_hInRaceCamera == this.m_Camera[1]) {
                    this.restoreCamera();
                }
            } else if (this.m_hInRaceCamera == this.m_Camera[1]) {
                this.restoreCamera();
            }
        } else {
            ms_iGamePadTouched = false;
            if (KeyState.m_keyPressed) {
                this.processMenuKeyboard();
            }
        }
        switch (this.m_iGameState) {
            case 114: {
                this.updateRace(pDeltaTime);
                return;
            }
            case 100: 
            case 101: 
            case 102: {
                this.manageLoadingRace();
                break;
            }
            case 105: {
                this.prepareRace();
                break;
            }
            case 110: {
                if (this.m_currentTime <= 3000) break;
                this.unloadImagesForMenu();
                this.changeMode(111);
                break;
            }
            case 111: {
                this.preparePlayStarAnim();
                break;
            }
            case 112: {
                if (this.m_currentTime > 8500 || this.m_iKindOfRace == 0) {
                    if (this.m_tCamera.oYaw.angle == -0.7854f) {
                        this.changeToCameraRace();
                    }
                    this.m_tCamera.oYaw.angle += 0.023562f;
                    Symbian.transform_setOrientation(this.m_tCamera.hYaw, this.m_tCamera.oYaw);
                    if (this.m_tCamera.oYaw.angle >= -0.005f) {
                        this.m_tCamera.oYaw.angle = -0.005f;
                        this.preparePlayCountDown();
                    }
                    this.moveBackground(this.m_tCamera.oYaw.angle);
                }
                this.m_Lapcontrol.update(0);
                this.m_UserCar.updateDynamics(0.0f, 0);
                this.m_UserCar.updateBackHead(this.m_tCamera.oYaw.angle);
                if (this.m_iKindOfRace == 3) {
                    this.m_AICar[0].updateBackHead(-this.m_tCamera.oYaw.angle * 0.5f);
                } else if (this.m_AICar != null) {
                    int iIndex = this.m_AICar.length;
                    while (--iIndex >= 0) {
                        this.m_AICar[iIndex].updateBackHead(this.m_tCamera.oYaw.angle);
                    }
                }
                this.manageAI(0, 0);
                break;
            }
            case 113: {
                this.m_Lapcontrol.update(0);
                this.m_UserCar.updateDynamics(0.0f, 0);
                this.manageAI(0, 0);
                if (this.m_iCountDownTime > 4500) {
                    this.preparePlayRacing();
                    break;
                }
                if (this.m_iCountDownTime <= 1425 || !GameSettings.m_bSound || this.m_bSoundStartRace) break;
                if (this.m_sound != null) {
                    this.m_sound.play();
                }
                this.m_bSoundStartRace = true;
                break;
            }
            case 116: {
                this.updateCarsAndMore(pDeltaTime);
                if (this.m_currentTime <= 2000) break;
                if (this.m_iKindOfRace == 0) {
                    this.prepareDlgShowUserTime();
                    break;
                }
                if (this.m_iKindOfRace == 3) {
                    this.finishingRace();
                    break;
                }
                this.prepareDlgShowRaceTimes();
                break;
            }
            case -2: {
                if (this.m_currentTime < 200) break;
                this.manageLoadIntroFiles();
                break;
            }
            case 0: {
                this.manageLoadIntroFiles();
                break;
            }
            case 1: {
                if ((long)this.m_currentTime <= 3000L) break;
                this.prepareSplashScreen();
                break;
            }
            case 2: {
                if ((long)this.m_currentTime <= 3000L) break;
                this.prepareIntroAnim();
                break;
            }
            case 11: {
                if (!this.m_LoaderRacers.finished()) break;
                this.prepareResumeFromPreloadRacers();
                break;
            }
            case 64: {
                if (this.m_currentTime <= 0) break;
                this.prepareDlgChallengeNow();
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                this.manageAnimation(this.m_currentTime);
            }
        }
        if (this.m_world != null && (this.m_iGameState < 100 || this.m_iGameState > 111)) {
            this.m_iValidity = this.m_world.animate(this.m_currentTime);
        }
    }

    public void moveBackground(float aRad) {
        this.mBackgroundCropX += aRad * 88.0f;
        if (this.mBackgroundCropX > (float)this.m_iBackgroundWidth) {
            this.mBackgroundCropX -= (float)this.m_iBackgroundWidth;
        } else if (this.mBackgroundCropX < (float)(-this.m_iBackgroundWidth)) {
            this.mBackgroundCropX += (float)this.m_iBackgroundWidth;
        }
        this.mBackground.setCrop((int)this.mBackgroundCropX, 0, this.m_iBackgroundWidth, this.m_iBackgroundHeight);
    }

    public void draw2D(Graphics g) {
        this.m_bWaiting = false;
        boolean bRepaintSK = false;
        if (this.m_iGameState >= 112 && this.m_iGameState <= 116) {
            if (this.m_currentTime == 0 || bRedrawFullInGameInterface) {
                g.setColor(3102130);
                g.fillRect(0, 0, 320, 96);
                this.m_Window.repaint();
            }
            if (this.m_iGameState == 116 && this.m_iKindOfRace == 3) {
                g.setColor((int)(this.m_fBombFade * 255.0f), (int)(this.m_fBombFade * 255.0f), (int)(this.m_fBombFade * 255.0f));
                g.setStrokeStyle(0);
                g.fillRect(0, 0, 320, 240);
            } else {
                if (CONSOLE) {
                    this.m_iTiempoSR = (int)System.currentTimeMillis();
                }
                this.m_Window.showRace(g);
                if (CONSOLE) {
                    this.m_iTiempoSR = (int)System.currentTimeMillis() - this.m_iTiempoSR;
                }
                if (this.m_iGameState == 113) {
                    this.drawCountDown(g);
                } else if (this.m_iGameState == 114 && this.m_bGo) {
                    this.drawGo(g);
                }
            }
        } else {
            switch (this.m_iGameState) {
                case 1: {
                    g.setColor(0xFFFFFFF);
                    g.fillRect(0, 0, 320, 240);
                    g.drawImage(ms_vKitmakerLogo, 160 - (ms_vKitmakerLogo.getWidth() >> 1), 120 - (ms_vKitmakerLogo.getHeight() >> 1), 0);
                    break;
                }
                case 2: {
                    g.drawImage(ms_vSplashScreen, 0, 0, 0);
                    break;
                }
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 27: 
                case 28: 
                case 30: 
                case 31: 
                case 99: {
                    if (this.m_currentTime == 0 || bRedrawFullInGameInterface) {
                        this.m_CurrentMenu.paintTitle(g);
                    }
                    if (this.m_iGameState == 23) {
                        ((RiderMenu)this.m_CurrentMenu).update();
                    } else if (this.m_iGameState == 24) {
                        ((CircuitsMenu)this.m_CurrentMenu).update(g);
                    }
                    if (this.m_iGameState == 31) {
                        ((QuickRaceMenu)this.m_CurrentMenu).paintBody(g);
                    } else {
                        this.m_CurrentMenu.paintBody(g);
                    }
                    if (!this.m_bGameInPauseMenu) break;
                    bRepaintSK = true;
                    break;
                }
                case 26: {
                    if (this.m_currentTime == 0 || bRedrawFullInGameInterface) {
                        this.m_CurrentMenu.paintTitle(g);
                    }
                    ++RiderMenu.ms_iTriFrame;
                    int iExtraX = 0;
                    for (int i = 0; i < 3; ++i) {
                        g.setColor(RiderMenu.TRI_COLORS[(RiderMenu.ms_iTriFrame + i) % RiderMenu.TRI_COLORS.length]);
                        g.fillTriangle(50 + iExtraX, 30, 90 + iExtraX, 15, 90 + iExtraX, 45);
                        g.setColor(RiderMenu.TRI_COLORS[(RiderMenu.ms_iTriFrame + i) % RiderMenu.TRI_COLORS.length]);
                        g.fillTriangle(270 - iExtraX, 30, 230 - iExtraX, 45, 230 - iExtraX, 15);
                        iExtraX += 20;
                    }
                    this.m_CurrentMenu.paintBody(g);
                    ((CircuitsMenu)this.m_CurrentMenu).update(g);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    this.drawIntroAnim(g, this.m_currentTime);
                    break;
                }
                case 46: 
                case 47: 
                case 55: 
                case 58: 
                case 62: 
                case 63: 
                case 65: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    bRepaintSK = true;
                    this.drawChallenge(g);
                    break;
                }
                case 51: 
                case 54: 
                case 59: 
                case 60: 
                case 68: 
                case 69: 
                case 81: {
                    this.drawDialog(g);
                    break;
                }
                case 0: 
                case 11: 
                case 12: 
                case 19: 
                case 64: 
                case 100: 
                case 101: 
                case 102: 
                case 110: 
                case 111: {
                    this.drawLoading(g);
                }
            }
        }
        this.drawSoftKeys(g, bRepaintSK);
        if (bRedrawFullInGameInterface) {
            bRedrawFullInGameInterface = false;
        }
    }

    void showConsoleInfo(Graphics g) {
        Font aFont = g.getFont();
        int aColor = g.getColor();
        g.setFont(Platform.FONT_SYSTEM_BOLD_SMALL);
        int iHeightF = g.getFont().getHeight();
        g.setColor(0xFF4444);
        g.setFont(aFont);
        g.setColor(aColor);
        aFont = null;
    }

    void drawIntroAnim(Graphics g, int iTime) {
        Font aFont = g.getFont();
        g.setFont(Platform.FONT_SYSTEM_BOLD_LARGE);
        g.setColor(0xFFFFFF);
        if (this.m_iGameState == 9) {
            int aTime = iTime;
            if (aTime > 0) {
                int iY = (int)((float)aTime / 1250.0f * (float)m_Image[0].getHeight());
                if (iY > m_Image[0].getHeight()) {
                    iY = m_Image[0].getHeight();
                }
                g.drawImage(m_Image[1], 0, 0, 20);
                g.drawImage(m_Image[0], 160, iY, 33);
            }
        } else if (this.m_iGameState == 8) {
            g.drawImage(m_Image[1], 0, 0, 20);
        } else if (this.m_iGameState != 7) {
            int iY;
            String aDriver = "";
            int iX = 160 - (g.getFont().stringWidth(aDriver) >> 1);
            if (this.m_iGameState == 3) {
                if (this.m_currentTime > 500) {
                    aDriver = LanguageManager.GetString("M120");
                }
                iY = 240;
            } else if (this.m_iGameState == 4) {
                if (this.m_currentTime > 3750) {
                    aDriver = LanguageManager.GetString("M121");
                }
                iY = 240;
            } else if (this.m_iGameState == 5) {
                if (this.m_currentTime > 7000) {
                    aDriver = LanguageManager.GetString("M122");
                }
                iY = 240;
            } else {
                if (this.m_currentTime > 10250) {
                    aDriver = LanguageManager.GetString("M123");
                }
                iY = 240;
            }
            g.drawString(aDriver, iX, iY, 33);
        }
        g.setFont(aFont);
    }

    public void commandAction(Command cmd, Displayable disp) {
        switch (this.m_iGameState) {
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 99: {
                this.m_CurrentMenu.cmdAction(cmd, this);
                break;
            }
            case 46: 
            case 47: 
            case 55: 
            case 58: 
            case 62: 
            case 63: 
            case 65: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                ((DialogChallenge)this.m_CurrentDialog).cmdAction(cmd, this);
                break;
            }
            case 51: 
            case 54: 
            case 59: 
            case 60: 
            case 68: 
            case 69: 
            case 81: {
                this.m_CurrentDialog.cmdAction(cmd, this);
                break;
            }
            case 116: {
                break;
            }
            case 113: 
            case 114: {
                if (cmd != TData.emptyleftCommand && cmd != TData.emptyrightCommand) break;
                this.m_oldInRaceGameState = this.m_iGameState;
                this.m_oldCurrentTime = this.m_currentTime;
                this.m_UserCar.vibrate(0);
                if (GameSettings.m_bSound && this.m_sound != null) {
                    this.m_sound.stop();
                }
                this.prepareMenuInGamePause();
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                if (cmd != TData.skipCommand) break;
                this.prepareIntroAnim4();
                break;
            }
        }
    }

    synchronized void exitGame() {
        this.m_midlet.destroyApp(false);
    }

    void drawChallenge(Graphics g) {
        if (this.m_currentTime == 0 || bRedrawFullInGameInterface) {
            ((DialogChallenge)this.m_CurrentDialog).paintTitle(g);
        }
        ((DialogChallenge)this.m_CurrentDialog).paintBody(g);
        if (this.m_iGameState == 65) {
            g.setFont(Platform.FONT_MENU);
            if (this.getProgress() != 6) {
                this.m_Window.showTrackInfo2(g, this.m_tRaceInfo.tTrackInfo.iImageHudShape, 108, this.getTrack());
            }
        }
    }

    void drawDialog(Graphics g) {
        if (this.m_iGameState == 59 || this.m_iGameState == 60) {
            g.setColor(0xFFFFFF);
            g.setStrokeStyle(0);
            g.fillRect(0, 0, 320, 240);
        }
        this.m_CurrentDialog.paintBody(g);
        if (this.m_iGameState == 54) {
            this.m_Window.displayUserTime(g);
        } else if (this.m_iGameState == 68) {
            this.m_Window.displayRaceTimes(g);
        } else if (this.m_iGameState == 69) {
            this.m_Window.showPersonalBestTimes(g);
        }
    }

    public void keyPressed(int keyCode) {
        try {
            switch (keyCode) {
                case 8: {
                    keyCode = -8;
                }
                case 116: {
                    keyCode = -1;
                    break;
                }
                case 102: {
                    keyCode = -3;
                    break;
                }
                case 104: {
                    keyCode = -4;
                    break;
                }
                case 98: {
                    keyCode = -2;
                    break;
                }
                case 103: {
                    keyCode = 53;
                    break;
                }
                case -5: {
                    keyCode = 53;
                    break;
                }
                case 100: 
                case 106: 
                case 107: 
                case 109: 
                case 114: 
                case 118: {
                    keyCode = 0;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        KeyState.m_LastkeyCode = keyCode;
        KeyState.KeyPressed(keyCode);
        if (this.mStartApp || this.mNeedsResume) {
            if (keyCode == -6 || KeyState.m_ACTION_MENU_SELECT) {
                if (this.mNeedsResume) {
                    this.finishResumingApp();
                } else if (this.mStartApp) {
                    this.mStartApp = false;
                    this.prepareSetSoundAndContinue(true);
                }
            } else if (keyCode == -7 && !this.mNeedsResume && this.mStartApp) {
                this.mStartApp = false;
                this.prepareSetSoundAndContinue(false);
            }
            KeyState.resetActionKeys();
            return;
        }
        if (keyCode == -6 && this.leftSoftCommand != null) {
            this.commandAction(this.leftSoftCommand, (Displayable)this);
            KeyState.KeyReleased(keyCode);
            return;
        }
        if (keyCode == -7 && this.rightSoftCommand != null) {
            this.commandAction(this.rightSoftCommand, (Displayable)this);
            KeyState.KeyReleased(keyCode);
            return;
        }
    }

    public void keyReleased(int keyCode) {
        try {
            switch (keyCode) {
                case 8: {
                    keyCode = -8;
                }
                case 116: {
                    keyCode = -1;
                    break;
                }
                case 102: {
                    keyCode = -3;
                    break;
                }
                case 104: {
                    keyCode = -4;
                    break;
                }
                case 98: {
                    keyCode = -2;
                    break;
                }
                case 103: {
                    keyCode = 53;
                    break;
                }
                case -5: {
                    keyCode = 53;
                    break;
                }
                case 100: 
                case 106: 
                case 107: 
                case 109: 
                case 114: 
                case 118: {
                    keyCode = 0;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.m_iGameState == 114) {
            KeyState.KeyReleased(keyCode);
        }
    }

    void TouchScreenCheck() {
        TOUCHSCREEN_SUPPORTED = this.hasPointerEvents() && this.hasPointerMotionEvents();
    }

    protected void pointerPressed(int _iX, int _iY) {
        ms_iScreenTouched_Map = 1;
        ms_iScreenTouched_X = _iX;
        ms_iScreenTouched_Y = _iY;
        ms_iScreenTouched_Frames = 0;
        ms_iScreenOrigin_X = ms_iScreenTouched_X;
        ms_iScreenOrigin_Y = ms_iScreenTouched_Y;
        block0 : switch (this.m_iGameState) {
            case 20: 
            case 25: 
            case 27: 
            case 30: 
            case 31: 
            case 99: {
                int iMenuH = this.m_CurrentMenu.m_Font.getHeight() + 0;
                int iMenuY = this.m_CurrentMenu.m_BaseY;
                for (int i = 0; i < this.m_CurrentMenu.m_OpcionMaxima; ++i) {
                    iMenuY = this.m_CurrentMenu.m_BaseY + i * iMenuH - (iMenuH >> 1);
                    if (_iY <= iMenuY || _iY >= iMenuY + iMenuH) continue;
                    ms_iMenuTouchedIndex = i;
                    this.m_CurrentMenu.setCurrentOption(i);
                    break block0;
                }
                break;
            }
            case 23: 
            case 24: 
            case 26: {
                if (_iY >= 60) break;
                if (_iX < 160) {
                    this.m_CurrentMenu.menuUp();
                } else {
                    this.m_CurrentMenu.menuDown();
                }
                if (this.m_iGameState == 23) break;
                this.m_CurrentMenu.lastActions(this);
                break;
            }
        }
    }

    protected void pointerDragged(int _iX, int _iY) {
        ms_iScreenTouched_Map = 2;
        ms_iScreenTouched_X = _iX;
        ms_iScreenTouched_Y = _iY;
        ++ms_iScreenTouched_Frames;
        block0 : switch (this.m_iGameState) {
            case 20: 
            case 25: 
            case 27: 
            case 30: 
            case 31: 
            case 99: {
                int iMenuH = this.m_CurrentMenu.m_Font.getHeight() + 0;
                int iMenuY = this.m_CurrentMenu.m_BaseY;
                for (int i = 0; i < this.m_CurrentMenu.m_OpcionMaxima; ++i) {
                    iMenuY = this.m_CurrentMenu.m_BaseY + i * iMenuH - (iMenuH >> 1);
                    if (_iY <= iMenuY || _iY >= iMenuY + iMenuH) continue;
                    this.m_CurrentMenu.setCurrentOption(i);
                    break block0;
                }
                break;
            }
        }
    }

    protected void pointerReleased(int _iX, int _iY) {
        ms_iScreenTouched_Map = 0;
        ms_iScreenTouched_X = _iX;
        ms_iScreenTouched_Y = _iY;
        ms_iScreenTouched_Frames = 0;
        block0 : switch (this.m_iGameState) {
            case 20: 
            case 25: 
            case 27: 
            case 30: 
            case 31: 
            case 99: {
                int iMenuH = this.m_CurrentMenu.m_Font.getHeight() + 0;
                int iMenuY = this.m_CurrentMenu.m_BaseY;
                for (int i = 0; i < this.m_CurrentMenu.m_OpcionMaxima; ++i) {
                    iMenuY = this.m_CurrentMenu.m_BaseY + i * iMenuH - (iMenuH >> 1);
                    if (_iY <= iMenuY || _iY >= iMenuY + iMenuH) continue;
                    if (ms_iMenuTouchedIndex != i) break block0;
                    this.keyPressed(-6);
                    break block0;
                }
                break;
            }
            case 114: {
                break;
            }
            case 46: 
            case 47: 
            case 51: 
            case 54: 
            case 55: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 81: {
                ((DialogChallenge)this.m_CurrentDialog).processTouched(this, _iX, _iY);
            }
        }
        if (ms_iScreenTouched_X < 32 && ms_iScreenTouched_Y > 208) {
            this.keyPressed(-6);
        } else if (ms_iScreenTouched_X > 288 && ms_iScreenTouched_Y > 208) {
            this.keyPressed(-7);
        }
    }

    static boolean GameScreenTouched(boolean _bResetTouch, boolean _bGetMove) {
        boolean bPressed;
        boolean bl = bPressed = (ms_iScreenTouched_Map == 1 || ms_iScreenTouched_Map == 2 && ms_iScreenTouched_Frames < 5 || ms_iScreenTouched_Map == 2 && _bGetMove) && TOUCHSCREEN_SUPPORTED;
        if (bPressed && _bResetTouch && !_bGetMove) {
            ms_iScreenTouched_Map = 0;
        }
        return bPressed;
    }

    static boolean GameScreenTouched(int _iX0, int _iY0, int _iX1, int _iY1, boolean _bResetTouch, boolean _bGetMove) {
        boolean bPressed;
        boolean bl = bPressed = (ms_iScreenTouched_Map == 1 || ms_iScreenTouched_Map == 2 && ms_iScreenTouched_Frames < 5 || ms_iScreenTouched_Map == 2 && _bGetMove) && TOUCHSCREEN_SUPPORTED && ms_iScreenTouched_X > _iX0 && ms_iScreenTouched_X < _iX1 && ms_iScreenTouched_Y > _iY0 && ms_iScreenTouched_Y < _iY1;
        if (bPressed && _bResetTouch && !_bGetMove) {
            ms_iScreenTouched_Map = 0;
        }
        return bPressed;
    }

    static boolean GameScreenSoftkey(int _iSoftKey) {
        boolean bPressed = false;
        if (ms_iScreenTouched_Map == 1 || ms_iScreenTouched_Map == 2) {
            if (_iSoftKey == 0) {
                ms_bSoftLeft = ms_iScreenTouched_X < 32 && ms_iScreenTouched_Y > 208;
            } else if (_iSoftKey == 1) {
                ms_bSoftRight = ms_iScreenTouched_X > 288 && ms_iScreenTouched_Y > 208;
            }
        } else if (ms_iScreenTouched_Map == 0) {
            if (_iSoftKey == 0 && ms_bSoftLeft) {
                ms_bSoftLeft = false;
                bPressed = true;
            } else if (_iSoftKey == 1 && ms_bSoftRight) {
                ms_bSoftRight = false;
                bPressed = true;
            }
        }
        return bPressed;
    }

    static boolean GameScreenSoftkeyOrigin(int _iSoftKey) {
        boolean bPressed = false;
        if (ms_iScreenTouched_Map == 1 || ms_iScreenTouched_Map == 2) {
            ms_bSoftRight = ms_iScreenTouched_X > 288 && ms_iScreenTouched_Y > 208 && ms_iScreenOrigin_X > 288 && ms_iScreenOrigin_Y > 208;
        } else if (ms_iScreenTouched_Map == 0 && _iSoftKey == 1 && ms_bSoftRight) {
            bPressed = true;
            ms_bSoftRight = false;
        }
        return bPressed;
    }

    public boolean TouchScreenReleased() {
        return ms_iScreenTouched_X == -1;
    }

    public void processMenuKeyboard() {
        if (this.m_bNoKeyForSuppressKeyEvent) {
            if (this.m_iSKLDespla > 1 || this.m_iSKRDespla > 1) {
                return;
            }
            switch (this.m_iGameState) {
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 30: 
                case 31: 
                case 99: {
                    this.m_CurrentMenu.processKey(this);
                    break;
                }
                case 46: 
                case 47: 
                case 55: 
                case 58: 
                case 62: 
                case 63: 
                case 65: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    ((DialogChallenge)this.m_CurrentDialog).processKey(this);
                    break;
                }
                case 51: 
                case 54: 
                case 59: 
                case 60: 
                case 68: 
                case 69: 
                case 81: {
                    this.m_CurrentDialog.processKey(this);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    if (!KeyState.m_ACTION_MENU_SELECT) break;
                    this.prepareIntroAnim4();
                    break;
                }
                case 112: {
                    this.changeToCameraRace();
                    this.preparePlayCountDown();
                    break;
                }
                case 116: {
                    break;
                }
                default: {
                    Platform.ToJumpOrNotToJump(this.m_iGameState);
                }
            }
            KeyState.resetActionKeys();
        }
    }

    public void addCommand(Command c) {
        switch (c.getCommandType()) {
            case 4: 
            case 5: 
            case 8: {
                this.leftSoftCommand = c;
                this.m_iSKLDespla = this.m_iSKLLong = Platform.SoftKeyFont.stringWidth(this.leftSoftCommand.getLabel());
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                this.rightSoftCommand = c;
                this.m_iSKRDespla = this.m_iSKRLong = Platform.SoftKeyFont.stringWidth(this.rightSoftCommand.getLabel());
                break;
            }
        }
    }

    public void removeCommand(Command c) {
        switch (c.getCommandType()) {
            case 4: 
            case 5: 
            case 8: {
                this.leftSoftCommand = null;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                this.rightSoftCommand = null;
                break;
            }
        }
    }

    public void manageAnimation(int aTiempo) {
        switch (this.m_iGameState) {
            case 3: {
                if (aTiempo <= 3250) break;
                this.m_IntroHeads[0].setRenderingEnable(false);
                this.m_IntroHeads[1].setRenderingEnable(true);
                this.changeMode(4);
                break;
            }
            case 4: {
                if (aTiempo <= 6500) break;
                this.m_IntroHeads[1].setRenderingEnable(false);
                this.m_IntroHeads[2].setRenderingEnable(true);
                this.changeMode(5);
                break;
            }
            case 5: {
                if (aTiempo <= 9750) break;
                this.m_IntroHeads[2].setRenderingEnable(false);
                this.m_IntroHeads[3].setRenderingEnable(true);
                this.removeCanvasCommands();
                this.changeMode(6);
                break;
            }
            case 6: {
                if (aTiempo <= 13000) break;
                this.prepareIntroAnim4();
                break;
            }
            case 7: {
                if (aTiempo <= 14250) break;
                this.generateBackgroundImage();
                this.m_LoaderIntro.destroy();
                this.m_LoaderIntro = null;
                this.m_world = null;
                this.preparePreloadRacers(12);
                break;
            }
            case 8: {
                this.changeMode(9);
                break;
            }
            case 9: {
                if (aTiempo <= 1500) break;
                this.endIntroAnimation();
            }
        }
    }

    public synchronized void prepareIntroAnim4() {
        this.loadImagesForMenu();
        this.removeCanvasCommands();
        Utils.stopAnimation((Object3D)this.m_world, 253469715);
        Utils.startAnimation((Object3D)this.m_world, 533981023, 13000);
        this.m_currentTime = 13000;
        ((Node)this.m_world.find(186650103)).setRenderingEnable(true);
        for (int iIndex = 0; iIndex < this.m_IntroHeads.length; ++iIndex) {
            this.m_IntroHeads[iIndex] = null;
        }
        this.m_IntroHeads = null;
        this.m_ChallengeRMS = new ChallengeRMS();
        this.m_iProgress = this.getProgressRMS();
        this.m_iPersistentProgress = this.getProgressPersistenteRMS();
        this.changeMode(7);
    }

    public synchronized void prepareMenuMain() {
        Utils.m_Random.setSeed(System.currentTimeMillis());
        this.setViewportValues(0, 0, 320, 240);
        this.unloadImagesForEnterInitials();
        if (GameSettings.m_bSound) {
            boolean bPlay = true;
            if (this.m_sound == null || this.m_sound != null && this.m_sound.getID() != 0) {
                this.loadSound(0);
                if (this.m_sound == null) {
                    bPlay = false;
                }
            } else if (this.m_sound == null || this.m_sound != null && this.m_sound.getState() == 400) {
                bPlay = false;
            }
            if (bPlay) {
                this.m_sound.play();
            }
        }
        if (this.m_LoaderRacers == null) {
            this.preparePreloadRacers(10);
        } else {
            this.removeCanvasCommands();
            this.loadImagesForMenu();
            this.m_world = null;
            this.m_CurrentMenu = new MainMenu(Platform.FONT_MENU, m_Image[0]);
            this.addCommand(TData.okCommand);
            this.addCommand(TData.quitCommand);
            this.changeMode(20);
        }
    }

    synchronized void prepareDlgForChallenge() {
        this.destroyRace();
        this.m_bChallenge = true;
        if (this.m_LoaderRacers == null) {
            this.preparePreloadRacers(65);
        } else {
            switch (this.m_iProgress) {
                case 0: 
                case 1: {
                    this.setTrack(1);
                    break;
                }
                case 2: 
                case 3: {
                    this.setTrack(2);
                    break;
                }
                case 4: 
                case 5: {
                    this.setTrack(3);
                }
            }
            this.changeMode(64);
        }
    }

    synchronized void prepareDlgChallengeNow() {
        if (this.getProgress() != 6) {
            this.loadTrackPreview(this.getTrack());
        }
        this.loadRacerChallenge();
        this.prepareDlgChallenge(65);
    }

    synchronized void prepareDlgChallengeFail() {
        this.destroyRace();
        if (this.m_LoaderRacers == null) {
            this.preparePreloadRacers(46);
        } else {
            this.loadRacerChallenge();
            this.prepareDlgChallenge(46);
        }
    }

    synchronized void prepareDlgResetChallenges() {
        if (this.m_LoaderRacers == null) {
            this.preparePreloadRacers(73);
        } else {
            this.removeCanvasCommands();
            this.addCommand(TData.yesCommand);
            this.addCommand(TData.noCommand);
            this.loadRacerChallenge();
            this.launchDlgBubble(LanguageManager.GetString("MRstCh"), 73);
        }
    }

    synchronized void prepareResumeFromPreloadRacers() {
        switch (this.m_iPreloadGameState) {
            case 12: {
                this.changeMode(9);
                break;
            }
            case 10: {
                this.generateBackgroundImage();
                this.prepareMenuMain();
                break;
            }
            case 65: {
                this.prepareDlgForChallenge();
                break;
            }
            case 46: {
                this.prepareDlgChallengeFail();
                break;
            }
            case 19: {
                this.prepareBestTimesMenuPersonal();
                break;
            }
            case 71: {
                this.launchHelp();
                break;
            }
            case 62: {
                this.launchYouMustProgressInChallenges();
                break;
            }
            case 70: {
                this.launchCredits();
                break;
            }
            case 72: {
                this.launchAbout();
                break;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                this.prepareHelpQuickRace();
                break;
            }
            case 73: {
                this.prepareDlgResetChallenges();
                break;
            }
            case 58: {
                this.prepareDlgAskToPlayAgain();
                break;
            }
            case 63: {
                this.prepareDlgDeleteRecordsConfirmation();
                break;
            }
            case 55: {
                this.prepareDlgExitGame();
            }
        }
    }

    synchronized void prepareChallenge2MainMenu() {
        this.m_world = null;
        this.m_bChallenge = false;
        this.generateBackgroundImage();
        this.prepareMenuMain();
    }

    public synchronized void prepareQuickRaceMenu() {
        this.m_bChallenge = false;
        this.removeCanvasCommands();
        this.m_world = null;
        this.loadImagesForMenu();
        this.m_CurrentMenu = new QuickRaceMenu(Platform.FONT_MENU, m_Image[0]);
        this.changeMode(31);
    }

    public synchronized void prepareDlgEndBombChase() {
        if (this.m_bWinRace) {
            this.prepareDlgFont(59, Platform.FONT_SYSTEM_BOLD_SMALL);
        } else {
            this.prepareDlgFont(60, Platform.FONT_SYSTEM_BOLD_SMALL);
        }
    }

    public synchronized void updateScore(String aDriver) {
        this.removeCanvasCommands();
        ArcadeRMS.SetScore(this.getTrack(), this.getRacer(), aDriver, this.m_Lapcontrol.getTotalTime(0));
    }

    public synchronized void updateScoreAndShowBestTimes(String aDriver) {
        this.updateScore(aDriver);
        this.unloadImagesForEnterInitials();
        this.prepareShowBestTimesAfterRace();
    }

    public synchronized void prepareShowBestTimesAfterRace() {
        this.removeCanvasCommands();
        this.addCommand(TData.okCommand);
        if (this.m_tPersonalTimes != null) {
            this.m_tPersonalTimes.destroy();
            this.m_tPersonalTimes = null;
        }
        this.m_tPersonalTimes = new TTimesRecordVector();
        this.m_tPersonalTimes.iPosition = ArcadeRMS.GetPosition(this.getTrack());
        ArcadeRMS.LoadPersonalTimes(this.getTrack(), this.m_tPersonalTimes);
        this.m_Window.setPersonalTimes(this.m_tPersonalTimes);
        this.m_Window.repaint();
        this.prepareDlg(69);
    }

    synchronized void prepareAfterEnterInitialsAndShowBestTimes() {
        this.m_tPersonalTimes.destroy();
        this.m_tPersonalTimes = null;
        if (!this.m_bChallenge) {
            this.prepareDlgAskToPlayAgain();
        } else if (!this.m_bWinRace) {
            this.prepareDlgChallengeFail();
        } else {
            this.prepareProgressInChallenge();
        }
    }

    synchronized void prepareDlgShowRaceTimes() {
        this.m_Lapcontrol.calculateOrderAndGetRaceTimes(this.m_tRaceTimes);
        this.m_Window.repaint();
        this.prepareDlg(68);
    }

    synchronized void prepareDlgShowUserTime() {
        this.m_Window.repaint();
        this.prepareDlg(54);
    }

    public synchronized void launchDlgBubble(String sText, int p_iState) {
        this.loadImagesForMenu();
        this.m_CurrentDialog = new DialogChallenge(0, 12, Platform.FONT_MENU, (Object)this, m_Image[0], "", sText);
        bRedrawFullInGameInterface = true;
        this.changeMode(p_iState);
    }

    public synchronized void prepareDlgAskToPlayAgain() {
        if (this.m_LoaderRacers == null) {
            this.preparePreloadRacers(58);
        } else {
            this.loadRacerChallenge(true);
            this.removeCanvasCommands();
            this.addCommand(TData.yesCommand);
            this.addCommand(TData.noCommand);
            this.launchDlgBubble(LanguageManager.GetString("MPlayA"), 58);
        }
    }

    public synchronized void launchCredits() {
        if (this.m_LoaderRacers == null) {
            this.preparePreloadRacers(70);
        } else {
            this.loadRacerChallenge();
            this.removeCanvasCommands();
            this.addCommand(TData.okCommand);
            String zAbout = LanguageManager.GetString("M7t");
            zAbout = Platform.parseText(zAbout, "$0", GameMIDlet.APPLICATION_VERSION);
            this.launchDlgBubble(zAbout, 70);
        }
    }

    public synchronized void resetChallenges() {
        this.setProgress(-2);
        this.prepareDlgChallengesResetOK();
    }

    public synchronized void prepareDlgChallengesResetOK() {
        this.loadRacerChallenge();
        this.removeCanvasCommands();
        this.addCommand(TData.okCommand);
        this.launchDlgBubble(LanguageManager.GetString("MChRstOk"), 47);
    }

    public synchronized void launchAbout() {
        if (this.m_LoaderRacers == null) {
            this.preparePreloadRacers(72);
        } else {
            this.loadRacerChallenge();
            this.removeCanvasCommands();
            this.addCommand(TData.okCommand);
            String aboutText = LanguageManager.GetString("M11t");
            int pos = aboutText.indexOf("$0");
            if (pos != -1) {
                aboutText = aboutText.substring(0, pos) + this.m_midlet.getAppProperty("MIDlet-Version") + aboutText.substring(pos + 2);
            }
            this.launchDlgBubble(aboutText, 72);
        }
    }

    public synchronized void launchHelp() {
        if (this.m_LoaderRacers == null) {
            this.preparePreloadRacers(71);
        } else {
            this.loadRacerChallenge();
            this.removeCanvasCommands();
            this.addCommand(TData.okCommand);
            this.launchDlgBubble(LanguageManager.GetString("M6T"), 71);
        }
    }

    public synchronized void launchYouMustProgressInChallenges() {
        if (this.m_LoaderRacers == null) {
            this.preparePreloadRacers(62);
        } else {
            this.loadRacerChallenge();
            this.removeCanvasCommands();
            this.addCommand(TData.okCommand);
            this.launchDlgBubble(LanguageManager.GetString("MExtras"), 62);
        }
    }

    public synchronized void prepareHelpQuickRace() {
        int iState = 75 + this.m_iKindOfRace;
        if (this.m_LoaderRacers == null) {
            this.preparePreloadRacers(iState);
        } else {
            this.loadRacerChallenge();
            this.removeCanvasCommands();
            this.addCommand(TData.okCommand);
            this.addCommand(TData.backCommand);
            String sText = "";
            switch (iState) {
                case 75: {
                    sText = LanguageManager.GetString("M6Td");
                    break;
                }
                case 76: {
                    sText = LanguageManager.GetString("M6Tc");
                    break;
                }
                case 77: {
                    sText = LanguageManager.GetString("M6Tb");
                    break;
                }
                case 78: {
                    sText = LanguageManager.GetString("M6Ta");
                }
            }
            this.launchDlgBubble(sText, iState);
        }
    }

    public synchronized void prepareDlgChallenge(int p_iDlg) {
        String sLabel = "";
        this.removeCanvasCommands();
        if (p_iDlg == 46) {
            sLabel = ChallengeRMS.GetRSCFail(this.m_iPersistentProgress);
            this.addCommand(TData.yesCommand);
            this.addCommand(TData.noCommand);
        } else {
            sLabel = ChallengeRMS.GetRSCFile(this.m_iPersistentProgress);
            this.addCommand(TData.okCommand);
            if (this.m_iPersistentProgress != 6) {
                this.addCommand(TData.backCommand);
            }
        }
        this.launchDlgBubble(LanguageManager.GetString(sLabel), p_iDlg);
    }

    public synchronized void prepareDlgExtrasFromCircuitsMenu() {
        this.m_world = null;
        this.launchYouMustProgressInChallenges();
    }

    public synchronized void prepareDlg(int p_iDlg) {
        this.prepareDlgFont(p_iDlg, Platform.FONT_DLG);
    }

    public synchronized void prepareDlgFont(int p_iDlg, Font p_Font) {
        this.removeCanvasCommands();
        this.loadImagesForMenu();
        String sRID = "";
        String sLabel = null;
        switch (p_iDlg) {
            case 54: {
                sRID = "M140";
                this.addCommand(TData.okCommand);
                break;
            }
            case 68: {
                sRID = "M140";
                this.addCommand(TData.okCommand);
                break;
            }
            case 69: {
                this.unloadImagesForMenu();
                sRID = "M5";
                this.addCommand(TData.okCommand);
                break;
            }
            case 59: {
                sLabel = LanguageManager.GetString("M12");
                this.addCommand(TData.okCommand);
                break;
            }
            case 60: {
                sLabel = LanguageManager.GetString("M13");
                this.addCommand(TData.okCommand);
            }
        }
        if (sLabel == null) {
            sLabel = "";
        }
        Object sBuff = null;
        String sDialogTitle = sRID.compareTo("") != 0 ? LanguageManager.GetString(sRID).toUpperCase() : "";
        int aGameStateCopy = this.m_iGameState;
        this.m_iGameState = p_iDlg;
        this.m_CurrentDialog = new DialogResource(0, 0, p_Font, (Object)this, m_Image != null ? m_Image[0] : null, sDialogTitle, sLabel);
        this.m_iGameState = aGameStateCopy;
        this.changeMode(p_iDlg);
    }

    public synchronized void generateBackgroundImage() {
        if (m_Image[1] == null) {
            CartoonRacer.m_Image[1] = Image.createImage((int)320, (int)240);
            Graphics g = m_Image[1].getGraphics();
            World aWorld = null;
            if (this.m_LoaderIntro != null) {
                aWorld = this.m_world;
                ((Node)aWorld.find(296699498)).setRenderingEnable(false);
            } else {
                aWorld = (World)Utils.LoadScene("/back");
                int ih = aWorld.getBackground().getImage().getHeight();
                int iw = aWorld.getBackground().getImage().getWidth();
                aWorld.getBackground().setImageMode(32, 32);
                aWorld.getBackground().setCrop(0, 0, iw, ih);
            }
            this.ms_g3d.bindTarget((Object)g);
            this.ms_g3d.setViewport(0, 0, 320, 240);
            this.ms_g3d.render(aWorld);
            this.ms_g3d.releaseTarget();
            Object var2_2 = null;
        }
    }

    public synchronized void endIntroAnimation() {
        this.setViewportValues(0, 0, 320, 240);
        this.prepareMenuMain();
    }

    synchronized boolean loadRacerChallenge() {
        return this.loadRacerChallenge(false);
    }

    synchronized boolean loadRacerChallenge(boolean bSafeCopy) {
        if (this.m_world != this.m_LoaderRacers.world()) {
            if (this.m_bGameInPauseMenu || bSafeCopy) {
                if (this.m_raceworldsafecoy == null) {
                    this.m_raceworldsafecoy = this.m_world;
                }
            } else {
                this.m_world = null;
            }
            this.m_world = this.m_LoaderRacers.world();
        }
        Utils.stopAnimation((Object3D)this.m_world, 799859962);
        Utils.stopAnimation((Object3D)this.m_world, 533981023);
        Utils.stopAnimation((Object3D)this.m_world, 253469715);
        Utils.stopAnimation((Object3D)this.m_world, 199994821);
        Utils.stopAnimation((Object3D)this.m_world, 112125373);
        Utils.stopAnimation((Object3D)this.m_world, 33982474);
        Utils.stopAnimation((Object3D)this.m_world, 253143392);
        Utils.stopAnimation((Object3D)this.m_world, 932157475);
        Utils.stopAnimation((Object3D)this.m_world, 439828159);
        Utils.startAnimation((Object3D)this.m_world, 562054811, 0);
        ((Node)this.m_world.find(956683772)).setRenderingEnable(true);
        ((Node)this.m_world.find(963976961)).setRenderingEnable(false);
        ((Node)this.m_world.find(755899032)).setRenderingEnable(false);
        Node hGuys = (Node)this.m_world.find(412047773);
        float[] proj = new float[4];
        if (this.m_bChallenge && this.m_iProgress > 5) {
            Utils.startAnimation((Object3D)this.m_world, 362770113, 0);
            hGuys.setRenderingEnable(true);
            this.setViewportValues(0, 120, 320, 104);
            Camera aCamera = (Camera)this.m_world.find(326971083);
            if (aCamera != null) {
                this.m_world.setActiveCamera(aCamera);
                aCamera.getProjection(proj);
                aCamera.setPerspective(14.5f, 3.0769231f, proj[2], proj[3]);
            }
            if (this.m_I2DBackForSelect == null) {
                this.m_I2DBackForSelect = (Image2D)Utils.LoadScene("/backforselect");
            }
            this.m_world.getBackground().setImage(this.m_I2DBackForSelect);
        } else {
            Utils.stopAnimation((Object3D)this.m_world, 362770113);
            Background aBack = this.m_world.getBackground();
            aBack.setImage(null);
            aBack.setColorClearEnable(true);
            aBack.setColor(0);
            hGuys.setRenderingEnable(false);
            this.setViewportValues(222, 120, 98, 104);
            Camera aCamera = (Camera)this.m_world.find(873658803);
            if (aCamera != null) {
                this.m_world.setActiveCamera(aCamera);
                aCamera.getProjection(proj);
                aCamera.setPerspective(proj[0], 0.9423077f, proj[2], proj[3]);
            }
        }
        if (!this.m_bGameInPauseMenu && !bSafeCopy) {
            if (this.m_Window == null) {
                this.m_Window = new Window(this);
            }
            this.m_Window.setTrackInfo(this.m_tRaceInfo.tTrackInfo);
        }
        return true;
    }

    synchronized boolean loadRacer(int p_iID) {
        if (this.m_world != this.m_LoaderRacers.world()) {
            this.m_world = null;
            this.m_world = this.m_LoaderRacers.world();
        }
        Background aBack = this.m_world.getBackground();
        if (this.m_I2DBackForSelect == null) {
            this.m_I2DBackForSelect = (Image2D)Utils.LoadScene("/backforselect");
        }
        aBack.setImage(this.m_I2DBackForSelect);
        aBack = null;
        this.m_world.setActiveCamera((Camera)this.m_world.find(1039097126));
        Utils.setAspectRatioActiveCamera(this.m_world, (float)this.m_iClipWidth / (float)this.m_iClipHeight);
        this.setRacer(p_iID);
        ((Node)this.m_world.find(956683772)).setRenderingEnable(true);
        ((Node)this.m_world.find(755899032)).setRenderingEnable(false);
        return true;
    }

    void extractTrackInfo(int p_iTrack) {
        this.m_tRaceInfo.tTrackInfo.iImageHud = null;
        this.m_tRaceInfo.tTrackInfo.iImageHudShape = null;
        this.m_tRaceInfo.tTrackInfo.iLongitud = 0;
        this.m_tRaceInfo.tTrackInfo.iTiempo = 0;
        int[] iLongitud = new int[]{2686, 3719, 3525};
        int[] iSense = new int[]{0, 1, 0};
        this.m_tRaceInfo.tTrackInfo.iLongitud = iLongitud[p_iTrack - 1];
        this.m_tRaceInfo.tTrackInfo.iSense = iSense[p_iTrack - 1];
        this.m_tRaceInfo.tTrackInfo.iTiempo = ArcadeRMS.GetBestTime(p_iTrack);
    }

    TTrackInfo getCurrentTrackInfo() {
        return this.m_tRaceInfo.tTrackInfo;
    }

    synchronized void resetRMSTimes() {
        for (int aIndex = 0; aIndex < 3; ++aIndex) {
            ArcadeRMS.deleteStore(aIndex + 1);
        }
    }

    synchronized void resetRMSTimesAndMainMenu() {
        this.resetRMSTimes();
        this.prepareMenuMain();
    }

    synchronized boolean loadTrackPreview(int p_iTrack) {
        String aBackground = "background" + 1;
        this.extractTrackInfo(p_iTrack);
        this.m_tRaceInfo.tTrackInfo.iImageHudShape = this.loadTrackShape(false, p_iTrack);
        this.m_tRaceInfo.tTrackInfo.iImageHud = this.loadTrackShape(true, p_iTrack);
        return true;
    }

    synchronized Image loadTrackShape(boolean bInGame, int p_iTrack) {
        Image aImage;
        try {
            aImage = bInGame ? Image.createImage((String)("/track" + p_iTrack + ".png")) : Image.createImage((String)("/track" + p_iTrack + "_shape.png"));
            if (aImage.getHeight() > aImage.getWidth()) {
                aImage = Image.createImage((Image)aImage, (int)0, (int)0, (int)aImage.getWidth(), (int)aImage.getHeight(), (int)6);
                this.m_tRaceInfo.tTrackInfo.bRotatedHud = true;
            } else {
                this.m_tRaceInfo.tTrackInfo.bRotatedHud = false;
            }
        }
        catch (IOException e) {
            aImage = null;
        }
        return aImage;
    }

    synchronized void prepareStartLoadingRace(int p_iTrack) {
        this.removeCanvasCommands();
        this.loadImagesForMenu();
        this.m_CurrentMenu = null;
        if (GameSettings.m_bSound) {
            this.m_sound.destroy(false);
            this.m_sound = null;
            Platform.SystemGc();
        }
        this.destroyRace();
        this.m_world = null;
        if (this.m_RaceLoader == null) {
            this.m_RaceLoader = new LoaderObject[2];
        }
        this.m_RaceLoader[0] = new LoaderObject("/circuito_base", 0, 0);
        this.changeMode(100);
    }

    synchronized void manageLoadingRace() {
        switch (this.m_iGameState) {
            case 100: {
                if (!this.m_RaceLoader[0].finished()) break;
                this.m_tRaceInfo.tTrackInfo.iImageHudShape = null;
                this.m_RaceLoader[1] = new LoaderObject("/track" + this.getTrack(), 0, 0);
                this.changeMode(102);
                break;
            }
            case 102: {
                if (!this.m_RaceLoader[1].finished()) break;
                this.m_world = this.m_RaceLoader[0].world();
                this.m_world.addChild((Node)this.m_RaceLoader[1].object3D());
                this.changeMode(105);
            }
        }
    }

    synchronized void resetRace() {
        this.m_bGo = false;
        this.m_bGameInPauseMenu = false;
        this.m_raceworldsafecoy = null;
        Camera aCamera = null;
        if (this.m_iKindOfRace == 1 || this.m_iKindOfRace == 2) {
            aCamera = (Camera)Symbian.wworld_findNode((Object3D)this.m_world, 998475647);
        } else if (this.m_iKindOfRace == 3) {
            aCamera = (Camera)Symbian.wworld_findNode((Object3D)this.m_world, 21383826);
            if (this.m_bChallenge) {
                this.m_iBombChaseTime = 90000;
            } else {
                switch (GameSettings.m_iBombChaseType) {
                    case 0: {
                        this.m_iBombChaseTime = 59000;
                        break;
                    }
                    case 1: {
                        this.m_iBombChaseTime = 90000;
                        break;
                    }
                    case 2: {
                        this.m_iBombChaseTime = 180000;
                    }
                }
            }
            this.m_iBombChaseTime = this.m_iBombChaseTime;
            this.m_Lapcontrol.setBombChaseTime(this.m_iBombChaseTime);
        } else {
            aCamera = (Camera)Symbian.wworld_findNode((Object3D)this.m_world, 294267052);
        }
        this.m_bRearCamera = false;
        Symbian.view_setCamera(this.m_world, (Object3D)aCamera);
        Symbian.engine_ReleaseHandle((Object3D)aCamera);
        this.m_iRaceTime = 0;
        this.m_iSkidTime = 0;
        this.m_bBestTimeInRace = false;
        this.m_bWinRace = false;
        if (this.m_iKindOfRace == 3) {
            this.m_UserCar.setBombed(true);
            this.m_AICar[0].setBombed(false);
        }
        ((Node)this.m_world.find(848828591)).setRenderingEnable(true);
        ((Node)this.m_world.find(714530118)).setRenderingEnable(false);
        Symbian.setBackgroundColor((Object3D)this.m_world, 0x707070);
        this.m_tCamera.fYawAnt = this.m_UserCar.getYawAngle();
        this.m_Window.resetRace();
        int iRaceTime = this.m_iKindOfRace == 3 ? this.m_iBombChaseTime - this.m_iRaceTime : (this.m_bChallenge && this.m_iKindOfRace == 0 ? 165000 - this.m_iRaceTime : this.m_iRaceTime);
        this.m_Window.setRaceTime(iRaceTime);
        this.resetCamera();
        this.m_tCamera.oYaw.angle = -0.7854f;
        Symbian.transform_setOrientation(this.m_tCamera.hYaw, this.m_tCamera.oYaw);
        this.resetBackground();
        this.removeCanvasCommands();
        this.addCommand(TData.emptyleftCommand);
        this.addCommand(TData.emptyrightCommand);
        this.m_bSoundStartRace = false;
        this.m_UserCar.vibrate(0);
        this.m_fBombFade = 0.0f;
        this.setViewportValues(0, 96, 320, 144);
    }

    synchronized void backToRace() {
        this.m_CurrentMenu = null;
        this.removeCanvasCommands();
        this.addCommand(TData.emptyleftCommand);
        this.addCommand(TData.emptyrightCommand);
        this.m_bGameInPauseMenu = false;
        if (this.m_raceworldsafecoy != null) {
            this.m_world = this.m_raceworldsafecoy;
            this.m_raceworldsafecoy = null;
        }
        this.setViewportValues(0, 96, 320, 144);
        KeyState.resetActionKeys();
        if (this.m_oldInRaceGameState == 113) {
            this.m_iGameState = 99;
            this.preparePlayCountDown();
        } else {
            if (GameSettings.m_bSound) {
                this.loadKindOfRaceSound();
            }
            this.changeMode(this.m_oldInRaceGameState);
        }
    }

    synchronized void finishHelpMenu() {
        if (this.m_bGameInPauseMenu) {
            this.prepareMenuInGamePause();
        } else {
            this.prepareMenuMain();
        }
    }

    synchronized void finishSettingsMenu() {
        if (this.m_bGameInPauseMenu) {
            this.prepareMenuInGamePause();
        } else {
            this.prepareMenuMain();
        }
    }

    synchronized void prepareRestartRace() {
        this.m_Lapcontrol.reset();
        this.m_Colisiones.reset();
        this.m_UserCar.Reset();
        if (this.m_AICar != null) {
            int iIndex = this.m_AICar.length;
            while (--iIndex >= 0) {
                this.m_AICar[iIndex].Reset();
            }
            this.resetAIs(this.m_AICar.length);
        }
        this.resetRace();
        this.changeMode(110);
    }

    void prepareForChallengeRace() {
        switch (this.getProgress()) {
            case 0: {
                this.setTrack(1);
                this.m_iKindOfRace = 0;
                break;
            }
            case 1: {
                this.m_iKindOfRace = 1;
                this.setTrack(1);
                break;
            }
            case 2: {
                this.m_iKindOfRace = 1;
                this.setTrack(2);
                break;
            }
            case 3: {
                this.m_iKindOfRace = 2;
                this.setTrack(2);
                break;
            }
            case 4: {
                this.m_iKindOfRace = 2;
                this.setTrack(3);
                break;
            }
            case 5: {
                this.m_iKindOfRace = 3;
                this.setTrack(3);
                break;
            }
        }
        this.prepareStartLoadingRace(this.getTrack());
    }

    synchronized void prepareRace() {
        this.unloadImagesForMenu();
        this.unloadImagesForMenuBackground();
        this.m_tRaceInfo.iTrack = this.getTrack();
        this.m_tRaceInfo.iIDTrack = Utils.GenerateID("track" + this.getTrack() + "Transform");
        this.m_tRaceInfo.iIDMotoTransform = 675067461;
        this.m_tRaceInfo.iIDMotoAI1Transform = 940391774;
        this.m_tRaceInfo.iIDMotoAI2Transform = 940391773;
        this.m_tRaceInfo.iIDMotoAI3Transform = 940391772;
        int iRacer = this.getRacer();
        int iTotalAIRiders = 0;
        boolean bCreateAI = true;
        if (this.m_iKindOfRace == 0) {
            bCreateAI = false;
        } else {
            iTotalAIRiders = this.m_iKindOfRace == 3 ? 1 : 3;
        }
        if (this.m_Window != null) {
            this.m_Window.destroy();
            this.m_Window = null;
        }
        this.m_tRaceInfo.iTotalRiders = iTotalAIRiders + 1;
        this.m_tRaceInfo.iKindOfRace = this.m_iKindOfRace;
        this.m_Window = new Window(this, this.m_tRaceInfo, Platform.FONT_SYSTEM_BOLD_SMALL);
        this.positionCarsInGrid(this.m_tRaceInfo.iIDTrack, bCreateAI, this.m_tRaceInfo.iTotalRiders);
        this.m_BezierTrack = new CBezierTrack((Node)this.m_world, this.m_tRaceInfo.iIDTrack);
        if (this.m_BezierTrack == null || !this.m_BezierTrack.isConsistent()) {
            this.m_BezierTrack = null;
            this.dontWantToPlayAgain();
            return;
        }
        this.m_Colisiones = new Colisions(this.m_world, this.m_tRaceInfo);
        if (this.m_Colisiones == null) {
            this.dontWantToPlayAgain();
            return;
        }
        this.m_UserCar = new CCar(this.m_world, this.m_tRaceInfo.iIDMotoTransform, this.m_BezierTrack, this.m_Colisiones, this.m_Window, iRacer, this.m_tRaceInfo.tTrackInfo.iSense);
        if (this.m_UserCar == null || !this.m_UserCar.isConsistent()) {
            this.m_UserCar = null;
            this.dontWantToPlayAgain();
            return;
        }
        String sRacerName = "";
        switch (iRacer) {
            case 0: {
                sRacerName = "M120";
                break;
            }
            case 1: {
                sRacerName = "M121";
                break;
            }
            case 2: {
                sRacerName = "M122";
                break;
            }
            case 3: {
                sRacerName = "M123";
            }
        }
        this.m_UserCar.setAlias("User " + LanguageManager.GetString(sRacerName));
        this.m_tRaceInfo.m_Cars[0] = this.m_UserCar;
        this.loadHandleCameras();
        if (bCreateAI && !this.createAICars(this.m_tRaceInfo.tTrackInfo.iSense, iTotalAIRiders)) {
            this.dontWantToPlayAgain();
            return;
        }
        this.m_Lapcontrol = this.creaLapControl(this.m_tRaceInfo);
        if (this.m_Lapcontrol == null) {
            this.dontWantToPlayAgain();
            return;
        }
        this.mBackground = this.m_world.getBackground();
        this.resetRace();
        this.changeMode(110);
    }

    public CLapControl creaLapControl(TRaceInfo aRaceInfo) {
        CLapControl aLC = new CLapControl((Node)this.m_world, this.m_Window, aRaceInfo, this.m_Colisiones);
        if (aLC != null) {
            aLC.addUserCar(this.m_UserCar);
            if (this.m_AICar != null) {
                for (int iIndex = 0; iIndex < this.m_AICar.length; ++iIndex) {
                    aLC.addAICar(this.m_AICar[iIndex]);
                }
            }
        }
        return aLC;
    }

    void resetCamera() {
        this.m_tCamera.fYawWork = 0.0f;
        this.m_tCamera.fPosXWork = 0.0f;
        this.m_tCamera.fPosZWork = this.m_tCamera.vInitialPos.z;
        swvOrientation.setO(this.m_tCamera.oYaw, 0.0f, 0.0f, 0.0f, 1.0f);
        this.m_tCamera.hDyn.setTranslation(this.m_tCamera.vInitialPos.x, this.m_tCamera.vInitialPos.y, this.m_tCamera.vInitialPos.z);
        this.m_hInRaceCamera = this.m_Camera[0];
    }

    void loadHandleCameras() {
        if (this.m_Camera == null) {
            this.m_Camera = new Camera[2];
        }
        for (int iIndex = 0; iIndex < 2; ++iIndex) {
            this.m_Camera[iIndex] = null;
        }
        this.m_Camera[0] = (Camera)Symbian.wworld_findNode((Object3D)this.m_world, 294267052);
        this.m_Camera[1] = (Camera)Symbian.wworld_findNode((Object3D)this.m_world, 388076611);
        this.m_tCamera.hGeo = this.m_Camera[0].getParent();
        this.m_tCamera.hYaw = this.m_tCamera.hGeo.getParent();
        this.m_tCamera.hDyn = this.m_tCamera.hYaw.getParent();
        Symbian.transform_getPosition(this.m_tCamera.hDyn, this.m_tCamera.vInitialPos);
        this.resetCamera();
    }

    boolean createAICars(int p_iSentido, int iTotalAIRiders) {
        int iIndex;
        this.m_AICar = new CCarAI[iTotalAIRiders];
        int[] iIDMotoAITransform = new int[]{this.m_tRaceInfo.iIDMotoAI1Transform, this.m_tRaceInfo.iIDMotoAI2Transform, this.m_tRaceInfo.iIDMotoAI3Transform};
        boolean bOK = true;
        for (iIndex = 0; iIndex < iTotalAIRiders; ++iIndex) {
            this.m_AICar[iIndex] = null;
            this.m_AICar[iIndex] = new CCarAI(this.m_world, iIDMotoAITransform[iIndex], this.m_BezierTrack, this.m_Colisiones, this.m_Window, p_iSentido, false);
            if (this.m_AICar[iIndex] != null) continue;
            bOK = false;
            break;
        }
        if (bOK) {
            for (iIndex = 0; iIndex < iTotalAIRiders; ++iIndex) {
                if (this.m_AICar[iIndex].isConsistent()) continue;
                bOK = false;
                break;
            }
        }
        if (!bOK) {
            return false;
        }
        this.resetAIs(iTotalAIRiders);
        return true;
    }

    void resetAIs(int iTotalAIRiders) {
        int[] iIndices = new int[4];
        int i = 0;
        int indx = 4;
        while (--indx >= 0) {
            if (this.getRacer() == indx) continue;
            if (this.m_iKindOfRace == 3) {
                iIndices[i] = 3;
                break;
            }
            iIndices[i] = indx;
            ++i;
        }
        for (indx = 0; indx < iTotalAIRiders; ++indx) {
            int aTrack = this.getTrack() - 1;
            CCarAI cAICar = this.m_AICar[indx];
            int iIndexAbility = TData.TRACKRIDERABILITY[aTrack][iIndices[indx]];
            float iniAb = TData.ABILITY[iIndexAbility];
            float incAb = TData.INCABILITY[iIndexAbility];
            float decAb = TData.DECABILITY[iIndexAbility];
            cAICar.setRacer(iIndices[indx]);
            cAICar.setInitialAbility(iniAb, incAb, decAb);
            this.m_tRaceInfo.m_Cars[indx + 1] = cAICar;
            String sRacerName = "";
            switch (iIndices[indx]) {
                case 0: {
                    sRacerName = "M120";
                    break;
                }
                case 1: {
                    sRacerName = "M121";
                    break;
                }
                case 2: {
                    sRacerName = "M122";
                    break;
                }
                case 3: {
                    sRacerName = "M123";
                }
            }
            cAICar.setAlias("AI" + (indx + 1) + "/" + LanguageManager.GetString(sRacerName));
            cAICar.setProgressDisplacementX(0.0f);
        }
    }

    void positionCarsInGrid(int p_iIDTrack, boolean p_bCreateAI, int p_iTotalRiders) {
        Node grid = null;
        swvVector3D l_vpos = new swvVector3D();
        swvVector3D l_vposparent = new swvVector3D();
        float[] afPos = new float[3];
        int[] iGrid = new int[]{934483840, 775499759, 616515678, 457531597};
        int[] iMoto = new int[]{487061308, 1041388269, 312333154, 592312753};
        int[] iMotoGeo = new int[]{0, 940391774, 940391773, 940391772};
        boolean[] bAI = new boolean[]{false, true, true, true};
        Node hTrackT = (Node)Symbian.wworld_findNode((Object3D)this.m_world, p_iIDTrack);
        Symbian.transform_getPosition(hTrackT, l_vposparent);
        grid = (Node)Symbian.wworld_findNode((Object3D)hTrackT, 934483840);
        Symbian.transform_getPosition(grid, l_vpos);
        swvVector3D.sumaV(l_vpos, l_vposparent);
        float z = -l_vpos.z;
        Symbian.engine_ReleaseHandle((Object3D)grid);
        Node hMinimo = (Node)Symbian.wworld_findNode((Object3D)hTrackT, 153563458);
        Node hMaximo = (Node)Symbian.wworld_findNode((Object3D)hTrackT, 566149904);
        if (hMinimo == null || hMaximo == null) {
            System.exit(-1);
        }
        Symbian.transform_getPosition(hMinimo, l_vpos);
        swvVector3D.negV(l_vpos);
        swvVector3D.sumaV(l_vposparent, l_vpos);
        l_vposparent.z = z;
        Symbian.transform_setPosition(hTrackT, l_vposparent);
        Node hBaseAICar = null;
        hBaseAICar = (Node)Symbian.wworld_findNode((Object3D)this.m_world, 1041388269);
        if (hBaseAICar == null) {
            System.exit(-1);
        }
        Node hBaseGeoCar = (Node)this.m_world.find(940391774);
        Group hUserCarRoll = (Group)this.m_world.find(362384805);
        Node aUserCar = (Node)hBaseGeoCar.duplicate();
        aUserCar.setUserID(675067461);
        hUserCarRoll.addChild(aUserCar);
        Platform.DuplicateMeshes((Object3D)hBaseAICar);
        Node hCar = null;
        for (int iIndex = 0; iIndex < p_iTotalRiders; ++iIndex) {
            grid = (Node)Symbian.wworld_findNode((Object3D)hTrackT, iGrid[iIndex]);
            if (grid == null) {
                System.exit(-1);
            }
            Symbian.transform_getPosition(grid, l_vpos);
            swvVector3D.sumaV(l_vpos, l_vposparent);
            hCar = null;
            if (bAI[iIndex]) {
                if (p_bCreateAI) {
                    if (iMoto[iIndex] == 1041388269) {
                        hCar = hBaseAICar;
                    } else {
                        hCar = (Node)hBaseAICar.duplicate();
                        this.m_world.addChild(hCar);
                        Platform.DuplicateMeshes((Object3D)hCar);
                    }
                    if (hCar == null) {
                        System.exit(-1);
                    }
                    hCar.setUserID(iMoto[iIndex]);
                    Node aGeo = (Node)Symbian.wworld_findNode((Object3D)hCar, 940391774);
                    aGeo.setUserID(iMotoGeo[iIndex]);
                    aGeo = null;
                }
            } else {
                hCar = (Node)Symbian.wworld_findNode((Object3D)this.m_world, iMoto[iIndex]);
            }
            if (hCar != null) {
                if (bAI[iIndex]) {
                    hCar.getTranslation(afPos);
                    l_vpos.z = 0.0f;
                }
                Symbian.transform_setPosition(hCar, l_vpos);
            }
            Symbian.engine_ReleaseHandle(hCar);
            Symbian.engine_ReleaseHandle((Object3D)grid);
        }
        if (!p_bCreateAI) {
            hBaseAICar.setRenderingEnable(false);
        }
        Symbian.engine_ReleaseHandle((Object3D)hBaseAICar);
        grid = null;
        grid = (Node)Symbian.wworld_findNode((Object3D)hTrackT, 590840834);
        if (grid == null) {
            System.exit(-1);
        }
        Symbian.transform_getPosition(grid, l_vpos);
        swvVector3D.sumaV(l_vpos, l_vposparent);
        Node hDummy = (Node)Symbian.wworld_findNode((Object3D)this.m_world, 855417622);
        if (hDummy == null) {
            System.exit(-1);
        }
        Symbian.transform_setPosition(hDummy, l_vpos);
        swvOrientation anOri = new swvOrientation(1.5707964f, 0.0f, 0.0f, 1.0f);
        if (this.m_tRaceInfo.tTrackInfo.iSense == 1) {
            Symbian.transform_setOrientation(hDummy, anOri);
        }
        Symbian.engine_ReleaseHandle((Object3D)hDummy);
        Symbian.engine_ReleaseHandle((Object3D)grid);
        Symbian.transform_getPosition(hMinimo, this.m_tRaceInfo.tTrackInfo.vMin);
        Symbian.transform_getPosition(hMaximo, this.m_tRaceInfo.tTrackInfo.vMax);
        swvVector3D.sumaV(this.m_tRaceInfo.tTrackInfo.vMin, l_vposparent);
        swvVector3D.sumaV(this.m_tRaceInfo.tTrackInfo.vMax, l_vposparent);
        Symbian.engine_ReleaseHandle((Object3D)hMinimo);
        Symbian.engine_ReleaseHandle((Object3D)hMaximo);
        swvVector3D.copyV(this.m_tRaceInfo.tTrackInfo.vSize, this.m_tRaceInfo.tTrackInfo.vMax);
        swvVector3D.restaV(this.m_tRaceInfo.tTrackInfo.vSize, this.m_tRaceInfo.tTrackInfo.vMin);
        Symbian.engine_ReleaseHandle((Object3D)hTrackT);
        hBaseAICar = null;
        iMotoGeo = null;
        iMoto = null;
        iGrid = null;
        l_vposparent = null;
        l_vpos = null;
        bAI = null;
        anOri = null;
        afPos = null;
    }

    void resetBackground() {
        this.mBackground.setImageMode(33, 32);
        this.m_iBackgroundWidth = this.mBackground.getImage().getWidth();
        this.m_iBackgroundHeight = (int)((float)this.mBackground.getImage().getHeight() * 1.86f);
        this.mBackground.setCrop(0, 0, this.m_iBackgroundWidth, this.m_iBackgroundHeight);
        this.moveBackground(this.m_tCamera.oYaw.angle);
    }

    void preparePlayStarAnim() {
        if (this.m_iKindOfRace != 0) {
            Utils.startAnimation((Object3D)this.m_world, 253469715, 0);
        }
        this.m_UserCar.updateBackHead(this.m_tCamera.oYaw.angle);
        if (this.m_iKindOfRace == 3) {
            this.m_AICar[0].updateBackHead(-this.m_tCamera.oYaw.angle * 0.5f);
        } else if (this.m_AICar != null) {
            int iIndex = this.m_AICar.length;
            while (--iIndex >= 0) {
                this.m_AICar[iIndex].updateBackHead(this.m_tCamera.oYaw.angle);
            }
        }
        this.changeMode(112);
    }

    void updateCameraFinishRace() {
        TCamera aCamera = this.m_tCamera;
        swvOrientation oYaw = aCamera.oYaw;
        if ((double)MyMath.fabs(oYaw.angle) < 0.65) {
            oYaw.angle += (float)this.m_deltaTime * 2.5E-4f;
        }
        Symbian.transform_setOrientation(aCamera.hYaw, oYaw);
        swvVector3D aPos = aCamera.vPos;
        swvVector3D.setV(aPos, 0.0f, -this.m_UserCar.getSpeed() * 0.005f, 0.0f);
        swvVector3D.sumaV(aPos, aCamera.vInitialPos);
        aCamera.hDyn.setTranslation(aPos.x, aPos.y, aPos.z);
    }

    void restoreCamera() {
        this.m_hInRaceCamera = this.m_Camera[0];
        Symbian.view_setCamera(this.m_world, (Object3D)this.m_hInRaceCamera);
        this.m_bRearCamera = false;
        this.m_Lapcontrol.notifyChangeCamera();
        if (this.m_AICar != null) {
            int iIndex = this.m_AICar.length;
            while (--iIndex >= 0) {
                this.m_AICar[iIndex].setRearView(false);
            }
        }
    }

    boolean usingRearCamera() {
        return this.m_bRearCamera;
    }

    void setRearCamera() {
        if (!this.m_UserCar.isDrivingBackwards()) {
            this.m_hInRaceCamera = this.m_Camera[1];
            Symbian.view_setCamera(this.m_world, (Object3D)this.m_hInRaceCamera);
            this.m_bRearCamera = true;
            this.m_Lapcontrol.notifyChangeCamera();
            if (this.m_AICar != null) {
                int iIndex = this.m_AICar.length;
                while (--iIndex >= 0) {
                    this.m_AICar[iIndex].setRearView(true);
                }
            }
        }
    }

    void updateCamera() {
        TCamera aCamera = this.m_tCamera;
        swvOrientation aYaw = aCamera.oYaw;
        if (this.m_UserCar.launchedRocket()) {
            aCamera.iRocketCountDown = 5;
        }
        float aDespla = 0.0f;
        if (MyMath.fabs(aCamera.fYawAnt - this.m_UserCar.getYawAngle()) > (float)Math.PI) {
            if (aCamera.fYawAnt - this.m_UserCar.getYawAngle() < 0.0f) {
                aCamera.fYawAnt = (float)Math.PI + ((float)Math.PI + aCamera.fYawAnt);
                aDespla = aCamera.fYawAnt - this.m_UserCar.getYawAngle();
            } else {
                aCamera.fYawAnt = (float)(-Math.PI) + (aCamera.fYawAnt - (float)Math.PI);
                aDespla = aCamera.fYawAnt - this.m_UserCar.getYawAngle();
            }
        } else {
            aDespla = (aCamera.fYawAnt - this.m_UserCar.getYawAngle()) * 2.0f;
        }
        aCamera.vPos.y = aCamera.vInitialPos.y - this.m_UserCar.getSpeed() * 0.0095f;
        aCamera.vPos.z = aCamera.vInitialPos.z + this.m_UserCar.getSpeed() * 0.0048f;
        if (aCamera.vPos.z > aCamera.vInitialPos.z + 0.085f) {
            aCamera.vPos.z = aCamera.vInitialPos.z + 0.085f;
        }
        aCamera.fYawAnt = this.m_UserCar.getYawAngle();
        if (aDespla == 0.0f && aCamera.iRocketCountDown == 0) {
            this.m_tCamera.vPos.x = 0.0f;
        } else {
            int iSgn;
            int n = iSgn = aDespla >= 0.0f ? 1 : -1;
            if (MyMath.fabs(aDespla) > 0.2f) {
                aDespla = 0.2f * (float)iSgn;
            }
            aCamera.vPos.x = this.m_UserCar.getSpeed() > 30.0f ? aDespla * this.m_UserCar.getRelSpeedToMaxSpeed() : aDespla * (1.0f - this.m_UserCar.getRelSpeedToMaxSpeed());
            if (aCamera.iRocketCountDown != 0) {
                aCamera.vPos.y += (float)aCamera.iRocketCountDown * 0.03f;
                aCamera.vPos.z += (float)aCamera.iRocketCountDown * 0.02f;
                --aCamera.iRocketCountDown;
            }
        }
        if (aCamera.iRocketCountDown == 0) {
            aYaw.angle = this.m_UserCar.getSpeed() > 30.0f ? aDespla * this.m_UserCar.getRelSpeedToMaxSpeed() : aDespla * (1.0f - this.m_UserCar.getRelSpeedToMaxSpeed());
        }
        aYaw.angle = (aYaw.angle + this.m_tCamera.fYawWork) * 0.5f;
        aCamera.vPos.x = (this.m_tCamera.vPos.x + this.m_tCamera.fPosXWork) * 0.5f;
        aCamera.vPos.z = (this.m_tCamera.vPos.z + this.m_tCamera.fPosZWork) * 0.5f;
        if (MyMath.fabs(aCamera.vPos.x) < 0.001f) {
            aCamera.vPos.x = 0.0f;
        }
        this.moveBackground(aYaw.angle);
        aCamera.fYawWork = aYaw.angle;
        aCamera.fPosXWork = aCamera.vPos.x;
        aCamera.fPosZWork = aCamera.vPos.z;
        Symbian.transform_setOrientation(aCamera.hYaw, aYaw);
        aCamera.hDyn.setTranslation(aCamera.vPos.x, aCamera.vPos.y, aCamera.vPos.z);
    }

    synchronized void destroyRace() {
        if (this.m_bGameInPauseMenu) {
            this.m_bGameInPauseMenu = false;
        }
        if (this.m_UserCar != null) {
            int iIndex;
            if (this.m_Lapcontrol != null) {
                this.m_Lapcontrol.destroy();
                this.m_Lapcontrol = null;
            }
            Group hUserCarRoll = (Group)this.m_world.find(362384805);
            Node aGeo = (Node)hUserCarRoll.find(675067461);
            Platform.RemoveDuplicatedMeshes((Object3D)aGeo);
            hUserCarRoll.removeChild(aGeo);
            aGeo = null;
            this.m_UserCar.destroy();
            this.m_UserCar = null;
            if (this.m_AICar != null) {
                for (iIndex = 0; iIndex < this.m_AICar.length; ++iIndex) {
                    Node aNode = this.m_AICar[iIndex].getDynTransform();
                    Platform.RemoveDuplicatedMeshes((Object3D)aNode);
                    this.m_AICar[iIndex].destroy();
                    this.m_world.removeChild(aNode);
                    this.m_AICar[iIndex] = null;
                }
                this.m_AICar = null;
            }
            if (this.m_Colisiones != null) {
                this.m_Colisiones.destroy();
                this.m_Colisiones = null;
            }
            if (this.m_BezierTrack != null) {
                this.m_BezierTrack.destroy();
                this.m_BezierTrack = null;
            }
            for (iIndex = 0; iIndex < 2; ++iIndex) {
                this.m_Camera[iIndex] = null;
            }
            this.m_world.removeChild((Node)this.m_RaceLoader[1].object3D());
            this.m_RaceLoader[0].destroy();
            this.m_RaceLoader[1].destroy();
            this.m_RaceLoader[0] = null;
            this.m_RaceLoader[1] = null;
            this.m_tCamera.hDyn = null;
            this.m_tCamera.hYaw = null;
            this.m_tCamera.hGeo = null;
            for (int aIndex = 0; aIndex < 4; ++aIndex) {
                this.m_tRaceInfo.m_Cars[aIndex] = null;
            }
            this.m_tRaceInfo.tTrackInfo.iImageHud = null;
            this.m_tRaceInfo.tTrackInfo.iImageHudShape = null;
            if (this.m_Window != null) {
                this.m_Window.destroy();
                this.m_Window = null;
            }
            this.mBackground = null;
            this.m_world = null;
            Platform.SystemGc();
        }
    }

    synchronized void letsPlayAgain() {
        this.m_world = this.m_raceworldsafecoy;
        this.m_raceworldsafecoy = null;
        this.prepareRestartRace();
    }

    synchronized void dontWantToPlayAgain() {
        if (this.m_raceworldsafecoy != null) {
            this.m_world = this.m_raceworldsafecoy;
            this.m_raceworldsafecoy = null;
        }
        this.destroyRace();
        this.generateBackgroundImage();
        this.prepareMenuMain();
    }

    synchronized void finishingRace() {
        this.removeCanvasCommands();
        int p_iState = this.m_iGameState;
        int iTime = 0;
        if (this.m_iKindOfRace == 3) {
            this.m_bWinRace = !this.m_UserCar.hasTheBomb();
            this.m_UserCar.vibrate(0);
            if (this.m_fBombFade != 0.0f) {
                this.m_fBombFade = 0.0f;
                ((Node)this.m_world.find(this.m_tRaceInfo.iIDTrack)).setRenderingEnable(true);
            }
        } else {
            if (!ArcadeRMS.openStore(false, this.getTrack())) {
                ArcadeRMS.createStore(this.getTrack());
            } else {
                iTime = ArcadeRMS.GetWorstBestTime(this.getTrack());
            }
            if (this.m_tRaceTimes.viCarIndex[0] == 0) {
                if (this.m_iKindOfRace != 0) {
                    // empty if block
                }
                this.m_bWinRace = true;
            } else {
                this.m_bWinRace = false;
            }
            if (this.m_bChallenge && this.m_iKindOfRace == 0) {
                iTime = 165000;
            }
            this.m_bBestTimeInRace = iTime == 0 || this.m_Lapcontrol.getTotalTime(0) < iTime;
        }
        if (this.m_bBestTimeInRace && this.m_iKindOfRace != 3) {
            this.prepareEnterName();
        } else if (this.m_bChallenge) {
            if (this.m_iKindOfRace == 0 || !this.m_bWinRace && this.m_iKindOfRace != 0) {
                this.prepareDlgChallengeFail();
            } else {
                this.prepareProgressInChallenge();
            }
        } else if (this.m_iKindOfRace == 3) {
            this.prepareDlgEndBombChase();
        } else {
            this.prepareDlgAskToPlayAgain();
        }
    }

    public synchronized void prepareProgressInChallenge() {
        int iProgreso = -1;
        switch (this.getProgress()) {
            case 0: {
                iProgreso = 1;
                break;
            }
            case 1: {
                iProgreso = 2;
                break;
            }
            case 2: {
                iProgreso = 3;
                break;
            }
            case 3: {
                iProgreso = 4;
                break;
            }
            case 4: {
                iProgreso = 5;
                break;
            }
            case 5: {
                iProgreso = 6;
            }
        }
        if (iProgreso != -1) {
            this.setProgress(iProgreso);
        }
        this.prepareDlgForChallenge();
    }

    public void preparePreloadRacers(int p_iState) {
        this.m_iPreloadGameState = p_iState;
        this.m_LoaderRacers = new LoaderObject("/selection", 0, ON_EMULATOR ? 0 : 250);
        this.changeMode(11);
    }

    CLapControl getLapControl() {
        return this.m_Lapcontrol;
    }

    int getCurrentTime() {
        return this.m_currentTime;
    }

    void setCurrentTime(int aTime) {
        this.m_currentTime = aTime;
    }

    int getGameState() {
        return this.m_iGameState;
    }

    void setRacer(int p_iRacer) {
        this.m_iRacer = p_iRacer;
    }

    int getRacer() {
        return this.m_iRacer;
    }

    void setTrack(int p_iTrack) {
        this.m_iTrack = p_iTrack;
    }

    int getTrack() {
        return this.m_iTrack;
    }

    public TRaceTimes getRaceTimes() {
        return this.m_tRaceTimes;
    }

    public TTimesRecordVector getPersonalTimes() {
        return this.m_tPersonalTimes;
    }

    public Window getWindow() {
        return this.m_Window;
    }

    public int getKindOfRace() {
        return this.m_iKindOfRace;
    }

    public void setKindOfRace(int p_iKOQR) {
        this.m_iKindOfRace = p_iKOQR;
    }

    int getProgress() {
        return this.m_iProgress;
    }

    int getProgressRMS() {
        return this.m_ChallengeRMS.getProgress();
    }

    boolean inChallengeMode() {
        return this.m_bChallenge;
    }

    int getProgressPersistenteRMS() {
        return this.m_ChallengeRMS.getPersistentProgress();
    }

    int getPersistentProgress() {
        return this.m_iPersistentProgress;
    }

    synchronized void setProgress(int p_iProgress) {
        if (p_iProgress == -2) {
            this.m_iProgress = 0;
            this.m_iPersistentProgress = this.m_ChallengeRMS.setAndStoreProgress(-2);
        } else {
            this.m_iProgress = p_iProgress;
            this.m_iPersistentProgress = this.m_ChallengeRMS.setAndStoreProgress(this.m_iProgress);
        }
    }

    public GameSettings getSettingsRMS() {
        return this.m_GameSettingsRMS;
    }

    public void uploadingWasSuccess() {
        if (DEBUG) {
            Utils.SystemOut("CartoonRacer - uploadingWasSuccess()");
        }
        this.m_GameSettingsRMS.uploadingWasSuccess();
    }

    static {
        ON_EMULATOR = true;
        SUN_EMULATOR = false;
        DEBUG = false;
        CONSOLE = false;
        USE_TRY = false;
        bRedrawFullInGameInterface = true;
        PAUSEAPP_TEXT_FONT = Font.getFont((int)0, (int)1, (int)0);
        TOUCHSCREEN_SUPPORTED = false;
        ms_iScreenTouched_Map = 0;
        ms_iScreenTouched_Frames = 0;
        m_Image = null;
    }

    private class doSoundStuff
    extends TimerTask {
        private doSoundStuff() {
        }

        public void run() {
            CartoonRacer.this.myTimer = null;
            if (GameSettings.m_bSound) {
                if (CartoonRacer.this.m_iGameState == 114) {
                    CartoonRacer.this.loadKindOfRaceSound();
                } else if (CartoonRacer.this.m_UserCar == null && CartoonRacer.this.m_iGameState > 1) {
                    CartoonRacer.this.loadSound(0);
                    if (CartoonRacer.this.m_sound != null) {
                        CartoonRacer.this.m_sound.play();
                    }
                }
            }
        }
    }
}

