/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.IOException;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import main.CartoonRacer;
import main.Dialog;
import main.KeyState;
import main.Platform;
import main.TData;

public final class DialogChallenge
extends Dialog {
    private Image m_ImageBubbleBottom;
    private boolean m_bUp = false;
    private boolean m_bDown = false;
    private int m_iIncY = 0;
    private int m_iStep = 3;
    private int m_iClipTextX;
    private int m_iClipTextY;
    private int m_iClipTextWidth;
    private int m_iWidth;
    private int m_iClipTextHeight;
    private int m_iNumLines;
    private int m_iHP;
    private int m_iStartY;
    private boolean m_bEndReached = false;
    private boolean m_bStartReached;

    public DialogChallenge(int p_iX, int p_iY, Font p_Font, Object p_Parent, Image p_Img, String p_sTitle, String p_sText) {
        super(p_Font, p_Parent, p_Img, p_sTitle, p_sText);
        this.setBaseX(p_iX);
        this.setBaseY(p_iY);
        this.m_iTitlePosY = 0;
        if (p_Img != null) {
            this.m_iTitleIMGPos_X = 160;
            this.m_iTitleIMGPos_Y = 0;
        }
        int iMaxTextWidth = this.mTextMaxWidth;
        try {
            this.m_ImageBubbleBottom = Image.createImage((String)"/bubble_triangle.png");
        }
        catch (IOException e) {
            this.m_ImageBubbleBottom = null;
        }
        int iFontHeight = this.m_Font.getHeight() + 0;
        this.m_iClipTextX = 160 - ((iMaxTextWidth >> 1) + 4);
        this.m_iClipTextWidth = iMaxTextWidth + 8;
        this.m_iClipTextHeight = 108 - (iFontHeight << 1);
        this.m_iNumLines = this.mNumLinesInList;
        this.m_iHP = this.m_iNumLines * iFontHeight;
        if (this.m_iClipTextHeight > this.m_iHP) {
            this.m_iStartY = this.m_iClipTextHeight - this.m_iHP + iFontHeight;
            this.m_iClipTextHeight -= this.m_iClipTextHeight - this.m_iHP;
        } else {
            this.m_iStartY = iFontHeight;
        }
        this.m_iPosY = this.m_iClipTextY = 12 + this.m_iStartY;
        if (this.m_iClipTextHeight == this.m_iHP) {
            this.m_bEndReached = true;
        }
        this.m_bStartReached = true;
    }

    public void cmdAction(Command cmd, CartoonRacer pLet) {
        switch (pLet.getGameState()) {
            case 65: {
                if (cmd == TData.backCommand || pLet.getProgress() == 6) {
                    pLet.prepareChallenge2MainMenu();
                    break;
                }
                pLet.prepareMenuRider();
                break;
            }
            case 46: {
                if (cmd == TData.noCommand) {
                    pLet.prepareChallenge2MainMenu();
                    break;
                }
                pLet.prepareDlgForChallenge();
                break;
            }
            case 70: 
            case 71: 
            case 72: {
                pLet.prepareMenuHelp();
                break;
            }
            case 62: {
                pLet.prepareChallenge2MainMenu();
                break;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                if (cmd == TData.backCommand) {
                    pLet.prepareQuickRaceMenu();
                    break;
                }
                pLet.prepareMenuRider();
                break;
            }
            case 73: {
                if (cmd == TData.noCommand) {
                    pLet.prepareMenuSettings();
                    break;
                }
                pLet.resetChallenges();
                break;
            }
            case 47: {
                pLet.prepareMenuSettings();
                break;
            }
            case 58: {
                if (cmd == TData.noCommand) {
                    pLet.dontWantToPlayAgain();
                    break;
                }
                pLet.letsPlayAgain();
                break;
            }
            case 63: {
                if (cmd == TData.yesCommand) {
                    pLet.resetRMSTimesAndMainMenu();
                    break;
                }
                pLet.prepareBestTimesMenu();
                break;
            }
            case 55: {
                if (cmd == TData.noCommand) {
                    pLet.prepareMenuMain();
                    break;
                }
                pLet.exitGame();
            }
        }
    }

    protected void fire(CartoonRacer pLet) {
        super.fire(pLet);
        this.cmdAction(TData.okCommand, pLet);
    }

    public void paintTitle(Graphics gc) {
        gc.setColor(0);
        gc.fillRect(0, 0, 320, 240);
        if (this.m_sTitle.length() > 0) {
            Font f = gc.getFont();
            gc.setFont(Platform.FONT_DLG_TITLE);
            gc.setColor(this.m_iColorTitleText);
            gc.drawString(this.m_sTitle, this.m_iTitlePosX, this.m_iTitlePosY, 17);
            gc.setFont(f);
        }
    }

    public void paintBody(Graphics g) {
        if (this.m_ImageBubbleBottom != null) {
            int iPosX = TData.GetCanvas().inChallengeMode() && TData.GetCanvas().getProgress() > 5 ? 208 : 160;
            g.drawImage(this.m_ImageBubbleBottom, iPosX, this.m_iClipTextHeight + this.m_iClipTextY + (this.m_Font.getHeight() + 0), 17);
        }
        g.setStrokeStyle(0);
        g.setColor(0xFFFFFF);
        int iFontHeight = this.m_Font.getHeight() + 0;
        g.fillRoundRect(this.m_iClipTextX, this.m_iClipTextY - iFontHeight, this.m_iClipTextWidth, this.m_iClipTextHeight + (iFontHeight << 1), 25, 25);
        int iValue = iFontHeight >> 1;
        int iDisplayedLines = 0;
        int currentY = 0;
        if (this.m_iNumLines > 0) {
            Font f = g.getFont();
            g.setFont(this.m_Font);
            g.setColor(0);
            int[] _lStart = this.mLineStart;
            int[] _lEnd = this.mLineEnd;
            String _Text = this.mText;
            Font _Font = this.m_Font;
            int fontheight = iFontHeight;
            currentY = this.m_iPosY;
            int end = 0;
            int start = 0;
            int iIndex = 0;
            while (iIndex < this.m_iNumLines) {
                if (currentY >= this.m_iClipTextY) {
                    int currentline;
                    int end_start;
                    if (iIndex == 0 && this.m_iIncY < 0) {
                        this.m_bStartReached = true;
                    }
                    if ((end_start = (end = _lEnd[currentline = this.mFirstLineOnScreen + iIndex]) - (start = _lStart[currentline])) > 0) {
                        g.drawSubstring(_Text, start, end_start, 160, currentY, 17);
                    }
                    ++iDisplayedLines;
                    if (currentY + (iFontHeight << 1) > this.m_iClipTextY + this.m_iClipTextHeight) break;
                }
                ++iIndex;
                currentY += fontheight;
            }
            if (iIndex == this.m_iNumLines && this.m_iIncY > 0 && iDisplayedLines < this.m_iNumLines) {
                this.m_bEndReached = true;
            }
            g.setFont(f);
        }
        if (this.m_iIncY < 0) {
            if (!this.m_bStartReached) {
                this.m_iPosY -= this.m_iIncY;
            }
        } else if (!this.m_bEndReached) {
            this.m_iPosY -= this.m_iIncY;
        }
        g.setColor(0);
        if (!this.m_bStartReached) {
            g.fillTriangle(160 - iValue, this.m_iClipTextY - iFontHeight + iValue, 160 + iValue, this.m_iClipTextY - iFontHeight + iValue, 160, this.m_iClipTextY - iFontHeight);
            g.drawLine(this.m_iClipTextX, this.m_iClipTextY - iFontHeight + iValue + 1, this.m_iClipTextX + this.m_iClipTextWidth, this.m_iClipTextY - iFontHeight + iValue + 1);
        }
        if (!this.m_bEndReached) {
            g.fillTriangle(160 - iValue, 120 - iValue, 160 + iValue, 120 - iValue, 160, 120);
            g.drawLine(this.m_iClipTextX, 120 - iValue - 2, this.m_iClipTextX + this.m_iClipTextWidth, 120 - iValue - 2);
        }
        if (this.m_bUp) {
            this.m_bUp = false;
        }
        if (this.m_bDown) {
            this.m_bDown = false;
        }
        if (this.m_Repaint && this.m_iIncY == 0) {
            this.m_Repaint = false;
        }
    }

    private void up(CartoonRacer pLet) {
        if (this.m_bEndReached && this.m_bStartReached) {
            return;
        }
        if (this.m_bEndReached) {
            this.m_bEndReached = false;
        }
        this.m_iIncY = -this.m_iStep;
        this.m_bUp = true;
        this.repaint();
    }

    private void down(CartoonRacer pLet) {
        if (this.m_bEndReached && this.m_bStartReached) {
            return;
        }
        if (this.m_bEndReached) {
            this.m_bEndReached = false;
        } else {
            if (this.m_bStartReached) {
                this.m_bStartReached = false;
            }
            this.m_iIncY = this.m_iStep;
        }
        this.m_bDown = true;
        this.repaint();
    }

    public void processTouched(CartoonRacer pLet, int _iX, int _iY) {
        int iFontHeight = this.m_Font.getHeight() + 0;
        int iY0 = this.m_iClipTextY - iFontHeight;
        int iY2 = iY0 + this.m_iClipTextHeight + (iFontHeight << 1);
        int iY1 = iY0 + iY2 >> 1;
        if (_iY > iY0 && _iY < iY1) {
            this.up(pLet);
        }
        if (_iY > iY1 && _iY < iY2) {
            this.down(pLet);
        }
    }

    public void processKey(CartoonRacer pLet) {
        if (KeyState.m_ACTION_MENU_UP || KeyState.m_upPressed) {
            this.up(pLet);
        } else if (KeyState.m_ACTION_MENU_DOWN || KeyState.m_downPressed) {
            this.down(pLet);
        } else if (KeyState.m_ACTION_MENU_SELECT || KeyState.m_firePressed) {
            this.fire(pLet);
        }
    }
}

