/*
 * Decompiled with CFR 0.152.
 */
package main;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import main.CartoonRacer;
import main.Dialog;
import main.KeyState;
import main.LanguageManager;
import main.Platform;
import main.TData;

public class EnterInitials
extends Dialog {
    private static final int NUM_INITIALS = 4;
    protected int mCurrentSlot = 0;
    protected char[] mInitials = new char[4];
    protected static char[] mLastInitials = new char[4];
    protected static boolean mLastInitialsStored = false;
    private static final int CHARSET_LATIN_UPPERCASE = 0;
    private static final int CHARSET_LATIN_LOWERCASE = 1;
    private static final int CHARSET_NUMBERS = 2;
    private static final int CHARSET_SYMBOLS = 3;
    private static final int CHARSET_HIRAGANA = 4;
    private static final int CHARSET_KATAKANA = 5;
    protected int mCurrentCharSet;
    protected int mNumCharSetsAvailables;
    private static final char[] MIN_LEGAL_CHAR = new char[]{'A', 'a', '0', ' ', '\u3041', '\u30a2'};
    private static final char[] STARTING_CHAR = new char[]{'A', 'a', '0', '!', '\u3041', '\u30a2'};
    private static final char[] MAX_LEGAL_CHAR = new char[]{'Z', 'z', '9', '/', '\u3090', '\u30ff'};
    private static final String[] CHARSET_NAME = new String[]{LanguageManager.GetString("M100"), LanguageManager.GetString("M101"), LanguageManager.GetString("M102"), LanguageManager.GetString("M103"), LanguageManager.GetString("M104"), LanguageManager.GetString("M105")};
    private static final int NUM_CHARSETS = 6;
    protected int mUpFramesPressed;
    protected int mDownFramesPressed;
    private static final int MAX_FRAMESPRESSED = 3;
    private int m_iState;

    public EnterInitials(int p_iX, int p_iY, Font p_Font, Object p_Parent, Image p_ImgBackground, String p_sTitle) {
        super(p_Font, p_Parent, p_ImgBackground, p_sTitle, "");
        this.setColorTitleText(8033535);
        this.setColorBodyText(16711749);
        this.setBaseX(p_iX);
        this.setBaseY(p_iY);
        this.mCurrentCharSet = 0;
        this.mNumCharSetsAvailables = System.getProperty("microedition.locale").substring(0, 2) == "jp" ? 6 : 4;
        for (int i = 0; i < 4; ++i) {
            this.mInitials[i] = mLastInitialsStored ? mLastInitials[i] : STARTING_CHAR[this.mCurrentCharSet];
        }
        this.mUpFramesPressed = 0;
        this.mDownFramesPressed = 0;
        this.m_iState = ((CartoonRacer)((Object)p_Parent)).getGameState();
    }

    public String getCharsetName() {
        return CHARSET_NAME[this.mCurrentCharSet];
    }

    protected void nextCharset() {
        ++this.mCurrentCharSet;
        if (this.mCurrentCharSet >= this.mNumCharSetsAvailables) {
            this.mCurrentCharSet = 0;
        }
        this.mInitials[this.mCurrentSlot] = STARTING_CHAR[this.mCurrentCharSet];
        this.m_Repaint = true;
    }

    public void paintBody(Graphics gc) {
        gc.setColor(3102130);
        gc.setStrokeStyle(0);
        gc.fillRect(0, 0, 320, 96);
        gc.setFont(Platform.FONT_ENTER_INITIALS_CHARSET);
        int xpos = this.m_iPosX - gc.getFont().charWidth('W') * 2;
        int ypos = this.m_iPosY;
        gc.setColor(0);
        gc.drawString(this.m_sTitle, 159, ypos - 1, 17);
        gc.setColor(8033535);
        gc.drawString(this.m_sTitle, 160, ypos, 17);
        gc.setFont(Platform.FONT_MENU);
        gc.setColor(0);
        gc.drawString(this.getCharsetName(), 159, (ypos += gc.getFont().getHeight() + 0) - 1, 17);
        gc.setColor(16711749);
        gc.drawString(this.getCharsetName(), 160, ypos, 17);
        ypos += gc.getFont().getHeight() + 0;
        gc.setFont(Platform.FONT_ENTER_INITIALS);
        int fwidth = (int)((float)gc.getFont().charWidth('W') * 1.5f);
        int fheight = gc.getFont().getHeight() + 0;
        int idImage1 = this.mUpFramesPressed > 3 ? 3 : 5;
        int idImage2 = this.mDownFramesPressed > 3 ? 2 : 4;
        int imHeight = CartoonRacer.m_Image[idImage1].getHeight();
        gc.drawImage(CartoonRacer.m_Image[idImage1], xpos + this.mCurrentSlot * fwidth, ypos, 17);
        gc.setColor(16711749);
        ypos += imHeight + 5;
        for (int i = 0; i < 4; ++i) {
            gc.drawChar(this.mInitials[i], xpos + i * fwidth, ypos, 17);
        }
        gc.drawImage(CartoonRacer.m_Image[idImage2], xpos + this.mCurrentSlot * fwidth, ypos += fheight + 5, 17);
        ++this.mUpFramesPressed;
        ++this.mDownFramesPressed;
        this.m_Repaint = false;
    }

    public void cmdAction(Command cmd, CartoonRacer pLet) {
        if (cmd == TData.okCommand) {
            this.fire(pLet);
        } else if (cmd == TData.nextCharSetCommand) {
            this.nextCharset();
        }
    }

    public void processKey(CartoonRacer pLet) {
        this.repaint();
        if (KeyState.m_ACTION_MENU_RIGHT || KeyState.m_rightPressed) {
            this.nextSlot();
        } else if (KeyState.m_ACTION_MENU_LEFT || KeyState.m_leftPressed) {
            this.prevSlot();
        } else if (KeyState.m_ACTION_MENU_DOWN || KeyState.m_downPressed) {
            if (this.mInitials[this.mCurrentSlot] < MAX_LEGAL_CHAR[this.mCurrentCharSet]) {
                int n = this.mCurrentSlot;
                this.mInitials[n] = (char)(this.mInitials[n] + '\u0001');
            } else {
                this.mInitials[this.mCurrentSlot] = MIN_LEGAL_CHAR[this.mCurrentCharSet];
            }
            this.mDownFramesPressed = 0;
        } else if (KeyState.m_ACTION_MENU_UP || KeyState.m_upPressed) {
            if (this.mInitials[this.mCurrentSlot] > MIN_LEGAL_CHAR[this.mCurrentCharSet]) {
                int n = this.mCurrentSlot;
                this.mInitials[n] = (char)(this.mInitials[n] - '\u0001');
            } else {
                this.mInitials[this.mCurrentSlot] = MAX_LEGAL_CHAR[this.mCurrentCharSet];
            }
            this.mUpFramesPressed = 0;
        } else if (KeyState.m_ACTION_MENU_SELECT || KeyState.m_firePressed) {
            this.fire(pLet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fire(CartoonRacer pLet) {
        CartoonRacer cartoonRacer = pLet;
        synchronized (cartoonRacer) {
            String sName = "";
            for (int i = 0; i < 4; ++i) {
                EnterInitials.mLastInitials[i] = this.mInitials[i];
                sName = sName + this.mInitials[i];
            }
            mLastInitialsStored = true;
            if (sName.compareTo("") != 0) {
                pLet.getSettingsRMS().setAndStoreLastName(sName);
                if (this.m_iState == 20) {
                    pLet.prepareMenuMain();
                } else {
                    pLet.updateScoreAndShowBestTimes(sName);
                }
            }
        }
    }

    protected void nextSlot() {
        ++this.mCurrentSlot;
        if (this.mCurrentSlot >= 4) {
            this.mCurrentSlot = 0;
        }
    }

    protected void prevSlot() {
        --this.mCurrentSlot;
        if (this.mCurrentSlot < 0) {
            this.mCurrentSlot = 3;
        }
    }
}

