/*
 * Decompiled with CFR 0.152.
 */
package main;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import main.CartoonRacer;
import main.GameSettings;
import main.LanguageManager;
import main.Menu;
import main.Platform;
import main.Sound;
import main.TData;

public class SettingsMenu
extends Menu {
    protected static int m_iPreviousOption = 0;
    private String[] m_vsStrings = null;
    private String[] m_vsSound = new String[]{LanguageManager.GetString("M34"), LanguageManager.GetString("M33")};
    private String[] m_vsVibra = new String[]{LanguageManager.GetString("M34"), LanguageManager.GetString("M33")};
    private String[] m_vsBombChase = new String[]{LanguageManager.GetString("M27"), LanguageManager.GetString("M28"), LanguageManager.GetString("M29")};
    private String[] m_vsResetChallenges = new String[]{LanguageManager.GetString("M35R")};
    int[] m_viCurrentOptions = new int[]{GameSettings.m_bSound ? 1 : 0, GameSettings.m_bVibra ? 1 : 0, GameSettings.m_iBombChaseType, 0, GameSettings.m_bBackLight ? 1 : 0};

    SettingsMenu(Font p_Font, Image p_Img) {
        super(p_Font, null, p_Img);
        this.insertOption(LanguageManager.GetString("M4"));
        this.insertOption(LanguageManager.GetString("M15"));
        this.insertOption(LanguageManager.GetString("M23"));
        this.insertOption(LanguageManager.GetString("M35C"));
        this.setMenuTitleText(LanguageManager.GetString("M9"));
        if (p_Img != null) {
            this.setMenuTitlePos(160, p_Img.getHeight());
            this.setMenuTitleImgPos(160, p_Img.getHeight() >> 1);
        }
        this.m_OpcionActual = m_iPreviousOption;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void menuFire(CartoonRacer pLet) {
        m_iPreviousOption = this.m_OpcionActual;
        super.menuFire(pLet);
        this.m_menuRepaint = true;
        switch (this.m_OpcionActual) {
            case 0: 
            case 1: 
            case 4: {
                this.m_viCurrentOptions[this.m_OpcionActual] = this.m_viCurrentOptions[this.m_OpcionActual] == 1 ? 0 : 1;
                CartoonRacer cartoonRacer = pLet;
                synchronized (cartoonRacer) {
                    if (this.m_OpcionActual == 0) {
                        pLet.getSettingsRMS().setAndStoreSound(this.m_viCurrentOptions[0] == 1);
                        Sound aSound = pLet.getSound();
                        if (!GameSettings.m_bSound) {
                            if (aSound != null) {
                                aSound.stop();
                            }
                        } else if (!pLet.gameInPauseMenu()) {
                            pLet.loadSound(0);
                            pLet.getSound().play();
                        }
                    } else if (this.m_OpcionActual == 1) {
                        pLet.getSettingsRMS().setAndStoreVibra(this.m_viCurrentOptions[1] == 1);
                    } else {
                        pLet.getSettingsRMS().setAndStoreBackLight(this.m_viCurrentOptions[4] == 1);
                        if (GameSettings.m_bBackLight) {
                            Platform.SetLightOn();
                        } else {
                            Platform.SetLightOff();
                        }
                    }
                    break;
                }
            }
            case 2: {
                this.m_viCurrentOptions[this.m_OpcionActual] = this.m_viCurrentOptions[this.m_OpcionActual] == 0 ? 1 : (this.m_viCurrentOptions[this.m_OpcionActual] == 1 ? 2 : 0);
                CartoonRacer cartoonRacer = pLet;
                synchronized (cartoonRacer) {
                    pLet.getSettingsRMS().setAndStoreBombChaseType(this.m_viCurrentOptions[2]);
                    break;
                }
            }
            case 3: {
                pLet.prepareDlgResetChallenges();
            }
        }
    }

    public void cmdAction(Command cmd, CartoonRacer pLet) {
        if (cmd == TData.selectCommand) {
            this.menuFire(pLet);
        } else if (cmd == TData.backCommand) {
            pLet.finishSettingsMenu();
        }
    }

    protected void paintBody(Graphics gc) {
        if (this.m_menuRepaint) {
            this.paintTitle(gc);
        }
        gc.setFont(this.m_Font);
        int iTemp = this.m_Font.getHeight() + 0;
        int nOpciones = this.m_Opciones.size();
        for (int i = 0; i < nOpciones; ++i) {
            int p0_y = this.m_BaseY + i * iTemp;
            gc.setColor(this.m_ColorText);
            gc.drawString((String)this.m_Opciones.elementAt(i), 32, p0_y, 20);
            switch (i) {
                case 0: {
                    this.m_vsStrings = this.m_vsSound;
                    break;
                }
                case 1: {
                    this.m_vsStrings = this.m_vsVibra;
                    break;
                }
                case 2: {
                    this.m_vsStrings = this.m_vsBombChase;
                    break;
                }
                case 3: {
                    this.m_vsStrings = this.m_vsResetChallenges;
                }
            }
            if (i == this.m_OpcionActual) {
                gc.setColor(this.m_ColorTextSelected);
            }
            gc.drawString(this.m_vsStrings[this.m_viCurrentOptions[i]], 288, p0_y, 24);
        }
        if (this.m_bUp) {
            this.m_bUp = false;
        }
        if (this.m_bDown) {
            this.m_bDown = false;
        }
        if (this.m_menuRepaint) {
            this.m_menuRepaint = false;
        }
    }
}

