/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.IOException;
import main.RMSManager;

class ByteBufferedRMSManager
extends RMSManager {
    ByteBufferedRMSManager(String aStoreName, boolean deleteifexists, boolean createifnotexists) {
        super(aStoreName, deleteifexists, createifnotexists);
    }

    public void destroy() {
        super.destroy();
    }

    public void flush() {
        try {
            outputStream.flush();
            byte[] b = baos.toByteArray();
            this.addRecord(b);
            baos.reset();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void addByte(byte aByte) {
        try {
            outputStream.writeByte(aByte);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void addBoolean(boolean aBool) {
        try {
            outputStream.writeBoolean(aBool);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void addInt(int aInt) {
        try {
            outputStream.writeInt(aInt);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void addIntArray(int[] aIntArray, boolean aStoreLenght) {
        try {
            if (aStoreLenght) {
                outputStream.writeInt(aIntArray.length);
            }
            for (int i = 0; i < aIntArray.length; ++i) {
                outputStream.writeInt(aIntArray[i]);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void addFloatArray(float[] aFloatArray, boolean aStoreLenght) {
        try {
            if (aStoreLenght) {
                outputStream.writeInt(aFloatArray.length);
            }
            for (int i = 0; i < aFloatArray.length; ++i) {
                outputStream.writeFloat(aFloatArray[i]);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void addFloatDoubleArray(float[][] aArray, int secondsize, boolean aStoreLenght) {
        try {
            if (aStoreLenght) {
                outputStream.writeInt(aArray.length);
            }
            for (int i = 0; i < aArray.length; ++i) {
                for (int j = 0; j < secondsize; ++j) {
                    outputStream.writeFloat(aArray[i][j]);
                }
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void addIntDoubleArray(int[][] aArray, int secondsize, boolean aStoreLenght) {
        try {
            if (aStoreLenght) {
                outputStream.writeInt(aArray.length);
            }
            for (int i = 0; i < aArray.length; ++i) {
                for (int j = 0; j < secondsize; ++j) {
                    outputStream.writeInt(aArray[i][j]);
                }
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void addFloat(float aFloat) {
        try {
            outputStream.writeFloat(aFloat);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void addString(String aString) {
        try {
            outputStream.writeUTF(aString);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

