/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.util.Vector;
import javax.microedition.m3g.Group;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Object3D;
import javax.microedition.m3g.World;
import main.MyMath;
import main.Symbian;
import main.Utils;
import main.swvVector3D;

public class CBezierTrack {
    private static final boolean DEBUG_SPEED = false;
    private static final boolean DEBUG_CORNER = false;
    private static final boolean DEBUG_PIECE = false;
    private static final boolean TRAZA3D = false;
    public static final int MAX_PRECALCULATED = 50;
    public static final int MAX_CONTROLPOINTS = 4;
    public static final float KMH_TO_MTSS = 0.27777776f;
    World m_world;
    boolean m_bAllRight = false;
    Vector m_BezierPieces = new Vector();
    Vector m_SpeedPoints = new Vector();
    Vector m_CornerPoints = new Vector();
    swvVector3D m_Dist0 = new swvVector3D();
    swvVector3D m_Dist1 = new swvVector3D();
    swvVector3D m_Work3D = new swvVector3D();
    swvVector3D m_BezierT3D = new swvVector3D();
    swvVector3D m_SpeedT3D = new swvVector3D();
    swvVector3D m_CornerT3D = new swvVector3D();
    int m_IndexCurrentPiece;
    int m_IndexCurrentPieceAnt;
    Node m_TrackWorld;
    Group m_BezierParentT;
    Node m_SpeedParentT;
    Node m_CornerParentT;

    private boolean extractBezierInfo() {
        int[] iId = new int[4];
        this.m_BezierParentT = (Group)Symbian.wworld_findNode((Object3D)this.m_TrackWorld, 388815126);
        if (this.m_BezierParentT == null) {
            return false;
        }
        Symbian.transform_getPosition((Node)this.m_BezierParentT, this.m_BezierT3D);
        String sBezier = "_bezier_";
        String Valor = Utils.GetPropertyAsString((Object3D)this.m_BezierParentT, "first");
        int iIDB = Utils.GenerateID(sBezier + Valor + "Transform");
        Node hFirst = (Node)Symbian.wworld_findNode((Object3D)this.m_BezierParentT, iIDB);
        if (hFirst == null) {
            return false;
        }
        Node hCopyFirst = hFirst;
        int iCont = 0;
        do {
            iId[0] = Symbian.wnode_getID(hFirst);
            Valor = Utils.GetPropertyAsString((Object3D)hFirst, "1");
            if (Valor == null) {
                return false;
            }
            String pBezier = sBezier + Valor + "Transform";
            iId[1] = Utils.GenerateID(pBezier);
            Valor = Utils.GetPropertyAsString((Object3D)hFirst, "2");
            if (Valor == null) {
                return false;
            }
            pBezier = sBezier + Valor + "Transform";
            iId[2] = Utils.GenerateID(pBezier);
            Valor = Utils.GetPropertyAsString((Object3D)hFirst, "3");
            if (Valor == null) {
                return false;
            }
            pBezier = sBezier + Valor + "Transform";
            iId[3] = Utils.GenerateID(pBezier);
            CBezierPiece aPiece = new CBezierPiece(this.m_TrackWorld, iId, 1);
            if (aPiece == null) {
                return false;
            }
            this.m_BezierPieces.addElement(aPiece);
            ++iCont;
            Symbian.engine_ReleaseHandle((Object3D)hFirst);
        } while ((hFirst = (Node)Symbian.wworld_findNode((Object3D)this.m_TrackWorld, iId[3])) != null && hFirst != hCopyFirst);
        hCopyFirst = null;
        if (hFirst == null) {
            return false;
        }
        Symbian.engine_ReleaseHandle((Object3D)hFirst);
        this.m_IndexCurrentPieceAnt = 0;
        this.m_IndexCurrentPiece = 0;
        int iSize = this.m_BezierPieces.size();
        for (int i = 0; i < iSize; ++i) {
            int previo = i == 0 ? iSize - 1 : i - 1;
            int next = i == iSize - 1 ? 0 : i + 1;
            CBezierPiece piece_previo = (CBezierPiece)this.m_BezierPieces.elementAt(previo);
            CBezierPiece piece_i = (CBezierPiece)this.m_BezierPieces.elementAt(i);
            CBezierPiece piece_next = (CBezierPiece)this.m_BezierPieces.elementAt(next);
            this.CalculeRestOfPrecalc(piece_previo, piece_i, piece_next);
            piece_next = null;
            piece_previo = null;
            piece_i = null;
        }
        iId = null;
        return true;
    }

    private boolean extractSpeedInfo() {
        this.m_SpeedParentT = (Node)Symbian.wworld_findNode((Object3D)this.m_TrackWorld, Utils.GenerateID("_GVelTransform"));
        if (this.m_SpeedParentT == null) {
            return false;
        }
        Symbian.transform_getPosition(this.m_SpeedParentT, this.m_SpeedT3D);
        float fSpeed = 0.0f;
        Node hFirst = null;
        int i = 0;
        while (true) {
            String name = i + 1 < 10 ? "_V0" : "_V";
            int newID = Utils.GenerateID(name = name + (i + 1) + "Transform");
            hFirst = (Node)Symbian.wworld_findNode((Object3D)this.m_SpeedParentT, newID);
            if (hFirst == null) break;
            String Valor = Utils.GetPropertyAsString((Object3D)hFirst, "v1");
            if (Valor == null) {
                return false;
            }
            fSpeed = Integer.parseInt(Valor);
            CSpeedPoint aSpeed = new CSpeedPoint(this.m_TrackWorld, fSpeed, hFirst);
            if (aSpeed == null) {
                return false;
            }
            this.m_SpeedPoints.addElement(aSpeed);
            Symbian.engine_ReleaseHandle((Object3D)hFirst);
            ++i;
        }
        return true;
    }

    private boolean extractCornerInfo() {
        String name;
        int newID;
        Node hFirst = null;
        this.m_CornerParentT = (Node)Symbian.wworld_findNode((Object3D)this.m_TrackWorld, Utils.GenerateID("_GCornerTransform"));
        if (this.m_CornerParentT == null) {
            return false;
        }
        Symbian.transform_getPosition(this.m_CornerParentT, this.m_CornerT3D);
        int i = 0;
        while ((hFirst = (Node)Symbian.wworld_findNode((Object3D)this.m_CornerParentT, newID = Utils.GenerateID(name = "corner" + i + "Transform"))) != null) {
            CCornerPoint aCorner;
            int iCorner = 0;
            String Valor = Utils.GetPropertyAsString((Object3D)hFirst, "Test");
            if (Valor != null) {
                iCorner = Integer.parseInt(Valor);
            }
            if ((aCorner = new CCornerPoint(this.m_TrackWorld, iCorner, hFirst)) == null) {
                return false;
            }
            this.m_CornerPoints.addElement(aCorner);
            Symbian.engine_ReleaseHandle((Object3D)hFirst);
            ++i;
        }
        return true;
    }

    boolean isConsistent() {
        return this.m_bAllRight;
    }

    void destroy() {
        this.free();
    }

    void CalculeRestOfPrecalc(CBezierPiece p_prev, CBezierPiece p_current, CBezierPiece p_next) {
        p_prev.GetPrecalPosition(49, this.m_Dist0);
        p_current.GetPrecalPosition(0, this.m_Dist1);
        p_current.SetPrecalDistance(0, MyMath.RDistance(this.m_Dist1.x - this.m_Dist0.x, this.m_Dist1.y - this.m_Dist0.y));
        float _10percent = Symbian.fu_div(Symbian.fixed_int(50), Symbian.fixed_int(100)) * 10.0f;
        for (int i = 0; i < 50; ++i) {
            int Recorre10 = i + (int)_10percent;
            p_current.GetPrecalPosition(i, this.m_Dist0);
            if (Recorre10 / 50 == 0) {
                p_current.GetPrecalPosition(Recorre10, this.m_Dist1);
            } else {
                p_next.GetPrecalPosition(Recorre10 % 50, this.m_Dist1);
            }
            p_current.SetPrecalYaw10(i, this.GiveMeYaw(this.m_Dist1.x - this.m_Dist0.x, this.m_Dist1.y - this.m_Dist0.y, MyMath.RDistance(this.m_Dist1.x - this.m_Dist0.x, this.m_Dist1.y - this.m_Dist0.y)));
        }
    }

    int FindIndexPiece(Node p_CarDyn) {
        int indexmin = -1;
        float fDistMin = 32000.0f;
        Symbian.transform_getPosition(p_CarDyn, this.m_Dist1);
        CBezierPiece piece = null;
        for (int i = 0; i < this.GetNumberOfPieces(); ++i) {
            piece = this.GetBezierPiece(i);
            piece.GetPrecalPosition(piece.GetNumSteps() >> 1, this.m_Dist0);
            float fDist = MyMath.fabs(this.m_Dist1.x - this.m_Dist0.x) + MyMath.fabs(this.m_Dist1.y - this.m_Dist0.y);
            if (!(fDist < fDistMin)) continue;
            fDistMin = fDist;
            indexmin = i;
        }
        return indexmin;
    }

    void FindIndexContiguousPieces(int p_indice, int[] p_iPrevPiece, int[] p_iNextPiece) {
        if (p_indice == 0) {
            p_iPrevPiece[0] = this.GetNumberOfPieces() - 1;
            p_iNextPiece[0] = 1;
        } else {
            p_iPrevPiece[0] = p_indice - 1;
            p_iNextPiece[0] = p_indice == this.GetNumberOfPieces() - 1 ? 0 : p_indice + 1;
        }
    }

    int FindIndexSpeedPoint(Node p_BykeDyn) {
        int indexmin = -1;
        float fDistMin = 30000.0f;
        Symbian.transform_getPosition(p_BykeDyn, this.m_Dist1);
        for (int i = 0; i < this.GetNumberOfSpeedPoints(); ++i) {
            CSpeedPoint speedpoint = this.GetSpeedPoint(i);
            speedpoint.GetPosition(this.m_Dist0);
            float fDist = MyMath.fabs(this.m_Dist1.x - this.m_Dist0.x) + MyMath.fabs(this.m_Dist1.y - this.m_Dist0.y);
            if (!(fDist < fDistMin)) continue;
            fDistMin = fDist;
            indexmin = i;
        }
        return indexmin;
    }

    public int FindIndexNextCornerPoint(int p_Indice) {
        return p_Indice == this.GetNumberOfCornerPoints() - 1 ? 0 : p_Indice + 1;
    }

    CBezierPiece GetBezierPiece(int p_i) {
        return (CBezierPiece)this.m_BezierPieces.elementAt(p_i);
    }

    CSpeedPoint GetSpeedPoint(int p_i) {
        return (CSpeedPoint)this.m_SpeedPoints.elementAt(p_i);
    }

    CCornerPoint GetCornerPoint(int p_i) {
        return (CCornerPoint)this.m_CornerPoints.elementAt(p_i);
    }

    int GetNumberOfPieces() {
        return this.m_BezierPieces.size();
    }

    int GetNumberOfSpeedPoints() {
        return this.m_SpeedPoints.size();
    }

    int GetNumberOfCornerPoints() {
        return this.m_CornerPoints.size();
    }

    float GiveMeYaw(float pcont, float popu, float phipo) {
        float fyaw = MyMath.acos(pcont / phipo);
        fyaw = popu < 0.0f ? -1.5707964f - fyaw : fyaw - 1.5707964f;
        return fyaw;
    }

    CBezierTrack(Node p_World, int p_iClipArt) {
        this.m_world = (World)p_World;
        this.m_TrackWorld = (Node)Symbian.wworld_findNode((Object3D)this.m_world, p_iClipArt);
        if (this.m_TrackWorld != null && this.extractSpeedInfo()) {
            this.m_world.removeChild(this.m_SpeedParentT);
            this.m_SpeedParentT = null;
            if (this.extractCornerInfo()) {
                this.m_world.removeChild(this.m_CornerParentT);
                this.m_CornerParentT = null;
                if (this.extractBezierInfo()) {
                    this.m_world.removeChild((Node)this.m_BezierParentT);
                    this.m_BezierParentT = null;
                    this.m_SpeedPoints.trimToSize();
                    this.m_BezierPieces.trimToSize();
                    this.m_CornerPoints.trimToSize();
                    this.m_bAllRight = true;
                }
            }
        }
    }

    private void free() {
        int iIndex;
        if (this.m_BezierPieces != null) {
            for (iIndex = 0; iIndex < this.m_BezierPieces.size(); ++iIndex) {
                CBezierPiece aB = (CBezierPiece)this.m_BezierPieces.elementAt(iIndex);
                aB.destroy();
                aB = null;
            }
            this.m_BezierPieces.removeAllElements();
            this.m_BezierPieces = null;
        }
        if (this.m_SpeedPoints != null) {
            for (iIndex = 0; iIndex < this.m_SpeedPoints.size(); ++iIndex) {
                CSpeedPoint aSP = (CSpeedPoint)this.m_SpeedPoints.elementAt(iIndex);
                aSP.destroy();
                aSP = null;
            }
            this.m_SpeedPoints.removeAllElements();
            this.m_SpeedPoints = null;
        }
        if (this.m_CornerPoints != null) {
            for (iIndex = 0; iIndex < this.m_CornerPoints.size(); ++iIndex) {
                CCornerPoint aCP = (CCornerPoint)this.m_CornerPoints.elementAt(iIndex);
                aCP.destroy();
                Object var2_2 = null;
            }
            this.m_CornerPoints.removeAllElements();
            this.m_CornerPoints = null;
        }
        if (this.m_TrackWorld != null) {
            Symbian.engine_ReleaseHandle((Object3D)this.m_TrackWorld);
        }
        this.m_BezierParentT = null;
        this.m_SpeedParentT = null;
        this.m_CornerParentT = null;
        this.m_CornerT3D = null;
        this.m_SpeedT3D = null;
        this.m_BezierT3D = null;
        this.m_Work3D = null;
        this.m_Dist1 = null;
        this.m_Dist0 = null;
    }

    protected class CBezierPiece {
        private TPieceInfo[] m_Info = new TPieceInfo[50];
        private Node[] m_ControlPointT = new Node[4];
        private swvVector3D[] m_Vector = new swvVector3D[4];
        int m_NumSteps;
        int m_iSense;

        CBezierPiece(Node p_trackT, int[] p_Id, int p_isense) {
            this.m_iSense = p_isense;
            this.m_NumSteps = 50;
            for (int iIndex = 0; iIndex < 4; ++iIndex) {
                this.m_ControlPointT[iIndex] = (Node)Symbian.wworld_findNode((Object3D)p_trackT, p_Id[iIndex]);
                if (this.m_ControlPointT[iIndex] == null) {
                    System.exit(-1);
                }
                this.m_Vector[iIndex] = new swvVector3D();
                Symbian.transform_getPosition(this.m_ControlPointT[iIndex], this.m_Vector[iIndex]);
                swvVector3D.sumaV(this.m_Vector[iIndex], CBezierTrack.this.m_BezierT3D);
                Symbian.transform_getPosition(p_trackT, CBezierTrack.this.m_Work3D);
                swvVector3D.sumaV(this.m_Vector[iIndex], CBezierTrack.this.m_Work3D);
                this.m_Vector[iIndex].z = 0.0f;
            }
            float mu = 0.0f;
            float jump = 0.02f;
            int iIndex = 0;
            while (iIndex < 50) {
                float mum1 = 1.0f - mu;
                float mum13 = Symbian.fu_mul(Symbian.fu_mul(mum1, mum1), mum1);
                float mu3 = Symbian.fu_mul(Symbian.fu_mul(mu, mu), mu);
                float temp31 = 3.0f * Symbian.fu_mul(Symbian.fu_mul(mu, mum1), mum1);
                float temp32 = 3.0f * Symbian.fu_mul(Symbian.fu_mul(mu, mu), mum1);
                this.m_Info[iIndex] = new TPieceInfo();
                this.m_Info[iIndex].m_Position[0] = Symbian.fu_mul(mum13, this.m_Vector[0].x) + Symbian.fu_mul(temp31, this.m_Vector[1].x) + Symbian.fu_mul(temp32, this.m_Vector[2].x) + Symbian.fu_mul(mu3, this.m_Vector[3].x);
                this.m_Info[iIndex].m_Position[1] = Symbian.fu_mul(mum13, this.m_Vector[0].y) + Symbian.fu_mul(temp31, this.m_Vector[1].y) + Symbian.fu_mul(temp32, this.m_Vector[2].y) + Symbian.fu_mul(mu3, this.m_Vector[3].y);
                if (iIndex > 0) {
                    float fDifX = this.m_Info[iIndex].m_Position[0] - this.m_Info[iIndex - 1].m_Position[0];
                    float fDifY = this.m_Info[iIndex].m_Position[1] - this.m_Info[iIndex - 1].m_Position[1];
                    this.m_Info[iIndex].m_Distance = MyMath.RDistance(fDifX, fDifY);
                }
                ++iIndex;
                mu += jump;
            }
            for (iIndex = 0; iIndex < 4; ++iIndex) {
                this.m_ControlPointT[iIndex] = null;
            }
            this.m_ControlPointT = null;
            for (iIndex = 0; iIndex < 4; ++iIndex) {
                this.m_Vector[iIndex] = null;
            }
            this.m_Vector = null;
        }

        public void destroy() {
            for (int iIndex = 0; iIndex < 50; ++iIndex) {
                this.m_Info[iIndex].destroy();
                this.m_Info[iIndex] = null;
            }
            this.m_Info = null;
        }

        public void GetPrecalPosition(int p_i, swvVector3D aPos) {
            aPos.x = this.m_Info[p_i].m_Position[0];
            aPos.y = this.m_Info[p_i].m_Position[1];
            aPos.z = 0.0f;
        }

        void SetPrecalDistance(int p_i, float p_d) {
            this.m_Info[p_i].m_Distance = p_d;
        }

        void SetPrecalYaw10(int p_i, float p_a) {
            this.m_Info[p_i].m_Yaw10 = p_a;
        }

        int FindStep(Node p_CarDyn) {
            int indexmin = -1;
            float fDistMin = Symbian.fixed_int(30000);
            Symbian.transform_getPosition(p_CarDyn, CBezierTrack.this.m_Dist0);
            for (int i = 0; i < this.GetNumSteps(); ++i) {
                this.GetPrecalPosition(i, CBezierTrack.this.m_Dist1);
                float fDist = MyMath.RDistance(CBezierTrack.this.m_Dist0.x - CBezierTrack.this.m_Dist1.x, CBezierTrack.this.m_Dist0.y - CBezierTrack.this.m_Dist1.y);
                if (!(fDist < fDistMin)) continue;
                fDistMin = fDist;
                indexmin = i;
            }
            return indexmin;
        }

        int GetNumSteps() {
            return this.m_NumSteps;
        }

        float GetPrecalDistance(int p_i) {
            return this.m_Info[p_i].m_Distance;
        }

        float GetPrecalYaw10(int p_i) {
            return this.m_Info[p_i].m_Yaw10;
        }
    }

    protected class CSpeedPoint {
        float m_Speed = 0.0f;
        swvVector3D m_Position = new swvVector3D();

        CSpeedPoint(Node p_trackT, float p_speed, Node p_h) {
            this.m_Speed = p_speed * 0.27777776f;
            Symbian.transform_getPosition(p_h, this.m_Position);
            swvVector3D.sumaV(this.m_Position, CBezierTrack.this.m_SpeedT3D);
            Symbian.transform_getPosition(p_trackT, CBezierTrack.this.m_Work3D);
            swvVector3D.sumaV(this.m_Position, CBezierTrack.this.m_Work3D);
            this.m_Position.z = 0.0f;
        }

        void GetPosition(swvVector3D aVector) {
            aVector.x = this.m_Position.x;
            aVector.y = this.m_Position.y;
            aVector.z = this.m_Position.z;
        }

        float GetSpeed() {
            return this.m_Speed;
        }

        public void destroy() {
            this.m_Position = null;
        }
    }

    protected class CCornerPoint {
        int m_iCorner;
        swvVector3D m_Position = new swvVector3D();

        CCornerPoint(Node p_trackT, int p_iCorner, Node p_h) {
            Symbian.transform_getPosition(p_h, this.m_Position);
            swvVector3D.sumaV(this.m_Position, CBezierTrack.this.m_CornerT3D);
            Symbian.transform_getPosition(p_trackT, CBezierTrack.this.m_Work3D);
            swvVector3D.sumaV(this.m_Position, CBezierTrack.this.m_Work3D);
            this.m_Position.z = 0.0f;
            this.m_iCorner = p_iCorner;
        }

        public swvVector3D GetPosition() {
            return this.m_Position;
        }

        public int GetCorner() {
            return this.m_iCorner;
        }

        public void destroy() {
            this.m_Position = null;
        }
    }

    protected class TPieceInfo {
        float[] m_Position = new float[2];
        float m_Distance;
        float m_Yaw10;

        protected TPieceInfo() {
        }

        public void destroy() {
            this.m_Position = null;
        }
    }
}

