/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.DataInputStream;
import java.io.IOException;

public class Utf8 {
    static final boolean STRICTLY_CHECK_FORMAT = true;
    static final boolean ALLOW_NORMAL_UTF8 = true;
    static final boolean ALLOW_PSEUDO_UTF8 = false;

    public static int readUtf8(DataInputStream p_din, StringBuffer p_strbuffer) throws IOException {
        byte b;
        p_strbuffer.setLength(0);
        while ((b = (byte)p_din.read()) != -1) {
            if (b == 10) {
                b = (byte)p_din.read();
                break;
            }
            if (b >= 0) {
                p_strbuffer.append((char)b);
                continue;
            }
            byte nb = (byte)p_din.read();
            if (b < -32) {
                char c = (char)((b & 0x1F) << 6 | nb & 0x3F);
                p_strbuffer.append(c);
                if ((b & 0xE0) != 192 || (nb & 0xC0) != 128) {
                    throw new RuntimeException("invalid marker bits for double byte char");
                }
                if (c < '\u0080') {
                    throw new RuntimeException("encountered double byte char that should have been single byte");
                }
                if (c <= '\u07ff') continue;
                throw new RuntimeException("encountered double byte char that should have been triple byte");
            }
            byte nnb = (byte)p_din.read();
            char c = (char)((b & 0xF) << 12 | (nb & 0x3F) << 6 | nnb & 0x3F);
            p_strbuffer.append(c);
            if ((b & 0xF0) != 224 || (nb & 0xC0) != 128 || (nnb & 0xC0) != 128) {
                throw new RuntimeException("invalid marker bits for triple byte char");
            }
            if (c >= '\u0800') continue;
            throw new RuntimeException("encountered triple byte char that should have been fewer bytes");
        }
        return b;
    }
}

