/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.sound.Sound;
import com.nokia.mid.ui.DeviceControl;
import com.nokia.mid.ui.FullCanvas;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

public class SavageCanvas_NOKIAUI_S60
extends FullCanvas {
    public Image imgBuffer;
    public Graphics gfxBuffer = null;
    public SavageScreen pScreen = null;
    public static byte[] wavHeader = new byte[]{82, 73, 70, 70, 110, 31, 0, 0, 87, 65, 86, 69, 102, 109, 116, 32, 16, 0, 0, 0, 1, 0, 1, 0, 64, 31, 0, 0, 64, 31, 0, 0, 1, 0, 8, 0, 100, 97, 116, 97, 0, 0, 0, 0};
    public static int[] indexTable = new int[]{-1, -1, -1, -1, 2, 4, 6, 8, -1, -1, -1, -1, 2, 4, 6, 8};
    public static int[] stepsizeTable = new int[]{7, 8, 9, 10, 11, 12, 13, 14, 16, 17, 19, 21, 23, 25, 28, 31, 34, 37, 41, 45, 50, 55, 60, 66, 73, 80, 88, 97, 107, 118, 130, 143, 157, 173, 190, 209, 230, 253, 279, 307, 337, 371, 408, 449, 494, 544, 598, 658, 724, 796, 876, 963, 1060, 1166, 1282, 1411, 1552, 1707, 1878, 2066, 2272, 2499, 2749, 3024, 3327, 3660, 4026, 4428, 4871, 5358, 5894, 6484, 7132, 7845, 8630, 9493, 10442, 11487, 12635, 13899, 15289, 16818, 18500, 20350, 22385, 24623, 27086, 29794, Short.MAX_VALUE};
    public boolean bAppPaused = false;
    public int nWidth;
    public int nHeight;
    public int nScrWidth = this.getWidth();
    public int nScrHeight = this.getHeight();
    public int rumble_counter = -1;
    public int sound_counter = 0;
    public Vector imageCache = new Vector();
    public Sound[] sounds;
    public int[] soundTypes;
    public int nNextSound;
    public int nCurSound;
    public int nCurPriority;
    public Player[] players;
    public int nBackgroundSound = -1;
    public int MMAPI = 0;

    public final Image cacheFindImage(int n) {
        for (int i = 0; i < this.imageCache.size(); ++i) {
            SavageCanvas_NOKIAUI_S60$CachedImage savageCanvas_NOKIAUI_S60$CachedImage = (SavageCanvas_NOKIAUI_S60$CachedImage)this.imageCache.elementAt(i);
            if (savageCanvas_NOKIAUI_S60$CachedImage.nId != n) continue;
            return savageCanvas_NOKIAUI_S60$CachedImage.pImage;
        }
        return null;
    }

    public final void cacheAddImage(int n, Image image) {
        SavageCanvas_NOKIAUI_S60$CachedImage savageCanvas_NOKIAUI_S60$CachedImage = new SavageCanvas_NOKIAUI_S60$CachedImage(this, n, image);
        this.imageCache.addElement(savageCanvas_NOKIAUI_S60$CachedImage);
    }

    public final void setDisplay(Display display) {
    }

    public final void setScreen(SavageScreen savageScreen) {
        if (savageScreen != null) {
            savageScreen.pCanvas = this;
            savageScreen.gfxBuffer = this.gfxBuffer;
            savageScreen.imgBuffer = this.imgBuffer;
            savageScreen.setGraphics(this.gfxBuffer);
            this.gfxBuffer.setClip(0, 0, this.nWidth, this.nHeight);
        }
        this.pScreen = savageScreen;
    }

    public final void createBackBuffer(int n, int n2) {
        this.nWidth = n;
        if (this.nWidth < this.nScrWidth) {
            this.nWidth = this.nScrWidth;
        }
        this.nHeight = n2;
        if (this.nHeight < this.nScrHeight) {
            this.nHeight = this.nScrHeight;
        }
        this.imgBuffer = Image.createImage((int)this.nWidth, (int)this.nHeight);
        this.gfxBuffer = this.imgBuffer.getGraphics();
        this.gfxBuffer.setColor(255, 255, 255);
        this.gfxBuffer.fillRect(0, 0, this.nWidth, this.nHeight);
    }

    public final void flip() {
        while (this.bAppPaused || !this.isShown()) {
            Thread.yield();
        }
        this.repaint();
        if (this.rumble_counter > 0 && --this.rumble_counter == 0) {
            this.stopRumble();
        }
        if (this.sound_counter-- < 0) {
            this.sound_counter = 25;
            if (this.MMAPI == 1 && this.nBackgroundSound >= 0 && this.players[this.nBackgroundSound] != null && (this.nCurSound < 0 || this.players[this.nCurSound].getState() != 400) && this.nBackgroundSound >= 0) {
                try {
                    if (this.players[this.nBackgroundSound].getState() != 400) {
                        if (this.players[this.nBackgroundSound].getState() != 300) {
                            this.players[this.nBackgroundSound].prefetch();
                        }
                        this.players[this.nBackgroundSound].start();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.serviceRepaints();
        System.gc();
    }

    public final void paint(Graphics graphics) {
        if (this.pScreen != null) {
            this.pScreen.paint(graphics);
        }
    }

    public final void setLightLevel(int n) {
        if (n == 0) {
            boolean bl = false;
        } else {
            boolean bl = true;
        }
        if (n > 100) {
            n = 100;
        }
    }

    public final void startRumble(int n, int n2) {
        this.rumble_counter = n2;
        try {
            DeviceControl.startVibra((int)n, (long)50L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void stopRumble() {
        this.rumble_counter = 0;
        try {
            DeviceControl.stopVibra();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void keyReleased(int n) {
        if (this.pScreen != null) {
            this.pScreen.keyReleased(n);
        }
    }

    public final void keyPressed(int n) {
        if (this.pScreen == null) {
            return;
        }
        this.pScreen.nLastKey = n;
        this.pScreen.bKeyPressed = true;
        this.pScreen.keyPressed(n);
    }

    public final void sndInit() {
        try {
            Class.forName("javax.microedition.media.Manager");
            System.out.println("MMAPI Present.");
            this.MMAPI = 1;
            this.players = new Player[16];
            this.soundTypes = new int[16];
        }
        catch (Exception exception) {
            System.out.println("MMAPI Not Present.");
            this.MMAPI = 0;
            this.sounds = new Sound[16];
        }
        this.nNextSound = 0;
        this.nCurSound = -1;
        this.nCurPriority = 256;
    }

    public final int sndLoad(int n) {
        if (n < 0) {
            return -1;
        }
        int n2 = this.nNextSound++;
        switch (this.MMAPI) {
            case 0: {
                byte[] byArray = this.pScreen.resLoad(n);
                byte by = byArray[1];
                if (by < 100) {
                    byte[] byArray2 = new byte[byArray.length - 2];
                    System.arraycopy(byArray, 2, byArray2, 0, byArray2.length);
                    byArray = null;
                    this.sounds[n2] = new Sound(byArray2, (int)by);
                    byArray2 = null;
                    return n2;
                }
                if (by == 101) {
                    this.sounds[n2] = new Sound(this.loadRawAsWav(this.adpcmDecode(byArray)), 5);
                    byArray = null;
                    return n2;
                }
                return -1;
            }
            case 1: {
                try {
                    byte[] byArray = this.pScreen.resLoad(n);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    byteArrayInputStream.skip(1L);
                    int n3 = byteArrayInputStream.read();
                    String string = "audio/X-wav";
                    switch (n3) {
                        case 100: {
                            string = "audio/midi";
                            this.soundTypes[n2] = 100;
                            break;
                        }
                        case 101: {
                            byteArrayInputStream.close();
                            byteArrayInputStream = new ByteArrayInputStream(this.loadRawAsWav(this.adpcmDecode(byArray)));
                            this.soundTypes[n2] = 5;
                            break;
                        }
                        default: {
                            this.soundTypes[n2] = 5;
                        }
                    }
                    this.players[n2] = Manager.createPlayer((InputStream)byteArrayInputStream, (String)string);
                    if (n3 != 100) {
                        this.players[n2].prefetch();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return n2;
            }
        }
        return -1;
    }

    public final void sndPlay(int n, int n2, int n3) {
        if (n < 0) {
            return;
        }
        switch (this.MMAPI) {
            case 0: {
                if (this.sounds[n] == null) break;
                if (this.nCurSound >= 0 && this.sounds[this.nCurSound].getState() != 1) {
                    if (this.nCurSound == n || n3 >= this.nCurPriority) break;
                    this.sounds[this.nCurSound].stop();
                    this.nCurSound = -1;
                }
                if (this.sounds[n].getState() != 1) break;
                this.sounds[n].play(n2);
                break;
            }
            case 1: {
                if (this.players[n] == null) break;
                if (n3 == 100 && n2 == 0) {
                    this.nBackgroundSound = n;
                }
                try {
                    if (this.nCurSound >= 0 && this.players[this.nCurSound] != null) {
                        int n4 = this.players[this.nCurSound].getState();
                        if (n4 != 400) {
                            this.nCurPriority = 256;
                        }
                        if (n3 < this.nCurPriority) {
                            this.players[this.nCurSound].stop();
                            this.nCurSound = -1;
                        } else {
                            return;
                        }
                    }
                    if (this.soundTypes[n] == 100) {
                        this.players[n].prefetch();
                    }
                    this.players[n].start();
                    if (n3 != 100 || n2 != 0) break;
                    this.nBackgroundSound = n;
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.nCurSound = n;
        this.nCurPriority = n3;
    }

    public final void sndStop(int n) {
        if (n < 0) {
            return;
        }
        if (n == this.nCurSound) {
            this.nCurPriority = 256;
            this.nCurSound = -1;
        }
        switch (this.MMAPI) {
            case 0: {
                if (this.sounds[n] == null) break;
                this.sounds[n].stop();
                break;
            }
            case 1: {
                if (this.players[n] == null) break;
                if (n == this.nBackgroundSound) {
                    this.nBackgroundSound = -1;
                }
                try {
                    this.players[n].stop();
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public final void sndReset() {
        switch (this.MMAPI) {
            case 0: {
                for (int i = 0; i < this.sounds.length; ++i) {
                    if (this.sounds[i] == null) continue;
                    this.sounds[i].release();
                    this.sounds[i] = null;
                }
                break;
            }
            case 1: {
                for (int i = 0; i < this.players.length; ++i) {
                    if (this.players[i] == null) continue;
                    this.players[i].deallocate();
                    this.players[i].close();
                    this.players[i] = null;
                    this.soundTypes[i] = -1;
                }
                this.nBackgroundSound = -1;
            }
        }
        this.nNextSound = 0;
        this.nCurSound = -1;
        this.nCurPriority = 256;
    }

    public final String getKeyName(int n) {
        if (n >= 0) {
            return super.getKeyName(n);
        }
        switch (n) {
            case -6: {
                return "L Softkey";
            }
            case -7: {
                return "R Softkey";
            }
            case -10: {
                return "Send";
            }
            case -11: {
                return "End";
            }
            case -5: {
                return "Select";
            }
            case -1: {
                return "Up";
            }
            case -2: {
                return "Down";
            }
            case -3: {
                return "Left";
            }
            case -4: {
                return "Right";
            }
        }
        return "undefined";
    }

    public final byte[] loadRawAsWav(byte[] byArray) {
        int n = byArray.length + wavHeader.length;
        byte[] byArray2 = new byte[n];
        System.arraycopy(wavHeader, 0, byArray2, 0, wavHeader.length);
        byArray2[4] = (byte)((n -= 8) & 0xFF);
        byArray2[5] = (byte)(n >> 8 & 0xFF);
        byArray2[6] = (byte)(n >> 16 & 0xFF);
        byArray2[7] = (byte)(n >> 24 & 0xFF);
        byArray2[40] = (byte)(byArray.length & 0xFF);
        byArray2[41] = (byte)(byArray.length >> 8 & 0xFF);
        byArray2[42] = (byte)(byArray.length >> 16 & 0xFF);
        byArray2[43] = (byte)(byArray.length >> 24 & 0xFF);
        System.arraycopy(byArray, 0, byArray2, 44, byArray.length);
        return byArray2;
    }

    public final byte[] adpcmDecode(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 2;
        int n4 = 0;
        int n5 = 0;
        int n6 = stepsizeTable[n5];
        boolean bl = true;
        byte[] byArray2 = new byte[byArray.length - 2 << 1];
        for (int i = byArray.length - 2 << 1; i > 0; --i) {
            int n7;
            if (bl) {
                n7 = n & 0xF;
            } else {
                n = byArray[n3++];
                n7 = n >> 4 & 0xF;
            }
            boolean bl2 = bl = !bl;
            if ((n5 += indexTable[n7]) < 0) {
                n5 = 0;
            }
            if (n5 > 88) {
                n5 = 88;
            }
            int n8 = n7 & 8;
            int n9 = n6 >> 3;
            if (((n7 &= 7) & 4) != 0) {
                n9 += n6;
            }
            if ((n7 & 2) != 0) {
                n9 += n6 >> 1;
            }
            if ((n7 & 1) != 0) {
                n9 += n6 >> 2;
            }
            n4 = n8 != 0 ? (n4 -= n9) : (n4 += n9);
            if (n4 > Short.MAX_VALUE) {
                n4 = Short.MAX_VALUE;
            } else if (n4 < Short.MIN_VALUE) {
                n4 = Short.MIN_VALUE;
            }
            n6 = stepsizeTable[n5];
            byArray2[n2++] = (byte)(n4 + 32768 >> 8);
        }
        return byArray2;
    }

    public final void hideNotify() {
        if (!this.bAppPaused) {
            this.bAppPaused = true;
            if (this.pScreen != null) {
                this.pScreen.saveState();
            }
        }
    }

    public final void showNotify() {
        if (this.bAppPaused) {
            this.bAppPaused = false;
            if (this.pScreen != null) {
                this.pScreen.msLag = 0L;
            }
        }
    }
}

