/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;

public abstract class SavageScreen {
    public Image imgBuffer;
    public Graphics gfxBuffer = null;
    public Graphics curGraphics = null;
    public DirectGraphics curDirectGraphics = null;
    public SavageCanvas_NOKIAUI pCanvas = null;
    public static int resource_bundle = -1;
    public static int resource_offset = 0;
    public static InputStream isRes = null;
    public static byte[] resource_buffer;
    public int nLastKey = 0;
    public boolean bKeyPressed = false;
    public long msNow = -1L;
    public long msNext = -1L;
    public long msLag = 0L;
    public static final byte[] PNG_HEADER;
    public static final byte[] IEND_BLOCK;
    public static int[] crc_table;

    public SavageScreen() {
        SavageScreen.crcBuildTable();
    }

    public final void setGraphics(Graphics graphics) {
        this.curGraphics = graphics;
        this.curDirectGraphics = DirectUtils.getDirectGraphics((Graphics)graphics);
    }

    public abstract void saveState();

    public void keyReleased(int n) {
    }

    public void keyPressed(int n) {
    }

    public final int getKeyPressed() {
        this.bKeyPressed = false;
        return this.nLastKey;
    }

    public final boolean hasKeyPressed() {
        boolean bl = this.bKeyPressed;
        this.bKeyPressed = false;
        return bl;
    }

    public final void clear() {
        this.curGraphics.setClip(0, 0, this.pCanvas.nScrWidth, this.pCanvas.nScrHeight);
        this.curGraphics.setColor(0, 0, 0);
        this.curGraphics.fillRect(0, 0, this.pCanvas.nScrWidth, this.pCanvas.nScrHeight);
    }

    public final void clearClip() {
        this.curGraphics.setClip(0, 0, this.pCanvas.nScrWidth, this.pCanvas.nScrHeight);
    }

    public final Font selectFont(int n, int n2, int n3) {
        Font font = null;
        Font font2 = null;
        int n4 = 0;
        int n5 = 0;
        int[] nArray = new int[]{16, 0, 8};
        int n6 = this.pCanvas.nScrHeight / n3;
        for (int i = 0; i < nArray.length && (n4 = (font = Font.getFont((int)n, (int)n2, (int)nArray[i])).getHeight()) >= n6; ++i) {
            font2 = font;
            n5 = n4;
        }
        if ((n4 = n6 - n4) < 0) {
            n4 = 0 - n4;
        }
        if (font2 == null) {
            return font;
        }
        if ((n5 = n6 - n5) < 0) {
            n5 = 0 - n5;
        }
        if (n4 < n5) {
            return font;
        }
        return font2;
    }

    public final void flip(long l) {
        if (l == 0L) {
            this.pCanvas.flip();
            this.msLag = 0L;
            this.msNext = -1L;
            return;
        }
        this.msNow = System.currentTimeMillis() + this.msLag;
        if (this.msNext < 0L) {
            this.msNext = System.currentTimeMillis();
        }
        try {
            if (this.msNow < this.msNext) {
                Thread.sleep(this.msNext - this.msNow);
            }
            this.msNow = System.currentTimeMillis();
            this.msLag += this.msNow - this.msNext;
            if (this.msLag > l) {
                this.msLag = l;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.msNext = System.currentTimeMillis() + l;
        if (this.msLag < l) {
            this.pCanvas.flip();
            this.msLag = 0L;
        }
    }

    public final void loadPrefs(String string, int[] nArray) {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(recordStore.getRecord(1));
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            if (dataInputStream.available() >= nArray.length) {
                int n = dataInputStream.readInt();
                for (int i = 0; i < n; ++i) {
                    nArray[i] = dataInputStream.readInt();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void savePrefs(String string, int[] nArray) {
        int n = nArray.length;
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(n);
            for (int i = 0; i < n; ++i) {
                dataOutputStream.writeInt(nArray[i]);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            try {
                recordStore.setRecord(1, byArray, 0, byArray.length);
            }
            catch (InvalidRecordIDException invalidRecordIDException) {
                recordStore.addRecord(byArray, 0, byArray.length);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final int resOpenBundle(int n, int n2) {
        if (n < 0) {
            return 0;
        }
        int n3 = n & 0xF;
        int n4 = n >> 4;
        String string = n3 + ".res";
        System.gc();
        try {
            if (resource_bundle == n3 && (n2 & 1) == 0) {
                return 0;
            }
            this.resCloseBundle();
            isRes = this.getClass().getResourceAsStream(string);
            resource_bundle = n3;
            resource_offset = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public final void resCloseBundle() {
        try {
            if (isRes != null) {
                isRes.close();
                isRes = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (resource_buffer != null) {
            resource_buffer = null;
        }
        resource_bundle = -1;
        resource_offset = 0;
        System.gc();
    }

    public final void resSeek(int n) {
        int n2 = (n & 0xFFFF) << 2;
        if (resource_buffer != null) {
            resource_offset = n2;
            return;
        }
        try {
            if (n2 < resource_offset) {
                this.resOpenBundle(resource_bundle, 1);
            } else {
                n2 -= resource_offset;
            }
            isRes.skip(n2);
            resource_offset += n2;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final byte[] resLoadBlock(int n, int n2) {
        int n3 = (n & 0xFFFF) << 2;
        int n4 = ((n2 & 0xFFFF) << 2) + (n2 >> 16);
        byte[] byArray = new byte[n4 -= n3];
        if (resource_buffer != null) {
            System.arraycopy(resource_buffer, n3, byArray, 0, n4);
            resource_offset = n3 + n4;
            return byArray;
        }
        this.resSeek(n);
        try {
            int n5 = 0;
            for (int i = 0; i != byArray.length && n5 != -1; i += n5) {
                n5 = isRes.read(byArray, i, byArray.length - i);
            }
            resource_offset += n4;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray;
    }

    public final byte[] resReadBytes(int n) {
        byte[] byArray = new byte[n];
        if (resource_buffer != null) {
            System.arraycopy(resource_buffer, resource_offset, byArray, 0, n);
            resource_offset += n;
            return byArray;
        }
        try {
            int n2 = 0;
            for (int i = 0; i != byArray.length && n2 != -1; i += n2) {
                n2 = isRes.read(byArray, i, byArray.length - i);
            }
            resource_offset += n;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray;
    }

    public final int resReadByte() {
        int n = 0;
        if (resource_buffer != null) {
            n = resource_buffer[resource_offset++];
        } else {
            try {
                n = isRes.read();
                ++resource_offset;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0xFF & n;
    }

    public final byte[] resLoad(int n) {
        return this.resLoadBlock(n, n);
    }

    public final Image resLoadImage(int n) {
        Image image = null;
        this.resSeek(n);
        try {
            int n2 = this.resReadByte() << 8 | this.resReadByte();
            int n3 = this.resReadByte() << 8 | this.resReadByte();
            int n4 = this.resReadByte();
            int n5 = this.resReadByte() << 8 | this.resReadByte();
            int n6 = this.resReadByte() << 8 | this.resReadByte();
            int n7 = this.resReadByte();
            int n8 = this.resReadByte();
            for (int i = 12; i < n2; ++i) {
                this.resReadByte();
            }
            image = SavageScreen.createImageEx(n5, n6, n7, n8, this.resReadBytes(n3), this.resReadBytes(n4 * 3));
        }
        catch (Exception exception) {
            return null;
        }
        return image;
    }

    public final int[] resLoadIntArray(int n) {
        return this.resLoadIntArray(n, false);
    }

    public final int[] resLoadIntArray(int n, boolean bl) {
        byte[] byArray = null;
        int[] nArray = null;
        byArray = this.resLoad(n);
        int n2 = 0;
        int n3 = ++n2;
        ++n2;
        byte by = byArray[n3];
        int n4 = 0xFF & by;
        int n5 = byArray.length >> (n4 >> 4);
        nArray = new int[n5];
        for (int i = 0; i < n5; ++i) {
            int n6;
            if (!bl) {
                for (n6 = n4 - 8; n6 >= 0; n6 -= 8) {
                    byte by2 = byArray[n2++];
                    nArray[i] = nArray[i] | (0xFF & by2) << n6;
                }
                continue;
            }
            for (n6 = 0; n6 < n4; n6 += 8) {
                byte by3 = byArray[n2++];
                nArray[i] = nArray[i] | (0xFF & by3) << n6;
            }
        }
        byArray = null;
        System.gc();
        return nArray;
    }

    public final String[] resLoadStringArray(int n) {
        String[] stringArray = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.resLoad(n));
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            int n2 = dataInputStream.readInt();
            stringArray = new String[n2];
            for (int i = 0; i < n2; ++i) {
                stringArray[i] = dataInputStream.readUTF();
                System.out.println(i + ": " + stringArray[i]);
            }
            dataInputStream.close();
            byteArrayInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        dataInputStream = null;
        byteArrayInputStream = null;
        System.gc();
        return stringArray;
    }

    public static Image createImageEx(int n, int n2, int n3, int n4, byte[] byArray, byte[] byArray2) {
        return SavageScreen.createImageEx(n, n2, n3, n4, byArray, byArray2, 0);
    }

    public static Image createImageEx(int n, int n2, int n3, int n4, byte[] byArray, byte[] byArray2, int n5) {
        byte[] byArray3;
        int n6 = 0;
        int n7 = 0;
        try {
            n7 = PNG_HEADER.length + byArray.length + byArray2.length + IEND_BLOCK.length + 30;
            if (n4 != 255) {
                n7 += 13;
            }
            byArray3 = new byte[n7];
            System.arraycopy(PNG_HEADER, 0, byArray3, 0, PNG_HEADER.length);
            byArray3[19] = (byte)(n & 0xFF);
            byArray3[18] = (byte)(n >> 8);
            byArray3[23] = (byte)(n2 & 0xFF);
            byArray3[22] = (byte)(n2 >> 8);
            byArray3[24] = (byte)n3;
            n6 = PNG_HEADER.length;
            n7 = SavageScreen.crcCalc(byArray3, 12, PNG_HEADER.length - 12, -1);
            byArray3[n6++] = (byte)((n7 & 0xFF000000) >> 24);
            byArray3[n6++] = (byte)((n7 & 0xFF0000) >> 16);
            byArray3[n6++] = (byte)((n7 & 0xFF00) >> 8);
            byArray3[n6++] = (byte)(n7 & 0xFF);
            n7 = byArray2.length;
            byArray3[n6++] = (byte)((n7 & 0xFF000000) >> 24);
            byArray3[n6++] = (byte)((n7 & 0xFF0000) >> 16);
            byArray3[n6++] = (byte)((n7 & 0xFF00) >> 8);
            byArray3[n6++] = (byte)(n7 & 0xFF);
            n7 = 1347179589;
            byArray3[n6++] = (byte)((n7 & 0xFF000000) >> 24);
            byArray3[n6++] = (byte)((n7 & 0xFF0000) >> 16);
            byArray3[n6++] = (byte)((n7 & 0xFF00) >> 8);
            byArray3[n6++] = (byte)(n7 & 0xFF);
            System.arraycopy(byArray2, 0, byArray3, n6, byArray2.length);
            n7 = SavageScreen.crcCalc(byArray3, n6 - 4, byArray2.length + 4, -1);
            n6 += byArray2.length;
            byArray3[n6++] = (byte)((n7 & 0xFF000000) >> 24);
            byArray3[n6++] = (byte)((n7 & 0xFF0000) >> 16);
            byArray3[n6++] = (byte)((n7 & 0xFF00) >> 8);
            byArray3[n6++] = (byte)(n7 & 0xFF);
            if (n4 != 255) {
                byArray3[n6++] = 0;
                byArray3[n6++] = 0;
                byArray3[n6++] = 0;
                byArray3[n6++] = 1;
                n7 = 1951551059;
                byArray3[n6++] = (byte)((n7 & 0xFF000000) >> 24);
                byArray3[n6++] = (byte)((n7 & 0xFF0000) >> 16);
                byArray3[n6++] = (byte)((n7 & 0xFF00) >> 8);
                byArray3[n6++] = (byte)(n7 & 0xFF);
                byArray3[n6] = (byte)n4;
                n7 = SavageScreen.crcCalc(byArray3, n6 - 4, 5, -1);
                int n8 = ++n6;
                byArray3[n8] = (byte)((n7 & 0xFF000000) >> 24);
                int n9 = ++n6;
                byArray3[n9] = (byte)((n7 & 0xFF0000) >> 16);
                int n10 = ++n6;
                byArray3[n10] = (byte)((n7 & 0xFF00) >> 8);
                int n11 = ++n6;
                byArray3[n11] = (byte)(n7 & 0xFF);
            }
            n7 = byArray.length;
            int n12 = ++n6;
            byArray3[n12] = (byte)((n7 & 0xFF000000) >> 24);
            int n13 = ++n6;
            byArray3[n13] = (byte)((n7 & 0xFF0000) >> 16);
            int n14 = ++n6;
            byArray3[n14] = (byte)((n7 & 0xFF00) >> 8);
            int n15 = ++n6;
            byArray3[n15] = (byte)(n7 & 0xFF);
            n7 = 1229209940;
            int n16 = ++n6;
            byArray3[n16] = (byte)((n7 & 0xFF000000) >> 24);
            int n17 = ++n6;
            byArray3[n17] = (byte)((n7 & 0xFF0000) >> 16);
            int n18 = ++n6;
            byArray3[n18] = (byte)((n7 & 0xFF00) >> 8);
            int n19 = ++n6;
            byArray3[n19] = (byte)(n7 & 0xFF);
            System.arraycopy(byArray, 0, byArray3, ++n6, byArray.length);
            n7 = SavageScreen.crcCalc(byArray3, n6 - 4, byArray.length + 4, -1);
            n6 += byArray.length;
            byArray3[n6++] = (byte)((n7 & 0xFF000000) >> 24);
            byArray3[n6++] = (byte)((n7 & 0xFF0000) >> 16);
            byArray3[n6++] = (byte)((n7 & 0xFF00) >> 8);
            byArray3[n6++] = (byte)(n7 & 0xFF);
            System.arraycopy(IEND_BLOCK, 0, byArray3, n6, IEND_BLOCK.length);
        }
        catch (Exception exception) {
            return null;
        }
        Image image = (n5 & 0x10) != 0 ? DirectUtils.createImage((byte[])byArray3, (int)0, (int)byArray3.length) : Image.createImage((byte[])byArray3, (int)0, (int)byArray3.length);
        return image;
    }

    public static void crcBuildTable() {
        int n = -306674912;
        crc_table = new int[256];
        for (int i = 0; i <= 255; ++i) {
            int n2 = i;
            for (int j = 0; j < 8; ++j) {
                if ((n2 & 1) == 1) {
                    n2 = 0xEDB88320 ^ n2 >>> 1;
                    continue;
                }
                n2 >>>= 1;
            }
            SavageScreen.crc_table[i] = n2;
        }
    }

    public static int crcCalc(byte[] byArray, int n, int n2, int n3) {
        int n4 = n;
        int n5 = n3;
        for (int i = 0; i < n2; ++i) {
            n5 = crc_table[(n5 ^ byArray[i + n]) & 0xFF] ^ n5 >>> 8;
        }
        return ~n5;
    }

    public void paint(Graphics graphics) {
    }

    public final int sndLoad(int n) {
        return this.pCanvas.sndLoad(n);
    }

    public final void sndPlay(int n, int n2, int n3) {
        this.pCanvas.sndPlay(n, n2, n3);
    }

    public final void sndStop(int n) {
        this.pCanvas.sndStop(n);
    }

    public final Image cacheFindImage(int n) {
        return this.pCanvas.cacheFindImage(n);
    }

    public final void cacheAddImage(int n, Image image) {
        this.pCanvas.cacheAddImage(n, image);
    }

    static {
        PNG_HEADER = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13, 73, 72, 68, 82, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0};
        IEND_BLOCK = new byte[]{0, 0, 0, 0, 73, 69, 78, 68, -82, 66, 96, -126};
    }
}

