/*
 * Decompiled with CFR 0.152.
 */
package game;

import constants.Anim3DConstants;
import constants.AnimConstants;
import constants.CarConstants;
import constants.ColourConstants;
import constants.EventConstants;
import constants.IStringConstants;
import constants.Merge3DConstants;
import constants.ObjectConstants;
import constants.ResourceConstants;
import constants.SoundEventConstants;
import constants.SplineConstants;
import constants.TrackConstants;
import constants.TrackSectionConstants;
import constants.TunerShopConstants;
import game.AppEngine;
import game.GlobalConstants;
import javax.microedition.lcdui.Graphics;

abstract class Scene
implements AnimConstants,
Anim3DConstants,
Merge3DConstants,
ColourConstants,
IStringConstants,
ResourceConstants,
SoundEventConstants,
GlobalConstants,
CarConstants,
ObjectConstants,
TrackConstants,
TrackSectionConstants,
SplineConstants,
EventConstants,
TunerShopConstants {
    public static final byte SCENE_NONE = -1;
    public static final byte SCENE_MENU = 0;
    public static final byte SCENE_GAME = 1;
    public static final int KEY_0 = 1;
    public static final int KEY_1 = 2;
    public static final int KEY_2 = 4;
    public static final int KEY_3 = 8;
    public static final int KEY_4 = 16;
    public static final int KEY_5 = 32;
    public static final int KEY_6 = 64;
    public static final int KEY_7 = 128;
    public static final int KEY_8 = 256;
    public static final int KEY_9 = 512;
    public static final int KEY_POUND = 1024;
    public static final int KEY_STAR = 2048;
    public static final int KEY_DPAD_FIRE = 4096;
    public static final int KEY_DPAD_UP = 8192;
    public static final int KEY_DPAD_DOWN = 16384;
    public static final int KEY_DPAD_LEFT = 32768;
    public static final int KEY_DPAD_RIGHT = 65536;
    public static final int KEY_SOFTL = 131072;
    public static final int KEY_SOFTR = 262144;
    public static final int KEY_CLR = 524288;
    public static final int KEY_FIRE = 4128;
    public static final int KEY_UP = 8196;
    public static final int KEY_DOWN = 16640;
    public static final int KEY_LEFT = 32784;
    public static final int KEY_RIGHT = 65600;
    public static final int KEY_ARROW = 123220;
    public static final int KEY_NUMBER = 1023;
    public static final int KEY_ANY_UP = 8206;
    public static final int KEY_ANY_DOWN = 17280;
    public static final int KEY_ANY_LEFT = 32914;
    public static final int KEY_ANY_RIGHT = 66120;
    public static final int COMMAND_NONE = 0;
    public static final int COMMAND_MENU = 1;
    public static final int COMMAND_NEXT = 2;
    public static final int COMMAND_BACK = 4;
    public static final int COMMAND_OKAY = 8;
    public static final int COMMAND_SELECT = 16;
    public static final int COMMAND_CANCEL = 32;
    public static final int COMMAND_EXIT = 64;
    public static final int COMMAND_YES = 128;
    public static final int COMMAND_NO = 256;
    public static final int COMMAND_LANG_SELECT = 512;
    public static final int COMMAND_LANG_BACK = 1024;
    protected final AppEngine m_engine;
    protected int m_loadingProgress;

    public final boolean checkKeys(int n, int n2, int n3, int n4) {
        if ((n2 & n4) != 0 || (n & n3) != 0) {
            this.m_engine.clearCommandKeys();
            this.m_engine.clearKeyBit(n3);
            return true;
        }
        return false;
    }

    protected Scene(AppEngine appEngine) {
        this.m_engine = appEngine;
    }

    public abstract void start(int var1);

    public abstract void pause();

    public abstract void resume();

    public abstract void end();

    public abstract void render(Graphics var1);

    public abstract void processKeys(int var1, int var2);

    public abstract void update(int var1);
}

