/*
 * Decompiled with CFR 0.152.
 */
package generic;

import constants.AnimConstants;
import game.AppEngine;
import generic.AnimPlayer;
import generic.ResourceManager;
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class AnimationManager {
    private static final byte SUB_IMAGE_ID = 0;
    private static final byte SUB_IMAGE_X = 1;
    private static final byte SUB_IMAGE_Y = 2;
    private static final byte SUB_IMAGE_WIDTH = 3;
    private static final byte SUB_IMAGE_HEIGHT = 4;
    private static final byte NUM_SUB_IMAGE_FIELDS = 5;
    private static final byte PRIMITIVE_SPRITE_ENUM = 0;
    private static final byte PRIMITIVE_CLIP_ENUM = 1;
    private static final byte PRIMITIVE_COLL_BOX_ENUM = 2;
    private static final byte PRIMITIVE_HOLLOW_RECTANGLE_ENUM = 3;
    private static final byte PRIMITIVE_FILLED_RECTANGLE_ENUM = 4;
    private static final byte PRIMITIVE_HOLLOW_ELLIPSE_ENUM = 5;
    private static final byte PRIMITIVE_FILLED_ELLIPSE_ENUM = 6;
    private static final byte PRIMITIVE_FIRE_POINT_ENUM = 7;
    private static final byte PRIMITIVE_LINE_ENUM = 8;
    private static final byte PRIMITIVE_TEXT_ENUM = 9;
    private static final byte PRIMITIVE_COLOR_ENUM = 10;
    private static final byte PRIMITIVE_XFLIPPED_SPRITE_ENUM = 11;
    private static final byte PRIMITIVE_ATTRIB_TYPE = 0;
    private static final byte PRIMITIVE_ATTRIB_X = 1;
    private static final byte PRIMITIVE_ATTRIB_Y = 2;
    private static final byte PRIMITIVE_ATTRIB_X2 = 3;
    private static final byte PRIMITIVE_ATTRIB_Y2 = 4;
    private static final byte PRIMITIVE_ATTRIB_SUBIMAGE = 3;
    private static final byte PRIMITIVE_ATTRIB_WIDTH = 3;
    private static final byte PRIMITIVE_ATTRIB_HEIGHT = 4;
    private static final byte PRIMITIVE_ATTRIB_COLOUR_INDEX = 1;
    public static final int NUM_BANKS = 1;
    private static byte[] s_colourData;
    private static short[][] s_frameDuration;
    private static short[][][][] s_primitiveData;
    private static short[][] s_subImages;
    private static int s_curBank;
    private static Image[][] s_animImageArray;

    private AnimationManager() {
    }

    public static final boolean loadColorsFile(ResourceManager resourceManager) {
        DataInputStream dataInputStream = new DataInputStream(resourceManager.loadBinaryFile(18));
        s_colourData = new byte[ResourceManager.getFileSize(18)];
        try {
            dataInputStream.read(s_colourData);
            dataInputStream.close();
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    public static final void setColor(Graphics graphics, int n) {
        int n2 = n * 3;
        byte[] byArray = s_colourData;
        graphics.setColor(byArray[n2] & 0xFF, byArray[n2 + 1] & 0xFF, byArray[n2 + 2] & 0xFF);
    }

    public static final boolean loadSubimageFile(ResourceManager resourceManager) {
        try {
            short[][] sArray = new short[132][5];
            DataInputStream dataInputStream = new DataInputStream(resourceManager.loadBinaryFile(24));
            for (int i = 0; i < 132; ++i) {
                short[] sArray2 = sArray[i];
                sArray2[0] = (short)dataInputStream.readUnsignedByte();
                sArray2[1] = dataInputStream.readShort();
                sArray2[2] = dataInputStream.readShort();
                sArray2[3] = dataInputStream.readShort();
                sArray2[4] = dataInputStream.readShort();
            }
            s_subImages = sArray;
        }
        catch (IOException iOException) {
            s_subImages = null;
            return false;
        }
        return true;
    }

    public static final boolean loadAnimFile(ResourceManager resourceManager) {
        try {
            short[][] sArrayArray = new short[98][];
            short[][][][] sArrayArray2 = new short[98][][][];
            DataInputStream dataInputStream = new DataInputStream(resourceManager.loadBinaryFile(4));
            for (int i = 0; i != 98; ++i) {
                int n = dataInputStream.readByte();
                short[] sArray = new short[n];
                sArrayArray[i] = sArray;
                short[][][] sArrayArray3 = new short[n][][];
                sArrayArray2[i] = sArrayArray3;
                for (int j = 0; j != n; ++j) {
                    sArray[j] = dataInputStream.readShort();
                    int n2 = dataInputStream.readByte();
                    short[][] sArrayArray4 = new short[n2][];
                    sArrayArray3[j] = sArrayArray4;
                    for (int k = 0; k != n2; ++k) {
                        byte by = dataInputStream.readByte();
                        short[] sArray2 = null;
                        switch (by) {
                            case 0: 
                            case 11: {
                                sArray2 = new short[4];
                                sArray2[3] = dataInputStream.readShort();
                                sArray2[1] = dataInputStream.readShort();
                                sArray2[2] = dataInputStream.readShort();
                                break;
                            }
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: {
                                sArray2 = new short[5];
                                sArray2[1] = dataInputStream.readShort();
                                sArray2[2] = dataInputStream.readShort();
                                sArray2[3] = dataInputStream.readShort();
                                sArray2[4] = dataInputStream.readShort();
                                break;
                            }
                            case 7: {
                                sArray2 = new short[3];
                                sArray2[1] = dataInputStream.readShort();
                                sArray2[2] = dataInputStream.readShort();
                                break;
                            }
                            case 8: {
                                sArray2 = new short[5];
                                sArray2[1] = dataInputStream.readShort();
                                sArray2[2] = dataInputStream.readShort();
                                sArray2[3] = dataInputStream.readShort();
                                sArray2[4] = dataInputStream.readShort();
                                break;
                            }
                            case 10: {
                                sArray2 = new short[2];
                                sArray2[1] = dataInputStream.readByte();
                            }
                        }
                        sArray2[0] = by;
                        sArrayArray4[k] = sArray2;
                    }
                }
            }
            s_frameDuration = sArrayArray;
            s_primitiveData = sArrayArray2;
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    private static final void DEBUG_LOADIMAGE(String string) {
    }

    public static final boolean loadImage(ResourceManager resourceManager, int n) {
        int n2;
        for (n2 = 0; n2 < 28 && n != AnimConstants.IMAGE_RES_IDS[n2]; ++n2) {
        }
        AnimationManager.DEBUG_LOADIMAGE(ResourceManager.getFileName(n));
        if (28 == n2) {
            AnimationManager.DEBUG_LOADIMAGE("load aborted (image not needed by anims)");
            return false;
        }
        Image[] imageArray = s_animImageArray[s_curBank];
        if (imageArray[n2] == null) {
            Image image;
            imageArray[n2] = image = resourceManager.loadImage(n);
            if (image == null) {
                AnimationManager.DEBUG_LOADIMAGE("load fail");
                return false;
            }
        }
        if (imageArray[n2] == null) {
            AnimationManager.DEBUG_LOADIMAGE("load 'success', but image is null!");
        } else {
            AnimationManager.DEBUG_LOADIMAGE("load success");
        }
        return true;
    }

    private static final void DEBUG_UNLOADIMAGE(String string) {
    }

    public static final boolean unloadImage(int n) {
        int n2;
        AnimationManager.DEBUG_UNLOADIMAGE(ResourceManager.getFileName(n));
        for (n2 = 0; n2 < 28 && n != AnimConstants.IMAGE_RES_IDS[n2]; ++n2) {
        }
        if (28 == n2) {
            AnimationManager.DEBUG_UNLOADIMAGE("unload aborted (resID not found)");
            return false;
        }
        AnimationManager.s_animImageArray[AnimationManager.s_curBank][n2] = null;
        AnimationManager.DEBUG_UNLOADIMAGE("unload success");
        return true;
    }

    public static final AnimPlayer createAnimPlayer() {
        return new AnimPlayer();
    }

    public static final void drawAnimFrame(Graphics graphics, int n, int n2, int n3, int n4) {
        if (n < 0) {
            return;
        }
        int n5 = graphics.getClipX();
        int n6 = graphics.getClipY();
        int n7 = graphics.getClipWidth();
        int n8 = graphics.getClipHeight();
        short[][] sArray = s_subImages;
        Image[] imageArray = s_animImageArray[s_curBank];
        short[][] sArray2 = s_primitiveData[n][n2];
        int n9 = sArray2.length;
        for (int i = 0; i != n9; ++i) {
            short[] sArray3 = sArray2[i];
            short s = sArray3[0];
            if (s == 0 || s == 11) {
                int n10 = n3 + sArray3[1];
                int n11 = n4 + sArray3[2];
                short[] sArray4 = sArray[sArray3[3]];
                int n12 = sArray4[0] & 0xFFFF;
                Image image = imageArray[n12];
                if (image == null) continue;
                int n13 = s == 0 ? 0 : 2;
                graphics.drawRegion(image, (int)sArray4[1], (int)sArray4[2], (int)sArray4[3], (int)sArray4[4], n13, n10, n11, 20);
                continue;
            }
            if (s == 2 || s == 7) continue;
            AnimationManager.drawPrimitive(graphics, n3, n4, sArray3);
        }
        graphics.setClip(n5, n6, n7, n8);
    }

    private static final void drawPrimitive(Graphics graphics, int n, int n2, short[] sArray) {
        switch (sArray[0]) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                int n3 = n + sArray[1];
                int n4 = n2 + sArray[2];
                short s = sArray[3];
                short s2 = sArray[4];
                switch (sArray[0]) {
                    case 3: {
                        graphics.drawRect(n3, n4, s - 1, s2 - 1);
                        break;
                    }
                    case 4: {
                        graphics.fillRect(n3, n4, (int)s, (int)s2);
                        break;
                    }
                    case 5: {
                        graphics.drawArc(n3, n4, s - 1, s2 - 1, 0, 360);
                        break;
                    }
                    case 6: {
                        graphics.fillArc(n3, n4, (int)s, (int)s2, 0, 360);
                    }
                }
                break;
            }
            case 8: {
                int n5 = n + sArray[1];
                int n6 = n2 + sArray[2];
                int n7 = n + sArray[3];
                int n8 = n2 + sArray[4];
                graphics.drawLine(n5, n6, n7, n8);
                break;
            }
            case 10: {
                AnimationManager.setColor(graphics, sArray[1]);
                break;
            }
            case 1: {
                int n9 = n + sArray[1];
                int n10 = n2 + sArray[2];
                short s = sArray[3];
                short s3 = sArray[4];
                graphics.clipRect(n9, n10, (int)s, (int)s3);
                break;
            }
        }
    }

    public static final int animGetNumFrames(int n) {
        return s_frameDuration[n].length;
    }

    public static final short animFrameGetDuration(int n, int n2) {
        return s_frameDuration[n][n2];
    }

    private static final int getPrimitiveX(short[] sArray) {
        switch (sArray[0]) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                return sArray[1];
            }
        }
        return 0;
    }

    private static final int getPrimitiveY(short[] sArray) {
        switch (sArray[0]) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                return sArray[2];
            }
        }
        return 0;
    }

    private static final int getPrimitiveWidth(short[] sArray) {
        switch (sArray[0]) {
            case 0: 
            case 11: {
                int n = sArray[3];
                return s_subImages[n &= 0xFFFF][3];
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return sArray[3];
            }
            case 8: {
                return sArray[3] - sArray[1];
            }
            case 9: {
                return 0;
            }
        }
        return 0;
    }

    private static final int getPrimitiveHeight(short[] sArray) {
        switch (sArray[0]) {
            case 0: 
            case 11: {
                int n = sArray[3];
                return s_subImages[n &= 0xFFFF][4];
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return sArray[4];
            }
            case 8: {
                return sArray[4] - sArray[2];
            }
            case 9: {
                return 0;
            }
        }
        return 0;
    }

    public static final int getAnimFrameX(int n, int n2) {
        short[][] sArray = s_primitiveData[n][n2];
        int n3 = sArray.length;
        if (n3 == 0) {
            return 0;
        }
        int n4 = Integer.MAX_VALUE;
        for (int i = 0; i != n3; ++i) {
            int n5;
            if (sArray[i][0] == 10 || (n5 = AnimationManager.getPrimitiveX(sArray[i])) >= n4) continue;
            n4 = n5;
        }
        return n4;
    }

    public static final int getAnimFrameY(int n, int n2) {
        short[][] sArray = s_primitiveData[n][n2];
        int n3 = sArray.length;
        if (n3 == 0) {
            return 0;
        }
        int n4 = Integer.MAX_VALUE;
        for (int i = 0; i != n3; ++i) {
            int n5;
            if (sArray[i][0] == 10 || (n5 = AnimationManager.getPrimitiveY(sArray[i])) >= n4) continue;
            n4 = n5;
        }
        return n4;
    }

    public static final int getAnimFrameWidth(int n, int n2) {
        short[][] sArray = s_primitiveData[n][n2];
        int n3 = sArray.length;
        if (n3 == 0) {
            return 0;
        }
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MIN_VALUE;
        for (int i = 0; i != n3; ++i) {
            if (sArray[i][0] == 10) continue;
            int n6 = AnimationManager.getPrimitiveX(sArray[i]);
            int n7 = n6 + AnimationManager.getPrimitiveWidth(sArray[i]);
            if (n6 < n4) {
                n4 = n6;
            }
            if (n7 <= n5) continue;
            n5 = n7;
        }
        return n5 - n4;
    }

    public static final int getAnimFrameHeight(int n, int n2) {
        short[][] sArray = s_primitiveData[n][n2];
        int n3 = sArray.length;
        if (n3 == 0) {
            return 0;
        }
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MIN_VALUE;
        for (int i = 0; i != n3; ++i) {
            if (sArray[i][0] == 10) continue;
            int n6 = AnimationManager.getPrimitiveY(sArray[i]);
            int n7 = n6 + AnimationManager.getPrimitiveHeight(sArray[i]);
            if (n6 < n4) {
                n4 = n6;
            }
            if (n7 <= n5) continue;
            n5 = n7;
        }
        return n5 - n4;
    }

    public static final int getAnimFrameFirePointCount(int n, int n2) {
        short[][] sArray = s_primitiveData[n][n2];
        int n3 = 0;
        for (int i = sArray.length - 1; i != -1; --i) {
            if (sArray[i][0] != 7) continue;
            ++n3;
        }
        return n3;
    }

    public static final boolean getAnimFrameFirePoint(int[] nArray, int n, int n2, int n3) {
        short[][] sArray = s_primitiveData[n][n2];
        int n4 = 0;
        int n5 = sArray.length;
        for (int i = 0; i != n5; ++i) {
            if (sArray[i][0] != 7) continue;
            if (n4 == n3) {
                nArray[0] = sArray[i][1];
                nArray[1] = sArray[i][2];
                return true;
            }
            ++n4;
        }
        nArray[0] = 0;
        nArray[1] = 0;
        return false;
    }

    public static final Image getAnimFrameImage(int n, int n2, int n3) {
        short[][] sArray = s_primitiveData[n][n2];
        int n4 = sArray.length;
        for (int i = 0; i != n4; ++i) {
            short s = sArray[i][0];
            if (s != 0 && s != 11) continue;
            if (n3 == 0) {
                short s2 = sArray[i][3];
                short s3 = s_subImages[s2][0];
                return s_animImageArray[s_curBank][s3];
            }
            --n3;
        }
        return null;
    }

    public static final boolean getAnimFrameCollisionBox(int[] nArray, int n, int n2) {
        short[][] sArray = s_primitiveData[n][n2];
        for (int i = sArray.length - 1; i != -1; --i) {
            if (sArray[i][0] != 2) continue;
            nArray[0] = sArray[i][1];
            nArray[1] = sArray[i][2];
            nArray[2] = sArray[i][3];
            nArray[3] = sArray[i][4];
            return true;
        }
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[3] = 0;
        return false;
    }

    public static final Image getImage(int n) {
        return n < 0 || n >= 28 ? null : s_animImageArray[s_curBank][n];
    }

    public static final void drawAnim(Graphics graphics, AnimPlayer animPlayer, int n, int n2) {
        AnimationManager.drawAnimFrame(graphics, animPlayer.getAnimID(), animPlayer.getCurrAnimFrame(), n, n2);
    }

    public static final void setBank(int n) {
        AppEngine.ASSERT(n >= 0 && n < 1, "invalid bank");
        s_curBank = n;
    }

    static {
        s_animImageArray = new Image[1][28];
        for (int i = 0; i < 1; ++i) {
            for (int j = 0; j < 28; ++j) {
                AnimationManager.s_animImageArray[i][j] = null;
            }
        }
    }
}

