/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.lwuit;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Vector;

public class Dbug {
    private static final Vector logs = new Vector(100);
    private static Writer writer = null;

    public static synchronized void clear() {
        logs.removeAllElements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(String tag, String message) {
        StringBuffer buf = new StringBuffer();
        if (tag != null || !tag.equals("")) {
            buf.append(tag);
            buf.append(":");
            buf.append(message);
        }
        if (writer != null) {
            try {
                writer.write(buf.toString() + "\n");
                writer.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Vector vector = logs;
        synchronized (vector) {
            logs.addElement(buf.toString());
        }
    }

    public static synchronized String[] getLogs(int amount) {
        if (amount == 0 || amount < 0 || logs.size() == 0) {
            return new String[0];
        }
        Object[] ret = new String[amount];
        if (amount > logs.size()) {
            ret = new String[logs.size()];
            logs.copyInto(ret);
        } else {
            int index = logs.size() == 1 ? 0 : logs.size() - amount;
            int r_i = 0;
            for (int i = index; i < logs.size(); ++i) {
                ret[r_i] = (String)logs.elementAt(i);
                ++r_i;
            }
        }
        return ret;
    }

    public static synchronized String[] getAllLogs() {
        Object[] ret = new String[logs.size()];
        logs.copyInto(ret);
        return ret;
    }

    public static synchronized void setOutputStream(OutputStream out) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        writer = new OutputStreamWriter(out);
    }
}

