/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.lwuit;

import com.nokia.mid.ui.DirectUtils;
import javax.microedition.lcdui.Image;

public class ImageUtils {
    public static Image applyAlphaBlending(Image source, int color, int coeff) {
        int[] sourceData = new int[source.getHeight() * source.getWidth()];
        source.getRGB(sourceData, 0, source.getWidth(), 0, 0, source.getWidth(), source.getHeight());
        sourceData = ImageUtils.applyAlphaBlending(sourceData, color, coeff);
        Image ret = DirectUtils.createImage((int)source.getWidth(), (int)source.getHeight(), (int)-16777216);
        ret.getGraphics().drawRGB(sourceData, 0, source.getWidth(), 0, 0, source.getWidth(), source.getHeight(), true);
        return ret;
    }

    public static int[] applyAlphaBlending(int[] rgb, int color, int coeff) {
        int[] sourceData = rgb;
        int alpha2 = (color & 0xFF000000) >>> 24;
        int red2 = (color & 0xFF0000) >> 16;
        int green2 = (color & 0xFF00) >> 8;
        int blue2 = color & 0xFF;
        for (int i = 0; i < sourceData.length; ++i) {
            int alpha1 = (sourceData[i] & 0xFF000000) >>> 24;
            int red1 = (sourceData[i] & 0xFF0000) >> 16;
            int green1 = (sourceData[i] & 0xFF00) >> 8;
            int blue1 = sourceData[i] & 0xFF;
            int c = 255 - coeff;
            int resultA = (alpha1 * coeff + alpha2 * c) / 255;
            int resultR = (red1 * coeff + red2 * c) / 255;
            int resultG = (green1 * coeff + green2 * c) / 255;
            int resultB = (blue1 * coeff + blue2 * c) / 255;
            sourceData[i] = resultA << 24 | resultR << 16 | resultG << 8 | resultB;
        }
        return sourceData;
    }

    public static Image drawMaskedImage(Image source, Image mask) {
        int[] sourceData = new int[source.getHeight() * source.getWidth()];
        int[] maskData = new int[mask.getHeight() * mask.getWidth()];
        source.getRGB(sourceData, 0, source.getWidth(), 0, 0, source.getWidth(), source.getHeight());
        mask.getRGB(maskData, 0, mask.getWidth(), 0, 0, mask.getWidth(), mask.getHeight());
        for (int i = 0; i < sourceData.length; ++i) {
            sourceData[i] = maskData[i] & 0xFF000000 | sourceData[i] & 0xFFFFFF;
        }
        Image ret = DirectUtils.createImage((int)source.getWidth(), (int)source.getHeight(), (int)0);
        ret.getGraphics().drawRGB(sourceData, 0, source.getWidth(), 0, 0, source.getWidth(), source.getHeight(), true);
        return ret;
    }
}

