/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.lwuit.components;

import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Font;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.Painter;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.geom.Rectangle;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public class NotificationBar
extends Container
implements Painter,
Runnable {
    private int notificationPrefWidth;
    private int notificationPrefHeight;
    private int defaultTextWidth;
    private int fixed_x_Coordinate;
    private int fixed_y_Coordinate;
    private int xPosition;
    private int yPosition;
    private static final int SPEED = 10;
    private static final int TIMEOUT = 2000;
    private static final int TEXT_HORIZONTAL_MARGIN = 10;
    private static final int LINE_GAP = 5;
    private int notificationBgColor;
    private int notificationFgColor;
    private int hidingYPosition;
    private volatile String textToShow;
    private String firstLine;
    private String secondLine;
    private boolean isPainting;
    private boolean doReverse = false;
    private InternalTimerTask internalTimerTask;
    private Font notificationFont;
    private Timer timer = new Timer();
    private Form form;
    private Style feedbackStyle;
    private Dimension notificationDimension;
    private Vector stringsArray = null;
    private Image notificationImage = null;
    private Image icon;

    public NotificationBar(Image icon, String firstLine, String secondLine) {
        this(icon, firstLine, secondLine, null);
    }

    NotificationBar(Image icon, String firstLine, String secondLine, String textToShow) {
        this.icon = icon;
        this.textToShow = textToShow;
        this.firstLine = firstLine;
        this.secondLine = secondLine;
        this.setUIID("NotificationBar");
        this.feedbackStyle = UIManager.getInstance().getComponentStyle("FeedbackNotificationBar");
        this.notificationFont = this.feedbackStyle.getFont();
        this.notificationFgColor = this.feedbackStyle.getFgColor();
        this.notificationBgColor = this.feedbackStyle.getBgColor();
        this.isPainting = false;
        this.notificationPrefWidth = 0;
        this.notificationPrefHeight = 0;
        this.calculateNotificationSize();
        this.notificationImage = this.createNotificationImage();
        this.yPosition = this.hidingYPosition = -1 * this.notificationImage.getHeight();
    }

    public NotificationBar(Image icon, String textToShow) {
        this(icon, null, null, textToShow);
    }

    public void showNoitification() {
        Thread thread = new Thread(this);
        if (thread != null && !thread.isAlive()) {
            thread.start();
        }
    }

    public void hideNotification() {
        if (this.internalTimerTask != null) {
            this.internalTimerTask.cancel();
            this.internalTimerTask = null;
        }
        this.doReverse = false;
    }

    public void paint(Graphics g, Rectangle rect) {
        g.drawImage(this.notificationImage, this.xPosition, this.yPosition);
        if (this.icon != null) {
            g.drawImage(this.icon, this.xPosition + 5, this.yPosition + 3);
        }
    }

    private void doTransition() {
        this.xPosition = this.fixed_x_Coordinate;
        if (this.yPosition != this.fixed_y_Coordinate) {
            this.yPosition += 5;
            if (this.yPosition > this.fixed_y_Coordinate) {
                this.yPosition = this.fixed_y_Coordinate;
            }
            if (Display.getInstance().getCurrent() != this.form) {
                this.form = Display.getInstance().getCurrent();
            }
            this.form.setGlassPane(null);
            this.form.setGlassPane(this);
        } else {
            this.isPainting = false;
            this.fixed_y_Coordinate = this.hidingYPosition;
        }
    }

    private void doReverseTransition() {
        this.xPosition = this.fixed_x_Coordinate;
        if (this.yPosition != this.fixed_y_Coordinate) {
            this.yPosition -= 5;
            if (this.yPosition < this.fixed_y_Coordinate) {
                this.yPosition = this.fixed_y_Coordinate;
            }
            this.form.setGlassPane(null);
            this.form.setGlassPane(this);
        } else {
            this.isPainting = false;
        }
    }

    public void run() {
        this.isPainting = true;
        while (this.isPainting) {
            if (!this.doReverse) {
                this.doTransition();
            } else {
                this.doReverseTransition();
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                System.out.println("Exception in running thread");
            }
        }
        if (!this.isPainting && !this.doReverse) {
            if (this.internalTimerTask != null) {
                this.internalTimerTask.cancel();
                this.internalTimerTask = null;
            }
            this.internalTimerTask = new InternalTimerTask();
            this.timer.schedule((TimerTask)this.internalTimerTask, 2000L);
        } else if (!this.isPainting && this.doReverse) {
            this.form.setGlassPane(null);
            this.hideNotification();
        }
    }

    private void calculateNotificationSize() {
        this.notificationPrefWidth = Display.getInstance().getDisplayWidth();
        this.defaultTextWidth = this.notificationPrefWidth - 10;
        int exactWidth = this.notificationFont.stringWidth(this.textToShow) + 10;
        if (exactWidth < this.notificationPrefWidth) {
            this.defaultTextWidth = this.notificationPrefWidth = exactWidth;
        }
        if (this.textToShow != null) {
            this.stringsArray = this.getMultipleLinesOftext(this.textToShow, this.notificationFont, this.defaultTextWidth);
            int lineCount = this.stringsArray.size();
            for (int i = 0; i < lineCount; ++i) {
                this.notificationPrefHeight += this.notificationFont.getHeight();
            }
        }
        this.notificationPrefHeight = 54;
        this.notificationPrefWidth = Display.getInstance().getDisplayWidth();
        this.notificationDimension = new Dimension(this.notificationPrefWidth, this.notificationPrefHeight);
        this.fixed_x_Coordinate = (Display.getInstance().getDisplayWidth() - this.notificationDimension.getWidth()) / 2;
        this.fixed_y_Coordinate = 0;
    }

    private Image createNotificationImage() {
        Image image = Image.createImage(this.notificationDimension.getWidth(), this.notificationDimension.getHeight());
        Graphics g = image.getGraphics();
        g.setColor(this.notificationBgColor);
        g.fillRect(0, 0, this.notificationDimension.getWidth(), this.notificationDimension.getHeight());
        g.setFont(this.notificationFont);
        g.setColor(this.notificationFgColor);
        int yCoordinate = 5;
        if (this.textToShow != null) {
            int strCount = this.stringsArray.size();
            for (int i = 0; i < strCount; ++i) {
                String tempString = (String)this.stringsArray.elementAt(i);
                if (this.icon == null) {
                    g.drawString(tempString, 10, yCoordinate);
                } else {
                    g.drawString(tempString, 10 + this.icon.getWidth(), yCoordinate);
                }
                yCoordinate += this.notificationFont.getHeight() + 5;
            }
        } else if (this.icon == null) {
            g.drawString(this.firstLine, 10, yCoordinate);
            g.drawString(this.secondLine, 10, yCoordinate += this.notificationFont.getHeight() + 5);
        } else {
            g.drawString(this.firstLine, 10 + this.icon.getWidth(), yCoordinate);
            g.drawString(this.secondLine, 10 + this.icon.getWidth(), yCoordinate += this.notificationFont.getHeight() + 5);
        }
        return image;
    }

    private Vector getMultipleLinesOftext(String text, Font font, int width) {
        Vector<String> allLines = new Vector<String>();
        int position = 0;
        int length = text.length();
        int start = 0;
        while (position < length - 1) {
            int i;
            int breakPosition = -1;
            for (i = position; i < length && font.stringWidth(text.substring(position, i)) <= width; ++i) {
                if (text.charAt(i) != ' ') continue;
                breakPosition = i;
            }
            position = i == length ? i : (breakPosition <= position ? i : breakPosition);
            int n = start;
            start = position;
            String tempString = text.substring(n, start);
            allLines.addElement(tempString);
        }
        return allLines;
    }

    private class InternalTimerTask
    extends TimerTask {
        private InternalTimerTask() {
        }

        public void run() {
            NotificationBar.this.doReverse = true;
            NotificationBar.this.showNoitification();
        }
    }
}

